this.adventurejs=this.ajs=this.A=this.adventurejs||{Preverbs:{},GlobalAssets:{Exits:[],Walls:[],Floors:[],Ceilings:[],Scenery:[]},Utils:{}};adventurejs.addWorldToHistory=function Adventurejs_addWorldToHistory(world){this.game.log("L1044","log","high","adventurejs.worldSave > Attempting to save the world.","CopyOperations");this.game.world_history.unshift(world);if(this.settings.max_undos<this.game.world_history.length){this.game.world_history[this.game.world_history.length-1]=null;this.game.world_history.pop()}this.game.log("L1045","log","high","adventurejs.worldSave > Saved the world.","CopyOperations")};adventurejs.arrayToLowerCase=function Adventurejs_arrayToLowerCase(array){if(!Array.isArray(array)){console.warn("arrayToLowerCase.js received something that's not an array. ");return false}for(var item in array)if("string"==typeof array[item])array[item]=array[item].toLowerCase();return array};adventurejs.camelToSnake=function Adventurejs_camelToSnake(string){if("string"!=typeof string)return"";else return string.replace(/([A-Z])/g,"_$1").toLowerCase()};adventurejs.capitalize=function Adventurejs_capitalize(string){if("string"!=typeof string)return"";else return string=string.charAt(0).toUpperCase()+string.substring(1)};adventurejs.clone=function Adventurejs_clone(source){var dest;if(null==source||"object"!=typeof source)return source;if(source instanceof Array){for(var dest=[],i=0,len=source.length;i<len;i++)dest[i]=A.clone.call(this,source[i]);return dest}if("function"==typeof source)return dest=source;if(source instanceof Object){if(source.class&&adventurejs[source.class])dest=new adventurejs[source.class](source.name,this.game_name,source.context_id?source.context_id:null);else dest={};for(var property in source)if(Object.prototype.hasOwnProperty.call(source,property))dest[property]=A.clone.call(this,source[property]);return dest}throw new Error("clone.js unable to copy source because its type isn't supported.")};adventurejs.cloneWorld=function Adventurejs_cloneWorld(source){console.warn("cloneWorld");this.game.log("L1048","log","high","cloneWorld()","CopyOperations");var dest={},starttime=(new Date).getTime(),object,stringified;for(object in source)if(void 0===source[object].class)dest[object]=source[object];else{dest[object]=new adventurejs[source[object].class](source[object].id,this.game_name);for(var prop in source[object]){if("string"==typeof source[object][prop])dest[object][prop]=source[object][prop];else if("function"==typeof source[object][prop]){stringified=source[object][prop].toString();dest[object][prop]=eval("("+stringified+")")}else if("object"==typeof source[object][prop])dest[object][prop]=A.clone.call(this.game,source[object][prop]);else{stringified=JSON.stringify(source[object][prop]);if(void 0!==stringified)dest[object][prop]=JSON.parse(stringified)}}}this.game.log("L1049","log","high","cloneWorld() took "+((new Date).getTime()-starttime)/1e3+" seconds.","CopyOperations");return dest};adventurejs.convertTemperature=function Adventurejs_convertTemperature(temperature,context_id){var newtemperature;if(false===isNaN(temperature))newtemperature=Number(temperature);else if("string"==typeof temperature){var newtemperature=temperature.replace(/[ ]/g,""),digits="",suffix="",char,digit;for(char in temperature){if(false===isNaN(temperature[char])||"."==temperature[char]){if(suffix.length<0)break;digits+=temperature[char]}else suffix+=temperature[char]}digits=Number(digits);if("f"===suffix.toLowerCase())newtemperature=5/9*(digits-32)}if(isNaN(newtemperature)){newtemperature=this.game.settings.ambient_temperature;var msg="";if(void 0!==context_id)msg+=context_id+"'s ";else msg+="An object's ";this.game.log("L1047","warn","critical",msg+=`temperature was set to an invalid value. [MORE...] 
      
convertTemperature received a value of ${temperature}. 
      
Adventure.js defaults to temperature in celsius. 
      
Recognized suffixes are: 
      
 - c (celsius)
      
 - f (fahrenheit)`,"Utility")}return newtemperature};adventurejs.convertVolume=function Adventurejs_convertVolume(volume,context_id){var newvolume;if(false===isNaN(volume))newvolume=Number(volume);else if("string"==typeof volume){var newvolume=volume.replace(/[ ,]/g,""),digits="",suffix="",char,digit;for(char in volume){if(false===isNaN(volume[char])||"."==volume[char]){if(suffix.length<0)break;digits+=volume[char]}else suffix+=volume[char]}digits=Number(digits);switch(suffix){case"":break;case"nL":newvolume=digits/1e6;break;case"μL":newvolume=digits/1e3;break;case"mL":newvolume=digits;break;case"cL":newvolume=10*digits;break;case"dL":newvolume=100*digits;break;case"L":newvolume=1e3*digits;break;case"daL":newvolume=1e4*digits;break;case"hL":newvolume=1e5*digits;break;case"kL":newvolume=1e6*digits;break;case"ML":newvolume=1e9*digits;break;default:break}}if(isNaN(newvolume)){var msg="";if(void(newvolume=0)!==context_id)msg+=context_id+"'s ";else msg+="An object's ";this.game.log("L1046","warn","critical",msg+="volume was set to an invalid value. [MORE...] \nconvertVolume received a value of "+volume+". \nAdventure.js defaults to volume in milliliters. \nSuffixes are case sensitive. \nRecognized suffixes are: \n - nL (nanoliters)\n - μL (microliters)\n - mL (milliliters)\n - cL (centiliters)\n - dL (deciliters)\n - L (liters)\n - daL (decaliters)\n - hL (hectoliters)\n - kL (kiloliters)\n - ML (megaliters)\nAdventure.js doesn't handle other measurements at this time. ","Utility")}return newvolume=Math.max(newvolume,0)};adventurejs.countCommonElements=function Adventurejs_countCommonElements(str1,str2){var str1=str1.split(",").map(item=>item.trim()),str2=str2.split(",").map(item=>item.trim()),set2=new Set(str2),item;let commonCount=0;for(item of str1)if(set2.has(item))commonCount++;return commonCount};adventurejs.deepSet=function Adventurejs_deepSet(props,object){if(null===props);else for(var key in props)if("function"==typeof props[key]||Array.isArray(props[key])||"object"!=typeof props[key])object[key]=props[key];else if(void 0===props[key]){var msg;this.game.log("L1039","error","high","Error during Atom construction. props[key] is undefined. ");return false}else{if(props&&props[key]&&props[key].class){var id;if(void 0===(id=props[key].id))id=props[key].id=key;object[key]=A.clone.call(this.game,props[key],object[key])}if("object"==typeof object[key])object[key]=A.mergeWorld.call(this,props[key],object[key]);else{if(void 0===object[key])object[key]=props[key];if("object"!=typeof object[key])object[key]=props[key];for(var nestedprop in props[key])if(!Object.prototype.hasOwnProperty.call(object[key],nestedprop));else object[key][nestedprop]=props[key][nestedprop]}}return object};adventurejs.deobfuscate=function Adventurejs_deobfuscate(text){return Array.from(text).map(c=>String.fromCharCode(c.charCodeAt(0)-3)).join("")};adventurejs.deserialize=function Adventurejs_deserialize(name){if("string"!=typeof name)return"";else return name.replace(/&/g," and ").replace(/_/g," ").replace(/\$/g,".").toLowerCase()};adventurejs.diff=function Adventurejs_diff(baseline_object,updated_object){var starttime=(new Date).getTime(),diff_object={},prop;for(prop in updated_object)if(false===Object.prototype.hasOwnProperty.call(updated_object,prop));else if(typeof updated_object[prop]!=typeof baseline_object[prop])diff_object[prop]=A.clone.call(this.game,updated_object[prop]);else if(void 0===baseline_object[prop]&&void 0!==updated_object[prop])diff_object[prop]=A.clone(updated_object[prop]);else if((null==updated_object[prop]||"object"!=typeof updated_object[prop])&&updated_object[prop]!==baseline_object[prop])diff_object[prop]=A.clone(updated_object[prop]);else if(Array.isArray(updated_object[prop])){var baseline_object_prop=JSON.stringify(baseline_object[prop]),updated_object_prop;if((updated_object_prop=JSON.stringify(updated_object[prop]))!==baseline_object_prop)diff_object[prop]=JSON.parse(updated_object_prop)}else if("function"==typeof updated_object[prop]){var baseline_object_prop=baseline_object[prop].toString(),updated_object_prop;if((updated_object_prop=updated_object[prop].toString())!==baseline_object_prop)diff_object[prop]=updated_object[prop]}else if("object"==typeof updated_object[prop]){var diff_object_prop=A.diff(baseline_object[prop],updated_object[prop]),diff_object_prop_keys;if(0<Object.keys(diff_object_prop).length)diff_object[prop]=diff_object_prop}return diff_object};adventurejs.dijkstra=function Adventurejs_dijkstra(graph,s){var solutions={};solutions[s]=[];solutions[s].dist=0;for(;;){var parent=null,nearest=null,dist=1/0,n;for(n in solutions)if(!solutions[n]);else{var ndist=solutions[n].dist,adj=graph[n],a;for(a in adj)if(solutions[a]);else{var d=adj[a]+ndist;if(d<dist){parent=solutions[n];nearest=a;dist=d}}}if(dist===1/0)break;solutions[nearest]=parent.concat(nearest);solutions[nearest].dist=dist}return solutions};adventurejs.generateCombinations=function Adventurejs_generateCombinations(arrays){function combine(prefix,arrays,index,result){if(index===arrays.length)result.push(prefix.join(", "));else for(var item of arrays[index])combine([...prefix,item],arrays,index+1,result)}var combined=[],arrays=(combine([],arrays,0,combined),combined.flatMap(str=>str.split(", ").map(s=>s.trim()))),uniqueParts,results;return[[...new Set(arrays)].join(", ")]};adventurejs.getBaselineDiff=function Adventurejs_getBaselineDiff(){var world_diff={},starttime=(new Date).getTime(),world_diff;if(void 0===(world_diff=A.diff.call(this.game,this.game.baseline.world,this.game.world))._title)world_diff._title=this.game.world._title;if(void 0===world_diff._timestamp)world_diff._timestamp=(new Date).getTime().toString();if(void 0===world_diff._intervals)world_diff._intervals=this.game.world._intervals;if(void 0===world_diff._vars)world_diff._vars=this.game.world._vars;world_diff=JSON.stringify(world_diff);this.game.log("L1040","log","high",`getBaselineDiff() took ${((new Date).getTime()-starttime)/1e3} seconds.`,"CopyOperations");return world_diff};adventurejs.getHorizontalDistance=function Adventurejs_getHorizontalDistance(point1,point2){var deltaX=point2.x-point1.x,point2=point2.z-point1.z;return Math.sqrt(deltaX*deltaX+point2*point2)};adventurejs.getRecentAssets=function Adventurejs_getRecentAssets(){let i=0;for(var assets=[];i<5;){var input=this.game.parser.input_history[i];if(void 0===input)break;for(let j=1;j<4;j++){var asset=input.getAsset(j);if(asset)assets.push(asset.id)}i++}return assets};adventurejs.getStringArrayFunction=adventurejs.getSAF=function Adventurejs_getStringOrArrayOrFunction(obj,scope,params={}){var msg="",err="";if("string"==typeof obj||"boolean"==typeof obj||null===obj)return obj;if(Array.isArray(obj))obj={use_saf:true,randomize:false,reset:false,frequency:1,index:0,array:obj};if(obj&&obj.array){if(void 0===obj.use_saf)obj.use_saf=true;if(void 0===obj.randomize)obj.randomize=this.game.settings.randomize_arrays_in_getStringArrayFunction;if(void 0===obj.reset)obj.reset=this.game.settings.reset_arrays_in_getStringOrArrayOrFunction;if(void 0===obj.index)obj.index=0;if(void 0===obj.frequency)obj.frequency=1;if(obj.frequency<+Math.random())return"";if(obj.randomize){var rand=Math.floor(Math.random()*obj.array.length),msg;if("string"!=typeof(msg=obj.array[rand])){msg="";this.log("L1540","warn",0,err="getStringArrayFunction found an array item that is something other than a string.","Game")}}else{if("string"!=typeof(msg=obj.array[obj.index])){msg="";this.log("L1541","warn",0,err="getStringArrayFunction found an array item that is something other than a string.","Game")}obj.index++;if(obj.index>=obj.array.length)obj.index=obj.reset?0:obj.array.length-1}return msg}if("function"==typeof obj){if("string"!=typeof(msg=scope?obj.call(scope):obj(this))){msg="";this.log("L1542","warn",0,err="getStringArrayFunction called a function that returned something other than a string.","Game")}return msg}};adventurejs.getVerbAgreement=function Adventurejs_getVerbAgreement(verb_name){console.warn("getVerbAgreement",verb_name);if(!verb_name)return"";var player=this.game.getPlayer(),subject=this.game.getInput().getSubject(),subject_has_propername;if(subject&&subject.id!==player.id&&subject.propername||["nonhuman","male","female"].includes(this.game.getInput().getSubject().pronouns))if(verb_name.endsWith("ch")||verb_name.endsWith("sh")||verb_name.endsWith("x")||verb_name.endsWith("s")||verb_name.endsWith("z")||verb_name.endsWith("o"))return verb_name+"es";else if(verb_name.endsWith("y")&&!/[aeiou]y$/.test(verb_name))return verb_name.slice(0,-1)+"ies";else return verb_name+"s";else return verb_name};adventurejs.handlePlaceholders=function Adventurejs_substituteCustomTemplates(msg){let token_regex=/\{(.*?)\}/g,exec_results=[],tokens=[],getVerbState=(asset,state)=>{var state=this.dictionary.verbs[this.dictionary.verb_state_lookup[state]];if(state&&asset.dov[state.name]){if(state.state&&asset.is[state.state])return state.state_string;if(false===asset.is[state.state])return state.unstate_string;else return}};var processClasses=token=>{var regex=/\[([^\]]*)\]/;let split_token;if(-1<token.search(regex))split_token=token.trim().split(regex);var token=split_token[1].trim(),regex=split_token[2].trim();if("image"===token)if(this.game.image_lookup[regex])return`<img src="${this.game.image_lookup[regex]}"/>`;return`<span class="${token}">${regex}</span>`};let getAssetFromTokenId=token_id=>{let asset;var direction,direction=this.dictionary.getDirection(token_id);if(direction){if((asset=this.getExitFromDirection(direction))&&asset.aperture)asset=this.getAsset(asset.aperture)}else asset=this.getAsset(token_id);return asset};for(var processAssetIsOr=token=>{var token=token.split("[is]").map(e=>e.trim()),token_id=token[0],token=token[1];let new_string="in an unknown state";var asset=getAssetFromTokenId(token_id),verb_states=token.split("[or]").map(e=>e.trim());if(verb_states.length){let found=false;for(let i=0;i<verb_states.length;i++){var state=verb_states[i];let state_string;if(state)state_string=getVerbState(asset,state);if(state_string){new_string=state_string;found=true;break}}if(!found)for(let i=0;i<verb_states.length;i++)if(asset.is[verb_states[i]]){new_string=verb_states[i];break}}return new_string},processAssetIsThen=token=>{var token=token.split("[is]").map(e=>e.trim()),token_id=token[0],hasElse,asset;let isThen=token[1],is,then,ells,isState=false;if(-1!==isThen.indexOf("[else]")){ells=isThen.split("[else]")[1];isThen=isThen.split("[else]")[0]}then=isThen.split("[then]")[1];is=isThen.split("[then]")[0].split("[is]")[0].trim();if(getAssetFromTokenId(token_id).is[is])isState=true;if(isState&&then)return then;if(!isState&&ells)return ells;else return""},processPronoun=(token,pronoun)=>{var player=this.game.getPlayer(),subject=this.game.getInput().getSubject(),upper_regex=new RegExp(/[A-Z]/),lower_regex=new RegExp(/[a-z]/),upper_regex=-1<token.substring(0,1).search(upper_regex),lower_regex=-1===token.search(lower_regex);if(subject&&subject.id!==player.id)if(upper_regex&&!lower_regex)pronoun=subject.propername||subject.Name;else pronoun=this.game.dictionary.pronouns[subject.pronouns][token];else if(upper_regex)pronoun=A.propercase(pronoun);if(lower_regex)pronoun=pronoun.toUpperCase();return pronoun},token,first,last,pronoun,dont;null!==(exec_results=token_regex.exec(msg));)tokens.push([exec_results[1],exec_results.index,token_regex.lastIndex]);for(;0<tokens.length;){let new_string="unknown";token=tokens[tokens.length-1][0];first=tokens[tokens.length-1][1];last=tokens[tokens.length-1][2];new_string="<span class='system error'>No substitute found for {"+token+"}</span>";if(pronoun=this.dictionary.getPronoun(token.toLowerCase()))new_string=processPronoun(token,pronoun);else if("success_adverb"===token)new_string=this.dictionary.success_adverbs[Math.floor(Math.random()*this.dictionary.success_adverbs.length)];else if("fail_adverb"===token)new_string=this.dictionary.fail_adverbs[Math.floor(Math.random()*this.dictionary.fail_adverbs.length)];else if(void 0!==this.world._vars[token])new_string=A.getSAF.call(this,this.world._vars[token]);else if(-1!==token.indexOf("[is]")&&-1!==token.indexOf("[then]"))new_string=processAssetIsThen(token);else if(-1!==token.indexOf("[is]")||-1!==token.indexOf(" is "))new_string=processAssetIsOr(token);else if(-1<token.search(/\[([^\]]*)\]/))new_string=processClasses(token,this);msg=msg.substring(0,first)+new_string+msg.substring(last,msg.length);tokens.pop()}return msg};adventurejs.hasDuplicates=function Adventurejs_hasDuplicates(array,specificItem){if(!Array.isArray(array)){console.warn("hasDuplicates.js received something that's not an array. ");return false}var seenItems=new Set;if(void 0!==specificItem){let specificItemCount=0;for(var item of array)if(item===specificItem)if(1<++specificItemCount)return true;return false}else{for(let item of array){if(seenItems.has(item))return true;seenItems.add(item)}return false}};adventurejs.indexOfSubarray=function Adventurejs_indexOfSubarray(sub,arr){var index=-1,subJson=JSON.stringify(sub);if(false===Array.isArray(sub)||false===Array.isArray(arr));else for(var i=0;i<arr.length;i++)if(subJson===JSON.stringify(arr[i])){index=i;break}return index};adventurejs.isFalseOrNull=function Adventurejs_isFalseOrNull(value){return false===value||null===value};adventurejs.isIdInMixedArray=function Adventurejs_isIdInMixedArray(id,array){for(var bool=false,i=0;i<array.length;i++){var object_i=array[i];if("string"==typeof object_i&&object_i===id)bool=true;else if(Object(object_i)===object_i){var object_i_keys=Object.keys(object_i),num,object_i_key;for(num in object_i_keys){if(object_i_keys[num]===id)bool=true}}}return bool};adventurejs.isObfuscated=function Adventurejs_isObfuscated(text){return"~"===text[0]};adventurejs.mergeWorld=function Adventurejs_mergeWorld(source,dest){for(var starttime=(new Date).getTime(),props=Object.keys(source),i=0;i<props.length;i++){var prop=props[i];if(source[prop]&&!dest[prop]){if("string"==typeof dest&&Array.isArray(source))dest=[];else if("string"==typeof dest&&"object"==typeof source)dest={};if(source[prop].class)dest[prop]=new adventurejs[source[prop].class](source[prop].id,this.game_name);try{dest[prop]=A.clone.call(this.game,source[prop])}catch(err){this.game.log("L1043","warn",0,err.message,"CopyOperations");continue}}if(source[prop]&&dest[prop]&&source[prop].class&&!dest[prop].class){dest[prop]=new adventurejs[source[prop].class](source[prop].id,this.game_name);dest[prop]=A.clone.call(this.game,source[prop])}else if("string"==typeof source[prop]||!source[prop]||"function"==typeof source[prop]||Array.isArray(source[prop])||"object"!=typeof source[prop]||null===source[prop])dest[prop]=A.clone.call(this.game,source[prop]);else dest[prop]=A.mergeWorld.call(this,source[prop],dest[prop])}return dest};adventurejs.obfuscate=function Adventurejs_obfuscate(text){return Array.from(text).map(c=>String.fromCharCode(c.charCodeAt(0)+3)).join("")};adventurejs.propercase=function Adventurejs_propercase(string){if("string"!=typeof string)return"";else return string=(string=string.toLowerCase()).charAt(0).toUpperCase()+string.substring(1)};adventurejs.randomize=function Adventurejs_randomize(arr){if(Array.isArray(arr))return arr[Math.floor(Math.random()*arr.length)];else return""};adventurejs.replaceStringsWithObjects=function Adventurejs_replaceStringsWithObjects(source,destination){function recurse(sourceObj,destObj){for(var key in destObj)if("string"==typeof destObj[key]&&sourceObj[key]&&"object"==typeof sourceObj[key])destObj[key]=sourceObj[key];else if("object"==typeof destObj[key]&&!Array.isArray(destObj[key]))recurse(sourceObj[key]||{},destObj[key])}recurse(source,destination);return destination};adventurejs.restoreWorld=function Adventurejs_restoreWorld(source){this.game.log("L1041","log","high","restoreWorld.js attempting to restore the world.","CopyOperations");var starttime=(new Date).getTime();if("string"==typeof source)source=JSON.parse(source);if(void 0===source._timestamp){alert("The selected json file doesn't appear to be a valid adventurejs save file.");return false}if(source._title&&this.game.title&&source._title!==this.game.title){alert("The selected save file doesn't appear to be for this game.");return false}if(source._ifid&&this.game.ifid&&source._ifid!==this.game.ifid){alert("The selected save file doesn't appear to be for this game.");return false}this.world={};this.world=A.clone.call(this,this.baseline.world);this.world=A.mergeWorld.call(this,source,this.world);source=null;this.game.updateDisplayRoom();this.game.scorecard.updateScore();this.game.log("L1042","log","high","restoreWorld() took "+((new Date).getTime()-starttime)/1e3+" seconds.","CopyOperations");return true};adventurejs.serialize=function Adventurejs_serialize(name){if("string"!=typeof name)return"";else return name.replace(/ /g,"_").replace(/\./g,"$").toLowerCase()};adventurejs.serializeArray=function Adventurejs_serializeArray(array){if(false===Array.isArray(array))console.warn("SerializeArray: "+array+" is not an array.");else for(var i=0;i<array.length;i++){if("string"==typeof array[i])array[i]=A.serialize(array[i]);if("object"==typeof array[i]);}return array};adventurejs.stringToArray=function Adventurejs_stringToArray(string){if("string"==typeof string)string=[string];return string};(()=>{function UID(){throw"UID cannot be instantiated"}UID._nextID=0;UID.get=function UID_get(){return"_"+UID._nextID++};adventurejs.UID=UID})();adventurejs.validateAssetList=function Adventurejs_validateAssetList(property){if(void 0===property)return[];if("string"==typeof property)property=A.stringToArray(property);if(Array.isArray(property)){for(var i=0;i<property.length;i++)if("string"==typeof property[i])property[i]=A.serialize(property[i]);else if(Object(property[i])===property[i])for(var key in property[i]){var value=property[i][key],id=A.serialize(key);if("string"==typeof value)value=A.stringToArray(A.serialize(value));if(Array.isArray(value)||Object(value)===value)value=A.validateAssetList(value);delete property[i][key];property[i][id]=value}}else if(Object(property)===property)for(var key in property){var value=property[key],id=A.serialize(key);if("string"==typeof value)value=A.stringToArray(A.serialize(value));else if(Array.isArray(value)||Object(value)===value)value=A.validateAssetList(value);delete property[key];property[id]=value}return property};adventurejs.validateClassList=function Adventurejs_validateClassList(property){property=adventurejs.stringToArray(property);for(var i=0;i<property.length;i++)if(!A[property[i]])property[i]=null;return property};if("function"!=typeof Object.assign)Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(null==target)throw new TypeError("Cannot convert undefined or null to object");for(var to=Object(target),index=1;index<arguments.length;index++){var nextSource=arguments[index];if(null!=nextSource)for(var nextKey in nextSource)if(Object.prototype.hasOwnProperty.call(nextSource,nextKey))to[nextKey]=nextSource[nextKey]}return to},writable:true,configurable:true});var aria=aria||{};aria.KeyCode={BACKSPACE:8,TAB:9,RETURN:13,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46};aria.Utils=aria.Utils||{};aria.Utils.matches=function(element,selector){if(!Element.prototype.matches)Element.prototype.matches=Element.prototype.matchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector||Element.prototype.oMatchesSelector||Element.prototype.webkitMatchesSelector||function(s){for(var matches=element.parentNode.querySelectorAll(s),i=matches.length;0<=--i&&matches.item(i)!==this;);return-1<i};return element.matches(selector)};aria.Utils.remove=function(item){if(item.remove&&"function"==typeof item.remove)return item.remove();if(item.parentNode&&item.parentNode.removeChild&&"function"==typeof item.parentNode.removeChild)return item.parentNode.removeChild(item);else return false};aria.Utils.isFocusable=function(element){if(0<element.tabIndex||0===element.tabIndex&&null!==element.getAttribute("tabIndex"))return true;if(element.disabled)return false;switch(element.nodeName){case"A":return!!element.href&&"ignore"!=element.rel;case"INPUT":return"hidden"!=element.type&&"file"!=element.type;case"BUTTON":case"SELECT":case"TEXTAREA":return true;default:return false}};aria.Utils.getAncestorBySelector=function(element,selector){if(!aria.Utils.matches(element,selector+" "+element.tagName))return null;for(var currentNode=element,ancestor=null;null===ancestor;)if(aria.Utils.matches(currentNode.parentNode,selector))ancestor=currentNode.parentNode;else currentNode=currentNode.parentNode;return ancestor};aria.Utils.hasClass=function(element,className){return new RegExp("(\\s|^)"+className+"(\\s|$)").test(element.className)};aria.Utils.addClass=function(element,className){if(!aria.Utils.hasClass(element,className))element.className+=" "+className};aria.Utils.removeClass=function(element,className){var className=new RegExp("(\\s|^)"+className+"(\\s|$)");element.className=element.className.replace(className," ").trim()};aria.Utils.bindMethods=function(object){var methodNames;Array.prototype.slice.call(arguments,1).forEach(function(method){object[method]=object[method].bind(object)})};var aria=aria||{};aria.Listbox=function(listboxNode){this.listboxNode=listboxNode;this.activeDescendant=this.listboxNode.getAttribute("aria-activedescendant");this.multiselectable=this.listboxNode.hasAttribute("aria-multiselectable");this.moveUpDownEnabled=false;this.siblingList=null;this.upButton=null;this.downButton=null;this.moveButton=null;this.keysSoFar="";this.handleFocusChange=function(){};this.handleItemChange=function(event,items){};this.registerEvents()};aria.Listbox.prototype.registerEvents=function(){this.listboxNode.addEventListener("focus",this.setupFocus.bind(this));this.listboxNode.addEventListener("keydown",this.checkKeyPress.bind(this));this.listboxNode.addEventListener("click",this.checkClickItem.bind(this))};aria.Listbox.prototype.setupFocus=function(){if(this.activeDescendant);};aria.Listbox.prototype.focusFirstItem=function(){var firstItem,firstItem=this.listboxNode.querySelector('[role="option"]');if(firstItem)this.focusItem(firstItem)};aria.Listbox.prototype.focusLastItem=function(){var itemList=this.listboxNode.querySelectorAll('[role="option"]');if(itemList.length)this.focusItem(itemList[itemList.length-1])};aria.Listbox.prototype.checkKeyPress=function(evt){var key=evt.which||evt.keyCode,nextItem=document.getElementById(this.activeDescendant);if(!nextItem);else switch(key){case aria.KeyCode.PAGE_UP:case aria.KeyCode.PAGE_DOWN:if(this.moveUpDownEnabled){evt.preventDefault();if(key===aria.KeyCode.PAGE_UP)this.moveUpItems();else this.moveDownItems()}break;case aria.KeyCode.UP:case aria.KeyCode.DOWN:evt.preventDefault();if(this.moveUpDownEnabled&&evt.altKey)if(key===aria.KeyCode.UP)this.moveUpItems();else this.moveDownItems();else{if(key===aria.KeyCode.UP)nextItem=nextItem.previousElementSibling;else nextItem=nextItem.nextElementSibling;if(nextItem)this.focusItem(nextItem)}break;case aria.KeyCode.HOME:evt.preventDefault();this.focusFirstItem();break;case aria.KeyCode.END:evt.preventDefault();this.focusLastItem();break;case aria.KeyCode.SPACE:evt.preventDefault();this.toggleSelectItem(nextItem);break;case aria.KeyCode.BACKSPACE:case aria.KeyCode.DELETE:case aria.KeyCode.RETURN:if(!this.moveButton);else{var keyshortcuts=this.moveButton.getAttribute("aria-keyshortcuts");if(key===aria.KeyCode.RETURN&&-1===keyshortcuts.indexOf("Enter"));else if((key===aria.KeyCode.BACKSPACE||key===aria.KeyCode.DELETE)&&-1===keyshortcuts.indexOf("Delete"));else{evt.preventDefault();for(var nextUnselected=nextItem.nextElementSibling;nextUnselected&&"true"==nextUnselected.getAttribute("aria-selected");)nextUnselected=nextUnselected.nextElementSibling;if(!nextUnselected){nextUnselected=nextItem.previousElementSibling;for(;nextUnselected&&"true"==nextUnselected.getAttribute("aria-selected");)nextUnselected=nextUnselected.previousElementSibling}this.moveItems();if(!this.activeDescendant&&nextUnselected)this.focusItem(nextUnselected)}}break;default:var keyshortcuts=this.findItemToFocus(key);if(keyshortcuts)this.focusItem(keyshortcuts);break}};aria.Listbox.prototype.findItemToFocus=function(key){var itemList=this.listboxNode.querySelectorAll('[role="option"]'),key=String.fromCharCode(key);if(!this.keysSoFar)for(var i=0;i<itemList.length;i++)if(itemList[i].getAttribute("id")==this.activeDescendant)this.searchIndex=i;this.keysSoFar+=key;this.clearKeysSoFarAfterDelay();var key=this.findMatchInRange(itemList,this.searchIndex+1,itemList.length);if(!key)key=this.findMatchInRange(itemList,0,this.searchIndex);return key};aria.Listbox.prototype.clearKeysSoFarAfterDelay=function(){if(this.keyClear){clearTimeout(this.keyClear);this.keyClear=null}this.keyClear=setTimeout(function(){this.keysSoFar="";this.keyClear=null}.bind(this),500)};aria.Listbox.prototype.findMatchInRange=function(list,startIndex,endIndex){for(var n=startIndex;n<endIndex;n++){var label=list[n].innerText;if(label&&0===label.toUpperCase().indexOf(this.keysSoFar))return list[n]}return null};aria.Listbox.prototype.checkClickItem=function(evt){if("option"===evt.target.getAttribute("role")){this.focusItem(evt.target);this.toggleSelectItem(evt.target)}};aria.Listbox.prototype.toggleSelectItem=function(element){if(this.multiselectable){element.setAttribute("aria-selected","true"===element.getAttribute("aria-selected")?"false":"true");if(this.moveButton)if(this.listboxNode.querySelector('[aria-selected="true"]'))this.moveButton.setAttribute("aria-disabled","false");else this.moveButton.setAttribute("aria-disabled","true")}};aria.Listbox.prototype.defocusItem=function(element){if(!element);else{if(!this.multiselectable)element.removeAttribute("aria-selected");aria.Utils.removeClass(element,"focused")}};aria.Listbox.prototype.focusItem=function(element){this.defocusItem(document.getElementById(this.activeDescendant));if(!this.multiselectable)element.setAttribute("aria-selected","true");aria.Utils.addClass(element,"focused");this.listboxNode.setAttribute("aria-activedescendant",element.id);this.activeDescendant=element.id;if(this.listboxNode.scrollHeight>this.listboxNode.clientHeight){var scrollBottom=this.listboxNode.clientHeight+this.listboxNode.scrollTop,elementBottom=element.offsetTop+element.offsetHeight;if(scrollBottom<elementBottom)this.listboxNode.scrollTop=elementBottom-this.listboxNode.clientHeight;else if(element.offsetTop<this.listboxNode.scrollTop)this.listboxNode.scrollTop=element.offsetTop}if(!this.multiselectable&&this.moveButton)this.moveButton.setAttribute("aria-disabled",false);this.checkUpDownButtons();this.handleFocusChange(element)};aria.Listbox.prototype.checkUpDownButtons=function(){var activeElement=document.getElementById(this.activeDescendant);if(!this.moveUpDownEnabled)return false;if(!activeElement){this.upButton.setAttribute("aria-disabled","true");this.downButton.setAttribute("aria-disabled","true")}else{if(this.upButton)if(activeElement.previousElementSibling)this.upButton.setAttribute("aria-disabled",false);else this.upButton.setAttribute("aria-disabled","true");if(this.downButton)if(activeElement.nextElementSibling)this.downButton.setAttribute("aria-disabled",false);else this.downButton.setAttribute("aria-disabled","true")}};aria.Listbox.prototype.addItems=function(items){if(!items||!items.length)return false;items.forEach(function(item){this.defocusItem(item);this.toggleSelectItem(item);this.listboxNode.append(item)}.bind(this));if(!this.activeDescendant)this.focusItem(items[0]);this.handleItemChange("added",items)};aria.Listbox.prototype.deleteItems=function(){var itemsToDelete;if(this.multiselectable)itemsToDelete=this.listboxNode.querySelectorAll('[aria-selected="true"]');else if(this.activeDescendant)itemsToDelete=[document.getElementById(this.activeDescendant)];if(!itemsToDelete||!itemsToDelete.length)return[];itemsToDelete.forEach(function(item){item.remove();if(item.id===this.activeDescendant)this.clearActiveDescendant()}.bind(this));this.handleItemChange("removed",itemsToDelete);return itemsToDelete};aria.Listbox.prototype.clearActiveDescendant=function(){this.activeDescendant=null;this.listboxNode.setAttribute("aria-activedescendant",null);if(this.moveButton)this.moveButton.setAttribute("aria-disabled","true");this.checkUpDownButtons()};aria.Listbox.prototype.moveUpItems=function(){var previousItem;if(!this.activeDescendant);else{if(previousItem=(currentItem=document.getElementById(this.activeDescendant)).previousElementSibling){this.listboxNode.insertBefore(currentItem,previousItem);this.handleItemChange("moved_up",[currentItem])}this.checkUpDownButtons()}};aria.Listbox.prototype.moveDownItems=function(){var nextItem;if(!this.activeDescendant);else{if(nextItem=(currentItem=document.getElementById(this.activeDescendant)).nextElementSibling){this.listboxNode.insertBefore(nextItem,currentItem);this.handleItemChange("moved_down",[currentItem])}this.checkUpDownButtons()}};aria.Listbox.prototype.moveItems=function(){if(!this.siblingList);else{var itemsToMove=this.deleteItems();this.siblingList.addItems(itemsToMove)}};aria.Listbox.prototype.enableMoveUpDown=function(upButton,downButton){this.moveUpDownEnabled=true;this.upButton=upButton;this.downButton=downButton;upButton.addEventListener("click",this.moveUpItems.bind(this));downButton.addEventListener("click",this.moveDownItems.bind(this))};aria.Listbox.prototype.setupMove=function(button,siblingList){this.siblingList=siblingList;(this.moveButton=button).addEventListener("click",this.moveItems.bind(this))};aria.Listbox.prototype.setHandleItemChange=function(handlerFn){this.handleItemChange=handlerFn};aria.Listbox.prototype.setHandleFocusChange=function(focusChangeHandler){this.handleFocusChange=focusChangeHandler};(()=>{class Dictionary{constructor(game){this.game=game;this.directions={};this.direction_lookup={};this.verbs={};this.enabled_verbs=[];this.disabled_verbs=[];this.did_initialize_verbs=false;this.verb_lookup={};this.verb_noun_preps=[];this.verb_prep_nouns=[];this.verb_prep_prep_nouns=[];this.verb_prep_prep_prep_nouns=[];this.verb_noun_prep_nouns=[];this.verb_noun_prep_prep_nouns=[];this.verb_noun_prep_noun_prep_nouns=[];this.verb_prep_noun_prep_nouns=[];this.verb_prep_noun_prep_noun_prep_nouns=[];this.verb_state_lookup={};return this}initStandardVerbs(){for(var preverb in A.Preverbs)this.createVerb(A.Preverbs[preverb]);this.did_initialize_verbs=true}isPreposition(word){var bool=false;if(-1<this.prepositions.indexOf(word))bool=true;return bool}getPreposition(word){if(-1<this.prepositions.indexOf(word))return word;else return false}getAdverb(word){this.game.log("L1527","log","high","[Dictionary.js] getAdverb receive: "+word,"Parser");if(-1<this.adverbs.indexOf(word)){this.game.log("L1528","log","high","[Dictionary.js] getAdverb found: "+word,"Parser");return word}else return false}getAdjective(word){if(-1<this.adjectives.indexOf(word))return word;else return false}set(props){return A.deepSet.call(this.game,props,this)}}adventurejs.Dictionary=Dictionary})();(()=>{var p;adventurejs.Dictionary.prototype.adjectives=["south","s","north","n","east","e","west","w","northeast","ne","northwest","nw","southeast","se","southwest","sw","port","starboard","aft","fore","old","new","dirty","clean","loud","quiet","good","bad","best","worst","big","little","small","large","tiny","huge","tall","short","long","wide","narrow","heavy","light","strong","weak","fast","slow","hot","cold","red","orange","yellow","green","blue","indigo","violet","purple","pink","white","black","grey","brown","tan","beige","clear","transparent","opaque"]})();(()=>{var p;adventurejs.Dictionary.prototype.adverbs=["carefully","quietly","quickly","slowly","gently","softly","firmly","patiently","noisily","loudly","cautiously","delicately","swiftly","boldly","upstairs","downstairs","sideways","back","left","right","towards"]})();(()=>{var p;adventurejs.Dictionary.prototype.aspects=["attached","behind","in","on","under","worn","hung","tied"]})();(()=>{var p;adventurejs.Dictionary.prototype.combineVerbs=function(pushVerbs,intoVerb){if("string"!=typeof intoVerb){var msg="Dictionary.combineVerbs takes a string but received unknown object "+intoVerb+". ";this.game.log("L1327","warn","critical",msg,"dictionary");return false}if(void 0===this.verbs[intoVerb]){var msg="Dictionary.combineVerbs received unknown verb "+intoVerb+". ";this.game.log("L1328","warn","critical",msg,"dictionary");return false}if("string"==typeof pushVerbs)pushVerbs=[pushVerbs];for(var v=0;v<pushVerbs.length;v++){var pushVerb=pushVerbs[v];if(void 0===this.verbs[pushVerb]){var msg="Dictionary.combineVerbs received unknown verb "+pushVerb+". ";this.game.log("L1329","warn","critical",msg,"dictionary")}else{for(var s=0;s<this.verbs[pushVerb].synonyms.length;s++)this.verb_lookup[intoVerb].synonyms.push(this.verbs[pushVerb].synonyms[s]);delete this.verb_lookup[pushVerb];delete this.verbs[pushVerb]}}}})();(()=>{var p=adventurejs.Dictionary.prototype;p.hasCommonWord=function Dictionary_hasCommonWord(word){return this.common_words.includes(word)};p.common_words=["brother","sister","aunt","uncle","grandmother","grandfather","store","cafe","shop","restaurant","zoo","mall","library","school","park","bakery","bar","museum","hospital","station","hotel","pharmacy","market","bank","church","theater","clinic","post office","university","diner","garage","airport","pier","gym","alley","courtyard","hall","garden","path","grove","meadow","attic","basement","cellar","tower","chapel","crypt","barn","shed","porch","veranda","balcony","clearing","bridge","tunnel","cavern","chamber","den","hearth","threshold","terrace","spire","ledge","archway","child","sister","brother","mother","father","stranger","vendor","beggar","priest","teacher","merchant","watchman","librarian","nurse","tailor","butcher","soldier","mechanic","traveler","guide","patient","clerk","rider","bystander","singer","fisherman","caretaker","driver","thief","monk","orphan","widow","scholar","apprentice","prophet","hand","eye","face","mouth","ear","hair","fingers","teeth","skin","voice","heart","breath","bone","shadow","gaze","palm","tongue","sigh","scar","foot","wrist","back","leg","arm","laugh","blink","step","touch","grip","pulse"]})();(()=>{var p;adventurejs.Dictionary.prototype.compound_prepositions=[[" below "," under "],[" down under "," under "],[" towards "," toward "],[" away from "," from "],[" above "," over "],[" inside "," in "],[" into "," in "],[" in to "," in "],[" inside "," in "],[" up on to "," on "],[" up onto "," on "],[" up on "," on "],[" up in "," in "],[" up over "," over "],[" onto "," on "],[" on to "," on "],[" on top of "," on "],[" down off of "," off "],[" down off "," off "],[" down from "," off "],[" off of "," off "],[" up off "," off "],[" out of "," out "],[" over to "," to "],[" go to "," goto "],[" in front of "," infrontof "],[" out from under "," outfromunder "],[" out from behind "," outfrombehind "],[" from under "," fromunder "],[" from behind "," frombehind "],[" from on "," fromon "],[" from in "," fromin "],[" from inside "," fromin "]]})();(()=>{var p;adventurejs.Dictionary.prototype.createVerb=function(preverb){if(void 0===preverb){var msg="Dictionary.createVerb received a bad value: "+preverb;this.game.log("L1287","warn",0,msg,"dictionary");return false}if(void 0===preverb.name){var msg="Dictionary.createVerb received a preverb without a name: "+preverb;this.game.log("L1288","warn",0,msg,"dictionary");return false}if(this.verbs[preverb.name]){var msg="Dictionary.createVerb Found an existing verb named "+preverb.name+". ";this.game.log("L1289","warn","critical",msg,"dictionary");return false}this.verbs[preverb.name]=new adventurejs.Verb(this.game);this.verbs[preverb.name].set(preverb);this.verbs[preverb.name].validate();this.verbs[preverb.name].initialize();this.verb_lookup[preverb.name]={synonyms:preverb.synonyms};return this.verbs[preverb.name]}})();(()=>{var p;adventurejs.Dictionary.prototype.disableAllVerbsBut=function(enabled_verbs){if("string"==typeof enabled_verbs)enabled_verbs=[enabled_verbs];for(var verbs=Object.keys(this.verbs),i=verbs.length-1;-1<i;i--){var verb=verbs[i],index;if(-1===enabled_verbs.indexOf(verbs[i])){delete this.verb_lookup[verb];delete this.verbs[verb]}}}})();(()=>{var p;adventurejs.Dictionary.prototype.disableVerbs=function(disabled_verbs){this.game.log("L1290","log","high","Dictionary.disableVerbs "+disabled_verbs,"dictionary");if("string"==typeof disabled_verbs)disabled_verbs=[disabled_verbs];for(var i=0;i<disabled_verbs.length;i++){var verb=disabled_verbs[i],msg;if(void 0===this.verb_lookup[verb]){this.game.log("L1291","warn","critical","Dictionary.disableVerbs received unknown verb "+verb+". ","dictionary")}else{delete this.verb_lookup[verb];delete this.verbs[verb];this.disabled_verbs.push(disabled_verbs[i])}}}})();(()=>{var p;adventurejs.Dictionary.prototype.doVerb=function(verb){this.game.log("L1311","log","high","Dictionary.doVerb > verb: "+verb,"dictionary");if(void 0!==this.verbs[verb])return this.verbs[verb].do();else return false}})();(()=>{var p;adventurejs.Dictionary.prototype.enableVerbs=function(disabled_verbs){if("string"==typeof disabled_verbs)disabled_verbs=[disabled_verbs];for(var i=0;i<disabled_verbs.length;i++){var verb=disabled_verbs[i];if(!this.verbs[verb])if(A.Preverbs[verb]){this.createVerb(A.Preverbs[verb]);this.disabled_verbs.splice(this.disabled_verbs.indexOf(verb),1)}}}})();(()=>{var p;adventurejs.Dictionary.prototype.exit_prepositions={behind:"out",in:"out",on:"off",under:"out"}})();(()=>{var p;adventurejs.Dictionary.prototype.fail_adverbs=["dramatically","astonishingly","stunningly","remarkably","extravagantly","magnificently","breathtakingly","impressively","phenomenally","astoundingly","gloriously","grandly","majestically","unbelievably","overwhelmingly","incredibly","sensationally","epicly","catastrophically","disastrously","horrifically","terribly","miserably","abysmally","dreadfully","appallingly","disgracefully","atrociously","cringeworthily","ingloriously","infamously","shamefully","embarrassingly","pathetically","abominably","monumentally","colossally","epicly"]})();(()=>{var p;adventurejs.Dictionary.prototype.getDirection=function Dictionary_getDirection(word){if(void 0!==this.direction_lookup[word])return word;for(var prop in this.direction_lookup)if(void 0===this.direction_lookup[prop].synonyms);else for(var synonyms=this.direction_lookup[prop].synonyms,i=0;i<synonyms.length;i++)if(word===synonyms[i])return prop;return false}})();(()=>{var p;adventurejs.Dictionary.prototype.getPronoun=function Dictionary_getPronoun(pronoun){return this.pronouns[this.game.settings.person]?.[pronoun]}})();(()=>{var p;adventurejs.Dictionary.prototype.getVerb=function(verb){if("string"!=typeof verb)return false;else return this.verbs[verb]||null}})();(()=>{var p;adventurejs.Dictionary.prototype.isDirection=function Dictionary_isDirection(word){return false!==this.getDirection(word)}})();(()=>{class NounMustBe{constructor(){this.character=false;this.child_of_noun2=false;this.direction=false;this.dov=false;this.exit=false;this.extant=true;this.global=false;this.global_substance=false;this.in_hands=false;this.in_inventory=false;this.in_inventory_if_takeable=false;this.intangible=false;this.iov=false;this.known=false;this.matter=false;this.present=false;this.present_if_tangible=false;this.prefer_present_if_ambiguous=false;this.prefer_carried_if_ambiguous=false;this.prefer_uncarried_if_ambiguous=false;this.not_direction=false;this.not_exit=false;this.not_global=false;this.not_in_hands=false;this.not_in_inventory=false;this.not_in_prior_plural=false;this.not_scenery=false;this.not_substance=false;this.not_worn=false;this.not_player=false;this.player=false;this.self=false;this.not_self=false;this.parent=false;this.parent_or_room=false;this.not_parent=false;this.not_parent_or_room=false;this.tangible=false;this.reachable=false;this.reachable_if_tangible=false;this.scenery=false;this.singular=false;this.string=false;this.substance=false;this.reservoir_if_substance=false;this.reservoir_or_carried_if_substance=false;this.takeable=false;this.visible=false;this.visible_if_tangible=false;this.worn=false}}adventurejs.NounMustBe=NounMustBe})();(()=>{var p;adventurejs.Dictionary.prototype.patchVerb=function(patchVerb){if("object"!=typeof patchVerb){var msg="Dictionary.patchVerb takes an object, but received "+typeof patchVerb+": "+patchVerb;this.game.log("L1323","warn","critical",msg,"dictionary");return false}if(void 0===patchVerb.name){var msg="Dictionary.patchVerb received an object without a name: "+JSON.stringify(patchVerb);this.game.log("L1324","warn","critical",msg,"dictionary");return false}if(void 0===this.verbs[patchVerb.name]){var msg="Dictionary.patchVerb received a verb name that doesn't exist: "+patchVerb.name;this.game.log("L1325","warn","critical",msg,"Verb");return false}var msg=this.verbs[patchVerb.name];if(patchVerb.synonyms)this.game.dictionary.verb_lookup[msg.name].synonyms=this.game.dictionary.verb_lookup[msg.name].synonyms.concat(patchVerb.synonyms);msg.set(patchVerb);msg.initialize();if(false!==msg)this.game.log("L1326","log","medium","patchVerb successfully patched verb "+msg.name+".","dictionary");return msg}})();(()=>{class Phrase{constructor(){this.accepts_string=false;this.accepts_direction=false;this.requires_string=false;this.accepts_number=false;this.requires_number=false;this.accepts_noun=false;this.requires_noun=false;this.accepts_preposition=false;this.accepts_preposition_without_noun=false;this.requires_preposition=false;this.preposition_must_be=[];this.preposition_must_not_be=[];this.noun_must_be=new adventurejs.NounMustBe;this.accepts_plural_noun=false}}adventurejs.Phrase=Phrase})();(()=>{var p;adventurejs.Dictionary.prototype.postures={cling:{gerund:"clinging"},hang:{gerund:"hanging"},grip:{gerund:"gripping"},kneel:{gerund:"kneel"},lie:{gerund:"lying"},sit:{gerund:"sitting"},stand:{gerund:"standing"}}})();(()=>{var p;adventurejs.Dictionary.prototype.prepositions=["around","backward","backwards","down","foreward","forewards","left","right","up","about","for","above","across","against","at","attached","behind","beside","between","beyond","from","frombehind","fromin","fromon","fromunder","in","infront","off","on","open","out","outfrombehind","outfromunder","over","past","through","to","toward","towards","under","with"]})();(()=>{var p;adventurejs.Dictionary.prototype.pretty_exit_prepositions={behind:"out from behind",in:"out of",on:"off of",under:"out from under",over:"down from over",between:"out from between",beside:"from beside",across:"from across",attached:"from where it's attached to",through:"from"}})();(()=>{var p;adventurejs.Dictionary.prototype.pronouns={first:{we:"I",us:"me","we'd":"I'd","we've":"I've","we'll":"I'll","we're":"I'm",our:"my",ours:"mine",ourself:"myself",ourselves:"myself","don't":"don't","haven't":"haven't","weren't":"weren't",have:"have",were:"was",are:"am",see:"see"},plural:{we:"we",us:"us","we'd":"we'd","we've":"we've","we'll":"we'll","we're":"we're",our:"our",ours:"ours",ourself:"ourselves",ourselves:"ourselves","don't":"don't","haven't":"haven't","weren't":"weren't",have:"have",were:"were",are:"are",see:"see"},second:{we:"you",us:"you","we'd":"you'd","we've":"you've","we'll":"you'll","we're":"you're",our:"your",ours:"yours",ourself:"yourself",ourselves:"yourself","don't":"don't","haven't":"haven't","weren't":"weren't",have:"have",were:"were",are:"are",see:"see"},nonbinary:{we:"they",us:"them","we'd":"they'd","we've":"they've","we'll":"they'll","we're":"they're",our:"their",ours:"theirs",ourself:"themself",ourselves:"themself","don't":"don't","haven't":"haven't","weren't":"weren't",have:"have",were:"were",are:"are",see:"see"},male:{we:"he",us:"him","we'd":"he'd","we've":"he's","we'll":"he'll","we're":"he's",our:"his",ours:"his",ourself:"himself",ourselves:"himself","don't":"doesn't","haven't":"hasn't","weren't":"wasn't",have:"has",were:"was",are:"is",see:"sees"},female:{we:"she",us:"her","we'd":"she'd","we've":"she's","we'll":"she'll","we're":"she's",our:"her",ours:"hers",ourself:"herself",ourselves:"herself","don't":"doesn't","haven't":"hasn't","weren't":"wasn't",have:"has",were:"was",are:"is",see:"sees"},nonhuman:{we:"it",us:"it","we'd":"it'd","we've":"it's","we'll":"it'll","we're":"it's",our:"its",ours:"its",ourself:"itself",ourselves:"itself","don't":"doesn't","haven't":"hasn't","weren't":"wasn't",have:"has",were:"was",are:"is",see:"sees"}}})();(()=>{var p;adventurejs.Dictionary.prototype.replaceVerb=function(oldVerb,newVerb){oldVerb=this.disableVerbs(oldVerb);if(false!==(newVerb=this.createVerb(newVerb)))this.game.log("L1310","log",2,"replaceVerb successfully replaced verb "+newVerb.name+".","dictionary");return newVerb}})();(()=>{var p;adventurejs.Dictionary.prototype.set=function Dictionary_set(props){if(null!=props)for(var n in props)this[n]=props[n];return this}})();(()=>{var p=adventurejs.Dictionary.prototype;p.string_lookup={prepositions:{attached:"attached to",behind:"behind",in:"in",on:"on",over:"over",through:"through",under:"under",worn:"worn"},posture_positions:{default:"resting",resting:"resting",lying:"lying",sitting:"sitting",standing:"standing",hanging:"hanging",suspended:"suspended",floating:"floating",tied:"tied"},posture_gerunds:{climb:"climbing",cling:"clinging",crawl:"crawling",float:"floating",fly:"flying",hang:"hanging",hover:"hovering",kneel:"kneeling",lie:"lying",sit:"sitting",slither:"slithering",stand:"standing",swim:"swimming"},movement_verbs:{climb:"climb",cling:"shinny",crawl:"crawl",float:"float",fly:"fly",grip:"grip",hang:"hang",hover:"hover",kneel:"crawl",lie:"belly crawl",sit:"scoot",slither:"slither",stand:"walk",swim:"swim"},substance_percents:{0:"empty","0.0":"empty",.1:"slightly full",.2:"about a quarter full",.3:"about a third full",.4:"almost half full",.5:"half full",.6:"slightly over half full",.7:"about three quarters full",.8:"mostly full",.9:"about full","1.0":"full",1:"full"},substance_temperatures:{0:"freezing",5:"near freezing",10:"chilled",14:"cold",17:"cool",20:"tepid",23:"lukewarm",40:"warm",60:"hot",85:"scalding",90:"near boiling",100:"boiling"}};p.getStringLookup=function Dictionary_getStringLookup(type,value){var see="See adventurejs.Dictionary.html#getStringLookup. ";if("string"!=typeof type){var msg="Dictionary.getStringLookup received a non-string for type. "+see;this.game.log("L1312","warn","critical",msg,"dictionary")}else if("string"!=typeof value){var msg="Dictionary.getStringLookup received a non-string for "+type+"value. "+see;this.game.log("L1313","warn","critical",msg,"dictionary")}else if(void 0===this.string_lookup[type]){var msg="Dictionary.getStringLookup received a non-existent type: "+type+". "+see;this.game.log("L1314","warn","critical",msg,"dictionary")}else{if(void 0!==this.string_lookup[type][value])return this.string_lookup[type][value];var msg="Dictionary.getStringLookup received a non-existent value of "+type+": "+value+". "+see;this.game.log("L1315","warn","critical",msg,"dictionary")}return""};p.setStringLookup=function Dictionary_setStringLookup(type,values){var see="See adventurejs.Dictionary.html#setStringLookup. ";if("string"!=typeof type){var msg="Dictionary.setStringLookup received a non-string for type. "+see;this.game.log("L1316","warn","critical",msg,"dictionary");return false}if("object"!=typeof values){var msg="Dictionary.getStringLookup received a non-object for "+type+" values. "+see;this.game.log("L1317","warn","critical",msg,"dictionary");return false}if(void 0===this.string_lookup[type]){this.string_lookup[type]={};var msg="Dictionary.getStringLookup received a non-existent type: "+type+". adventurejs will try to add this type. "+see;this.game.log("L1318","warn","critical",msg,"dictionary")}for(var valuekeys=Object.keys(values),v=0;v<valuekeys.length;v++){var valuekey=valuekeys[v];this.string_lookup[type][valuekey]=values[valuekey]}msg="Dictionary.setStringLookup: "+JSON.stringify(this.string_lookup[type]);this.game.log("L1319","log","high",msg,"dictionary");return true};p.getStringLookupByRange=function Dictionary_getStringLookupByRange(type,value){var see="See adventurejs.Dictionary.html#getStringLookupByRange. ",str_return="",keysSorted;if("string"!=typeof type){var msg="Dictionary.getStringLookupByRange received a non-string for type. "+see;this.game.log("L1320","warn","critical",msg,"dictionary")}if(isNaN(value)){var msg="Dictionary.getStringLookupByRange received a non-numerical value for "+type+" value. "+see;this.game.log("L1321","warn","critical",msg,"dictionary")}if(void 0===this.string_lookup[type]){var msg="Dictionary.getStringLookup received a non-existent type: "+type+". "+see;this.game.log("L1322","warn","critical",msg,"dictionary");return""}for(var keysSorted=Object.keys(this.string_lookup[type]).sort(function(a,b){return a-b}),i=0;i<keysSorted.length;i++)if(Number(value)>=keysSorted[i])str_return=this.string_lookup[type][keysSorted[i]];return str_return}})();(()=>{var p;adventurejs.Dictionary.prototype.success_adverbs=["dramatically","astonishingly","stunningly","remarkably","extravagantly","magnificently","breathtakingly","impressively","phenomenally","astoundingly","splendidly","gloriously","grandly","majestically","exquisitely","unbelievably","overwhelmingly","awesomely","incredibly","sensationally","epicly"]})();(()=>{var p;adventurejs.Dictionary.prototype.testVerbSynonyms=function Dictionary_testVerbSynonyms(word1,word2){var prop,testword;if(word1===word2)return true;if("string"!=typeof word1||"string"!=typeof word2)console.warn("synonyms function takes two strings, but receive:",word1,word2);else if(void 0===this.verb_lookup[word1]&&void 0===this.verb_lookup[word2])console.warn("Neither "+word1+" nor "+word2+" were found in the dictionary.");else if(void 0!==this.verb_lookup[word1]&&void 0!==this.verb_lookup[word2]);else{if(void 0===this.verb_lookup[word1]){testword=word1;prop=word2}else{testword=word2;prop=word1}var synonyms=this.verb_lookup[prop].synonyms;if(void 0===synonyms);else for(var i=0;i<synonyms.length;i++)if(testword===synonyms[i])return prop}return false}})();(()=>{class Verb{constructor(game){this.game=game;this.dictionary=game.dictionary;this.type={travel:false,manipulation:false,direction:false,locomotion:false};this.default_direction="";this.extends="";this.name="";this.prettyname="";this.past_tense="";this.gerund="";this.posture="";this.override_aspect_posture=false;this.override_aspect_scale_increments={up:false,down:false};this.can_span=false;this.state="";this.unstate="";this.state_strings={state:"",unstate:""};this.with_params={};this.makes_connections=false;this.adjective="";this.adjectives=[];this.subject_must_be={player:true,not_constrained:true,not_on_floor:false,not_under:false,not_behind:false,not_nested_elsewhere:false};this.let_verb_handle_disambiguation=false;this.let_verb_handle_remaining_input=false;this.in_can_mean_on=false;this.is_direction=false;this.is_compass_direction=false;this.is_relative_direction=false;this.article="";this.direction_preposition="";this.phrase1=new adventurejs.Phrase;this.phrase2=new adventurejs.Phrase;this.phrase3=new adventurejs.Phrase;this.accepts_structures=[];this.accepts_adverbs=[];this.input_substitutions={};this.override_failure_msg="";this.override_success_msg="";this.msgNoObject="";this.msgNoAspect="";this.related=[];this.enqueue_collections=false;this.allow_iov_on_iov=false;return this}get Name(){return A.propercase(this.name)}get tryVerbThis(){return"try"+this.Name+"This"}get tryVerbWithThis(){return"try"+this.Name+"WithThis"}get tryVerbFromThis(){return"try"+this.Name+"FromThis"}get tryVerbThisWithThat(){return"try"+this.Name+"ThisWithThat"}get tryVerbThatWithThis(){return"try"+this.Name+"ThatWithThis"}get tryVerbThisFromThat(){return"try"+this.Name+"ThisFromThat"}get tryVerbThatFromThis(){return"try"+this.Name+"ThatFromThis"}get doVerb(){return"do"+this.Name}get doVerbThis(){return`do${this.Name}This`}get doVerbFromThis(){return`do${this.Name}FromThis`}get doVerbWithThis(){return`do${this.Name}WithThis`}get doVerbThisWithThat(){return`do${this.Name}ThisWithThat`}get doVerbThatWithThis(){return`do${this.Name}ThatWithThis`}get doVerbThisFromThat(){return`do${this.Name}ThisFromThat`}get doVerbThatFromThis(){return`do${this.Name}ThatFromThis`}get synonyms(){return this._synonyms}set synonyms(arr){if(false===Array.isArray(this._synonyms))this._synonyms=[];this._synonyms=arr;if(-1===this._synonyms.indexOf(this.name))this._synonyms.push(this.name)}get verb_prep_noun_prep_noun(){return this._verb_prep_noun_prep_noun}set verb_prep_noun_prep_noun(arr){if(!Array.isArray(this._verb_prep_noun_prep_noun))this._verb_prep_noun_prep_noun=[];if(0<this._verb_prep_noun_prep_noun.length)for(var i=this._verb_prep_noun_prep_noun.length;-1<i;i--){var pair=[this._verb_prep_noun_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_prep_noun_prep_nouns);if(-1!==pair)this.dictionary.verb_prep_noun_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_prep_noun_prep_nouns.push([arr[i],this.name]);this._verb_prep_noun_prep_noun=arr}get verb_noun_prep(){return this._verb_noun_prep}set verb_noun_prep(arr){if(false===Array.isArray(this._verb_noun_prep))this._verb_noun_prep=[];if(0<this._verb_noun_prep.length)for(var i=this._verb_noun_prep.length;-1<i;i--){var pair=[this._verb_noun_prep[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_noun_preps);if(-1!==pair)this.dictionary.verb_noun_preps.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_noun_preps.push([arr[i],this.name]);this._verb_noun_prep=arr}get verb_prep_noun(){return this._verb_prep_noun}set verb_prep_noun(arr){if(false===Array.isArray(this._verb_prep_noun))this._verb_prep_noun=[];if(0<this._verb_prep_noun.length)for(var i=this._verb_prep_noun.length;-1<i;i--){var pair=[this._verb_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_prep_nouns);if(-1!==pair)this.dictionary.verb_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_prep_nouns.push([arr[i],this.name]);this._verb_prep_noun=arr}get verb_prep_prep_noun(){return this._verb_prep_prep_noun}set verb_prep_prep_noun(arr){if(false===Array.isArray(this._verb_prep_prep_noun))this._verb_prep_prep_noun=[];if(0<this._verb_prep_prep_noun.length)for(var i=this._verb_prep_prep_noun.length;-1<i;i--){var pair=[this._verb_prep_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_prep_prep_nouns);if(-1!==pair)this.dictionary.verb_prep_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_prep_prep_nouns.push([arr[i],this.name]);this._verb_prep_prep_noun=arr}get verb_prep_prep_prep_noun(){return this._verb_prep_prep_prep_noun}set verb_prep_prep_prep_noun(arr){if(false===Array.isArray(this._verb_prep_prep_prep_noun))this._verb_prep_prep_prep_noun=[];if(0<this._verb_prep_prep_prep_noun.length)for(var i=this._verb_prep_prep_prep_noun.length;-1<i;i--){var pair=[this._verb_prep_prep_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_prep_prep_prep_nouns);if(-1!==pair)this.dictionary.verb_prep_prep_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_prep_prep_prep_nouns.push([arr[i],this.name]);this._verb_prep_prep_prep_noun=arr}get verb_noun_prep_noun(){return this._verb_noun_prep}set verb_noun_prep_noun(arr){if(false===Array.isArray(this._verb_noun_prep_noun))this._verb_noun_prep_noun=[];if(0<this._verb_noun_prep_noun.length)for(var i=this._verb_noun_prep_noun.length;-1<i;i--){var pair=[this._verb_noun_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_noun_prep_nouns);if(-1!==pair)this.dictionary.verb_noun_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_noun_prep_nouns.push([arr[i],this.name]);this._verb_noun_prep_noun=arr}get verb_noun_prep_prep_noun(){return this._verb_noun_prep}set verb_noun_prep_prep_noun(arr){if(false===Array.isArray(this._verb_noun_prep_prep_noun))this._verb_noun_prep_prep_noun=[];if(0<this._verb_noun_prep_prep_noun.length)for(var i=this._verb_noun_prep_prep_noun.length;-1<i;i--){var pair=[this._verb_noun_prep_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_noun_prep_prep_nouns);if(-1!==pair)this.dictionary.verb_noun_prep_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_noun_prep_prep_nouns.push([arr[i],this.name]);this._verb_noun_prep_prep_noun=arr}get verb_noun_prep_noun_prep_noun(){return this._verb_noun_prep_noun_prep_noun}set verb_noun_prep_noun_prep_noun(arr){if(false===Array.isArray(this._verb_noun_prep_noun_prep_noun))this._verb_noun_prep_noun_prep_noun=[];if(0<this._verb_noun_prep_noun_prep_noun.length)for(var i=this._verb_noun_prep_noun_prep_noun.length;-1<i;i--){var pair=[this._verb_noun_prep_noun_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_noun_prep_noun_prep_nouns);if(-1!==pair)this.dictionary.verb_noun_prep_noun_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_noun_prep_noun_prep_nouns.push([arr[i],this.name]);this._verb_noun_prep_noun_prep_noun=arr}get verb_prep_noun_prep_noun_prep_noun(){return this._verb_prep_noun_prep_noun_prep_noun}set verb_prep_noun_prep_noun_prep_noun(arr){if(false===Array.isArray(this._verb_prep_noun_prep_noun_prep_noun))this._verb_prep_noun_prep_noun_prep_noun=[];if(0<this._verb_prep_noun_prep_noun_prep_noun.length)for(var i=this._verb_prep_noun_prep_noun_prep_noun.length;-1<i;i--){var pair=[this._verb_prep_noun_prep_noun_prep_noun[i],this.name],pair=A.indexOfSubarray(pair,this.dictionary.verb_prep_noun_prep_noun_prep_nouns);if(-1!==pair)this.dictionary.verb_prep_noun_prep_noun_prep_nouns.splice(pair,1)}if(0<arr.length)for(var i=0;i<arr.length;i++)this.dictionary.verb_prep_noun_prep_noun_prep_nouns.push([arr[i],this.name]);this._verb_prep_noun_prep_noun_prep_noun=arr}do(){this.game.log("L1292","log","high",`[${this.name}.js] ${this.name}.do() `,"Verb");var input=this.game.getInput(),input_copy,msg="";if(-1<input.verb_chain.indexOf(this.name)&&!input.allow_circular_verb){if(msg=`[${this.name}.js] Error: Circular verb call: ${input.verb_chain}. See console for more information. `)this.game.print(msg,"error");msg+="Circular verb call:";for(var i=0;i<input.verb_chain.length;i++)msg+="\n - "+input.verb_chain[i];this.game.log("L1293","error","critical",msg,"Verb");return false}else{input.allow_circular_verb=false;input.verb_chain.push(this.name)}var qualifiedCount=1;if(input.parsedNoun1)qualifiedCount=input.parsedNoun1.matches.qualified.length;if(1<qualifiedCount){this.game.log("L1534","log","high",[`[${this.name}.js] ${this.name} enqueue multiple assets: `+input.parsedNoun1.matches.qualified.length],"Verb");input_copy=new adventurejs.Input({game_name:this.game.game_name});input_copy=Object.assign(input_copy,input)}for(var i=0;i<qualifiedCount;i++){if(0<i){this.game.parser.input_history.unshift(new adventurejs.Input({game_name:this.game.game_name}).set({plural:true}));this.game.parser.input_history[0]=Object.assign(this.game.parser.input_history[0],input_copy);input.did.doBeforeTry=false;input.did.doTry=false;input.did.doAfterTry=false;input.did.doBeforeSuccess=false;input.did.doSuccess=false;input.did.doAfterSuccess=false;input.did.tryTravel=false}let results;if(input.parsedNoun1){this.game.log("L1533","log","high",[`[${this.name}.js] ${this.name} queue asset ${i+1} of ${input.parsedNoun1?.matches.qualified.length||0}:`,input.parsedNoun1.matches.qualified[input.parsedNoun1.matches.qualifiedIndex]],"Verb");input.parsedNoun1.matches.qualifiedIndex=i}for(var vc in input.verb_chain){var verb=this.game.dictionary.verbs[input.verb_chain[vc]];if(0<Number(vc)&&!this.game.settings.use_nested_verb_phase_hooks)break;if(input.did.phases.includes(verb.name+"_did_doBeforeTry"));else{msg=`[${verb.name}.js] ${verb.name}.doBeforeTry() `;this.game.log("L1294","log","high",msg,"VerbPhase");results=verb.tryPhaseHook("doBeforeTry");input.did.doBeforeTry=true;input.did.phases.push(verb.name+"_did_doBeforeTry");if(false===results){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);}}msg=`[${this.name}.js] ${this.name}.handleActions('try') `;this.game.log("L1295","log","high",msg,"Verb");if(false===(results=this.handleActions("try"))){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);else{msg=`[${this.name}.js] ${this.name}.doTry `;this.game.log("L1296","log","high",msg,"Verb");results=this.doTry();input.did.doTry=true;input.did.phases.push(this.name+"_did_doTry");if(false===results){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);else{for(let vc in input.verb_chain){let verb=this.game.dictionary.verbs[input.verb_chain[vc]];if(0<Number(vc)&&!this.game.settings.use_nested_verb_phase_hooks)break;if(input.did.phases.includes(verb.name+"_did_doAfterTry"));else{msg=`[${verb.name}.js] ${verb.name}.doAfterTry() `;this.game.log("L1297","log","high",msg,"VerbPhase");results=verb.tryPhaseHook("doAfterTry");input.did.doAfterTry=true;input.did.phases.push(verb.name+"_did_doAfterTry");if(false===results){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);}}for(let vc in input.verb_chain){let verb=this.game.dictionary.verbs[input.verb_chain[vc]];if(0<Number(vc)&&!this.game.settings.use_nested_verb_phase_hooks)break;if(input.did.phases.includes(verb.name+"_did_doBeforeSuccess"));else{msg=`[${verb.name}.js] ${verb.name}.doBeforeSuccess() `;this.game.log("L1298","log","high",msg,"VerbPhase");results=verb.tryPhaseHook("doBeforeSuccess");input.did.doBeforeSuccess=true;input.did.phases.push(verb.name+"_did_doBeforeSuccess");if(false===results){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);}}msg=`[${this.name}.js] ${this.name}.handleActions('do') `;this.game.log("L1299","log","high",msg,"Verb");if(false===(results=this.handleActions("do"))){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);else{msg=`[${this.name}.js] ${this.name}.doSuccess() `;this.game.log("L1300","log","high",msg,"Verb");results=input.did.doSuccess||input.did.tryTravel?this.handleSuccess():this.doSuccess();input.did.doSuccess=true;input.did.phases.push(this.name+"_did_doSuccess");if(false===results){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);else{for(let vc in input.verb_chain){let verb=this.game.dictionary.verbs[input.verb_chain[vc]];if(0<Number(vc)&&!this.game.settings.use_nested_verb_phase_hooks)break;if(input.did.phases.includes(verb.name+"_did_doAfterSuccess"));else{msg=`[${verb.name}.js] ${verb.name}.doAfterSuccess() `;this.game.log("L1301","log","high",msg,"VerbPhase");results=verb.tryPhaseHook("doAfterSuccess");input.did.doAfterSuccess=true;input.did.phases.push(verb.name+"_did_doAfterSuccess");if(false===results){this.game.parser.clearQueue();return false}if(null===results&&i===qualifiedCount-1)return null;if(null===results);}}if(!input.did.print)input.printOutput();input.did.print=true}}}}}}doTry(){return true}handleActions(dotry){var input=this.game.getInput(),subject=input.getSubject(),verb=this,input_verb=input.input_verb,action=this.name,Action=A.propercase(this.name);if(input_verb&&input_verb!==this.name)if(this.is_direction)Action=A.propercase(this.name);else return;if(input["did_"+dotry]);else{input["did_"+dotry]=true;var input_verb=input.getAdverb();if(input_verb)Action+=A.propercase(input_verb);var direct_object=input.getAsset(1),input_verb=input.getPreposition(1),Direct_preposition=A.propercase(input_verb),indirect_object=input.getAsset(2),input_verb=input.getPreposition(2),Indirect_preposition=A.propercase(input_verb),indirect_object2=input.getAsset(3),input_verb=A.propercase(input.getPreposition(3)),Indirect_preposition2=A.propercase(input_verb),hook="",results,hook=""+dotry+Action;this.game.log("L1498","log","high",`[${this.name}.js] doVerbAction('${hook}')`,"Verb");if(void 0!==(results=subject.doVerbAction({action:hook,type:"VerbAction"})));else{if(direct_object)if(void 0!==(results=direct_object.doVerbAction({action:hook,type:"VerbAction"})))return results;if(indirect_object)if(void 0!==(results=indirect_object.doVerbAction({action:hook,type:"VerbAction"})))return results;if(indirect_object2)if(void 0!==(results=indirect_object2.doVerbAction({action:hook,type:"VerbAction"})))return results;switch(input.getStructure()){case"verb preposition":this.game.log("L1499","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+Direct_preposition),"Verb");if(void 0!==(results=subject.doVerbAction({action:hook,type:"VerbAction"})))return results;break;case"verb noun":this.game.log("L1500","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+"This"),"Verb");if(void 0!==(results=direct_object.doVerbAction({action:hook,asset2:subject,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook=""+dotry+Action+"That",asset2:direct_object,type:"VerbAction"})))return results;break;case"verb preposition noun":this.game.log("L1501","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+Direct_preposition+"This"),"Verb");if(void 0!==(results=direct_object.doVerbAction({action:hook,asset2:subject,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook=""+dotry+Action+Direct_preposition+"That",asset2:direct_object,type:"VerbAction"})))return results;break;case"verb noun noun":this.game.log("L1502","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+"ThisThat"),"Verb");if(void 0!==(results=direct_object.doVerbAction({action:hook,asset2:indirect_object,type:"VerbAction"})))return results;this.game.log("L1503","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+"ThatThis"),"Verb");if(void 0!==(results=indirect_object.doVerbAction({action:hook,asset2:direct_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook=""+dotry+Action+"ThatThat",asset2:direct_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook,asset2:indirect_object,type:"VerbAction"})))return results;break;case"verb noun preposition noun":this.game.log("L1504","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+`This${Indirect_preposition}That`),"Verb");if(void 0!==(results=direct_object.doVerbAction({action:hook,asset2:indirect_object,type:"VerbAction"})))return results;this.game.log("L1505","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+`That${Indirect_preposition}This`),"Verb");if(void 0!==(results=indirect_object.doVerbAction({action:hook,asset2:direct_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook=""+dotry+Action+`That${Indirect_preposition}That`,asset2:direct_object,asset3:indirect_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook,asset2:indirect_object,type:"VerbAction"})))return results;break;case"verb preposition noun preposition noun":this.game.log("L1506","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+Direct_preposition+`This${Indirect_preposition}That`),"Verb");if(void 0!==(results=direct_object.doVerbAction({action:hook,asset2:indirect_object,type:"VerbAction"})))return results;this.game.log("L1507","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+Direct_preposition+`That${Indirect_preposition}This`),"Verb");if(void 0!==(results=indirect_object.doVerbAction({action:hook,asset2:direct_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook=""+dotry+Action+Direct_preposition+`That${Indirect_preposition}That`,asset2:direct_object,asset3:indirect_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook,asset2:indirect_object,type:"VerbAction"})))return results;break;case"verb noun preposition noun preposition noun":this.game.log("L1508","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+`This${Indirect_preposition}That${Indirect_preposition2}Other`),"Verb");if(void 0!==(results=direct_object.doVerbAction({action:hook,asset2:indirect_object,asset3:indirect_object2,type:"VerbAction"})))return results;this.game.log("L1509","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+`That${Indirect_preposition}This${Indirect_preposition2}Other`),"Verb");if(void 0!==(results=indirect_object.doVerbAction({action:hook,asset2:direct_object,asset3:indirect_object2,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook=""+dotry+Action+`That${Indirect_preposition}That${Indirect_preposition2}Other`,asset2:direct_object,asset3:indirect_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook,asset2:direct_object,asset3:indirect_object2,type:"VerbAction"})))return results;break;case"verb preposition noun preposition noun preposition noun":this.game.log("L1510","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+Direct_preposition+`This${Indirect_preposition}That${Indirect_preposition2}Other`),"Verb");if(void 0!==(results=direct_object.doVerbAction({action:hook,asset2:indirect_object,asset3:indirect_object2,type:"VerbAction"})))return results;this.game.log("L1511","log","high",`[${this.name}.js] doVerbAction `+(hook=""+dotry+Action+Direct_preposition+`That${Indirect_preposition}This${Indirect_preposition2}Other`),"Verb");if(void 0!==(results=indirect_object.doVerbAction({action:hook,asset2:direct_object,asset3:indirect_object2,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook=""+dotry+Action+Direct_preposition+`That${Indirect_preposition}That${Indirect_preposition2}Other`,asset2:direct_object,asset3:indirect_object,type:"VerbAction"})))return results;if(void 0!==(results=subject.doVerbAction({action:hook,asset2:direct_object,asset3:indirect_object2,type:"VerbAction"})))return results;break}}return results}}doSuccess(){return true}tryPhaseHook(phase){for(var input=this.game.getInput(),i=1;i<=3;i++){var asset=input.getAsset(i);if(1===i&&!asset)asset=this.game.getPlayer();if(!asset);else{if("doBeforeTry"===phase)asset.incrementTryVerbCount(this.name,i);let fx,ov;if(!asset.dov[this.name]&&!asset.iov[this.name]);else{if((2===i||3===i)&&asset.iov[this.name])ov="iov";else if((1===i||2===i)&&asset.dov[this.name])ov="dov";if((2===i||3===i)&&asset.iov[this.name]&&"function"==typeof asset.iov[this.name][phase]){fx=asset.iov[this.name][phase];ov="iov"}else if((2===i||1===i)&&asset.dov[this.name]&&"function"==typeof asset.dov[this.name][phase]){fx=asset.dov[this.name][phase];ov="dov"}this.game.debug("D1628","VerbPhase",`<span class="ajs-tryfound">TRY</span>
          <span class="ajs-actor">${asset.id}</span>.<span class="ajs-ov">${ov}</span>.<span class="ajs-verb">${this.name}</span>.<span class="ajs-action">${phase}()</span>`);if(!fx);else{var phasemsg=`↳ ${asset.id}.${ov}.${this.name}.${phase}()`;this.game.log("L1574","log","high",phasemsg,"VerbPhase");this.game.debug("D1518","VerbPhase ",` <span class="ajs-tryfound">↳ FOUND</span> <span class="ajs-actor">${asset.id}</span>.<span class="ajs-ov">${ov}</span>.<span class="ajs-verb">${this.name}</span>.<span class="ajs-action">${phase}()</span>`);var phasemsg=fx.call(asset,{index:i,verb:this.name});if(void 0!==phasemsg){var asset=`${asset.name}.[dov/iov].${this.name}.${[phase]} returned ${phasemsg}. `;this.game.log("L1302","log","critical",asset,"Verb");return phasemsg}}}}}return true}tryToInferIndirectObject({direct_object,handle_input,context,infer_first_use}={}){if(void 0===context)context=this.game.getSubject();if(direct_object.allowVerbWithNothing(this.name,"dov"))return{allow:true};if(!(this.game.settings.infer_objects&&direct_object&&direct_object instanceof adventurejs.Matter))return{fail:true};var input=this.game.getInput(),related_verbs=this.related.concat([this.name]),infer_first_use,indirect_object=null,prompt=false;if(!infer_first_use&&this.game.settings.objects_must_be_used_before_inferring&&false===direct_object.didDoVerbs(related_verbs))prompt=true;if(!(infer_first_use=context.findNestedIndirectObjects(this.name,direct_object))||!infer_first_use.length)prompt=true;else indirect_object=infer_first_use[0];if(1<infer_first_use.length&&!this.game.settings.auto_pick_inferred_objects)prompt=true;if(prompt&&!handle_input)return{prompt:true};if(prompt&&handle_input){input.setPreposition(2,"with");input.setSoftPrompt({index:2,type:"noun",noun2:true,structure:"verb noun preposition noun"});return{prompt:true}}if(handle_input){input.pushPhrase({asset:indirect_object,preposition:"with"});input.setStructure("verb noun preposition noun")}if(indirect_object)return{success:true,indirect_object:indirect_object};else return{prompt:true}}tryToPutThisInThatAspectOrParent(direct_object,indirect_preposition,indirect_object){for(var results={fail:true};results.fail;){if(indirect_object.hasClass("Room"))return{indirect_preposition:"in",indirect_object:indirect_object};if((results=this.tryToPutThisInThatAspect(direct_object,indirect_preposition,indirect_object)).fail)indirect_preposition=(indirect_object=indirect_object.getPlaceAsset()).getPlacePreposition()}return{indirect_preposition:indirect_preposition,indirect_object:indirect_object}}tryToPutThisInThatAspect(direct_object,preposition,indirect_object){var response={fail:false,msg:"",status:"",end_turn:false},asset_aspect,msg="",can=true;if("string"==typeof direct_object)direct_object=this.game.getAsset(direct_object);if("string"==typeof indirect_object)indirect_object=this.game.getAsset(indirect_object);if("at"===preposition&&indirect_object?.default_aspect)preposition=indirect_object.default_aspect;if(!(direct_object&&direct_object instanceof adventurejs.Tangible&&indirect_object&&indirect_object instanceof adventurejs.Tangible&&preposition&&indirect_object.hasAspectAt(preposition))){this.game.debug("D1670",this.name+".js ",` can't move ${direct_object.id||""} into ${indirect_object.id||""} `);if(!indirect_object.hasAspectAt(preposition))msg+=`{We} can't put anything ${preposition} ${indirect_object.articlename}. `;else msg+=this.game.settings.getUnparsedMessage(this.game.getInput().input);return response={fail:true,msg:msg,status:"bad_request",end_turn:false}}if("in"===preposition&&indirect_object.isDOV("close")&&indirect_object.is.closed){let can_open=false;if(this.game.settings.auto_open_containers)if(!this.game.settings.auto_open_containers_after_first_use)can_open=true;else if(indirect_object.didDoVerbs(["open"]))can_open=true;if(indirect_object.isDOV("lock")&&indirect_object.is.locked);if(indirect_object.isDOV("seal")&&indirect_object.is.sealed);if(!can_open){this.game.debug("D1671",this.name+".js "," indirect_object.id.is.closed ");return response={fail:true,msg:msg+=indirect_object.Articlename+" is closed.",status:"closed",end_turn:false}}}var with_classes=indirect_object.aspects[preposition].with_classes;if(0<with_classes.length){for(var can=false,i=0;i<with_classes.length;i++){var clas=with_classes[i];if(direct_object instanceof adventurejs[clas]){can=true;break}}if(!can){this.game.debug("D1661",this.name+".js ",` ${direct_object.id}.class ${direct_object.class} is not among ${indirect_object.id}.aspects.${preposition}.with_classes `);return response={fail:true,msg:msg+=`${direct_object.Articlename} can't be placed ${preposition} ${indirect_object.articlename}. `,status:"with_classes",end_turn:false}}}var with_assets=indirect_object.aspects[preposition].with_assets;if(0<with_assets.length){can=false;for(var i=0;i<with_assets.length;i++)if(direct_object.id===with_assets[i]){can=true;break}if(!can){this.game.debug("D1662",this.name+".js ",` ${direct_object.id} is not among ${indirect_object.id}.aspects.${preposition}.with_assets `);return response={fail:true,msg:msg+=`${direct_object.Articlename} can't be placed ${preposition} ${indirect_object.articlename}. `,status:"with_assets",end_turn:false}}}if(-1<(asset_aspect=indirect_object.getAspectAt(preposition)).contents_limits.width&&direct_object.dimensions.width>asset_aspect.contents_limits.width){this.game.debug("D1667",this.name+".js ",` ${direct_object.id}.dimensions.width > ${indirect_object.id}.aspects.${preposition}.contents_limits.width `);return response={fail:true,msg:msg+=`${direct_object.Articlename} doesn't fit ${preposition} ${indirect_object.articlename}. `,status:"maxwidth",end_turn:false}}if(-1<asset_aspect.contents_limits.height&&direct_object.dimensions.height>asset_aspect.contents_limits.height){this.game.debug("D1127",this.name+".js ",` ${direct_object.id}.dimensions.height > ${indirect_object.id}.aspects.${preposition}.contents_limits.height `);return response={fail:true,msg:msg+=`${direct_object.Articlename} doesn't fit ${preposition} ${indirect_object.articlename}. `,status:"maxheight",end_turn:false}}if(-1<asset_aspect.contents_limits.depth&&direct_object.dimensions.depth>asset_aspect.contents_limits.depth){this.game.debug("D1128",this.name+".js ",` ${direct_object.id}.dimensions.depth > ${indirect_object.id}.aspects.${preposition}.contents_limits.depth `);return response={fail:true,msg:msg+=`${direct_object.Articlename} doesn't fit ${preposition} ${indirect_object.articlename}. `,status:"maxdepth",end_turn:false}}if(-1<asset_aspect.contents_limits.weight&&direct_object.dimensions.weight>asset_aspect.contents_limits.weight){this.game.debug("D1668",this.name+".js ",` ${direct_object.id}.dimensions.weight > ${indirect_object.id}.aspects.${preposition}.contents_limits.weight `);return response={fail:true,msg:msg+=`${direct_object.Articlename_is} too heavy to ${this.name} ${preposition} ${indirect_object.articlename}. `,status:"maxweight",end_turn:false}}if(-1<asset_aspect.contents_limits.count&&asset_aspect.contents.length>=asset_aspect.contents_limits.count){this.game.debug("D1669",this.name+".js ",` ${indirect_object.id}.aspects.${preposition}.contents.length >= ${indirect_object.id}.aspects.${preposition}.contents_limits.count `);return response={fail:true,msg:msg+=`Nothing ${0<asset_aspect.contents_limits.count?"more ":""} can be ${this.past_tense} ${preposition} ${indirect_object.articlename}. `,status:"maxcount",end_turn:true}}return response}validate(){}initialize(){if(!this.prettyname)this.prettyname=this.name;if(this.is_direction)this.dictionary.direction_lookup[this.name]={synonyms:this.synonyms,adjectives:this.adjectives,article:this.article};if(this.state_string)this.game.dictionary.verb_state_lookup[this.state_string]=this.name;if(this.unstate_string)this.game.dictionary.verb_state_lookup[this.unstate_string]=this.name}enqueueCollection(object){this.game.log("L1303","log","high","Verb.js.enqueueCollection()","Verb");for(var i=0;i<object.collection.length;i++){var linefeed=i===object.collection.length?true:void 0;this.game.parser.input_queue.push({input:this.name+" "+object.collection[i],output_class:"concatenate_output",linefeed:linefeed})}return false}set(props){return A.deepSet.call(this.game,props,this)}handleFailure(msg){var input=this.game.getInput(),noun1=input.getAsset(1),noun2=input.getAsset(2),input=input.getAsset(3),results;msg=A.getSAF.call(this.game,this.override_failure_msg)||msg;if(noun1?.dov[this.name]){if(noun1.triedVerbCount(this.name,"dov")<=1&&noun1.dov[this.name].on_first_failure)results=A.getSAF.call(this.game,noun1.dov[this.name].on_first_failure,noun1);else results=A.getSAF.call(this.game,noun1.dov[this.name].on_failure,noun1);if(results&&"string"==typeof results)msg+=results}if(noun2?.iov[this.name]){if(noun2.iTriedVerbCount(this.name,"iov")<=1&&noun2.iov[this.name].on_first_failure)results=A.getSAF.call(this.game,noun2.iov[this.name].on_first_failure,noun2);else results=A.getSAF.call(this.game,noun2.iov[this.name].on_failure,noun2);if(results&&"string"==typeof results)msg+=results}else if(noun2?.dov[this.name]){if(noun2.triedVerbCount(this.name,"dov")<=1&&noun2.dov[this.name].on_first_failure)results=A.getSAF.call(this.game,noun2.dov[this.name].on_first_failure,noun2);else results=A.getSAF.call(this.game,noun2.dov[this.name].on_failure,noun2);if(results&&"string"==typeof results)msg+=results}if(input?.iov[this.name]){if(input.iTriedVerbCount(this.name,"iov")<=1&&input.iov[this.name].on_first_failure)results=A.getSAF.call(this.game,input.iov[this.name].on_first_failure,input);else results=A.getSAF.call(this.game,input.iov[this.name].on_failure,input);if(results&&"string"==typeof results)msg+=results}if(msg)this.game.print(msg,this.game.getInput().output_class)}handleSuccess(msg){var input=this.game.getInput(),noun1=input.getSubstance(1)||input.getAsset(1)||null,noun2=input.getSubstance(2)||input.getAsset(2)||null,noun3=input.getSubstance(3)||input.getAsset(3)||null,results;if(!noun1)noun1=this.game.getPlayer();msg=A.getSAF.call(this.game,this.override_success_msg)||msg;if(noun1)if(noun1.dov[this.name]){noun1.incrementDoVerbCount(this.name,"dov");if(1===noun1.didVerbCount(this.name,"dov")&&noun1.dov[this.name].on_first_success)results=A.getSAF.call(this.game,noun1.dov[this.name].on_first_success,noun1);else results=A.getSAF.call(this.game,noun1.dov[this.name].on_success,noun1);if(results&&"string"==typeof results)msg+=results;if(noun1.dov[this.name].once)noun1.dov[this.name].enabled=false;if((results=noun1.tryDestroyDirectObjectAfterUsing(this.name)).destroy)msg+=results.msg?results.msg:noun1.Articlename+" disappears. "}else this.game.log("L1304","warn",0,`[${this.name}.js] ${noun1.id} is not direct subscribed to `+this.name,"Verb");if(noun2)if(noun2.iov[this.name]){noun2.incrementDoVerbCount(this.name,"iov");if(1===noun2.iDidVerbCount(this.name,"iov")&&noun2.iov[this.name].on_first_success)results=A.getSAF.call(this.game,noun2.iov[this.name].on_first_success,noun2);else results=A.getSAF.call(this.game,noun2.iov[this.name].on_success,noun2);if(results&&"string"==typeof results)msg+=results;if(noun2.iov[this.name].once)noun2.iov[this.name].enabled=false;if((results=noun2.tryDestroyIndirectObjectAfterUsing(this.name)).destroy)msg+=results.msg?results.msg:noun2.Articlename+" disappears. "}else if(noun2.dov[this.name]){noun2.incrementDoVerbCount(this.name,"dov");if(1===noun2.didVerbCount(this.name,"dov")&&noun2.dov[this.name].on_first_success)results=A.getSAF.call(this.game,noun2.dov[this.name].on_first_success,noun2);else results=A.getSAF.call(this.game,noun2.dov[this.name].on_success,noun2);if(results&&"string"==typeof results)msg+=results;if(noun2.dov[this.name].once)noun2.dov[this.name].enabled=false;if((results=noun2.tryDestroyDirectObjectAfterUsing(this.name)).destroy)msg+=results.msg?results.msg:noun2.Articlename+" crumbles to pieces. "}else this.game.log("L1305","warn",0,noun2.id+" is not indirect or direct subscribed to "+this.name,"Verb");if(noun3)if(noun3.iov[this.name]){noun3.incrementDoVerbCount(this.name,"iov");if(1===noun3.iDidVerbCount(this.name,"dov")&&noun3.iov[this.name].on_first_success)results=A.getSAF.call(this.game,noun3.iov[this.name].on_first_success,noun3);else results=A.getSAF.call(this.game,noun3.iov[this.name].on_success,noun3);if(results&&"string"==typeof results)msg+=results;if(noun3.iov[this.name].once)noun3.iov[this.name].enabled=false;if((results=noun3.tryDestroyIndirectObjectAfterUsing(this.name)).destroy)msg+=results.msg?results.msg:noun3.Articlename+" crumbles to pieces. "}else this.game.log("L1306","warn",0,noun3.id+" is not indirect subscribed to "+this.name,"Verb");if(msg)input.printer.output=msg;return true}canBeIntransitive(){return!this.phrase1.requires_noun}hasState(){return this.state||this.unstate}getState(){return this.state||this.unstate}setState(asset,bool){if(this.getState())asset.setIs(this.getState(),bool)}hasStructure(structure){return this.accepts_structures.includes(structure)}setVerbConnection(direct_object,indirect_object){this.game.log("L1307","log","high",`${this.name}.setVerbConnection > ${direct_object.id} to `+(indirect_object?indirect_object.id:"nothing"),"Verb");if(direct_object&&direct_object.is.connected_by){if(!direct_object.is.connected_by[this.name])direct_object.is.connected_by[this.name]={to_dov:[],to_iov:[]};var indirect_value=indirect_object&&indirect_object.id?indirect_object.id:null;if(!direct_object.is.connected_by[this.name].to_iov.includes(indirect_value))direct_object.is.connected_by[this.name].to_iov.push(indirect_value)}if(indirect_object&&indirect_object.is.connected_by){if(!indirect_object.is.connected_by[this.name])indirect_object.is.connected_by[this.name]={to_dov:[],to_iov:[]};var indirect_value=direct_object&&direct_object.id?direct_object.id:null;if(!indirect_object.is.connected_by[this.name].to_dov.includes(indirect_value))indirect_object.is.connected_by[this.name].to_dov.push(indirect_value)}}unsetVerbConnection(direct_object,indirect_object){console.warn("unsetVerbConnection",direct_object,indirect_object);if(direct_object&&direct_object.is.connected_by&&direct_object.is.connected_by[this.name]){let indirect_value=indirect_object&&indirect_object.id?indirect_object.id:null;if(direct_object.is.connected_by[this.name].to_iov.includes(indirect_value))direct_object.is.connected_by[this.name].to_iov=direct_object.is.connected_by[this.name].to_iov.filter(item=>item!==indirect_value)}if(indirect_object&&indirect_object.is.connected_by&&indirect_object.is.connected_by[this.name]){let direct_value=direct_object&&direct_object.id?direct_object.id:null;if(indirect_object.is.connected_by[this.name].to_dov.includes(direct_value))indirect_object.is.connected_by[this.name].to_dov=indirect_object.is.connected_by[this.name].to_dov.filter(item=>item!==direct_value)}}hasVerbSubscriptionConnection(direct_object,indirect_object){let dconnect=true,iconnect=true;if(!(direct_object.dov[this.name]&&direct_object.is.connected_by&&direct_object.is.connected_by[this.name]&&direct_object.is.connected_by[this.name].to_iov&&direct_object.is.connected_by[this.name].to_iov.includes(indirect_object.id)))dconnect=false;if(!(indirect_object.iov[this.name]&&indirect_object.is.connected_by&&indirect_object.is.connected_by[this.name]&&indirect_object.is.connected_by[this.name].to_dov&&indirect_object.is.connected_by[this.name].to_dov.includes(direct_object.id)))iconnect=false;if(dconnect&&!iconnect)this.game.log("L1308","warn","high",`${direct_object.id}.is.connected_by.${this.name}.to_iov contains ${indirect_object.id} but ${indirect_object.id}.is.connected_by.${this.name}.to_dov does not contain `+direct_object.id,"Verb");else{if(dconnect||!iconnect)return true;this.game.log("L1309","warn","high",`${indirect_object.id}.is.connected_by.${this.name}.to_dov contains ${direct_object.id} but ${direct_object.id}.is.connected_by.${this.name}.to_iov does not contain `+indirect_object.id,"Verb")}return false}canCharacterGoThereFromNest(direct_preposition,direct_object){var response={failure:false,msg:""},input,subject=this.game.getInput().getSubject(),nest_asset=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),reachable=true;if(this.game.settings.xz_determines_reachability)var distance,reachable=A.getHorizontalDistance(nest_asset.position,direct_object.position)<=subject.jump_length;if(!reachable){this.game.debug("D1027",this.name+".js ",` ${subject.id} is nested ${nest_preposition} ${nest_asset.id} `);response.msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename} while ${subject.getPostureGerund()} ${nest_preposition} ${nest_asset.articlename}. `;response.failure=true}return response}agree(verb_name=this.name){if(verb_name.name)verb_name=verb_name.name;if("string"!=typeof verb_name)return"";var player=this.game.getPlayer(),subject=this.game.getInput().getSubject(),subject_has_propername;if(subject&&subject.id!==player.id&&subject.propername||["nonhuman","male","female"].includes(this.game.getInput().getSubject().pronouns))if(verb_name.endsWith("ch")||verb_name.endsWith("sh")||verb_name.endsWith("x")||verb_name.endsWith("s")||verb_name.endsWith("z")||verb_name.endsWith("o"))return verb_name+"es";else if(verb_name.endsWith("y")&&!/[aeiou]y$/.test(verb_name))return verb_name.slice(0,-1)+"ies";else return verb_name+"s";else return verb_name}}adventurejs.Verb=Verb})();A.Preverbs.again={name:"again",synonyms:["again","g"],accepts_structures:["verb"],do:function(){this.game.log("L1365","error","high","again.do fired, but it never should because again is handled by parser.","verbs");return null}};A.Preverbs.aim={name:"aim",prettyname:"aim",past_tense:"aimed",synonyms:["aim"],state:"aimed",gerund:"aiming",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,accepts_preposition:true,requires_preposition:true,noun_must_be:{known:true,matter:true,present_if_tangible:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1767",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1802",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1796",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1797",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1801",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1894",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1803",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} ) `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.ask={name:"ask",prettyname:"ask about",synonyms:["ask about","a"],gerund:"asking",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,present:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true}},with_params:{},doTry:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),output_class=input.output_class,input="";if("ask about"===verb_phrase);if(!(direct_object instanceof adventurejs.Character)){this.game.debug("D1231",this.name+".js ",` ${direct_object.id} is not class Character`);input+=direct_object.Articlename+" can't answer. ";this.handleFailure(input)}else{if(direct_object.isDOV(this.name))return true;this.game.debug("D1329",this.name+".js ",` ${direct_object.id}.dov.${this.name} is unset`);input+=direct_object.Articlename+" doesn't answer. ";this.handleFailure(input)}return null},doSuccess:function(){this.game.debug("D1232",this.name+".js "," print success");var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),output_class=input.output_class,input="";input+=`{We} ask ${direct_object.articlename}${indirect_object?" about "+indirect_object.articlename:""}. `;return this.handleSuccess(input)}};A.Preverbs.attach={name:"attach",prettyname:"attach",past_tense:"attached",synonyms:["attach","connect"],gerund:"attaching",accepts_structures:["verb noun","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,accepts_plural_noun:true,noun_must_be:{in_inventory_if_takeable:true,known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory_if_takeable:true,known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["to","with"]},phrase3:{accepts_noun:true,noun_must_be:{in_inventory_if_takeable:true,known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with","to"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),object1=input.getAsset(1),nouns,object2_preposition,tool,tool_preposition,results,subject,msg="";if(object1.isDOV("tie")){this.game.debug("D1234",this.name+".js "," infer verb tie ");return this.game.dictionary.doVerb("tie")}if(object1.isDOV("screw")){this.game.debug("D2147",this.name+".js "," infer verb screw ");return this.game.dictionary.doVerb("screw")}if(object1.isDOV("plugIn")){this.game.debug("D2148",this.name+".js "," infer verb plugIn ");return this.game.dictionary.doVerb("plugIn")}if(input.hasStructure("verb noun"))if(input.verified_sentence.phrase1.noun.includes("&")){var nouns=input.verified_sentence.phrase1.noun.split("&");if(2===nouns.length&&this.game.parser.input_queue.length&&this.game.parser.input_queue[0].input==="attach "+nouns[1]){var nouns=this.game.parser.parseNoun(nouns[1]);let object2=nouns.matches.all[nouns.matches.qualifiedIndex];input.setAsset(2,object2);input.setPreposition(2,"to");object2_preposition="to";input.setStructure("verb noun preposition noun");this.game.parser.input_queue.shift()}else{this.game.debug("D1360",this.name+".js "," attach can't handle more than two nouns ");msg+=`{We} can't ${this.name} those all at once. `;this.handleFailure(msg);return false}}else{msg+=`{We} don't know how to ${this.name} ${object1.articlename}. `;this.handleFailure(msg);return false}if(input.getPreposition(2)===input.getPreposition(3)){this.game.debug("D1638",this.name+".js "," expected A to B with C, received two identical prepositions ");msg+=this.game.settings.getUnparsedMessage(this.game.getInput().input);this.handleFailure(msg);return null}if("with"===input.getPreposition(2)&&"to"===input.getPreposition(3))input.swapPhrases(2,3);if("with"===input.getPreposition(2)&&!input.hasPhrase(3)){input.swapPhrases(2,3);input.setPreposition(2,"to");input.setSoftPrompt({index:2,type:"noun",noun2:true,structure:"verb noun preposition noun preposition noun"});this.game.debug("D1523",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${object1.articlename} to? `;this.handleFailure(msg);return null}nouns=input.getAsset(2);object2_preposition=input.getPreposition(2);if(!object1.isDOV(this.name)&&!nouns.isDOV(this.name)){this.game.debug("D1349",this.name+".js ",` neither ${object1.id} nor ${nouns.id}.dov.${this.name}.enabled `);msg+=`${object1.Articlename} and ${nouns.articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(!object1.canBePut("attached",nouns)&&!nouns.canBePut("attached",object1)){this.game.debug("D1235",this.name+".js "," neither asset is listed in the other's .aspects.attached.with_assets/with_classes ");msg+=`${object1.Articlename} and ${nouns.articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(!object1.canBePut("attached",nouns)&&nouns.canBePut("attached",object1)){input.swapNouns(1,2);object1=input.getAsset(1);nouns=input.getAsset(2)}if(object1.isPlacedAtAspectAndAsset("attached",nouns.id)){this.game.debug("D1236",this.name+".js ",` ${object1.id} is attached to ${nouns.id} `);msg=`${object1.Articlename_is} already attached to ${nouns.articlename}. `;this.handleFailure(msg);return null}tool=input.getAsset(3);tool_preposition=input.getPreposition(3);if(!tool)if(!object1.allowVerbWithNothing(this.name,"dov")&&!nouns.allowVerbWithNothing(this.name,"dov")){results=this.tryToInferIndirectObject({direct_object:object1,context:subject,handle_input:false});subject=this.tryToInferIndirectObject({direct_object:nouns,context:subject,handle_input:false});if(results.success||subject.success){var either_one,tool=(results.success?results.success:subject.success).indirect_object,tool_preposition="with";input.pushPhrase({asset:tool,preposition:"with"});input.setStructure("verb noun preposition noun preposition noun");this.game.printInferred("with "+tool.articlename)}else if(results.prompt||subject.prompt){input.setPreposition(3,"with");input.setSoftPrompt({index:3,type:"noun",noun3:true,structure:"verb noun preposition noun preposition noun"});input.setStructure("verb noun preposition noun preposition noun");this.game.debug("D1672",this.name+".js "," soft prompt for noun3 ");msg+=`What would {we} like to ${this.name} ${object1.articlename} to ${nouns.articlename} with? `;this.handleFailure(msg);return false}}if(input.hasStructure("verb noun preposition noun preposition noun")){if(object1.allowVerbWithAnything(this.name,"dov")||nouns.allowVerbWithAnything(this.name,"dov"))return true;if(!object1.allowVerbWithAsset({verb:this.name,asset:tool,ov:"dov"})&&!nouns.allowVerbWithAsset({verb:this.name,asset:tool,ov:"dov"})){this.game.debug("D1750",this.name+".js ",` neither ${object1.id} nor ${nouns.id}.dov.${this.name}.with_assets/with_classes includes ${tool.id} `);msg+=`${tool.Articlename} can't be used to ${this.name} ${object1.articlename} to ${nouns.articlename}. `;this.handleFailure(msg);return null}if(tool&&tool.allowVerbOnce(this.name,"iov")&&tool.iDidVerb(this.name,"iov")){this.game.debug("D1820",this.name+".js ",` ${tool.id}.iov.${this.name}.once and ${tool.id}.did.${this.name}.indirectly is ${tool.did[this.name].indirectly} `);msg+=`${tool.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),object1=input.getAsset(1),object1_parent=object1.getPlaceAsset(),object2=input.getAsset(2),object2_preposition=input.getPreposition(2),tool=input.getAsset(3),tool_preposition=input.getPreposition(3),object1_parent,input="";if(object1_parent.id!==object2.id){if(void 0!==(object1_parent=object1.moveFrom(object1_parent)))return object1_parent;if(void 0!==(object1_parent=object1.moveTo("attached",object2)))return object1_parent}input=(input=(input=(input+=`{We} ${this.agree()} `+object1.articlename)+(object2?" to "+object2.articlename:""))+(tool?" with "+tool.articlename:"")).trim();return this.handleSuccess(input+=". ")}};A.Preverbs.break={name:"break",prettyname:"break",past_tense:"broke",synonyms:["break","smash","destroy"],state:"broken",gerund:"breaking",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1238",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1791",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1821",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1836",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1836",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1839",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1896",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1804",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="";this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(direct_object.is[this.state]?" again":"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.brief={name:"brief",synonyms:["brief"],accepts_structures:["verb"],do:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase;if(this.game.settings.verbosity>this.game.settings.min_verbosity)--this.game.settings.verbosity;var msg="Ok, I'll try to show shorter room descriptions. ";if(msg)this.game.print(msg,input.output_class);return true}};A.Preverbs.button={name:"button",synonyms:["button"],past_tense:"buttoned",prettyname:"button",state:"buttoned",gerund:"buttoning",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,not_global:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1489",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1491",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1492",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1493",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1508",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1931",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1897",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1615",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.catch={name:"catch",prettyname:"catch",past_tense:"caught",synonyms:["catch"],state:"caught",gerund:"catching",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"],noun_must_be:{in_inventory:true,known:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1770",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1094",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1095",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1792",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1898",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1805",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="",results=direct_object.moveFrom(direct_object.getPlaceAsset());if(void 0!==results)return results;if(void 0!==(results=direct_object.moveTo("in",subject)))return results;msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.climb={name:"climb",prettyname:"climb",past_tense:"climbed",synonyms:["climb"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"climbing",default_direction:"up",verb_prep_noun:[],accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,noun_must_be:{tangible:true,known:true,present:true,visible:true,reachable:true,not_self:true},accepts_preposition:true,accepts_preposition_without_noun:true,accepts_direction:true},phrase2:{accepts_noun:true,noun_must_be:{tangible:true,known:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["with","to"]},with_params:{},in_can_mean_on:true,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),nest_asset=subject.getNestAsset(),msg="";if(input.hasStructure("verb"))if(nest_asset){var h=nest_asset.dimensions.height,y,py;if(nest_asset.position.y+h<=subject.position.y)input.setPreposition(1,"down");else input.setPreposition(1,"up");input.setAsset(1,nest_asset);input.setStructure("verb preposition noun");direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);this.game.printInferred(direct_preposition+" "+direct_object.articlename)}else{input.setSoftPrompt({index:1,type:"noun",noun1:true});this.game.debug("D1177",this.name+".js "," no noun provided or inferrable, soft prompt noun1");this.handleFailure(msg+="What would {we} like to climb? ");return null}return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.close={name:"close",prettyname:"close",past_tense:"closed",synonyms:["close","shut"],state:"closed",related:["open"],state_strings:{state:"closed",unstate:"open"},state_string:"closed",unstate_string:"open",enqueue_collections:true,gerund:"closing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(direct_object.linked_components?.Drain){if(!(direct_object=this.game.getAsset(direct_object.linked_components.Drain)))return null;input.setAsset(1,direct_object);input.setInferred(1,true)}if(direct_object.isDOV("plug")&&!direct_object.is.plugged){this.game.debug("D1368",this.name+".js ",` ${direct_object.id}.dov.plug, doVerb plug `);return this.game.dictionary.doVerb("plug")}if(!direct_object.isDOV(this.name)){this.game.debug("D1241",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.state}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1242",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1822",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1403",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1704",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return null}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1693",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1899",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1806",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.crawl={name:"crawl",prettyname:"crawl",past_tense:"crawled",synonyms:["crawl"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"crawling",in_can_mean_on:true,subject_must_be:{not_constrained:true,able_to_crawl:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.cut={name:"cut",prettyname:"cut",past_tense:"cut",synonyms:["cut"],gerund:"cutting",accepts_structures:["verb noun","verb preposition noun","verb noun preposition","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,direct_preposition,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1247",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1823",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun preposition"))if(["off","out"].includes(indirect_preposition)){direct_preposition=indirect_preposition;input.setPreposition(1,indirect_preposition);input.deletePhrase(2);input.setStructure("verb preposition noun")}else{this.game.debug("D1946",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun"))if("off"===direct_preposition||"out"===direct_preposition)return true;else{this.game.debug("D1948",this.name+".js ",` ${this.name} ${direct_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1834",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((direct_preposition=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1835",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_preposition.success){indirect_object=direct_preposition.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if("with"!==indirect_preposition){this.game.debug("D1955",this.name+".js ",` no handling for ${this.name} ${direct_object.id} ${indirect_preposition} ${indirect_object.id} `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1837",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1900",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1838",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.descend={name:"descend",prettyname:"descend",past_tense:"descended",synonyms:["descend"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"descending",default_direction:"down",subject_must_be:{not_constrained:true},accepts_adverbs:[],accepts_structures:["verb","verb noun","verb preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{tangible:true,known:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["down","from","off"]},with_params:{},doTry:function(){var input=this.game.getInput();input.setPreposition(1,"down");input.updateStructure();return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.detach={name:"detach",prettyname:"detach",past_tense:"detached",synonyms:["detach","disconnect"],unstate:"attached",gerund:"detaching",accepts_structures:["verb noun","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["from","with"]},phrase3:{accepts_noun:true,noun_must_be:{in_inventory_if_takeable:true,known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["from","with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),object1=input.getAsset(1),object2,object2_preposition,tool,tool_preposition,results,subject,msg="";if(object1.is.worn&&object1.isDOV("remove")){this.game.debug("D1522",this.name+".js ",` ${object1.id}.is.worn, infer verb remove `);return this.game.dictionary.doVerb("remove")}if(object1.getVerbConnectionCount("tie","to_iov")&&object1.isDOV("untie")){this.game.debug("D1249",this.name+".js ",` ${object1.id}.dov.untie, infer verb untie `);return this.game.dictionary.doVerb("untie")}if(input.hasStructure("verb noun"))if(object1.isPlacedAtAspect("attached")){object2=object1.getPlaceAsset();input.setAsset(2,object2);input.setPreposition(2,"from");input.setStructure("verb noun preposition noun");this.game.printInferred("from "+object2.articlename)}else{input.setStructure("verb noun preposition noun");input.setPreposition(2,"from");input.setSoftPrompt({index:2,type:"noun",noun2:true,structure:"verb noun preposition noun"});this.game.debug("D1520",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${object1.articlename} from? `;this.handleFailure(msg);return null}if(input.getPreposition(2)===input.getPreposition(3)){this.game.debug("D1251",this.name+".js "," expected A from B with C, received two identical prepositions ");msg+=this.game.settings.getUnparsedMessage(this.game.getInput().input);this.handleFailure(msg);return null}if("with"===input.getPreposition(2)&&"from"===input.getPreposition(3))input.swapPhrases(2,3);if("with"===input.getPreposition(2)&&!input.hasPhrase(3)){input.swapPhrases(2,3);input.setPreposition(2,"from");tool=input.getAsset(3);tool_preposition="from";if(object1.isPlacedAtAspect("attached")){input.setAsset(2,object1.getPlaceAsset());input.setStructure("verb noun preposition noun preposition noun");this.game.printInferred("from "+input.getAsset(2).articlename)}else{input.setSoftPrompt({index:2,type:"noun",noun2:true,structure:"verb noun preposition noun preposition noun"});this.game.debug("D1520",this.name+".js "," soft prompt for noun3 ");msg+=`What would {we} like to ${this.name} ${object1.articlename} from with ${tool.articlename}? `;this.handleFailure(msg);return null}}object2=input.getAsset(2);object2_preposition=input.getPreposition(2);if(!object1.isDOV(this.name)&&!object2.isDOV(this.name)){this.game.debug("D1250",this.name+".js ",` neither ${object1.id} nor ${object2.id}.dov.${this.name}.enabled `);msg+=`${object1.Articlename} can't be ${this.past_tense} from ${object2.articlename}. `;this.handleFailure(msg);return null}if(!object1.isPlacedAtAspect("attached",object2)&&!object2.isPlacedAtAspect("attached",object1)){this.game.debug("D1353",this.name+".js "," neither asset is in the other's .aspects.attached.contents ");msg+=`${object1.Articlename} and ${object2.articlename} aren't ${this.unstate}. `;this.handleFailure(msg);return null}if(!object1.isPlacedAtAspect("attached",object2)&&object2.isPlacedAtAspect("attached",object1)){input.swapNouns(1,2);object1=input.getAsset(1);object2=input.getAsset(2)}tool=input.getAsset(3);tool_preposition=input.getPreposition(3);if(!tool)if(!object1.allowVerbWithNothing(this.name,"dov")&&!object2.allowVerbWithNothing(this.name,"dov")){results=this.tryToInferIndirectObject({direct_object:object1,context:subject,handle_input:false});subject=this.tryToInferIndirectObject({direct_object:object2,context:subject,handle_input:false});if(results.success||subject.success){var either_one,tool=(results.success?results.success:subject.success).indirect_object,tool_preposition="with";input.pushPhrase({asset:tool,preposition:tool_preposition});input.setStructure("verb noun preposition noun preposition noun");this.game.printInferred(tool_preposition+" "+tool.articlename)}else if(results.prompt||subject.prompt){input.setPreposition(3,"with");input.setSoftPrompt({index:3,type:"noun",noun3:true,structure:"verb noun preposition noun preposition noun"});input.setStructure("verb noun preposition noun preposition noun");this.game.debug("D1720",this.name+".js "," soft prompt for noun3 ");msg+=`What would {we} like to ${this.name} ${object1.articlename} from ${object2.articlename} with? `;this.handleFailure(msg);return false}}if(input.hasStructure("verb noun preposition noun preposition noun")){if(object1.allowVerbWithAnything(this.name,"dov"))return true;if(!object1.allowVerbWithAsset({verb:this.name,asset:tool,ov:"dov"})&&!object2.allowVerbWithAsset({verb:this.name,asset:tool,ov:"dov"})){this.game.debug("D1521",this.name+".js ",` neither ${object1.id} nor ${object2.id}.dov.${this.name}.with_assets/with_classes includes ${tool.id} `);msg+=`${tool.Articlename} can't be used to ${this.name} ${object1.articlename} from ${object2.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),object1=input.getAsset(1),object1_parent=object1.getPlaceAsset(),object2=input.getAsset(2),object2_preposition=input.getPreposition(2),tool=input.getAsset(3),tool_preposition=input.getPreposition(3),results,input="";if(object2.id!==subject.id){if(void 0!==(results=object1.moveFrom(object2)))return results;var target=object1.isDOV("take")?subject:this.game.getRoom(),targetprep="in",results;if(void 0!==(results=object1.moveTo(targetprep,target)))return results}input=(input=(input=(input=(input+=`{We} ${this.agree()} `+object1.articlename)+(object2?" from "+object2.articlename:""))+(tool?" with "+tool.articlename:""))+(target.id===subject.id?" and take it":` and set it ${targetprep} `+target.articlename)).trim();return this.handleSuccess(input+=". ")}};A.Preverbs.dig={name:"dig",prettyname:"dig",past_tense:"dug",synonyms:["dig"],gerund:"digging",accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},phrase3:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),player=this.game.getPlayer(),player,msg="";let hole_asset,hole_preposition,hole_position,target_asset,target_preposition,target_aspect,target_substance,target_container,target_is_hole,tool_asset,tool_preposition;for(let i=input.getPhraseCount();0<i;i--){var phrase=input.getPhrase(i),asset=input.getAsset(i),preposition=input.getPreposition(i),substance=input.getSubstance(i),phrase="hole"===phrase.noun;if("global_hole"===asset.id){hole_position=i;hole_asset=input.verb_params.hole_asset=asset;hole_preposition=input.verb_params.hole_preposition=preposition}else if(phrase){target_asset=input.verb_params.target_asset=asset;target_is_hole=input.verb_params.target_is_hole=true;target_preposition=input.verb_params.target_preposition=preposition}else if("with"===preposition){tool_asset=input.verb_params.tool_asset=asset;tool_preposition=input.verb_params.tool_preposition=preposition}else if(["in","under","behind"].includes(preposition)){target_asset=input.verb_params.target_asset=asset;target_preposition=input.verb_params.target_preposition=preposition;target_substance=input.verb_params.target_substance=substance}else{this.game.debug("D1190",this.name+".js ",` ${this.name} doesn't handle `+input.input);msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}}if(hole_position)input.deletePhrase(hole_position);if(!target_asset){var reservoirs=this.game.getRoom().findNestedAssetsWithProperty("aspects.in.vessel.is.reservoir");if(reservoirs.length)for(var item in reservoirs){var item=reservoirs[item];if(item.aspects.in.vessel.substance.hasClass("Solid")){target_asset=input.verb_params.target_asset=item;target_preposition=input.verb_params.target_preposition="in";target_aspect=input.verb_params.target_aspect=item.aspects.in;target_substance=input.verb_params.target_substance=target_aspect.vessel.substance}}if(!target_asset){target_asset=input.verb_params.target_asset=player.getNestOrPlaceAsset();target_preposition=input.verb_params.target_preposition=player.getNestOrPlacePreposition();if((target_aspect=input.verb_params.target_aspect=player.getNestOrPlaceAspect()).vessel?.substance)target_substance=input.verb_params.target_substance=target_aspect.vessel.substance}input.pushPhrase({asset:target_asset,preposition:target_preposition})}if(tool_asset?.id===input.getAsset(1).id&&target_asset?.id===input.getAsset(2).id)input.swapPhrases(1,2);if(!target_asset.isDOV(this.name)){this.game.debug("D1192",this.name+".js ",` ${target_asset.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${target_preposition?target_preposition:""} ${target_asset.articlename}. `;this.handleFailure(msg);return null}if(target_asset&&target_asset.allowVerbOnce(this.name,"dov")&&target_asset.didVerb(this.name,"dov")){this.game.debug("D1196",this.name+".js ",` ${target_asset.id}.dov.${this.name}.once and ${target_asset.id}.did.${this.name}.directly `);msg+=`${target_asset.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(target_asset&&!tool_asset){if(!target_asset.hasIndirectObjects(this.name)&&!target_asset.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1337",this.name+".js ",` ${target_asset.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${target_asset.articlename}. `;this.handleFailure(msg);return false}if((player=this.tryToInferIndirectObject({direct_object:target_asset,context:subject,handle_input:true})).prompt){if(target_asset.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1206",this.name+".js "," no tool found ");msg+=`{We} don't appear to have anything to ${this.name} ${target_preposition?target_preposition:""} ${target_asset.articlename} with. `;this.handleFailure(msg);return false}else if(player.success){tool_asset=input.verb_params.tool_asset=player.indirect_object;tool_preposition=input.verb_params.tool_preposition="with";this.game.printInferred(tool_preposition+" "+tool_asset.articlename)}}if(tool_asset&&!tool_asset.isIOV(this.name)){this.game.debug("D1319",this.name+".js ",` ${tool_asset.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${tool_preposition?tool_preposition:"with"} ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(tool_asset&&!this.game.parser.selectInHands(tool_asset.id).length){this.game.debug("D1335",this.name+".js ",` ${tool_asset.id}.$is("inhands") is false `);msg+=`{We're} not holding ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(tool_asset&&tool_asset.allowVerbOnce(this.name,"iov")&&tool_asset.didVerb(this.name,"dov")){this.game.debug("D1193",this.name+".js ",` ${tool_asset.id}.dov.${this.name}.once and ${tool_asset.id}.did.${this.name}.directly `);msg+=`${tool_asset.Articlename} has already been used to ${this.name}. `;this.handleFailure(msg);return false}if(tool_asset&&target_asset?.allowVerbWithAnything(this.name,"dov"));return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),results,msg="",{hole_asset,hole_preposition,target_asset:input,target_preposition,target_aspect,target_substance,target_container,target_is_hole,tool_asset,tool_preposition}=input.verb_params;msg+="{We} "+this.name;if(target_preposition)msg+=" "+target_preposition;if(target_substance&&input&&input.hasClass("Room"))msg+=` ${target_substance.articlename} `;if(target_substance&&input&&!input.hasClass("Room"))msg+=` ${target_substance.articlename} of ${input.articlename} `;if(!target_substance&&input)msg+=input.hasClass("Room")?" the ground":" "+input.articlename;if(tool_preposition)msg+=" "+tool_preposition;if(tool_asset)msg+=" "+tool_asset;msg=msg.trim();return this.handleSuccess(msg+=". ")}};A.Preverbs.dip={name:"dip",prettyname:"dip",past_tense:"dipped",synonyms:["dip","dunk"],gerund:"dipping",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true,visible:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{matter:true,present:true,reachable:true,visible:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["in"]},with_params:{},doTry:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_substance=input.getSubstance(2),indirect_container,msg="",containers,container,aspect;if("dip in"===verb_phrase||"dunk in"===verb_phrase);if(indirect_substance){indirect_container=indirect_object;indirect_object=indirect_substance}if(!direct_object.isDOV(this.name)){this.game.debug("D1840",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2123",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We} can't ${this.name} ${direct_object.articlename} again. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun"))if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;if(input.hasStructure("verb noun preposition noun")){if(!indirect_object.isIOV(this.name)){this.game.debug("D2124",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2125",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`{We've} already ${this.past_tense} into ${indirect_object.articlename} enough. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb noun preposition noun")&&indirect_object.hasClass("Tangible"))if("in"==(aspect=indirect_object.getVesselPreposition())&&indirect_object.is.closed){this.game.debug("D1842",this.name+".js ",` ${indirect_object.id}.is.closed`);msg+=indirect_object.Articlename_is+" closed. ";this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun")&&indirect_object.hasClass("Substance"));return true},doSuccess:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_container,indirect_preposition=input.getPreposition(2),input=input.getSubstance(2),indirect_vessel,msg="",dampened=false,indirect_object;if(!input&&indirect_object.containsAnySubstance())input=indirect_object.getVessel().getSubstance();if(input){indirect_container=indirect_object;indirect_object=input}if(indirect_container)indirect_vessel=indirect_container.getVesselAt(indirect_container.getVesselPreposition());if(indirect_vessel?.substance_id&&indirect_vessel.getSubstance().hasClass("Liquid")&&direct_object.is.absorbent&&direct_object.absorption_quantity&&!direct_object.is.damp){var input=indirect_vessel.getVolume()-direct_object.absorption_quantity;indirect_vessel.setVolume(input);dampened=direct_object.is.damp=true;if(void 0!==(indirect_object=direct_object.onMoistenThisWithThat(indirect_vessel.getSubstance())))return indirect_object}msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_container?" "+indirect_container.articlename:"")+". "+(dampened?direct_object.Articlename+" comes away damp. ":"");return this.handleSuccess(msg)}};A.Preverbs.dismount={name:"dismount",prettyname:"dismount",past_tense:"dismounted",synonyms:["dismount"],gerund:"dismounting",subject_must_be:{not_constrained:true},accepts_structures:["verb","verb noun","verb preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{tangible:true,known:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["from","off"]},with_params:{},doTry:function(){var input=this.game.getInput();input.setPreposition(1,"off");input.updateStructure();return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.draw={name:"draw",prettyname:"draw on",past_tense:"drew",synonyms:["draw"],gerund:"drawing",allow_iov_on_iov:true,accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true},accepts_preposition:true,preposition_must_be:["on","with"]},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true,visible:true,reachable:true,prefer_carried_if_ambiguous:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["in","on","with"]},phrase3:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true,visible:true,reachable:true,prefer_carried_if_ambiguous:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["in","on","with"]},with_params:{tool:false,target:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),msg="",subject_asset,tool_asset,tool_preposition,tool_asset_inferred,target_asset,target_preposition,subject,count;if(input.getAsset(1).is.information)return this.game.dictionary.doVerb("write");for(let i=input.getPhraseCount();0<i;i--){var asset=input.getAsset(i),preposition=input.getPreposition(i);console.warn(`${asset.id}.isDOV(draw) && !${asset.id}.isIOV(draw) `,asset?.isDOV(this.name)&&!asset.isIOV(this.name));if(asset?.isDOV(this.name)&&!asset.isIOV(this.name)){if(subject_asset){this.game.debug("D1527",this.name+".js "," can't handle multiple drawn items");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(preposition){this.game.debug("D1528",this.name+".js ",` no handling for "${preposition} ${asset.id}" `);msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.name}. `;this.handleFailure(msg);return false}subject_asset=input.verb_params.subject_asset=asset}else if(asset?.isIOV(this.name)&&asset.iov[this.name].with_params.tool){if(tool_asset){this.game.debug("D1535",this.name+".js "," can't handle multiple tool assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if("with"!==preposition){this.game.debug("D1602",this.name+".js "," can't handle preposition");msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}tool_asset=input.verb_params.tool_asset=asset;tool_preposition=input.verb_params.tool_preposition=preposition}else if(asset?.isIOV(this.name)&&asset.iov[this.name].with_params.target){if(target_asset){this.game.debug("D1620",this.name+".js "," can't handle multiple target assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(!["in","on"].includes(preposition)){this.game.debug("D1621",this.name+".js "," can't handle preposition");msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}target_asset=input.verb_params.target_asset=asset;target_preposition=input.verb_params.target_preposition=preposition}else{this.game.debug("D1622",this.name+".js ",` unusable asset ${asset.id} found`);msg+=`{We} don't know how to ${this.name} ${preposition?preposition:""} ${asset?asset.articlename:""}. `;this.handleFailure(msg);return null}}if(!subject_asset&&!target_asset&&!tool_asset){this.game.debug("D1623",this.name+".js "," no relevant assets found");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(!subject_asset){subject_asset=input.verb_params.subject_asset=this.game.getAsset("global_drawing");input.shiftPhrase({asset:subject_asset})}if(!target_asset){var index=input.getPhraseCount()+1;input.setPreposition(index,"on");input.setSoftPrompt({index:index,type:"noun",["noun"+index]:true});this.game.debug("D1624",this.name+".js "," soft prompt for target asset ");this.handleFailure(msg+="What would {we} like to draw on? ");return null}if(tool_asset&&!this.game.parser.selectInHands([tool_asset.id]).length){this.game.debug("D1624",this.name+".js ",` ${tool_asset.id}.place is not ${subject.id} `);msg+=`{We're} not holding ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(tool_asset&&!tool_asset.allowVerbWithAsset({verb:this.name,asset:target_asset,ov:"iov"})&&!tool_asset.allowVerbWithAnything(this.name,"iov")){this.game.debug("D1625",this.name+".js ",` neither ${tool_asset.id} nor ${target_asset.id} lists the other in dov/iov.${this.name}.with_assets or dov/iov.${this.name}.with_classes `);msg+=`${target_asset.Articlename} doesn't present a good drawing surface for ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(!tool_asset&&this.game.settings.infer_objects)if((subject=this.tryToInferIndirectObject({direct_object:target_asset,context:subject,handle_input:false,infer_first_use:true})).fail);else if(subject.prompt);else if(subject.success){var tool_asset=input.verb_params.tool_asset=subject.indirect_object,tool_preposition=input.verb_params.tool_preposition="with",index=input.pushPhrase({asset:tool_asset,preposition:"with"});this.game.printInferred("with "+tool_asset.articlename)}if(!tool_asset){var index=input.hasPhrase(2)?3:2;input.setSoftPrompt({index:index,type:"noun",["noun"+index]:true,structure:input.getStructure()+" preposition noun"});input.setPreposition(index,"with");this.game.debug("D1627",this.name+".js "," soft prompt for noun2 ");this.handleFailure(msg+="What would {we} like to draw with? ");return false}var phrase_count=input.getPhraseCount(),subject=input.getAsset(1);if(subject_asset&&subject&&subject_asset.id!==subject.id){let info_found_in_slot;for(let i=1;i<=phrase_count;i++)if(input.getAsset(i).id===subject_asset.id){info_found_in_slot=i;break}input.swapPhrases(info_found_in_slot,1)}var index=input.getAsset(2);if(target_asset&&index&&target_asset.id!==index.id){let target_found_in_slot;for(let i=1;i<=phrase_count;i++)if(input.getAsset(i).id===target_asset.id){target_found_in_slot=i;break}if(target_found_in_slot)input.swapPhrases(target_found_in_slot,2)}var subject=input.getAsset(phrase_count);if(tool_asset&&subject&&tool_asset.id!==subject.id){let tool_found_in_slot;for(let i=1;i<=phrase_count;i++){let asset=input.getAsset(i);if(asset&&asset.id===tool_asset.id){tool_found_in_slot=i;break}}if(tool_found_in_slot)input.swapPhrases(tool_found_in_slot,phrase_count)}return true},doSuccess:function(){var input,results,msg="",{subject_asset,info_preposition,target_asset,target_preposition,tool_asset,tool_preposition}=this.game.getInput().verb_params;msg+="{We} draw ";if(target_asset){if(subject_asset){var subject_asset=subject_asset.indefinite_name;subject_asset.replace(/^"(.*)"$/,"$1");msg+=`<span class="drawing ${tool_asset.class.toLowerCase()}">${subject_asset}</span> `;target_asset.drawn_things.push({class:tool_asset.class,erasable:tool_asset.is.erasable,data:subject_asset,color:tool_asset.appearance.color||""})}else{msg+=" a doodle ";target_asset.appearance.scribbles=true}msg=(msg+=target_asset.hasQuirk("draw_on_means_draw_in")?"in ":"on ")+target_asset.articlename}else msg+=" a doodle in the air";if(tool_asset)msg+=" with "+tool_asset.articlename;return this.handleSuccess(msg+=". ")}};A.Preverbs.drink={name:"drink",prettyname:"drink",past_tense:"drank",synonyms:["drink","sip"],gerund:"drinking",accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true,prefer_carried_if_ambiguous:true},accepts_preposition:true,preposition_must_be:["from"]},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["from"]},with_params:{on_drink_empty:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),room=this.game.getRoom(),containers,container,msg="",results,hook,find_container_for_direct_object=false,find_substance_for_direct_object=false;if(direct_object instanceof adventurejs.Substance&&indirect_object instanceof adventurejs.Tangible&&!indirect_object.containsAnySubstance()&&indirect_object.hasAnyPartContainingAnySubstance()){var substance_part=indirect_object.getAnyPartContainingAnySubstance(),indirect_object=substance_part;input.setAsset(2,substance_part)}if(input.hasStructure("verb noun")||input.hasStructure("verb preposition noun"))if(direct_object instanceof adventurejs.Substance)if(this.game.settings.infer_containers)find_container_for_direct_object=true;else{this.game.debug("D1173",this.name+".js "," this.game.settings.infer_containers is false ");msg+=`What would {we} like to ${this.name} ${direct_object.id} from? `;input.setPreposition(2,"from");input.setSoftPrompt({index:2,type:"noun",noun2:true});input.setStructure(input.getStructure()+" preposition noun");this.handleFailure(msg);return null}else{let substance_part=direct_object.getAnyPartContainingAnySubstance();if(direct_object.containsAnySubstance())find_substance_for_direct_object=true;else if(substance_part){direct_object=substance_part;input.setAsset(1,substance_part);find_substance_for_direct_object=true}else if(direct_object.canContainSubstances()||direct_object.canAnyPartContainSubstances()){this.game.debug("D1575",this.name+".js ",` ${direct_object.id} is empty `);msg+=direct_object.Articlename_is+" empty. ";this.handleFailure(msg);return null}else if(direct_object.isDOV("drink")){if(!direct_object.isDOV("take")||direct_object.isWithin(subject))return input.verb_params.can_be_drunk=true;this.game.debug("D1748",this.name+".js ",` ${direct_object.id} is not in subject `);msg+=`{We're} not carrying ${direct_object.articlename}. `;this.handleFailure(msg);return null}else{this.game.debug("D1171",this.name+".js ",` ${direct_object.id}.dov.drink.enabled is false `);msg+=direct_object.Articlename+" can't be drunk from. ";this.handleFailure(msg);return null}}if(find_container_for_direct_object){if(!(containers=this.game.findSubstanceContainers(direct_object.id,this.game.getRoom(),["Present","Known","Visible","Reachable"])).length){this.game.debug("D1576",this.name+".js "," no containers found ");msg+=`{We} {don't} see any ${direct_object.name}. `;this.handleFailure(msg);return null}if(1<containers.length){console.warn({containers:containers});var carried_containers=[];for(let i=0;i<containers.length;i++){var asset=containers[i];if(asset.$is("carried"))carried_containers.push(asset)}if(carried_containers.length){switch(carried_containers.length){case 0:break;case 1:container=carried_containers[0];break;default:outer:for(let i=0;i<carried_containers.length;i++){var carried=carried_containers[i],last_turn=this.game.getLastTurn(),last_turn_asset;for(let phrase=1;phrase<last_turn.getPhraseCount();phrase++){if(last_turn.getAsset(phrase).id===carried.id){container=carried;break outer}}}break}if(!container)container=carried_containers[0]}if(!container&&this.game.settings.infer_containers_prefers_reservoir)for(var i=0;i<containers.length;i++){let asset=containers[i];if(asset.$is("reservoir")||asset.$is("emitting")){container=asset;break}}if(!container&&!this.game.settings.auto_pick_inferred_container){this.game.debug("D1578",this.name+".js "," multiple containers found, disambiguate ");input.setPreposition(1,"from");input.setParsedNounMatchesQualified(1,containers);this.game.parser.printNounDisambiguation({parsedNoun:input.getParsedNoun(1),nounIndex:1});return null}}if(!container)container=containers[0];if(container.id===room.id)input.verb_params.drink_from_room=true;input.setAsset(2,this.game.getAsset(container));input.setPreposition(2,"from");input.setInferred(2,true);input.setStructure("verb noun preposition noun");indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2);this.game.printInferred("from "+indirect_object.articlename)}if(find_substance_for_direct_object){indirect_object=direct_object;direct_object=this.game.getAsset(indirect_object.getAnySubstanceThisContains());input.setAsset(1,direct_object);input.setPreposition(1,"");input.setAsset(2,indirect_object);input.setPreposition(2,"from");input.setStructure("verb noun preposition noun");this.game.printInferred(direct_object.name+" from "+indirect_object.articlename)}if(input.hasStructure("verb noun preposition noun")){if(!direct_object.isDOV("drink")){this.game.debug("D1577",this.name+".js ",` ${direct_object.id}.dov.drink.enabled is false `);msg+=`{We} can't drink ${direct_object.name}. `;this.handleFailure(msg);return null}let substance_part=indirect_object.getAnyPartContainingAnySubstance();if(!indirect_object.canContainSubstances()){this.game.debug("D1582",this.name+".js ",` ${indirect_object.id} has no substance container `);msg+=indirect_object.Articlename+" can't be drunk from. ";this.handleFailure(msg);return null}if("in"===indirect_object.getVesselPreposition()&&indirect_object.isDOV("open")){this.game.debug("D1571",this.name+".js ",` ${indirect_object.id}.is.closed `);msg+=indirect_object.Articlename_is+" closed. ";this.handleFailure(msg);return null}if(!indirect_object.containsAnySubstance()){if(indirect_object instanceof adventurejs.SubstanceEmitter){this.game.debug("D1580",this.name+".js ",` ${indirect_object.id} is class SubstanceEmitter and .is.emitting is false `);msg+=`Nothing is coming out of ${indirect_object.articlename}. `}else{this.game.debug("D1581",this.name+".js ",` ${indirect_object.id}.aspects.in.vessel.volume is 0 `);msg+=indirect_object.Articlename_is+" empty. "}this.handleFailure(msg);return null}if(!indirect_object.containsSubstance(direct_object.id)){if(indirect_object instanceof adventurejs.SubstanceEmitter){this.game.debug("D1339",this.name+".js ",` ${indirect_object.id} is not emitting ${direct_object.id} `);msg+=`{We} don't see any ${direct_object.name} coming out of ${indirect_object.articlename}. `}else{this.game.debug("D1340",this.name+".js ",` ${indirect_object.id}.aspects.in.vessel.volume is 0 `);msg+=`${indirect_object.Articlename_is} doesn't contain any ${direct_object.name}. `}this.handleFailure(msg);return null}if(indirect_object.isDOV("take")&&!indirect_object.isWithin(subject)){this.game.debug("D1579",this.name+".js ",` ${indirect_object.id} is not in subject `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results,direct_object,input,direct_object;if(input.verb_params.can_be_drunk){if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));msg+=`{We} drink ${direct_object.articlename}. `;if(void 0!==(results=subject.onIngestThat(direct_object)))return results;if(direct_object&&direct_object.dov.drink?.then_destroy)direct_object.destroy()}else if(input.hasStructure("verb noun"));else if(input.hasStructure("verb preposition noun"));else if(input.hasStructure("verb noun preposition noun")){direct_object=indirect_object.getVesselPreposition();input=indirect_object.getVesselAt(direct_object);direct_object=this.game.getAsset(input.substance_id);if(indirect_object.iov.drink?.with_params.on_drink_empty)input.setVolume(0);else input.subtractVolume(this.game.settings.mouthful);msg+=`{We} drink some ${direct_object.name} from `+indirect_object.articlename;if(input.getVolume()<=0)msg+=", emptying it in one gulp";msg=msg.trim();msg+=". ";if(void 0!==(results=subject.onIngestThat(direct_object)))return results}return this.handleSuccess(msg)}};A.Preverbs.drive={name:"drive",prettyname:"drive",past_tense:"drove",synonyms:["drive"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"driving",subject_must_be:{not_constrained:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("ride")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.drop={name:"drop",prettyname:"drop",past_tense:"dropped",synonyms:["drop"],enqueue_collections:true,gerund:"dropping",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,accepts_plural_noun:true,noun_must_be:{known:true,in_inventory:true,not_worn_if_all:true,not_nested_inventory_if_all:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,singular:false},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),room=this.game.getRoom(),results,msg="";if("put down"===verb_phrase);if(input.hasStructure("verb noun preposition noun"))if(indirect_object.hasClass("Floor")){if(!room.has_floor){this.game.debug("D2068",this.name+".js ",` ${room.id}.has_floor is false `);this.handleFailure(msg+="{We} can't see a floor here. ");return null}if("on"!==indirect_preposition){this.game.debug("D2069",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}input.deletePhrase(2);input.setStructure("verb noun")}else if(indirect_object.hasClass("Room")){if("in"!==indirect_preposition){this.game.debug("D2070",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}input.deletePhrase(2);input.setStructure("verb noun")}else{this.game.debug("D2030",this.name+".js "," inferring put, doVerb put ");return this.game.dictionary.doVerb("put")}if("all"===input.parsedNoun1.original_input&&direct_object.is.worn)this.game.debug("D1263",this.name+".js ",` ${direct_object}.is.worn, not dropping it `);else if("all"===input.parsedNoun1.original_input&&direct_object.getPlaceAssetId()!==this.game.world._player)this.game.debug("D1264",this.name+".js ",` ${direct_object} is not direct child of subject, not dropping it `);else{if(subject.isConnectedToAsset("hold",direct_object,"to_dov")&&direct_object.isDOV("release")){this.game.debug("D1265",this.name+".js ",` subject is holding ${direct_object}, infer release `);return this.game.dictionary.doVerb("release")}if(!direct_object.isWithin(subject)){this.game.debug("D1266",this.name+".js ",` ${direct_object.id}+" is not child of subject `);msg+=`{We're} not carrying ${direct_object.articlename}. `;this.handleFailure(msg)}else{if(subject.getNestId()!==direct_object.id)return true;this.game.debug("D1267",this.name+".js "," subject is nested on "+direct_object.id);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition?indirect_preposition:""} ${indirect_object?indirect_object.articlename:""} while {we're} ${subject.getPostureGerund()} ${subject.getNestPreposition()} it. `;this.handleFailure(msg)}}return null},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),room=this.game.getRoom(),nest_asset=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),msg="",removedItem=false,results;if(direct_object.is.worn){msg=msg+((results=direct_object.unfasten())?`{We} ${results}, remove, `:"{We} remove ")+`and drop ${direct_object.articlename}. `;direct_object.incrementDoVerbCount("remove","dov");direct_object.is.worn=false}else msg+=`{We} drop ${direct_object.articlename}. `;if(void 0!==(results=subject.onRemoveThatFromThis(direct_object)))return results;if(nest_asset)results=this.tryToPutThisInThatAspect(direct_object,subject.getNestPreposition(),nest_asset);if(nest_asset&&!results.fail){if(void 0!==(results=nest_asset.onMoveThatToThis(direct_object,nest_preposition)))return results}else if(void 0!==(results=room.onMoveThatToThis(direct_object,"in")))return results;if((1<input.parsedNoun1.matches.qualified.length||this.game.parser.isParsingMultiple())&&-1===input.output_class.indexOf("concatenate_output"))input.output_class+=" concatenate_output ";return this.handleSuccess(msg)}};A.Preverbs.eat={name:"eat",prettyname:"eat",past_tense:"ate",synonyms:["eat"],gerund:"eating",accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with","from"]},with_params:{on_eat_destroy:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),direct_container,indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,direct_substance,msg="";if(direct_substance){direct_container=direct_object;direct_object=direct_substance}if(!direct_object.isDOV("eat")){this.game.debug("D1269",this.name+".js ",` ${direct_object.id}.dov.eat.enabled is false `);msg+=`{We} can't eat ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2129",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1611",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((direct_substance=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2113",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_substance.success){indirect_object=direct_substance.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(!indirect_object.isIOV("eat")){this.game.debug("D2114",this.name+".js ",` ${indirect_object.id}.iov.eat.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D2009",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2115",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2116",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2117",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),direct_container,indirect_object=input.getAsset(2),input=input.getPreposition(2),direct_substance,msg="";if(direct_substance){direct_container=direct_object;direct_object=direct_substance}msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.article_name:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";if(void 0!==(direct_substance=subject.onIngestThat(direct_object)))return direct_substance;if(direct_object.dov.eat?.with_params.on_eat_destroy)direct_object.destroy();return this.handleSuccess(msg)}};A.Preverbs.empty={name:"empty",prettyname:"empty",past_tense:"emptied",synonyms:["empty"],gerund:"emptying",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),substance="",msg="",empty_means_take_all,empty_means_unplug,empty_means_take_plug;if(direct_object instanceof adventurejs.Tangible){if(direct_object.isDOV("open")){this.game.debug("D1741",this.name+".js ",` ${direct_object.id}.is.closed `);msg+=direct_object.Articlename_is+" closed. ";this.handleFailure(msg);return null}if(!direct_object.containsAnySubstance()&&!direct_object.containsAnyAsset()){this.game.debug("D1551",this.name+".js ",` ${direct_object.id}.containsAnySubstance and .containsAnyAsset are false `);msg+=direct_object.Articlename_is+" empty. ";this.handleFailure(msg);return null}}if(input.hasStructure("verb noun")){if(direct_object instanceof adventurejs.Substance){this.game.debug("D1742",this.name+".js ",` ${direct_object.id} is a substance rather than a container `);msg+=`{We} {don't} know how to empty ${direct_object.name}. `;this.handleFailure(msg);return null}if(!direct_object.isDOV("take")){if(direct_object.containsAnyAssetAt("in"))for(var takeable_assets=[],i=0;i<direct_object.aspects.in.contents.length;i++){var asset=this.game.getAsset(direct_object.aspects.in.contents[i]);if(asset.isDOV("take"))takeable_assets.push(asset);if(takeable_assets.length){input.verb_params.empty_means_take_all=empty_means_take_all=true;input.verb_params.takeable_assets=takeable_assets}}if(!empty_means_take_all){this.game.debug("D1744",this.name+".js ",` ${direct_object.id}.dov.take.enabled is false and .aspects.in.contents is empty `);msg+=`{We} {don't} know how to empty ${direct_object.articlename}. `;this.handleFailure(msg);return null}}else{indirect_object=subject.getNestOrPlaceAsset();indirect_preposition=subject.getNestOrPlacePreposition();input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setInferred(2,true);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+(indirect_object.hasClass("Room")?"the floor":indirect_object.articlename))}}if(input.hasStructure("verb noun preposition noun")){if(indirect_object instanceof adventurejs.Floor){indirect_object=this.game.getRoom();input.setAsset(2,indirect_object)}if(!direct_object.isDOV("take")){this.game.debug("D1745",this.name+".js ",` ${direct_object.id}.dov.take.enabled is false `);msg+=`{We} {don't} know how to empty ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.isDOV("take")&&!direct_object.isWithin(subject)){this.game.debug("D1743",this.name+".js ",` ${direct_object.id}.place not in subject `);msg+=`{We're} not carrying ${direct_object.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results,room=indirect_object instanceof adventurejs.Room,target_object,target_preposition,emptied_count=0,transferred=[],spillover=[],overflow=false,input,empty_this=false,mixer;if(input.hasStructure("verb noun")){if(input.verb_params.empty_means_take_all){for(var takeable_assets=input.verb_params.takeable_assets,i=0;i<takeable_assets.length;i++){var asset=takeable_assets[i],results;if(void 0!==(results=asset.moveFrom(direct_object)))return results;if(void 0!==(results=asset.moveTo("in",subject)))return results}this.game.debug("D1746",this.name+".js "," empty means take ");msg+=`{We} take ${this.game.getPrintableObjectList({objects:takeable_assets})} from ${direct_object.articlename}. `}}else if(input.hasStructure("verb noun preposition noun")){this.game.debug("D1747",this.name+".js "," empty means pour ");msg+="{We} empty "+direct_object.articlename;if("under"===indirect_preposition||"behind"===indirect_preposition)msg+=` ${indirect_preposition} `+indirect_object.articlename;else msg+=" over "+(room?"the floor":indirect_object.articlename);msg=msg.trim();msg+=". ";if(direct_object.hasVesselAtAspect("in")){if(0<direct_object.aspects.in.vessel.getVolume()){input=this.game.getAsset(direct_object.aspects.in.vessel.substance_id);if(room||"under"===indirect_preposition||"behind"===indirect_preposition){msg+=input.Name+" spills to the floor. ";empty_this=true}else if("on"===indirect_preposition&&!indirect_object.hasVesselAtAspect(indirect_preposition)){msg+=`${input.Name} pours over ${indirect_object.articlename} and then drains away. `;empty_this=true}else if(indirect_object.hasVesselAtAspect(indirect_preposition)){results=(mixer=new adventurejs.SubstanceMixer(this.game.game_name).set({source_input:direct_object.id,source_aspect:"in",source_substance_id:direct_object.aspects.in.vessel.substance_id,target_input:indirect_object.id,target_aspect:indirect_preposition})).mix();if(A.isFalseOrNull(results))return results;mixer.target_vessel.is.known=true;msg+=`${mixer.source_substance_asset.Name} pours from 
              ${mixer.source_asset.articlename} ${indirect_preposition} 
              ${"in"===indirect_preposition||"on"===indirect_preposition?" to":""} 
              `+mixer.target_asset.articlename;if(mixer.can_drain_target)msg+=", where it quickly drains away";else if(mixer.did_overflow_target)msg+=`, overflowing ${mixer.target_asset.articlename} with 
                `+(mixer.did_mix_substances?mixer.output_substance_asset.name:mixer.source_substance_asset.name);else if(mixer.did_fill_target)msg+=`, filling ${mixer.target_asset.articlename} with 
                `+(mixer.did_mix_substances?mixer.output_substance_asset.name:mixer.source_substance_asset.name);else if(mixer.did_mix_substances)msg+=", resulting in "+mixer.output_substance_asset.name;msg=msg.trim();msg+=". "}else{msg+=`${input.Name} pours over ${indirect_object.articlename} and then spills to the floor. `;empty_this=true}}if(empty_this&&isFinite(direct_object.aspects.in.vessel.getVolume()))direct_object.aspects.in.vessel.setVolume(0)}if(0<direct_object.aspects.in.contents.length)for(var i=direct_object.aspects.in.contents.length-1;-1<i;i--){var content_object=this.game.getAsset(direct_object.aspects.in.contents[i]),target_object=indirect_object,target_preposition=indirect_preposition,overflow=false;emptied_count++;if(room)transferred.push(content_object);else if(indirect_object.canContainAssetAt(content_object,indirect_preposition))transferred.push(content_object);else{target_object=this.game.getRoom();target_preposition="in";spillover.push(content_object)}if(void 0!==(results=direct_object.onRemoveThatFromThis(content_object)))return results;if(void 0!==(results=target_object.onMoveThatToThis(content_object,target_preposition)))return results}if(room)switch(emptied_count){case 0:break;case 1:msg+="A single item tumbles out and falls to the floor. ";break;case 2:msg+="Two items tumble out and fall to the floor. ";break;case 3:msg+="Several items tumble out and fall to the floor. ";break;default:msg+="A number of items tumble out and fall to the floor. ";break}else{var to_target=indirect_preposition+("in"===indirect_preposition||"on"===indirect_preposition?" to ":" ")+indirect_object.articlename;switch(emptied_count){case 0:break;case 1:msg+="A single item tumbles "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=" then falls to the floor. ";break}break;case 2:msg+="Two items tumble "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=", and one falls to the floor. ";break;case 2:msg+=" then fall to the floor. ";break}break;case 3:msg+="Several items tumble "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=", and one falls to the floor. ";break;case 2:msg+=", and a couple of them fall to the floor. ";break;case 3:msg+=" then fall to the floor. ";break}break;default:msg+="A number of items tumble "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=", and one falls to the floor. ";break;case 2:msg+=", and a couple of them fall to the floor. ";break;case 3:msg+=", and several fall to the floor. ";break;default:msg+=" and some fall to the floor. ";break}break}}}return this.handleSuccess(msg)}};A.Preverbs.erase={name:"erase",prettyname:"erase",past_tense:"erased",synonyms:["erase"],gerund:"erasing",phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{tangible:true,present:true,known:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,in_inventory:true},accepts_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,verb_phrase,msg="",allow=true;if("erase with"===verb_phrase);if(!direct_object.isDOV("erase")){this.game.debug("D1516",this.name+".js ",` ${direct_object.id}.dov.erase.enabled is false `);msg+=direct_object.Articlename+" can't be erased. ";this.handleFailure(msg);return false}if(input.hasStructure("verb noun"))if((verb_phrase=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true,infer_first_use:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1755",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(verb_phrase.success){indirect_object=verb_phrase.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,"with");input.setStructure("verb noun preposition noun");this.game.printInferred("with "+indirect_object.articlename)}if(input.hasStructure("verb noun preposition noun")){if(!indirect_object.isIOV("erase")){this.game.debug("D1519",this.name+".js ",` ${indirect_object.id}.iov.erase.enabled is false `);msg+=indirect_object.Articlename+" can't be used as an eraser. ";this.handleFailure(msg);return null}if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1361",this.name+".js ",` neither ${direct_object.id} nor ${indirect_object.id} lists the other in dov/iov.${this.name}.with_assets or dov/iov.${this.name}.with_classes `);msg+=`{We} can't ${this.name} ${direct_object.articlename} with ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),input=input.getAsset(2),msg="",results,oldcount=direct_object.written_strings.length+direct_object.drawn_things.length;for(let i=direct_object.written_strings.length-1;-1<i;i--)if(direct_object.written_strings[i].erasable)direct_object.written_strings.splice(i,1);var newcount=direct_object.written_strings.length;for(let i=direct_object.drawn_things.length-1;-1<i;i--)if(direct_object.drawn_things[i].erasable)direct_object.drawn_things.splice(i,1);newcount+=direct_object.drawn_things.length;msg+=`{We} ${0===oldcount||0<newcount?"try to":""} erase ${direct_object.articlename} with 
        ${input?input.articlename:"the flat of {our} hand"}. `;return this.handleSuccess(msg)}};A.Preverbs.examine={name:"examine",prettyname:"examine",past_tense:"examined",synonyms:["examine","x"],type:{sensory:true},extends:{look:true},gerund:"examining",accepts_structures:["verb noun","verb preposition","verb preposition noun","verb noun preposition noun","verb noun preposition noun preposition noun"],accepts_adverbs:["carefully"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present:true,visible:true},accepts_preposition:true,accepts_preposition_without_noun:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,matter:true,present:true,visible:true},accepts_preposition:true,requires_preposition:true},with_params:{must_be_worn:false,must_be_held:false},msgNoObject:"What did you want to examine?",doTry:function(){var input=this.game.getInput();if(!input.getPreposition(1))input.setPreposition(1,"at");input.updateStructure();return this.game.dictionary.doVerb("look")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.exits={name:"exits",synonyms:["exits"],accepts_structures:["verb"],do:function(){var input=this.game.getInput(),exits=this.game.getRoomExits();if(exits)this.game.print(exits,input.output_class);return true}};A.Preverbs.feed={name:"feed",prettyname:"feed",past_tense:"fed",synonyms:[],gerund:"feeding",accepts_structures:["verb noun","verb noun noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,preposition_must_be:["with","to"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb noun preposition noun"))if("to"===indirect_preposition&&(indirect_object.hasClass("Character")||indirect_object.isDOV(this.name))){input.swapPhrases(1,2);input.setPreposition(1,"");input.setPreposition(2,"with");direct_object=input.getAsset(1);indirect_object=input.getAsset(2);direct_preposition=input.getPreposition(1);indirect_preposition=input.getPreposition(2)}if(!direct_object.isDOV(this.name)){this.game.debug("D2119",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2118",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of anything to ${this.name} ${direct_object.articlename} with. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2119",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun noun")){input.setPreposition(2,indirect_preposition="with");input.setStructure("verb noun preposition noun")}if(input.hasStructure("verb noun preposition noun")){if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D1280",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2121",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2122",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=indirect_object.Articlename+" doesn't appear to be edible. ";this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1959",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=indirect_object.Articlename+" has already been eaten enough. ";this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";if(direct_object.dov.eat?.with_params.on_eat_destroy)direct_object.destroy();msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.feel={name:"feel",prettyname:"feel",past_tense:"felt",synonyms:["touch","feel","finger"],gerund:"feeling",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),output_class=input.output_class,direct_object=input.getAsset(1),indirect_preposition=input.getPreposition(2),indirect_object=input.getAsset(2),room=this.game.getRoom(),direct_substance,indirect_substance,results,msg="",direct_substance=direct_object instanceof adventurejs.Substance;if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(input.hasStructure("verb noun preposition noun"))indirect_substance=indirect_object instanceof adventurejs.Substance;if(!direct_object&&"feel"===input.input_verb)if(room.hasDescription("feel")){input.setAsset(1,room);input.verb_params.source=room.descriptions.feel;return true}if(indirect_object){if(direct_substance&&indirect_substance){this.game.debug("D1641",this.name+".js "," both items are substances ");msg+=`{We} can't ${this.name} ${direct_object.name} ${indirect_preposition} ${indirect_object.name}. `;this.handleFailure(msg);return null}if(direct_substance&&(!indirect_object.hasAspectAt(indirect_preposition)||indirect_object.getAspectAt(indirect_preposition).vessel.substance_id!==direct_object.id)){this.game.debug("D1643",this.name+".js ",` ${indirect_object.id} does not contain ${direct_object.id} `);msg+=`${indirect_object.Articlename} doesn't contain ${direct_object.name}. `;this.handleFailure(msg);return null}if(!indirect_substance&&!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D1639",this.name+".js ",` ${indirect_object.id} has no aspect at ${indirect_preposition} `);msg+=`There's nothing ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!direct_substance&&!indirect_substance&&!direct_object.isWithin(indirect_object)){this.game.debug("D1640",this.name+".js ",` ${direct_object.id} not in ${direct_object.id} `);msg+=`${direct_object.Articlename} doesn't appear to be ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(indirect_substance){var input=direct_object.getPlaceAspect();if(!input||!input.vessel||input.vessel.substance_id!==indirect_object.id){this.game.debug("D1642",this.name+".js ",` ${direct_object.id} is not in something that contains ${indirect_object.id} `);msg+=`${direct_object.Articlename} doesn't appear to be ${indirect_preposition} ${indirect_object.name}. `;this.handleFailure(msg);return null}}}if(!direct_object.isDOV(this.name)){this.game.debug("D1452",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg)}else{if(direct_object.hasDescription(this.name))return true;this.game.debug("D1453",this.name+".js ",` ${direct_object.id}.descriptions.${this.name} is unset `);msg+=`{We} {don't} ${this.name} anything special. `;this.handleFailure(msg)}return null},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));msg+=`{We} ${this.name} ${direct_object.articlename}. `;if(input.verb_params.source)msg+=A.getSAF.call(this.game,input.verb_params.source);else if(direct_object.hasDescription(this.name))msg+=this.game.getDescription({asset:direct_object,identifier:this.name});else msg+="{We} {don't} feel anything in particular. ";return this.handleSuccess(msg)}};A.Preverbs.fill={name:"fill",prettyname:"fill",past_tense:"filled",synonyms:["fill"],gerund:"filling",accepts_structures:["verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,prefer_carried_if_ambiguous:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with","from"]},phrase3:{accepts_noun:true,accepts_preposition:true,noun_must_be:{known:true,matter:true,present:true,visible:true,reachable:true},requires_preposition:true,preposition_must_be:["from"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),target_asset=input.getAsset(1),source_asset=input.getAsset(2),preposition2=input.getPreposition(2),source_asset2=input.getAsset(3),preposition3=input.getPreposition(3),substance_id="",containers,container,msg="",source_volume,preposition2,input,source_aspect,substance_id;if("from"===preposition2&&!source_asset.containsAnySubstance()&&source_asset.hasAnyPartContainingAnySubstance()){source_asset=source_asset.getAnyPartContainingAnySubstance();input.setAsset(2,source_asset)}if("from"===preposition3&&!source_asset2.containsAnySubstance()&&source_asset2.hasAnyPartContainingAnySubstance()){source_asset2=source_asset2.getAnyPartContainingAnySubstance();input.setAsset(3,source_asset2)}if("with"===preposition2&&"from"===preposition3){if(!(substance_id=input.getParsedNoun(2).matches.substance)){this.game.debug("D1559",this.name+".js ",` ${source_asset.id} is not a substance `);msg+=`{We} can't fill ${target_asset.articlename} with ${source_asset.articlename}. `;this.handleFailure(msg);return null}if(!source_asset2.containsSubstance(substance_id)&&!source_asset2.hasAnyPartContainingSubstance(substance_id)){this.game.debug("D1563",this.name+".js ",` ${source_asset2.id} does not contain ${substance_id} `);msg+=source_asset2.articlename+` doesn't contain ${substance_id}. `;this.handleFailure(msg);return null}input.setPhrase(2,input.getPhrase(3));input.setPhrase(3,{});source_asset=input.getAsset(2);preposition2=input.getPreposition(2)}else if("with"===preposition2)if(substance_id=input.getParsedNoun(2).matches.substance){if(!(containers=this.game.findSubstanceContainers(substance_id,this.game.getRoom(),["Present","Known","Visible","Reachable"])).length){this.game.debug("D1565",this.name+".js "," no containers found ");msg+=`There's no ${this.game.getAsset(substance_id).name} to fill ${target_asset.articlename} with. `;this.handleFailure(msg);return null}if(1<containers.length){if(this.game.settings.infer_containers_prefers_reservoir)for(var i=0;i<containers.length;i++){var asset=this.game.getAsset(containers[i]);if(asset.id===this.game.getRoom().id){container=asset;break}}if(!container&&!this.game.settings.auto_pick_inferred_container){this.game.debug("D1564",this.name+".js "," multiple containers found, disambiguate ");input.setPreposition(2,"from");input.setParsedNounMatchesQualified(2,containers);this.game.parser.printNounDisambiguation({parsedNoun:input.getParsedNoun(2),nounIndex:2});return null}}if(!container)container=containers[0];input.setPhrase(2,{});input.setPreposition(2,"from");input.setAsset(2,this.game.getAsset(container));input.setInferred(2,true);source_asset=input.getAsset(2);preposition2="from";this.game.printInferred("from "+container.articlename)}else{if(!source_asset.containsAnySubstance()){if(source_asset.canBePut("in",target_asset)&&this.game.hasVerb("put")){console.warn(source_asset.id+" CAN BE PUT IN "+target_asset.id);this.game.debug("D1543",this.name+".js ",` ${source_asset.id} can be put in ${target_asset.id}, doVerb put `);if(input.getAsset(1).id!==source_asset.id){input.setAsset(1,source_asset);input.setPreposition(1,"")}if(input.getAsset(2).id!==target_asset.id){input.setAsset(2,target_asset);input.setPreposition(2,"in")}this.game.dictionary.doVerb("put")}else{this.game.debug("D1566",this.name+".js ",` ${source_asset.id} does not contain anything `);msg+=`${source_asset.Articlename} doesn't contain anything with which to fill ${target_asset.articlename}. `;this.handleFailure(msg)}return null}input.setPreposition(2,"from");preposition2="from"}else if("from"===preposition2)if(source_asset&&!source_asset.containsAnySubstance()&&!source_asset.hasAnyPartContainingAnySubstance()){this.game.debug("D1560",this.name+".js ",` ${source_asset.id} does not contain anything `);msg+=`${source_asset.Articlename} doesn't contain anything with which to fill ${target_asset.articlename}. `;this.handleFailure(msg);return null}if(!target_asset.hasVessel()){this.game.debug("D1566",this.name+".js ",` ${target_asset.id} has no substance container `);msg+=target_asset.Articlename+" can't be filled. ";this.handleFailure(msg)}else{if(!target_asset.isWithin(subject)&&!source_asset.isWithin(subject)){if(target_asset.isDOV("take")&&source_asset.isDOV("take")){this.game.debug("D1567",this.name+".js ",` neither ${target_asset.id} nor ${source_asset.id} are in subject `);msg+=`{We're} holding neither ${target_asset.articlename} nor ${source_asset.articlename}. `;this.handleFailure(msg);return null}if(!target_asset.isDOV("take")&&!source_asset.isDOV("take")){this.game.debug("D1569",this.name+".js ",` both ${target_asset.id} and ${source_asset.id} are stationary `);msg+=`{We} try transferring ${this.game.getAsset(source_asset.getAnySubstanceThisContains()).name} 
              from ${target_asset.articlename} to ${source_asset.articlename} by hand, to little effect. `;this.handleFailure(msg);return null}if(target_asset.isDOV("take")||source_asset.isDOV("take")){var preposition3=target_asset.isDOV("take")?target_asset:source_asset;this.game.debug("D1570",this.name+".js ",` ${preposition3.id}.dov.take.enabled is true, but is unheld `);msg+=`{We're} not holding ${preposition3.articlename}. `;this.handleFailure(msg);return null}}if("in"===source_aspect&&source_asset.isDOV("close")&&source_asset.is.closed){var source_asset2=target_asset.is.closed?target_asset:source_asset;this.game.debug("D1471",this.name+".js ",` ${source_asset2.id}.is.closed is true `);msg+=source_asset2.Articlename_is+" closed. ";this.handleFailure(msg)}else{substance_id=target_asset.getVesselPreposition();source_aspect=source_asset.getVesselPreposition();input=target_asset.getVesselAt(substance_id);if((source_volume=(preposition2=source_asset.getVesselAt(source_aspect)).getVolume())<=0)if(source_asset instanceof adventurejs.SubstanceEmitter){this.game.debug("D1572",this.name+".js ",` ${source_asset.id} is class SubstanceEmitter, but .is.emitting is false `);msg+=`Nothing is coming out of ${source_asset.articlename}. `;this.handleFailure(msg);return null}else{this.game.debug("D1573",this.name+".js ",` ${source_asset.id}.aspects.in.vessel.volume is 0 `);msg+=`Nothing is coming out of ${source_asset.articlename}. `;this.handleFailure(msg);return null}if(input.getVolume()!==input.maxvolume||input.substance_id!==preposition2.substance_id)return true;this.game.debug("D1574",this.name+".js ",` ${target_asset.id}.aspects.${substance_id}.vessel.volume is equal to .maxvolume `);msg+=`${target_asset.Articlename_is} already full of ${this.game.getAsset(input.substance_id).name}. `;this.handleFailure(msg)}}return null},doSuccess:function(){var input=this.game.getInput(),target_asset=input.getAsset(1),input=input.getAsset(2),room=input instanceof adventurejs.Room,msg="",target_asset,input,input=new adventurejs.SubstanceMixer(this.game.game_name).set({can_overflow_target:false,source_input:input.id,source_aspect:input.getVesselPreposition(),source_substance_id:input.getVesselPreposition().substance_id,target_input:target_asset.id,target_aspect:target_asset.getVesselPreposition()}),target_asset=input.mix();if(A.isFalseOrNull(target_asset))return target_asset;input.target_vessel.is.known=true;msg=`{We} fill ${input.target_asset.articlename} with `+input.source_substance_asset.name+(room?"":" from "+input.source_asset.articlename);if(input.can_drain_target)msg+=", but it quickly drains away";else if(input.did_mix_substances)msg+=", resulting in "+input.output_substance_asset.name;else if(input.did_displace_substance)msg+=`, displacing the ${this.game.getAsset(input.target_substance_id).name} that was already there`;msg=msg.trim();return this.handleSuccess(msg+=". ")}};A.Preverbs.fix={name:"fix",prettyname:"fix",past_tense:"fixed",synonyms:["fix","repair"],unstate:"broken",gerund:"fixing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1945",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1936",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} not ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1937",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1938",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1939",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1941",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1942",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1943",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="";this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.flick={name:"flick",prettyname:"flick",past_tense:"flicked",synonyms:["flick"],gerund:"flicking",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present:true,visible:true,reachable:true,reservoir_or_carried_if_substance:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),direct_container,indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,direct_substance,msg="";if(direct_substance){direct_container=direct_object;direct_object=direct_substance}if(!direct_object.isDOV("flick")){this.game.debug("D1281",this.name+".js ",` ${direct_object.id}.dov.flick.enabled is false`);msg+=`{We} can't flick ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1823",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1949",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((direct_substance=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1950",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_substance.success){indirect_object=direct_substance.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if("with"===indirect_preposition&&!indirect_object.isWithin(subject)){this.game.debug("D1947",this.name+".js ",` ${direct_object.id} is not in subject `);msg+=indirect_object.isDOV("take")?`{We're} not carrying ${indirect_object.articlename}. `:`{We} can't use ${indirect_object.articlename} that way. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1952",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1953",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1954",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),room=this.game.getRoom(),input,msg="";if(input.hasStructure("verb noun"))if(direct_substance)msg+=`{We} flick a bit of ${direct_substance.articlename} from ${direct_object.hasClass("Room")?"the ground":direct_object.articlename}. `;else msg+=`{We} flick ${direct_object.articlename}. `;if(input.hasStructure("verb noun preposition noun"))if(direct_substance)msg+=`{We} flick a bit of ${direct_substance.articlename} from ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;else{if("with"!==indirect_preposition){if(void 0!==(input=subject.onRemoveThatFromThis(direct_object)))return input;if(void 0!==(input=room.onMoveThatToThis(direct_object,"in")))return input}msg+=`{We} flick ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `}return this.handleSuccess(msg)}};A.Preverbs.flip={name:"flip",prettyname:"flip",past_tense:"flipped",synonyms:["flip"],gerund:"flipping",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["on","off","over","with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,msg="",subject;if(direct_object.hasQuirk("flip_means_toggle")&&direct_object.isDOV("toggle")){this.game.debug("D2040",this.name+".js ",` ${direct_object.id}.quirks.push_means_press is true, doVerb press `);return this.game.dictionary.doVerb("toggle")}if(!direct_object.isDOV("flip")){this.game.debug("D1283",this.name+".js ",` ${direct_object.id}.dov.flip.enabled is false`);msg+=`{We} can't flip ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2010",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We} {don't} need to ${this.name} ${direct_object.Articlename} any more. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2011",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2012",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb preposition noun"))if(["on","off","over"].includes(indirect_preposition)){input.setPreposition(2,direct_preposition);input.setPreposition(1,"");input.setStructure("verb noun preposition")}else{this.game.debug("D2013",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${indirect_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition"))if(!["on","off","over"].includes(direct_preposition)){this.game.debug("D2014",this.name+".js ",` ${this.name} ${direct_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2015",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2016",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset `);msg+=`${indirect_object.Articlename} can't be used to ${this.name} anything. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2017",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.float={name:"float",prettyname:"float",past_tense:"floated",synonyms:["float"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"floating",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_float:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.fly={name:"fly",prettyname:"fly",past_tense:"flew",synonyms:["fly"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"flying",override_aspect_scale_increments:{up:true,down:true},subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_fly:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.get={name:"get",prettyname:"get",past_tense:"got",synonyms:["get"],extends:{go:true,take:true},gerund:"getting",accepts_structures:["verb noun","verb preposition","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun","verb preposition noun preposition noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,not_global:true,not_scenery:true,not_exit:true,tangible:true,present:true,visible:true,reachable:true,not_worn:true,not_nested_inventory_if_all:true},accepts_preposition:true,accepts_preposition_without_noun:true},phrase2:{accepts_noun:true,accepts_preposition:true,requires_preposition:true,noun_must_be:{known:true,not_global:true,not_scenery:true,not_exit:true,tangible:true,present:true,visible:true,reachable:true}},let_verb_handle_disambiguation:false,do:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),msg="",target="";if(input.hasStructure("verb noun")){target=direct_object.direction||direct_object.is.exit?"go":"take";this.game.log("L1367","log","high",`[${this.name}.js] ${this.name} ${direct_object.name}: infer `+target,"Verbs")}else if(input.hasStructure("verb preposition")){switch(direct_preposition){case"up":target="stand";break;case"down":if(subject.isNested()){input.setAsset(1,subject.getNestAsset());input.setPreposition(1,"off");input.setStructure("verb preposition noun");target="go"}else target="sit";break;case"off":if(subject.isNested()){input.setAsset(1,subject.getNestAsset());input.setStructure("verb preposition noun");target="go"}else{this.game.debug("D1020",this.name+".js "," subject is not nested");this.handleFailure(msg+="Neither the time nor the place. ");return null}break;case"on":if(subject.isNested()){this.game.debug("D1037",this.name+".js ",` subject is ${subject.getNestAspect().id} `+subject.getNestAsset().id);msg+=`{We're} ${subject.getNestAspect().id} ${subject.getNestAsset().articlename}. `;this.handleFailure(msg);return null}else{var last=this.game.getAsset(this.game.getLastTurn().verified_sentence.phrase1?.parsedNoun?.qualified_object_id);if(last&&last.hasAspectAt(last.default_aspect)&&last.getAspectAt(last.default_aspect).canCharacter("enter")){input.setAsset(1,last);input.setStructure("verb preposition noun");target="go"}else{input.setSoftPrompt({index:1,type:"noun",input_verb:this.name,verb:this.name,noun1:true,structure:"verb preposition noun"});this.game.debug("D1038",this.name+".js "," no noun provided or inferrable, soft prompt noun1");msg+=`What would {we} like to ${this.name} on? `;this.handleFailure(msg);return null}}break;case"in":var last=this.game.getExitFromDirection("in");if(last&&!last.is.global){target="go";input.setAsset(1,last);input.setPreposition(1,"");input.setStructure("verb noun")}else{input.setSoftPrompt({input_verb:this.name,verb:this.name,noun1:true,structure:"verb preposition noun"});this.game.debug("D1039",this.name+".js "," no noun provided or inferrable, soft prompt noun1");msg+=`What would {we} like to ${this.name} in? `;this.handleFailure(msg);return null}break;default:target="go";break}this.game.log("L1368","log","high",`[${this.name}.js] ${this.name} ${direct_preposition}: infer `+target,"Verbs")}else if(input.hasStructure("verb preposition noun"))this.game.log("L1369","log","high",`[${this.name}.js] ${this.name} ${direct_preposition} ${direct_object.name}: infer `+(target="from"===direct_preposition?"take":"go"),"Verbs");else if(input.hasStructure("verb noun preposition noun")){target=direct_object.direction?"go":"take";this.game.log("L1370","log","high",`[${this.name}.js] ${this.name} ${direct_object.name} ${indirect_preposition} ${indirect_object.name}: infer `+target,"Verbs")}else if(input.hasStructure("verb preposition noun preposition noun"))this.game.log("L1371","log","high",`[${this.name}.js] ${this.name} ${direct_preposition} ${direct_object.name} ${indirect_preposition} ${indirect_object.name}: infer `+(target="go"),"Verbs");else if(input.hasStructure("verb preposition noun preposition noun preposition noun"))this.game.log("L1372","log","high",`[${this.name}.js] ${this.name} ${direct_preposition} ${direct_object.name} ${indirect_preposition} ${indirect_object.name} ${indirect_preposition2} ${indirect_object2.name}: infer `+(target="go"),"Verbs");return this.game.dictionary.doVerb(target)}};A.Preverbs.give={name:"give",prettyname:"give",past_tense:"gave",synonyms:[],gerund:"giving",accepts_structures:["verb noun","verb noun noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true,tangible:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["to"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results;if(input.hasStructure("verb noun noun")){input.swapPhrases(1,2);input.setPreposition(2,"to");direct_object=input.getAsset(1);indirect_object=input.getAsset(2)}if(!direct_object.isDOV(this.name)){this.game.debug("D1292",this.name+".js ",` ${direct_object.id}.dov.give.enabled is false`);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.is.worn&&!direct_object.isDOV("remove")){this.game.debug("D1294",this.name+".js ",` ${direct_object.id}.dov.remove.enabled is false`);msg+=`{We} can't remove ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(subject.getNestId()===direct_object.id){this.game.debug("D1189",this.name+".js "," subject is nested on "+direct_object.id);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition?indirect_preposition:""} ${indirect_object?indirect_object.articlename:""} while {we're} ${subject.getPostureGerund()} ${subject.getNestPreposition()} it. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")){var chars=this.game.getRoom().findNestedAssetsWithClass("Character",{exclude:[subject.id]});for(let i=chars.length-1;-1<i;i--)if(!chars[i].isIOV("give"))chars.splice(i,1);switch(chars.length){case 1:indirect_object=this.game.getAsset(chars[0]);input.setAsset(2,indirect_object);input.setPreposition(2,"to");input.setInferred(2);input.setStructure("verb noun preposition noun");this.game.printInferred("to "+indirect_object.articlename);break;default:input.setPreposition(2,"to");input.setSoftPrompt({index:2,type:"noun",noun2:true,structure:"verb noun preposition noun"});this.game.debug("D1924",this.name+".js "," soft prompt for noun2 ");msg+=`To whom would {we} like to ${this.name} ${direct_object.articlename}? `;this.handleFailure(msg);return null}}if(input.hasStructure("verb noun preposition noun")){if(!(indirect_object instanceof adventurejs.Character)){this.game.debug("D1290",this.name+".js ",` ${indirect_object.id} is not class Character`);msg+=`{We} can't give anything to ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV("give")){this.game.debug("D1291",this.name+".js ",` ${indirect_object.id}.iov.give is unset`);msg+=`{We} can't give anything to ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!direct_object.isWithin(subject)){this.game.debug("D1583",this.name+".js ",` ${direct_object.id} is not in `+subject.id);msg+=`{We're} not holding ${direct_object.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),closedAnscestors=[],direct_object=input.getAsset(1),indirect_object=input.getAsset(2),parent=direct_object.getPlaceAsset(),results,msg="";if(direct_object.isWithin(subject)&&direct_object.areAnscestorsClosed())for(var closedAnscestors=direct_object.getClosedAnscestors(),i=0;i<closedAnscestors.length;i++){this.game.getAsset(closedAnscestors[i]).is.closed=false;closedAnscestors[i]=this.game.getAsset(closedAnscestors[i]).name}if(0<closedAnscestors.length){msg+="{We} open the ";for(var i=0;i<closedAnscestors.length;i++){if(2<closedAnscestors.length&&i<closedAnscestors.length-2)msg+=", ";if(1<closedAnscestors.length&&i===closedAnscestors.length-1)msg+=" and the ";msg+=closedAnscestors[i]}msg+=". "}if(direct_object.is.worn){msg=msg+((results=direct_object.unfasten())?`{We} ${results}, then remove, `:"{We} remove ")+(direct_object.articlename+". ");direct_object.incrementDoVerbCount("remove","dov");direct_object.is.worn=false}if(void 0!==(results=parent.onRemoveThatFromThis(direct_object)))return results;if(void 0!==(results=indirect_object.onMoveThatToThis(direct_object,"in")))return results;msg+=`{We} give ${direct_object.articlename} to ${indirect_object.articlename}. `;if((1<input.parsedNoun1.matches.qualified.length||this.game.parser.isParsingMultiple())&&-1===input.output_class.indexOf("concatenate_output"))input.output_class+=" concatenate_output ";return this.handleSuccess(msg)}};A.Preverbs.go={name:"go",prettyname:"go",past_tense:"went",synonyms:["go"],gerund:"going",type:{locomotion:true,travel:true},accepts_adverbs:["down","up","left","right","around","back","towards","over"],accepts_structures:["verb noun","verb preposition","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun","verb preposition noun preposition noun preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,noun_must_be:{tangible:true,known:true,prefer_present_if_ambiguous:true,visible:true,reachable:true,not_self:true},accepts_preposition:true,accepts_preposition_without_noun:true,accepts_direction:true},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{tangible:true,known:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},phrase3:{accepts_noun:true,requires_noun:true,noun_must_be:{tangible:true,known:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},in_can_mean_on:true,getPercentStringUp:function(percent){return 1===percent?"to the top of":.75<percent?"almost to the top of":.5<percent?"still further up":.25<percent?"further up":"part way up"},getPercentStringDown:function(percent){return 1===percent?"to the top of":.75<percent?"part way down":.5<percent?"further down":.25<percent?"still further down":"almost all the way down"},getPostureString:function(posture,prep){return"stand"===posture?this.agree("stand")+" upon it":"sit"===posture?this.agree("sit")+` down ${prep} it`:"lie"===posture?this.agree("lie")+` down ${prep} it`:"kneel"===posture?this.agree("kneel")+` down ${prep} it`:"cling"===posture?this.agree("cling")+" tightly to it":"grip"===posture?this.agree("grip")+" it tightly":"hang"===posture?this.agree("hang")+" from it":""},canCharacterUseThisWithThat:function(target_preposition,target_asset,tool_asset){var input=this.game.getInput(),input_verb=this.game.dictionary.getVerb(input.input_verb),response={failure:false,return:null,msg:""};if(target_asset.allowVerbWithAnything(this.name,"dov"))return{return:true};if(target_asset.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1868",this.name+".js ",` ${tool_asset.id} isn't needed to ${input.input_verb} ${target_preposition?target_preposition:"to"} `+target_asset.id);response.msg+=`${tool_asset.Articlename} isn't needed to ${input.input_verb} ${target_preposition?target_preposition:"to"} ${target_asset.articlename}. `;response.failure=true}else if(!tool_asset.isIOV(input_verb.name)){this.game.debug("D1293",this.name+".js ",` ${tool_asset.id}.iov.${input_verb.name} is unset`);response.msg+=`{We} can't use ${tool_asset.articlename} to ${input.input_verb} ${target_preposition} ${target_asset.articlename}. `;response.failure=true}else if(!target_asset.allowVerbWithAsset({verb:this.name,asset:tool_asset,ov:"dov"})){this.game.debug("D1869",this.name+".js ",` ${target_asset.id}.dov.${this.name}.with_assets does not include ${tool_asset.id} `);response.msg+=`${tool_asset.Articlename} can't be used to ${input.input_verb} ${target_preposition} ${target_asset.articlename}. `;response.failure=true}else if(tool_asset.allowVerbOnce(this.name,"iov")&&tool_asset.iDidVerb(this.name,"iov")){this.game.debug("D1870",this.name+".js ",` ${tool_asset.id}.iov.${this.name}.once and ${tool_asset.id}.did.${this.name}.indirectly is ${tool_asset.did[this.name].indirectly} `);response.msg+=`${tool_asset.Articlename} has already been used to ${input.input_verb} ${target_preposition} something. `;response.failure=true}return response},canCharacterGoFromThisToThat:function(origin,destination){var input=this.game.getInput(),character=input.getSubject(),input_verb=this.game.dictionary.getVerb(input.input_verb),origin_asset=character.getNestOrPlaceAsset(),origin_aspect=character.getNestOrPlaceAspect(),response={failure:false,msg:"",aspect:null,asset:destination};if(origin_asset.id!==origin.id){this.game.debug("D1183",this.name+".js ",` ${character.id} is not on `+origin.id);response.msg+=`{We're} not ${origin.aspects[origin.default_aspect]?.canCharacter("enter")?origin.default_aspect:"on"} ${origin.articlename}. `;response.failure=true}else if(!destination.hasAspectAt(destination.default_aspect)||!destination.getAspectAt(destination.default_aspect).canCharacter("enter")){this.game.debug("D1239",this.name+".js ",` ${destination.id} has no enterable aspect set `);origin_asset.hasClass("Room")||origin_asset.id===destination.getPlaceAssetId()?response.msg+=`{We} edge a bit closer to ${destination.articlename}. `:response.msg+=`{We} can't reach ${destination.articlename} from ${origin_asset.hasClass("room")?"here":origin_asset.articlename}. `;response.failure=true}else{response.aspect=destination.getAspectAt(destination.default_aspect);if(!destination?.isDOV(input.input_verb)){this.game.debug("D1012",this.name+".js ",` ${destination.id}.dov.${input.input_verb}.enabled is unset`);response.msg+=`{We} can't ${input.input_verb} ${response.aspect.preposition} ${destination.articlename}. `;response.failure=true}else if(destination.placePreventsNesting(character)){this.game.debug("D1874",this.name+".js ",` ${destination.id} can't nest ${character.id} while it's ${destination.getPlacePreposition()} ${destination.getPlaceAssetId}. `);response.msg+=`{We} can't ${input.input_verb} ${response.aspect.preposition} ${destination.articlename} while it's ${destination.getPlacePreposition()} ${destination.getPlaceAssetId}. `;response.failure=true}else{if(this.game.settings.xz_determines_reachability){var distance=A.getHorizontalDistance(origin.position,destination.position);input.setVerbParam("distance",distance);if(input_verb.can_span){var input_verb=distance<=character.jump_length;if(input_verb)input.setVerbParam("spanning",true);if(!input_verb){this.game.debug("D1864",this.name+".js ",` ${character.id} is nested ${origin_aspect.preposition} ${origin.id}, at a distance of ${distance} from ${destination.id}, which is larger than ${character.id}.jump_length of ${character.jump_length} `);response.msg+=`{We} can't reach ${destination.articlename} from {our} place ${origin_aspect.preposition} ${origin_asset.articlename}. `;response.failure=true;return response}}}if(this.game.settings.y_determines_reachability){let reachable=destination.getYBottom()<character.getY()+character.jump_height;console.warn("character.getY()",character.getY(),"destination.getYBottom()",destination.getYBottom(),"character.jump_height",character.jump_height,"destination.getYBottom() - character.jump_height",destination.getYBottom()-character.jump_height);console.warn("character.getY() < destination.getYBottom() - character.jump_height",character.getY()<destination.getYBottom()-character.jump_height);console.warn({reachable:reachable});if(!reachable){this.game.debug("D1284",this.name+".js ",` ${character.id} is nested ${origin_aspect.preposition} ${origin_asset.id}, infer "go from to" `);response.msg+=`{We} can't reach ${destination.articlename} from {our} place ${origin_aspect.preposition} ${origin_asset.articlename}. `;response.failure=true}}}}return response},canCharacterRepositionUp:function(origin_asset,origin_aspect){var input=this.game.getInput(),character=input.getSubject(),input=this.game.dictionary.getVerb(input.input_verb);return origin_aspect.canCharacter(input.name)&&origin_aspect.canCharacter("scale")&&character.can.scale&&0<origin_aspect.scale_increment&&character.getY()<origin_asset.getYTop()&&!input.override_aspect_scale_increments.up},canCharacterRepositionDown:function(origin_asset,origin_aspect,off){var input=this.game.getInput(),character=input.getSubject(),input=this.game.dictionary.getVerb(input.input_verb),bool;if(off&&!origin_asset.hasQuirk("get_off_means_go_down"))return false;else{return origin_aspect.canCharacter(input.name)&&origin_aspect.canCharacter("scale")&&character.can.scale&&0<origin_aspect.scale_increment&&character.getY()-origin_asset.getY()>origin_aspect.scale_increment&&!input.override_aspect_scale_increments.down}},doTry:function(){var input=this.game.getInput(),player=this.game.getPlayer(),character=input.getSubject(),player=player.id===character.id,nest_asset=character.getNestAsset(),input_verb=this.game.dictionary.getVerb(input.input_verb),adverb=input.getAdverb();let msg="",results;if(!player&&!character.isDOV(input_verb.name)){this.game.debug("D1179",this.name+".js ",` ${character.id}.dov.${input_verb.name} is unset`);var player=this.game.dictionary.pronouns[this.game.getPlayer().pronouns]["our"];msg+=character.ignore_msg||`{We} ignores ${player} command. `;this.handleFailure(msg)}else{if(input.hasStructure("verb noun")){var player=input.getAsset(1);if(!player.isDOV(input_verb.name)){this.game.debug("D1147",this.name+".js ",` ${player.id}.dov.${input_verb.name} is unset`);msg+=`{We} can't ${input_verb.name} ${player.articlename}. `;this.handleFailure(msg);return null}}if("to"===input.getPreposition(1)&&"from"===input.getPreposition(2)||"to"===input.getPreposition(2)&&"from"===input.getPreposition(3))input.setVerbParam("fromto",true);if("to"===input.getPreposition(2)&&"from"===input.getPreposition(3)){input.swapPhrases(2,3);input.setVerbParam("fromto",true)}else if("to"===input.getPreposition(1)&&"from"===input.getPreposition(2)){input.swapPhrases(1,2);input.setVerbParam("fromto",true)}if(input.hasStructure("verb noun preposition noun")&&"from"===input.getPreposition(2)){input.setPreposition(1,"to");input.swapPhrases(1,2);input.setVerbParam("fromto",true)}var current_room=this.game.getRoom(),origin_asset=character.getNestOrPlaceAsset(),origin_aspect=character.getNestOrPlaceAspect();input.setVerbParam("origin_asset",origin_asset);input.setVerbParam("origin_aspect",origin_aspect);let asset1=input.getAsset(1),preposition1=input.getPreposition(1),asset2=input.getAsset(2),preposition2=input.getPreposition(2);var asset3=input.getAsset(3),destination_preposition;let preposition3=input.getPreposition(3),destination_asset,destination_aspect,tool_asset,tool_preposition,verified_canPlayerGoFromThisToThat;var exit_from_preposition=this.game.getExitFromDirection(input.getPreposition(1)),destination,in_means_on;if(input.hasStructure("verb")){if(-1===input_verb.accepts_structures.indexOf("verb")){this.game.debug("D1182",input_verb.name+".js "," no direct_object, soft prompt noun1");msg+=`Where did {we} want to ${input.getInput()}? `;input.setSoftPrompt({index:1,type:"noun",noun1:true,verb_phrase:input.verb_phrase,verb:input_verb.name,structure:"verb noun"});this.handleFailure(msg);return null}if("jump"===input_verb.name&&origin_asset.hasQuirk("jump_means_jump_on"))return true;if("jump"===input_verb.name&&origin_asset.hasQuirk("jump_means_jump_off")&&origin_aspect.canCharacter("exit")){input.setPreposition(1,"off");input.setAsset(1,origin_asset);input.setStructure("verb preposition noun");return true}}if(input.hasStructure("verb")){input.setVerbParam("action","none");return true}if(input.hasStructure("verb preposition")&&origin_asset.hasClass("Room")){if(!exit_from_preposition){this.game.debug("D1121",this.name+".js ",` no context found for ${input_verb.name} with preposition `+preposition1);msg=`{We} {don't} see a way to ${input_verb.name} ${preposition1}. `;this.handleFailure(msg);return null}this.game.log("L1384","log","high",`[${this.name}.js] received preposition ${preposition1}, infer exit `+exit_from_preposition.id,"Verbs");return this.game.tryTravel(exit_from_preposition.direction)}if(input.hasStructure("verb preposition")&&!origin_asset.hasClass("Room")){if(!origin_asset.isDOV(input_verb.name)){this.game.debug("D1131",this.name+".js ",` ${origin_asset.id}.dov.${input_verb.name} is unset `);msg+=`{We} can't ${input_verb.name} ${preposition1} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}switch(preposition1){case"up":if(character.getY()<origin_asset.getYTop())if(this.canCharacterRepositionUp(origin_asset,origin_aspect)){input.setAsset(1,origin_asset);input.setStructure("verb preposition noun");input.setVerbParam("reposition_up",true);input.setVerbParam("action","reposition");return true}else{this.game.debug("D1040",this.name+".js ",` ${origin_asset.id}.aspects.${origin_aspect.preposition}.nest.can.scale is false `);msg+=`{We} can't ${input_verb.name} any higher on ${origin_asset.articlename}. `;this.handleFailure(msg);return null}else if(character.getY()>=origin_asset.getYTop())if(exit_from_preposition){this.game.log("L1385","log","high",`[${this.name}.js] ${character.id} is at top of ${origin_asset.id}, tryTravel `+exit_from_preposition.direction,"Verbs");this.game.print(msg);return this.game.tryTravel(exit_from_preposition.direction)}else{this.game.debug("D1047",this.name+".js ",` ${character.id} is at top of ${origin_asset.id} `);msg+=`{We} can't get any higher on ${origin_asset.articlename}. `;this.handleFailure(msg);return null}break;case"down":if(this.canCharacterRepositionDown(origin_asset,origin_aspect)){input.setAsset(1,origin_asset);input.setStructure("verb preposition noun");input.setVerbParam("action","reposition");input.setVerbParam("reposition_down",true);return true}else{if(!origin_aspect.canCharacter("exit")){this.game.debug("D1295",this.name+".js ",` ${origin_asset.id}.aspects.${origin_aspect.preposition}.nest.can.exit is false `);msg+=`{We} can't get get off ${origin_asset.articlename}. `;this.handleFailure(msg);return null}input.setAsset(1,origin_asset);input.setStructure("verb preposition noun");input.setVerbParam("action","unnest");input.setVerbParam("off",true);input.setPreposition(1,"off");return true}case"in":this.game.log("L1390","log","high",`[${this.name}.js] tryTravel `+exit_from_preposition.direction,"Verbs");return this.game.tryTravel(exit_from_preposition.direction);case"out":this.game.log("L1386","log","high",`[${this.name}.js] infer 'get out of ${origin_asset.id}'`,"Verbs");if(!["on","in","under","behind"].includes(origin_aspect.preposition)||!origin_aspect.canCharacter("exit")){this.game.debug("D1130",this.name+".js ",` ${character.id} nested ${origin_aspect.preposition} ${origin_asset.id} `);msg+="{We're} not in anything {we} can get out of. ";this.handleFailure(msg);return null}input.setVerbParam("action","unnest");input.setVerbParam("out",true);input.setAsset(1,origin_asset);input.setStructure("verb preposition noun");return true;case"off":this.game.log("L1387","log","high",`[${this.name}.js] infer 'get off of ${origin_asset.id}'`,"Verbs");if("on"!==origin_aspect.preposition){this.game.debug("D1152",this.name+".js ",` ${character.id} nested ${origin_aspect.preposition} ${origin_asset.id} `);msg+=`{We're} not on ${origin_asset.articlename}. `;this.handleFailure(msg);return null}if(!origin_aspect.canCharacter("exit")){this.game.debug("D1304",this.name+".js ",` ${origin_asset.id}.aspects.${origin_aspect.preposition}.nest.can.exit is false`);msg+=`{We} can't get off ${origin_asset.articlename}. `;this.handleFailure(msg);return null}if(this.canCharacterRepositionDown(origin_asset,origin_aspect,true)){input.setAsset(1,origin_asset);input.setStructure("verb preposition noun");input.setVerbParam("action","reposition");input.setVerbParam("reposition_down",true)}else{input.setVerbParam("action","unnest");input.setVerbParam("off",true);input.setAsset(1,origin_asset);input.setStructure("verb preposition noun")}return true;default:this.game.debug("D1046",this.name+".js ",` no context found for ${input_verb.name} with preposition `+preposition1);msg=`{We} {don't} see a way to ${input_verb.name} ${preposition1}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb preposition"))if(!asset1){this.game.debug("D1001",this.name+".js "," no direct_object, soft prompt noun1");msg+=`Where did {we} want to ${input.getInput()}? `;input.setSoftPrompt({index:1,type:"noun",noun1:true,structure:"verb preposition noun"});this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun")&&"go"===input_verb.name&&"to"===preposition1){if(asset1 instanceof adventurejs.Room){if(asset1.id===current_room.id){this.game.debug("D1205",this.name+".js ",` ${character.id} is already in `+current_room.id);msg+="{We're} already there! ";this.handleFailure(msg);return null}input.setVerbParam("goto",true)}if(!(asset1 instanceof adventurejs.Room)){if(asset1.getRoomId()!==current_room.id)input.setVerbParam("goto",true)}if(input.getVerbParam("goto")){if(!origin_asset.hasClass("Room")&&!origin_asset.hasClass("Vehicle")&&!this.game.settings.auto_unnest_on_travel){this.game.debug("D1210",this.name+".js",`${character.id} is nested ${character.getNestPreposition()} `+origin_asset.id);msg+=`{We'll} have to get ${character.getPrettyUnnestPreposition()} ${origin_asset.articlename} first. `;this.handleFailure(msg);return null}if(this.game.hasVerb("goTo")){this.game.log("L1383","log","high",`[${this.name}.js] destination is not in current room, doVerb goTo `,"Verbs");return this.game.dictionary.doVerb("goTo")}else{this.game.debug("D1092",this.name+".js "," destination is not in current room and verb goTo is not enabled ");msg+=`{We} can't get to ${asset1.articlename} from here. `;this.handleFailure(msg);return null}}}if(input.hasStructure("verb noun preposition noun")&&input.getAsset(1).direction&&["to","in"].includes(input.getPreposition(2))&&input.getAsset(2).hasClass("Room")){var player=input.getAsset(1),dest=input.getAsset(2);if(player.destinationID!==dest.id){this.game.debug("D1365",this.name+".js ",` ${player.direction} exit's destination is not ${dest.id} `);msg+=player.is.placeholder?`{We} don't see any way ${player.direction}. `:`{We} don't believe the ${player.direction} exit leads to ${dest.articlename}. `;this.handleFailure(msg);return null}this.game.log("L1516","log","high",`[${this.name}.js] tryTravel `+player.direction,"Verbs");return this.game.tryTravel(player.direction)}for(let i=input.getPhraseCount();0<i;i--){let asset=input.getAsset(i),preposition=input.getPreposition(i);if(asset&&!this.game.parser.selectPresent([asset]).length){this.game.debug("D2138",this.name+".js ",` ${asset.id} not in room `);msg+=`There doesn't appear to be any ${input.replacements[asset.id]?input.replacements[asset.id].source:asset.name} present. `;this.handleFailure(msg);return null}if(asset?.is.global&&"global_floor"!==asset.id){this.game.debug("D1725",this.name+".js ",` ${asset.id}.is.global `);msg=(msg=(msg+=`{We} can't ${input_verb.name} `)+(asset.direction?asset.direction:` ${preposition?preposition:"to"} `+asset.articlename)).trim();msg+=". ";if(asset.direction&&this.game.settings.when_travel_fails_list_exits)msg+=this.game.getRoomExits();this.handleFailure(msg);return null}if(asset?.direction);if("in"===preposition&&asset&&!asset.direction&&asset.hasQuirk("in_means_on")&&asset.hasAspectAt("on")&&asset.getAspectAt("on").canCharacter("enter"))preposition="on";switch(preposition){case"with":if(1<i)if((results=this.canCharacterUseThisWithThat(input.getPreposition(i-1),input.getAsset(i-1),asset)).failure){this.handleFailure(results.msg);return null}input.setVerbParam("with",true);input.setVerbParam("tool_asset",asset);input.setVerbParam("tool_preposition","with");input.setVerbParam("tool_position",i);tool_asset=asset;tool_preposition="with";continue;case"from":if(asset.id!==origin_asset.id){this.game.debug("D1216",this.name+".js ",` ${character.id} is not ${asset.default_aspect} ${asset.id} `);msg+=`{We're} not ${asset.default_aspect} ${asset.articlename}. `;this.handleFailure(msg);return null}if("to"===input.getPreposition(i+1))input.setVerbParam("fromto",true);continue;case"to":if(asset.direction)continue;if(origin_asset.id===asset.id){this.game.debug("D1237",this.name+".js ",` ${character.id} is already ${origin_aspect.preposition} ${asset.id} `);msg+=`{We're} already ${origin_aspect.preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}if((results=this.canCharacterGoFromThisToThat(origin_asset,asset)).failure){this.handleFailure(results.msg);return null}verified_canPlayerGoFromThisToThat=true;destination_aspect=results.aspect;destination_asset=asset;if("from"===input.getPreposition(i-1))input.setVerbParam("fromto",true);input.setVerbParam("to",true);input.setVerbParam("destination_asset",destination_asset);input.setVerbParam("destination_aspect",destination_aspect);continue;case"through":if(!asset.direction&&!asset.hasAspectAt(preposition)){this.game.debug("D1129",this.name+".js ",` neither ${asset.id}.direction nor ${asset.id}.aspects.${preposition} are set `);msg+=`{We} can't ${input_verb.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}input.setVerbParam("destination_asset",asset);input.setVerbParam("destination_preposition","through");input.setVerbParam("through",true);destination_asset=asset;continue;case"off":if(asset.id===origin_asset.id&&"on"===origin_aspect.preposition)continue;this.game.debug("D1132",this.name+".js ",` ${character.id} is not on ${asset.id} `);msg+=`{We're} not on ${asset.articlename}. `;this.handleFailure(msg);return null;case"out":if(asset.direction)continue;if(asset.id!==origin_asset.id&&asset.id!==current_room.id||!["on","behind","under","in"].includes(origin_aspect.preposition)){this.game.debug("D1116",this.name+".js ",` ${character.id} is not in ${asset.id} `);msg+=`{We're} not in ${asset.articlename}. `;this.handleFailure(msg);return null}continue;case"outfromunder":if(asset.id!==origin_asset.id||"under"!==origin_aspect.preposition){this.game.debug("D1136",this.name+".js ",` ${character.id} is not under ${asset.id} `);msg+=`{We're} not under ${asset.articlename}. `;this.handleFailure(msg);return null}input.setVerbParam("outfromunder",true);input.setVerbParam("action","unnest");input.setPreposition(i,"out");1===i?preposition1="out":2===i?preposition2="out":preposition3="out";continue;case"outfrombehind":if(asset.id!==origin_asset.id||"behind"!==origin_aspect.preposition){this.game.debug("D1000",this.name+".js ",` ${character.id} is not behind ${asset.id} `);msg+=`{We're} not behind ${asset.articlename}. `;this.handleFailure(msg);return null}input.setVerbParam("outfrombehind",true);input.setVerbParam("action","unnest");input.setPreposition(i,"out");1===i?preposition1="out":2===i?preposition2="out":preposition3="out";continue;case"on":if(1===i||1<i&&!input.getAsset(i-1).direction){var aspect=asset.getAspectAt(preposition);if(!aspect||!aspect.canCharacter("enter")){this.game.debug("D1230",this.name+".js ",` ${asset.id}.aspects.${preposition} is unset`);msg+=`{We} can't ${input_verb.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}if(origin_asset.id===asset.id&&origin_aspect===preposition){this.game.debug("D1208",this.name+".js ",` ${character.id} is already ${origin_aspect.preposition} `+origin_asset.id);msg+=`{We're} already ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}input.setVerbParam("destination_asset",asset);input.setVerbParam("destination_aspect",aspect);input.setVerbParam("on",true);input.setVerbParam("action",origin_asset.hasClass("Room")?"nest":"renest");destination_asset=asset;destination_aspect=aspect}else if(1<i&&input.getAsset(i-1).direction){if(asset.direction){this.game.debug("D1268",this.name+".js "," unable to parse "+input.getInput());msg+=`{We} {don't} know how to ${input.getInput()}. `;this.handleFailure(msg);return null}if(origin_asset.id!==asset.id){this.game.debug("D1118",this.name+".js ",` ${character.id} is not ${preposition} `+asset.id);msg+=`{We're} not ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}input.setVerbParam("tool_asset",asset);input.setVerbParam("tool_preposition",preposition);input.setVerbParam("tool_position",i);tool_asset=asset;tool_preposition=preposition}else{this.game.debug("D1261",this.name+".js "," unable to parse "+input.getInput());msg+=`{We} {don't} know how to ${input.getInput()}. `;this.handleFailure(msg);return null}continue;case"in":if(asset.direction){if("in"===asset.direction)continue;this.game.debug(`L1394 | ${this.name}.js | ${asset.id}.direction is not in`);msg+=`{We} can't ${input_verb.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}else if(1===i){let aspect=asset.getAspectAt(preposition);if(!aspect||!aspect.canCharacter("enter")){if(asset.hasQuirk("in_means_on"))aspect=asset.getAspectAt(preposition);if(!aspect||!aspect.canCharacter("enter")){this.game.debug("D1117",this.name+".js ",` ${asset.id}.aspects.${preposition} is unset`);msg+=`{We} can't ${input_verb.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}}if(origin_asset.id===asset.id){this.game.debug("D1175",this.name+".js ",` ${character.id} is already ${origin_aspect.preposition} `+origin_asset.id);msg+=`{We're} already ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}input.setVerbParam("destination_asset",asset);input.setVerbParam("destination_aspect",aspect);input.setVerbParam(aspect.preposition,true);destination_asset=asset;destination_aspect=aspect}else if(1<i&&input.getAsset(i-1).direction){if(asset.direction){if(asset.direction===input.getAsset(i-1).direction){input.deletePhrase(i);continue}this.game.debug("D1248",this.name+".js "," unable to parse "+input.getInput());msg+=`{We} {don't} know how to ${input.getInput()}. `;this.handleFailure(msg);return null}if(origin_asset.id!==asset.id){this.game.debug("D1161",this.name+".js ",` ${character.id} is not ${preposition} `+asset.id);msg+=`{We're} not ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}input.setVerbParam("tool_asset",asset);input.setVerbParam("tool_preposition",preposition);input.setVerbParam("tool_position",i);tool_asset=asset;tool_preposition=preposition}else{this.game.debug("D1253",this.name+".js "," unable to parse "+input.getInput());msg+=`{We} {don't} know how to ${input.getInput()}. `;this.handleFailure(msg);return null}continue;case"under":case"behind":if(1===i){let aspect=asset.getAspectAt(preposition);if(!aspect||!aspect.canCharacter("enter")){this.game.debug("D1212",this.name+".js ",` ${asset.id}.aspects.${preposition} is unset`);msg+=`{We} can't ${input_verb.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}if(origin_asset.id===asset.id&&origin_aspect.preposition===aspect.preposition){this.game.debug("D1213",this.name+".js ",` ${character.id} is already ${origin_aspect.preposition} `+origin_asset.id);msg+=`{We're} already ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}if(origin_asset.id===asset.id&&origin_aspect.preposition!==aspect.preposition);input.setVerbParam("destination_asset",asset);input.setVerbParam("destination_aspect",aspect);input.setVerbParam(aspect.preposition,true);input.setVerbParam("action","nest");destination_asset=asset;destination_aspect=aspect}continue;case"down":console.warn("Jo down");continue;case"up":console.warn("Jo up");continue}}if(input.hasStructure("verb noun")&&asset1.direction){this.game.log("L1391","log","high",`[${this.name}.js] ${asset1.id}.direction is ${asset1.direction}, tryTravel `+asset1.direction,"Verbs");return this.game.tryTravel(asset1.direction)}if(input.hasStructure("verb noun")&&!asset1.direction){if(adverb);if(!asset1.default_aspect||!asset1.aspects[asset1.default_aspect]?.canCharacter("enter")){this.game.debug("D1270",this.name+".js ",` 
            `+(!asset1.default_aspect?asset1.id+".default_aspect is unset":asset1.id+".aspects."+asset1.default_aspect+".nest.can.enter is unset"));origin_asset.hasClass("Room")||origin_asset.id===asset1.getPlaceAssetId()?msg+=`{We} edge a bit closer to ${asset1.articlename}. `:msg+=`{We} can't reach ${asset1.articlename} from ${origin_asset.hasClass("room")?"here":origin_asset.articlename}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb noun")&&origin_asset.hasClass("Room")){input.setPreposition(1,asset1.default_aspect);input.setVerbParam("destination_asset",asset1);input.setVerbParam("destination_aspect",asset1.getAspectAt(asset1.default_aspect));input.setVerbParam(asset1.default_aspect,true);input.setStructure("verb preposition noun");input.setVerbParam("action","nest");return true}if(input.hasStructure("verb noun")&&origin_asset.id!==asset1.id){if((results=this.canCharacterGoFromThisToThat(origin_asset,asset1)).failure){this.handleFailure(results.msg);return null}input.swapPhrases(1,2);input.setAsset(1,origin_asset);input.setPreposition(1,"from");input.setPreposition(2,"to");input.setStructure("verb preposition noun preposition noun");input.setVerbParam("fromto",true);input.setVerbParam("action","renest");input.setVerbParam("destination_asset",results.asset);input.setVerbParam("destination_aspect",results.aspect);return true}if(input.hasStructure("verb noun")&&origin_asset.id===asset1.id&&"up"===input_verb.default_direction)if(this.canCharacterRepositionUp(origin_asset,origin_aspect)){input.setPreposition(1,"up");input.setStructure("verb preposition noun");input.setVerbParam("reposition_up",true);input.setVerbParam("action","reposition");return true}else{this.game.debug("D1126",this.name+".js ",` ${character.id} is at top of `+origin_asset.id);msg+=`{We're} as high as {we} can ${input_verb.name} ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")&&origin_asset.id===asset1.id&&["down","off","out"].includes(input_verb.default_direction))if(this.canCharacterRepositionDown(origin_asset,origin_aspect,"off"===input_verb.default_direction)){input.setPreposition(1,"down");input.setStructure("verb preposition noun");input.setVerbParam("action","reposition");input.setVerbParam("reposition_down",true);return true}else if(origin_aspect.canCharacter(input_verb.name)&&origin_aspect.canCharacter("exit")){input.setPreposition(1,"off");input.setStructure("verb preposition noun");input.setVerbParam("action","unnest");input.setVerbParam("off",true);return true}else{this.game.debug("D1511",this.name+".js ",` ${character.id} can't ${input_verb.name} ${preposition1} `+origin_asset.id);msg+=`{We} {don't} know how to ${input_verb.name} ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")&&origin_asset.id===asset1.id){this.game.debug("D1125",this.name+".js ",` ${character.id} is already ${origin_aspect.preposition} `+origin_asset.id);msg+=`{We're} already ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg)}else if(input.hasStructure("verb preposition noun")&&asset1.direction){if("down"===asset1.direction&&["through","in","down"].includes(preposition1)||"up"===asset1.direction&&["through","out","up"].includes(preposition1)||"in"===asset1.direction&&["through","in"].includes(preposition1)||"out"===asset1.direction&&["through","out"].includes(preposition1)||"in"!==asset1.direction&&["through","out"].includes(preposition1)||"out"!==asset1.direction&&["through","in"].includes(preposition1)||["through","to"].includes(preposition1)){this.game.log("L1393","log","high",`[${this.name}.js] ${asset1.id}.direction is ${asset1.direction}, tryTravel `+asset1.direction,"Verbs");return this.game.tryTravel(asset1.direction)}this.game.debug("D1375",this.name+".js ",` ${preposition1} ${asset1.id} not understood `);msg+=`{We're} not sure how to ${input_verb.name} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg)}else{if(input.hasStructure("verb preposition noun")&&"from"===preposition1)if(this.canCharacterRepositionDown(origin_asset,origin_aspect)){input.setVerbParam("action","reposition");input.setVerbParam("reposition_down",true);return true}else{if(!origin_aspect.canCharacter("exit")){this.game.debug("D1308",this.name+".js ",` ${origin_asset.id}.aspects.${origin_aspect.preposition}.nest.can.exit is false `);msg+=`{We} can't get ${input_verb.name} from ${origin_asset.articlename}. `;this.handleFailure(msg);return null}input.setPreposition(1,"off");input.setVerbParam("off",true);input.setVerbParam("action","unnest");return true}if(input.hasStructure("verb preposition noun")&&"with"===preposition1)if(asset1.isDOV(input_verb.name)){input.setVerbParam("with",true);input.setVerbParam("action","none");return true}else if(asset1.isIOV(input_verb.name)){if(!origin_asset.isDOV(input_verb.name)||!origin_aspect.playerCan(input_verb.name)){this.game.debug("D1312",this.name+".js ",` ${origin_asset.id}.dov.${input_verb.name} or ${origin_asset.id}.aspects.${origin_aspect.preposition}.nest.can.${input_verb.name} is unset`);msg+=`{We} can't ${input_verb.name} ${origin_asset.articlename} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg);return null}if((results=this.canCharacterUseThisWithThat(origin_aspect.preposition,origin_asset,asset1)).failure){this.handleFailure(results.msg);return null}switch(preposition2=input_verb.default_direction?input_verb.default_direction:origin_aspect.preposition){case"up":if(this.canCharacterRepositionUp(origin_asset,origin_aspect))break;this.game.debug("D1316",this.name+".js ",` ${origin_asset.id}.aspects.${origin_aspect.preposition}.nest.can.scale is false `);msg+=`{We} can't ${input_verb.name} any higher on ${origin_asset.articlename}. `;this.handleFailure(msg);return null;case"down":case"off":preposition2=this.canCharacterRepositionDown(origin_asset,origin_aspect,true)?"down":"off";break;default:this.game.debug("D1318",this.name+".js ",` ${input_verb.name} ${preposition1} ${asset1.id} is unhandled`);msg+=`{We're} not sure how to ${input_verb.name} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg);return null}if("off"===preposition2&&!origin_aspect.playerCan("exit")){this.game.debug("D1123",this.name+".js ",` ${origin_asset.id}.aspects.${origin_aspect.preposition}.nest.can.exit is unset`);msg+=`{We} can't ${input_verb.name} off ${origin_asset.articlename} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg);return null}switch(preposition2){case"down":input.setVerbParam("reposition_down",true);input.setVerbParam("action","reposition");break;case"up":input.setVerbParam("reposition_up",true);input.setVerbParam("action","reposition");break;case"off":input.setVerbParam("action","unnest");break;default:this.game.debug("D1317",this.name+".js ",` ${input_verb.name} ${preposition1} ${asset1.id} not handled`);msg+=`{We} {don't} know how to ${input_verb.name} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg);return null}input.setPreposition(2,preposition2);input.setAsset(2,origin_asset);input.swapPhrases(1,2);input.setStructure("verb preposition noun preposition noun");input.setVerbParam("with",true);return true}else{this.game.debug("D1282",this.name+".js ",` neither ${asset1.id}.dov.${input_verb.name} nor ${asset1.id}.iov.${input_verb.name} is set`);msg+=`{We} can't ${input_verb.name} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun")&&"to"===preposition1)if(origin_asset.hasClass("Room")){input.setVerbParam("action","nest");return true}else if(!origin_asset.hasClass("Room")){if((results=this.canCharacterGoFromThisToThat(origin_asset,asset1)).failure){this.handleFailure(results.msg);return null}input.setPreposition(2,"from");input.setAsset(2,origin_asset);input.swapPhrases(1,2);input.setStructure("verb preposition noun preposition noun");input.setVerbParam("fromto",true);input.setVerbParam("action","renest");return true}if(input.hasStructure("verb preposition noun")&&["off","out"].includes(preposition1)&&asset1.id===current_room.id){if(!current_room.aspects.in.canCharacter("exit")){this.game.debug("D1399",this.name+".js ",` ${current_room.id}.aspects.in.nest.can.exit is unset`);msg+=`{We} can't leave ${current_room.articlename}. `;this.handleFailure(msg);return null}if(origin_asset.id!==current_room.id&&!this.game.settings.auto_unnest_on_travel){this.game.debug("D1003",this.name+".js ",` ${character.id}.isNested`);msg+=`{We} can't do that from {our} position ${character.getPostureGerund()} ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}if(character.isOnFloor())if(this.game.settings.auto_stand_on_travel){this.game.printInferred(`rising from {our} position ${character.getPostureGerund()} on the floor`);if(nest_asset)if(void 0!==(results=character.onUnnestThisFromThat(nest_asset)))return results}else{this.game.debug("D1004",this.name+".js ",` ${character.id}.isOnFloor `);msg+=`{We} can't do that from {our} position ${character.getPostureGerund()} on the floor. `;this.handleFailure(msg);return null}this.game.log("L1395","log","high",`[${this.name}.js] doVerb exit`,"Verbs");return this.game.tryTravel(preposition1)}if(input.hasStructure("verb preposition noun")&&["off","out"].includes(preposition1)&&asset1.id!==current_room.id){let prep="",prep_match=false;if("off"===preposition1)if((prep="on")===origin_aspect.preposition)prep_match=true;if(input.getVerbParam("outfromunder")){prep="under";if(origin_aspect.preposition===prep)prep_match=true}else if(input.getVerbParam("outfrombehind")){prep="behind";if(origin_aspect.preposition===prep)prep_match=true}else if("out"===preposition1){prep="in";if(origin_aspect.preposition===prep)prep_match=true;if(!prep_match&&"on"===origin_aspect.preposition&&origin_asset.hasQuirk("in_means_on")){prep="on";prep_match=true}if(!prep_match&&"under"===origin_aspect.preposition){prep="under";prep_match=true}if(!prep_match&&"behind"===origin_aspect.preposition){prep="behind";prep_match=true}}if(origin_asset.id!==asset1.id||!prep_match){this.game.debug("D1045",this.name+".js ",` ${character.id} not ${prep} ${asset1.id} `);msg+=`{We're} not ${prep} ${asset1.articlename}. `;this.handleFailure(msg);return null}if(!origin_aspect.canCharacter("exit")){this.game.debug("D1002",this.name+".js ",` ${asset1.id}.aspects.${origin_aspect.preposition}.nest.can.exit is false`);msg+=`{We} can't ${input_verb.name} ${character.getPrettyUnnestPreposition()} ${asset1.articlename}. `;this.handleFailure(msg);return null}var dest=character.getUnnestPreposition();if(preposition1!==dest){preposition1=dest;input.setPreposition(1,preposition1);input.setVerbParam(preposition1,true)}input.setVerbParam("action","unnest")}if(input.hasStructure("verb preposition noun")&&"off"===preposition1)if(this.canCharacterRepositionDown(character,origin_asset,origin_aspect,input_verb,true)){input.setPreposition(1,"down");input.setVerbParam("reposition_down",true);input.setVerbParam("action","reposition");return true}if(input.hasStructure("verb preposition noun")&&origin_asset.id!==asset1.id&&!origin_asset.hasClass("Room")){if((results=this.canCharacterGoFromThisToThat(origin_asset,asset1)).failure){this.handleFailure(results.msg);return null}destination_asset=asset1;destination_aspect=asset1.getAspectAt(preposition1)||results.aspect;input.swapPhrases(1,2);input.setAsset(1,origin_asset);input.setPreposition(1,"from");input.setPreposition(2,"to");asset1=input.getAsset(1);preposition1=input.getPreposition(1);asset2=input.getAsset(2);preposition2=input.getPreposition(2);input.setVerbParam("destination_asset",destination_asset);input.setVerbParam("destination_aspect",destination_aspect);input.setStructure("verb preposition noun preposition noun");input.setVerbParam("fromto",true);input.setVerbParam("action","renest");return true}if(input.hasStructure("verb preposition noun")&&"on"===preposition1){let aspect=asset1.aspects.on;if(origin_aspect.id===aspect.id){var player=input_verb.default_direction||"up";console.warn({preposition1:preposition1,dir:player});preposition1=player;input.setPreposition(1,player);input.setVerbParam(player,true)}}if(input.hasStructure("verb preposition noun")&&"up"===preposition1){let aspect=asset1.aspects.on;if(origin_aspect.id!==aspect.id){preposition1="on";input.setPreposition(1,"on");input.setVerbParam("on",true);input.setVerbParam("action","nest")}}if(input.hasStructure("verb preposition noun")&&"on"===preposition1){let aspect=asset1.aspects.on;input.setVerbParam("on",true);input.setVerbParam("action","nest");input.setVerbParam("destination_asset",asset1);input.setVerbParam("destination_aspect",aspect)}if(input.hasStructure("verb preposition noun")&&"up"===preposition1){let aspect=asset1.aspects.on;if(this.canCharacterRepositionUp(asset1,aspect)){input.setPreposition(1,"up");preposition1="up";input.setVerbParam("reposition_up",true);input.setVerbParam("action","reposition")}else{this.game.debug("D1274",this.name+".js ",` ${character.id} can't go higher on ${asset1.id} `);msg+=`{We} can't ${input_verb.name} any higher on ${asset1.articlename}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb preposition noun")&&"down"===preposition1){if(origin_asset.id!==asset1.id){if(character.getY()>asset1.getY());this.game.debug("D1244",this.name+".js ",` ${character.id} not nested on ${asset1.id} `);msg+=`{We're} not on ${asset1.articlename}. `;this.handleFailure(msg);return null}if(origin_asset.id===asset1.id)if(this.canCharacterRepositionDown(origin_asset,origin_aspect)){input.setVerbParam("action","reposition");input.setVerbParam("reposition_down",true);return true}else{input.setPreposition(1,"off");input.setVerbParam("off",true);input.setVerbParam("action","unnest");return true}}if(input.hasStructure("verb preposition noun")){if(origin_asset.hasClass("Room")&&character.isOnFloor())if(this.game.settings.auto_stand_on_travel){this.game.printInferred(`rising from {our} position ${character.getPostureGerund()} on the floor`);if(nest_asset)if(void 0!==(results=character.onUnnestThisFromThat(nest_asset)))return results}else{this.game.debug("D1006",this.name+".js ",` ${character.id}.isOnFloor `);msg+=`{We} can't do that from {our} position ${character.getPostureGerund()} on the floor. `;this.handleFailure(msg);return null}if(asset1.id===origin_asset.id&&preposition1===origin_aspect.preposition||origin_asset.hasClass("Room")&&asset1 instanceof adventurejs.Floor){if(input_verb.hasStructure("verb")){this.game.log("L1388","log","high",`[${this.name}.js] ${character.id} is already ${asset1.id===origin_asset.id?origin_aspect.preposition+" "+origin_asset.id:"on the floor"}
inferring sentence structure "verb"`,"verbs");input.setStructure("verb");input.setVerbParam("action","none");return true}this.game.debug("D1007",this.name+".js ",` ${character.id} is already ${asset1.id===origin_asset.id?"nested "+origin_aspect.preposition+" "+origin_asset.id:"on the floor"} `);msg+=`{We're} already ${origin_aspect?origin_aspect.preposition:asset1.default_aspect} ${asset1.articlename}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb preposition noun")&&!["off","out","up","down"].includes(preposition1)){if(!asset1.hasAspectAt(preposition1)){if("in"===preposition1&&asset1.hasQuirk("in_means_on")&&asset1.hasAspectAt("on")){preposition1="on";input.setPreposition(1,"on")}else{this.game.debug("D1009",this.name+".js ",` ${asset1.id}.aspects.${preposition1} is undefined`);msg+=`{We} can't ${input_verb.name} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg);return null}}if(!asset1.aspects[preposition1].canCharacter("enter")){this.game.debug("D1005",this.name+".js ",` ${asset1.id}.aspects.${preposition1}.nest.can.enter is false`);msg+=`{We} can't ${input_verb.name} ${preposition1} ${asset1.articlename}. `;this.handleFailure(msg);return null}if(asset1.id===origin_asset.id&&preposition1!==origin_aspect.preposition){if(!this.game.settings.auto_unnest_on_travel){this.game.debug("D1008",this.name+".js ",` ${character.id}.is ${origin_aspect.preposition} ${origin_asset.id} not `+preposition1);msg+=`{We} can't do that from {our} position ${character.getPostureGerund()} ${origin_aspect.preposition} ${origin_asset.articlename}. `;this.handleFailure(msg);return null}input.setPreposition(2,"from");input.setAsset(2,origin_asset);input.swapPhrases(1,2);input.setStructure("verb preposition noun preposition noun");input.setVerbParam("fromto",true);input.setVerbParam("action","renest");return true}}if(input.hasStructure("verb preposition noun")){if(["in","on","under","behind"].includes(preposition1))input.setVerbParam("action","nest");return true}if(input.hasStructure("verb noun preposition noun")&&!["with","in","on","through"].includes(preposition2)){this.game.debug("D1867",this.name+".js "," irregular phrase ");msg+=`{We} can't ${input_verb.name} ${preposition2} ${asset2.articlename}. `;this.handleFailure(msg)}else{if(input.hasStructure("verb noun preposition noun")&&asset1.direction){let allow_travel=false;if(asset2.hasClass("Vehicle")){if(origin_asset.id!==asset2.id){this.game.debug("D1042",this.name+".js ",` ${character.id} is not on ${asset2.name} `);msg+=`{We're} not on ${asset2.articlename}. `;this.handleFailure(msg);return null}allow_travel=true}else if(asset1.direction===asset2.direction)allow_travel=true;if(allow_travel)return this.game.tryTravel(asset1.direction,asset2.direction?{}:{with:[asset2.id]});else{this.game.debug("D1871",this.name+".js "," irregular phrase ");msg+=`{We} can't ${input_verb.name} ${asset1.direction} ${preposition2} ${asset2.articlename}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb noun preposition noun")&&!asset1.direction)if(input_verb.default_direction){preposition1=input_verb.default_direction;input.setPreposition(1,preposition1);input.setStructure("verb preposition noun preposition noun")}if(input.hasStructure("verb noun preposition noun"))if(asset1.getAspectAt(asset1.default_aspect)&&asset1.getAspectAt(asset1.default_aspect).nest.can.enter){preposition1=asset1.default_aspect;input.setPreposition(1,preposition1);input.setStructure("verb preposition noun preposition noun")}if(input.hasStructure("verb noun preposition noun")){this.game.debug("D1325",this.name+".js ",` "${input.getInput()}" isn't handled by go.js `);msg+=`{We} {don't} know how to ${input.getInput()}. `;this.handleFailure(msg)}else{if(input.hasStructure("verb preposition noun preposition noun")||input.hasStructure("verb preposition noun preposition noun preposition noun")){let asset=destination_asset?destination_asset:origin_asset,aspect=destination_aspect?destination_aspect:origin_aspect;console.warn("FROMTO?",input.getVerbParam("fromto"));if(tool_asset)if((results=this.canCharacterUseThisWithThat(aspect.preposition,asset,tool_asset)).failure){this.handleFailure(results.msg);return null}if(destination_asset){if((results=this.canCharacterGoFromThisToThat(origin_asset,destination_asset)).failure){this.handleFailure(results.msg);return null}verified_canPlayerGoFromThisToThat=true}}if(input.hasStructure("verb preposition noun preposition noun")&&"with"===preposition2){if(!origin_asset.hasClass("Room")&&origin_asset.id!==asset1.id){input.swapPhrases(2,3);input.swapPhrases(1,2);input.setAsset(1,origin_asset);input.setPreposition(1,"from");input.setVerbParam("fromto",true);input.setStructure("verb preposition noun preposition noun preposition noun");input.setVerbParam("action","renest")}return true}if(input.hasStructure("verb preposition noun preposition noun")&&input.getVerbParam("fromto")){input.setVerbParam("action","renest");return true}if(input.hasStructure("verb preposition noun preposition noun")){this.game.debug("D1328",this.name+".js ",` "${input.getInput()}" isn't handled by go.js `);msg+=`{We} {don't} know how to ${input.getInput()}. `;this.handleFailure(msg)}else{if(input.hasStructure("verb preposition noun preposition noun preposition noun"))if(input.getVerbParam("fromto")&&input.getVerbParam("with")){input.setVerbParam("action","renest");return true}this.game.debug("D1279",this.name+".js ",` "${input.getInput()}" isn't handled by go.js `);msg+=`{We} {don't} know how to ${input.getInput()}. `;this.handleFailure(msg)}}}}}return null},doSuccess:function(){var input=this.game.getInput(),character=input.getSubject(),input_verb=this.game.dictionary.getVerb(input.input_verb),adverb=input.getAdverb(),current_room=this.game.getRoom(),origin_asset=input.getVerbParam("origin_asset"),origin_aspect=input.getVerbParam("origin_aspect"),destination_asset=input.getVerbParam("destination_asset"),destination_aspect=input.getVerbParam("destination_aspect"),tool_asset=input.getVerbParam("tool_asset"),tool_preposition=input.getVerbParam("tool_preposition"),tool_string=tool_asset?`use ${tool_asset.articlename} to`:"",none=input.getVerbParam("action","none"),action=input.getVerbParam("action"),repositioning="reposition"===action,exiting="unnest"===action||"renest"===action||"span"===action,entering="nest"===action||"renest"===action||"span"===action,spanning=input.getVerbParam("spanning"),fromto=input.getVerbParam("fromto"),reposition_up=input.getVerbParam("reposition_up"),reposition_down=input.getVerbParam("reposition_down"),reposition_top=input.getVerbParam("reposition_top"),reposition_bottom=input.getVerbParam("reposition_bottom");let reposition_percent_string="";var reposition_percent=100,mount_down,adverb,origin_aspect;let get_off=exiting?["go","get","exit"].includes(input_verb.name)?"get":input_verb.name:false;if(get_off)get_off=this.agree(get_off);let get_on=entering?["go","get","enter"].includes(input_verb.name)?"get":["ride"].includes(input_verb.name)?"mount":input_verb.name:false;if(get_on)get_on=this.agree(get_on);let mount_up,mount_percent_string="",msg="",results,newY=0,posture_string="";this.game.log("L1398","log","high",`[${this.name}.js] 
       sentence structure: ${input.getStructure()}
       ${input_verb.name} action: ${input.getVerbParam("action")}
       character start y: `+character.getY(),"verbs");if(input.hasStructure("verb")||none)if("jump"===input_verb.name){msg+="{We} jump "+(adverb?adverb:"up and down");if(origin_asset.hasClass("Room"))msg+=" in place";else msg+=(origin_aspect?" "+origin_aspect.preposition:"")+(origin_asset?" "+origin_asset.articlename:"");msg=msg.trim();msg+=". "}else{msg+=`{We} ${input_verb.name} `+(adverb?adverb:"about");if(origin_asset.hasClass("Room"))msg+=" in place";else msg+=(origin_aspect?" "+origin_aspect.preposition:"")+(origin_asset?" "+origin_asset.articlename:"");msg=(msg=msg+(input.getVerbParam("with")?" with "+tool_asset.articlename+" ":"")+(adverb?"":" for a bit")).trim();msg+=". "}else{if(repositioning){if(reposition_top)newY=origin_asset.getYTop();if(reposition_bottom)newY=origin_asset.getY();if(reposition_up)newY=Math.min(character.getY()+origin_aspect.scale_increment,origin_asset.getYTop());if(reposition_down)newY=Math.max(character.getY()-origin_aspect.scale_increment,origin_asset.getYBottom());reposition_percent=newY/origin_asset.getHeight();reposition_percent_string=reposition_up?this.getPercentStringUp(reposition_percent):this.getPercentStringDown(reposition_percent)}if(exiting)newY=0;if(entering){var none=destination_asset.getYTop();mount_up=false;if(0<destination_aspect.scale_increment&&destination_aspect.scale_increment<destination_asset.getHeight()&&!input_verb.override_aspect_scale_increments.up){newY=destination_asset.getY()+destination_aspect.scale_increment;mount_up=true}else newY=none;adverb=newY/none;if(mount_up)mount_percent_string=this.getPercentStringUp(adverb);if(void 0)mount_percent_string=this.getPercentStringDown(adverb)}var reposition_top=character.getPrettyUnnestPreposition();if(exiting)if(void 0!==(results=character.onUnnestThisFromThat(origin_asset)))return results;if(entering)if(void 0!==(results=character.onNestThisToThat(destination_asset,destination_aspect.preposition)))return results;var reposition_bottom=input_verb.override_aspect_posture?input_verb.posture:"",reposition_down=character.getNestOrPlaceAspect(),origin_aspect=reposition_bottom&&reposition_down.canCharacter(reposition_bottom)?reposition_bottom:reposition_down.nest.posture;posture_string=this.getPostureString(origin_aspect,reposition_down.preposition);if(["ride"].includes(input_verb.name)&&"sit"===posture_string)posture_string="take a seat";character.posture=origin_aspect;character.position.y=newY;msg+=`{We}
      `+(tool_asset?"use "+tool_asset.articlename+" to":"");if(input.getVerbParam("spanning"))msg+=`${input_verb.agree()} from ${origin_asset.articlename} to ${destination_asset.articlename} and `+posture_string;else msg+=`${get_off&&get_on?get_off:get_on&&!get_off?get_on:get_off&&!get_on?get_off:input_verb.agree()}
        ${repositioning?reposition_percent_string+" "+origin_asset.articlename:""}
        ${exiting?reposition_top+" "+origin_asset.articlename:""}
        ${"renest"===action?" and then "+get_on:""}
        ${mount_percent_string}
        ${entering&&!mount_percent_string?["ride"].includes(input_verb.name)?"":destination_aspect.preposition:""}
        ${entering?destination_asset.articlename:""}
        ${entering?"and "+posture_string:""}
      `;msg=msg.trim()+". ";this.game.log("L1392","log","high",`[${this.name}.js] 
       character end y: ${character.getY()}
       character posture: `+origin_aspect,"verbs")}return this.handleSuccess(msg)}};A.Preverbs.goTo={name:"goTo",prettyname:"go to",type:{locomotion:true,travel:true},subject_must_be:{not_constrained:true,not_nested_elsewhere:true},accepts_structures:["verb noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true}},with_params:{},msgNoObject:"Where did you want to go?",doTry:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),input=input.getNoun(1),current_room=this.game.world._room,msg="";if(!(direct_object instanceof adventurejs.Room))input=direct_object.getRoomId();if(input!==current_room)return true;this.game.debug("D1296",this.name+".js "," destination is current room ");this.game.print(msg+="Look around. ");return false},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),destination=input.getNoun(1),current_room=this.game.world._room,input="",print_room=this.game.settings.goto_prints_room_descriptions,output_class=print_room?"":"concatenate_output",exclude_unvisited=this.game.settings.goto_excludes_unvisited_locations,exclude_locked=this.game.settings.goto_excludes_locked_doors;if(!(direct_object instanceof adventurejs.Room))destination=direct_object.getRoomId();for(var layout={},i=0;i<this.game.room_lookup.length;i++){var room=this.game.getAsset(this.game.room_lookup[i]);if(!room);else if(!subject.hasVisitedRoom(room))this.game.log("L1343","log","high",`[${this.name}.js] ${room.id} excluded from goTo because ${subject.id} hasn't been`,"verbs");else{for(var nodes=[],exits=room.exits,keys=Object.keys(exits),k=0;k<keys.length;k++){var exit=exits[keys[k]];if(!(exit=this.game.getAsset(exit)));else{var destination_room=this.game.getAsset(exit.destinationID);if(!destination_room);else{var aperture=exit.aperture,key_assets;if(!exit.destinationID);else if(!subject.hasVisitedRoom(destination_room)&&exclude_unvisited)this.game.log("L1345","log","high",`[${this.name}.js] ${subject.id}.has_been[${destination_room.id}] is unset`,"verbs");else{if(aperture&&exclude_locked){if((aperture=this.game.getAsset(aperture)).isDOV("unlock")&&aperture.is.locked){key_assets=subject.findNestedIndirectObjects("unlock",aperture);if(!aperture.allowVerbWithNothing("unlock","dov")&&!key_assets.length){this.game.log("L1346","log","high",`[${this.name}.js] ${aperture.id}.is.locked and subject has no key`,"verbs");continue}if(!aperture.canDoVerbAutomatically("unlock"))continue}if(aperture.isDOV("unseal")&&aperture.is.sealed){key_assets=subject.findNestedIndirectObjects("unseal",aperture);if(!aperture.allowVerbWithNothing("unseal","dov")&&!key_assets.length){this.game.log("L1347","log","high",`[${this.name}.js] ${aperture.id}.is.sealed and subject has no key`,"verbs");continue}if(!aperture.canDoVerbAutomatically("unseal"))continue}if(aperture.isDOV("open")&&aperture.is.closed){key_assets=subject.findNestedIndirectObjects("open",aperture);if(!aperture.allowVerbWithNothing("open","dov")&&!key_assets.length){this.game.log("L1348","log","high",`[${this.name}.js] ${aperture.id}.is.closed and subject has no key`,"verbs");continue}if(!aperture.canDoVerbAutomatically("unlock"))continue}if(aperture.is.hidden){this.game.log("L1349","log","high",`[${this.name}.js] ${aperture.id}.is.hidden`,"verbs");continue}}nodes.push(exit.destinationID)}}}}layout[room.id]=nodes}}this.game.log("L1350","log","low",["layout:",layout],"verbs");var graph={},id;for(id in layout){if(!graph[id])graph[id]={};layout[id].forEach(function(aid){graph[id][aid]=1;if(!graph[aid])graph[aid]={};graph[aid][id]=1})}this.game.log("L1351","log","low",["graph:",graph],"verbs");var start=this.game.world._room,solutions=A.dijkstra(graph,start);this.game.log("L1352","log","low",["solutions[destination]:",solutions[destination]],"verbs");if(void 0===solutions[destination]||0===solutions[destination].length){this.game.debug("D1297",this.name+".js ",` 
            No path was found. 
            Blockers may include locked/sealed/closed doors which 
            subject has not opened or does not have a key for, 
            or destination unknown to / unvisited by subject. `);input+="{We} {don't} know of a route between here and there";if(!destination?.is?.known&&!subject.knowsAbout(destination))input+=", or even if there is a there there";this.handleFailure(input+=".");return false}else for(var len=solutions[destination].length,i=0,thisRoom,nextRoom,direction;i<len;i++){if(0===i)thisRoom=start;else thisRoom=solutions[destination][i-1];nextRoom=solutions[destination][i];thisRoom=this.game.world[thisRoom];nextRoom=this.game.world[nextRoom];for(direction in thisRoom.exits){var exit,dest=(exit=this.game.world[thisRoom.id+"_"+direction]).destinationID;if(void 0===dest);else if(nextRoom.id===dest){this.game.log("L1353","log","low",["nextRoom.id",nextRoom.id,"dest",dest],"verbs");var output="",aperture;if(aperture=exit.aperture)aperture=this.game.getAsset(aperture);if(aperture&&(aperture.is.locked||aperture.is.closed))this.game.parser.input_queue.push({input:"open "+aperture.id,printInput:false,excludeRoomDescriptions:true,output_class:output_class,linefeed:linefeed});var output="{We} go "+direction+" to "+(nextRoom.use_definite_article_in_lists?nextRoom.definite_article+" ":"")+nextRoom.name+". ",linefeed=i===len-1?true:void 0;this.game.parser.input_queue.push({input:direction,printInput:false,excludeRoomDescriptions:!print_room,output_class:output_class,linefeed:linefeed})}}}return true}};A.Preverbs.hang={name:"hang",prettyname:"hang",past_tense:"hung",synonyms:[],gerund:"hanging",accepts_structures:["verb","verb preposition","verb preposition noun","verb noun preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,accepts_preposition_without_noun:true},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),nest_preposition=subject.getNestPreposition(),nest_parent_id=subject.getNestId(),nest_asset=subject.getNestAsset(),target,msg="",direct_preposition;if("from"===direct_preposition){input.setPreposition(1,"on");direct_preposition="on"}if("from"===indirect_preposition){input.setPreposition(2,"on");indirect_preposition="on"}if(input.hasStructure("verb")){var parent,direct_object=subject.getNestOrPlaceAsset(),direct_preposition=subject.getNestOrPlacePreposition();input.setAsset(1,direct_object);input.setPreposition(1,direct_preposition);input.setStructure("verb preposition noun");this.game.printInferred("from "+direct_object.articlename)}if(input.hasStructure("verb preposition")){if(["out","on"].includes(direct_preposition))return true;if("up"===direct_preposition){var phones=subject.findNestedAssetsWithClass("Phone");if(!phones.length){this.game.debug("D1303",this.name+".js ",` ${subject.id} has no phone `);this.handleFailure(msg+="{We} slam down {our} imaginary phone. ");return null}if(phones.length){for(let i=0;i<phones.length;i++){var phone=this.game.getAsset(phones[i]);if(phone&&phone.is.connected){input.setAsset(1,direct_object=phone);input.setStructure("verb preposition noun");this.game.printInferred(""+direct_object.articlename)}}if(!direct_object){this.game.debug("D1262",this.name+".js ",` ${subject.id} has phone but no connection `);this.handleFailure(msg+="{We} {don't} appear to be on a call. ");return null}}}else{this.game.debug("D1245",this.name+".js ",` ${this.name} ${direct_preposition} is unsupported `);msg+=`{We} {don't} know how to ${input.input_verb} ${direct_preposition}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb preposition noun")){if(!direct_object.isDOV("hang")){this.game.debug("D1305",this.name+".js ",` ${direct_object.id}.dov.hang is unset `);msg+=`{We} see no way to hang ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if("up"===direct_preposition&&direct_object instanceof adventurejs.Phone){this.game.debug("D1246",this.name+".js ",` ${direct_object.id} is ${direct_object.is.connected?"":"un"}connected phone `);if(direct_object.is.connected)return true;msg+=direct_object.Articlename+" doesn't appear to be connected. ";this.handleFailure(msg);return null}if(nest_asset&&direct_object.id===nest_asset.id&&direct_preposition===nest_preposition){this.game.debug("D1338",this.name+".js ",` subject is ${direct_preposition} ${direct_object.id} `);msg+=`{We're} already ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.placePreventsNesting(subject)){this.game.debug("D2098",this.name+".js ",` ${direct_object.id}.is.deep_nest is false `);msg+=`{We} can't do that while ${direct_object.articlename_is} 
              ${direct_object.getPrettyPlacePreposition()}
              ${direct_object.getPlaceAsset().articlename}. `;this.handleFailure(msg);return null}var nest_preposition=direct_object.getYRange();if(subject.position.y>nest_preposition.max||subject.position.y<nest_preposition.min){this.game.debug("D1306",this.name+".js ",` ${subject.id}.position.y out of range of ${direct_object.id} `);msg+=`${direct_object.Articlename_is} too far ${subject.position.y>nest_preposition.max?"below":"above"} your position on ${subject.isNested()?nest_asset.articlename:"the floor"}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb noun preposition noun")){if(!indirect_object.isIOV("hang")){this.game.debug("D1298",this.name+".js ",` ${indirect_object.id}.iov.hang is unset `);msg+=`{We} can't hang anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D1299",this.name+".js ",` ${indirect_object.id}.aspects.${indirect_preposition} is unset `);msg+=`{We} can't hang anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if((direct_preposition=this.tryToPutThisInThatAspect(direct_object,indirect_preposition,indirect_object)).fail){msg=direct_preposition.msg;this.handleFailure(msg);if(direct_preposition.end_turn)return false;else return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),nest_parent_id=subject.getNestId(),nest_asset=subject.getNestAsset(),msg="",results;if(input.hasStructure("verb"));if(input.hasStructure("verb preposition")){if("out"===direct_preposition)msg+="{We} chillax for a moment. ";if("on"===direct_preposition)msg+="{We} cling desperately to life. ";if("up"===direct_preposition)msg+="{We} do have {ours}. ";msg+=""}if(input.hasStructure("verb preposition noun"))if("up"===direct_preposition&&direct_object instanceof adventurejs.Phone){msg+=`{We} hang up ${direct_object.articlename}. `;direct_object.is.connected=false}else{msg+=`{We} hang ${direct_preposition} ${direct_object.articlename}. `;if(nest_asset&&nest_asset.id!==direct_object.id)if(void 0!==(results=subject.onUnnestThisFromThat(nest_asset)))return results;if(void 0!==(results=subject.onNestThisToThat(direct_object,direct_preposition)))return results;subject.posture="hang"}if(input.hasStructure("verb noun preposition noun")){if(void 0!==(results=subject.onRemoveThatFromThis(direct_object)))return results;if(void 0!==(results=indirect_object.onMoveThatToThis(direct_object,"on")))return results;msg+=`{We} hang ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;direct_object.posture_position=this.game.dictionary.getStringLookup("posture_positions","hanging")}return this.handleSuccess(msg)}};A.Preverbs.hide={name:"hide",prettyname:"hide",past_tense:"hid",synonyms:["hide"],extends:{go:true,put:true},gerund:"hiding",accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,not_global:true,not_scenery:true,not_exit:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,accepts_preposition:true,requires_preposition:true,noun_must_be:{known:true,not_global:true,not_scenery:true,not_exit:true,tangible:true,present:true,visible:true,reachable:true}},let_verb_handle_disambiguation:false,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",target="";if(input.hasStructure("verb noun")){if(direct_object.isWithin(subject))return true;this.game.debug("D1408",this.name+".js ",` ${direct_object.id} is not in `+subject.id);msg+=`{We're} not carrying ${direct_object.articlename}. `;this.handleFailure(msg);return null}else if(input.hasStructure("verb preposition noun"))if("from"===direct_preposition)return true;else this.game.log("L1523","log","high",`[${this.name}.js] ${this.name} ${direct_preposition} ${direct_object.name}: infer `+(target="go"),"Verbs");else if(input.hasStructure("verb noun preposition noun"))if("from"===indirect_preposition){if(direct_object.isWithin(subject))return true;this.game.debug("D1409",this.name+".js ",` ${direct_object.id} is not in `+subject.id);msg+=`{We're} not carrying ${direct_object.articlename}. `;this.handleFailure(msg);return null}else this.game.log("L1524","log","high",`[${this.name}.js] ${this.name} ${direct_object.name} ${indirect_preposition} ${indirect_object.name}: infer `+(target="put"),"Verbs");return this.game.dictionary.doVerb(target)},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="";if(input.hasStructure("verb noun"))msg+=`{We} ${this.agree()} ${direct_object.articlename}. `;else if(input.hasStructure("verb preposition noun")&&"from"===direct_preposition){msg+=`{We} ${this.agree()} ${direct_preposition} `+direct_object.articlename;if(!direct_object.hasClass("Character"))msg+=` (like ${direct_object.articlename} cares)`;msg+=". "}else if(input.hasStructure("verb noun preposition noun")&&"from"===indirect_preposition)msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition}  ${indirect_object.articlename}. `;else return this.handleSuccess();return this.handleSuccess(msg)}};A.Preverbs.hit={name:"hit",prettyname:"hit",past_tense:"hit",synonyms:["hit","attack","rochambeau"],gerund:"hitting",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1307",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1957",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1697",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1701",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if("with"===indirect_preposition)if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D2133",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1309",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1958",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2136",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.hold={name:"hold",prettyname:"hold",past_tense:"held",synonyms:["hold","grab"],verb_prep_noun:["hold onto","grab onto"],verb_prep_prep_noun:["hold on to","grab on to"],gerund:"holding",makes_connections:true,accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{max_connections:1},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,msg="",verb_phrase;if("hold on to"===verb_phrase||"grab on to"===verb_phrase||"hold onto"===verb_phrase||"grab onto"===verb_phrase);if(!direct_object.isDOV("hold")&&direct_object.isDOV("take")){this.game.debug("D1311",this.name+".js "," inferring take, doVerb take ");return this.game.dictionary.doVerb("take")}if(!direct_object.isDOV("hold")){this.game.debug("D1313",this.name+".js ",` ${direct_object.id}.dov.hold.enabled is false `);msg+=`{We} can't hold on to ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(subject.isConnectedToAsset(this.name,direct_object,"to_dov")){this.game.debug("D1314",this.name+".js ",` ${subject.id}.is.connected_by.hold.to_dov contains ${direct_object.id} `);msg+=`{We're} already ${this.gerund} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(subject.hasVerbMaxConnections(this.name,"to_dov")){this.game.debug("D1315",this.name+".js ",` ${subject.id}.is.connected_by.${this.name}.to_dov.length >= ${subject.id}.dov.${this.name}.with_params.max_connections `);msg+=`{We're} ${this.gerund} on to as many things as {we} can. `;this.handleFailure(msg);return null}if(direct_object.isDOV("tie")&&!direct_object.getVerbConnectionCount("tie","to_iov")&&!direct_object.isAttached()){this.game.debug("D1588",this.name+".js "," inferring take, doVerb take ");this.game.dictionary.doVerb("take");return null}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1787",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((verb_phrase=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1788",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(verb_phrase.success){indirect_object=verb_phrase.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1789",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1901",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1807",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject();if(input.did.doSuccess)return this.handleSuccess();var direct_object=input.getAsset(1),indirect_object=input.getAsset(2),msg="",results;this.setVerbConnection(direct_object,subject);msg=(msg=(msg+="take"===input.input_verb?`{We} can't take ${direct_object.articlename}, but {we} can hold it, so {we} do that instead`:"{We} grab hold of "+direct_object.articlename)+(indirect_object?", using "+indirect_object.articlename:"")).trim();return this.handleSuccess(msg+=". ")}};A.Preverbs.hop={name:"hop",prettyname:"hop",past_tense:"flew",synonyms:["hop"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"hopping",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_hop:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.hover={name:"hover",prettyname:"hover",past_tense:"hovered",synonyms:["hover"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"hovering",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_hover:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.inventory={name:"inventory",synonyms:["inventory","inv","i"],accepts_structures:["verb"],do:function(){this.game.printPlayerInventory();return true}};A.Preverbs.jump={name:"jump",prettyname:"jump",past_tense:"jumped",synonyms:["jump"],verb_prep_noun:["jump up"],extends:{go:true},gerund:"jumping",posture:"stand",override_aspect_scale_increments:{up:false,down:true},override_aspect_posture:true,can_span:true,default_direction:"off",subject_must_be:{not_constrained:true,not_on_floor:true,able_to_jump:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition noun","verb noun noun","verb preposition noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},in_can_mean_on:true,doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.kick={name:"kick",prettyname:"kick",past_tense:"kicked",synonyms:["kick","punt"],gerund:"kicking",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true},accepts_structures:["verb noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,not_worn:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),input=input.getAsset(1),msg="";if(!input.isDOV("kick")){this.game.debug("D1321",this.name+".js ",` ${input.id}.dov.kick.enabled is false `);msg+=`{We} can't ${this.name} ${input.articlename}. `;this.handleFailure(msg);return null}if(input.getPlaceAssetId()===subject.id&&!input.can.kick_while_held){this.game.debug("D1322",this.name+".js ",` ${input.id}.can.kick_while_held is false `);msg+=`{We} can't ${this.name} ${input.articlename} while holding it. `;this.handleFailure(msg);return null}if(input.allowVerbOnce(this.name,"dov")&&input.didVerb(this.name,"dov")){this.game.debug("D1960",this.name+".js ",` ${input.id}.dov.${this.name}.once and ${input.id}.did.${this.name}.directly `);msg+=`${input.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,input="";input+=`{We} ${this.agree()} ${direct_object.articlename}. `;return this.handleSuccess(input)}};A.Preverbs.kill={name:"kill",prettyname:"kill",past_tense:"killed",synonyms:["kill","murder"],state:"dead",gerund:"killing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV("kill")){this.game.debug("D1324",this.name+".js ",` ${direct_object.id}.dov.kill.enabled is false `);msg+=`{We} can't kill ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1961",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.propername} is already ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1962",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1963",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1964",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1965",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1966",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1967",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.kneel={name:"kneel",prettyname:"kneel",past_tense:"knelt",gerund:"kneeling",accepts_structures:["verb","verb noun","verb preposition","verb preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,not_direction:true,not_in_inventory:true},accepts_preposition:true,accepts_preposition_without_noun:true,requires_preposition:true},with_params:{},in_can_mean_on:true,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),nest=subject.getNest(),nest_asset=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),input,msg="",input,already_on_it;if(input.hasStructure("verb")){if(subject.is.kneeling){this.game.debug("D1326",this.name+".js ",` ${subject.id}.is.kneeling `);this.handleFailure(msg+="{We're} already kneeling! ");return null}if(nest_asset){direct_preposition=subject.getNestOrPlacePreposition();direct_object=nest_asset}else{direct_preposition="on";direct_object=this.game.getRoomFloor()}input.setAsset(1,direct_object);input.setPreposition(1,direct_preposition);input.setStructure("verb preposition noun");this.game.printInferred(direct_preposition+" "+direct_object.articlename)}if(input.hasStructure("verb preposition"))if("down"===direct_preposition){if(subject.is.kneeling){this.game.debug("D1088",this.name+".js ",` ${subject.id}.is.kneeling`);this.handleFailure(msg+="{We} shift weight from knee to knee. ");return null}if(nest_asset){direct_object=nest_asset;direct_preposition=nest_preposition}else{direct_object=this.game.getRoomFloor();direct_preposition="on"}if(direct_object){input.setAsset(1,direct_object);input.setPreposition(1,direct_preposition);input.setInferred(1,true);input.setStructure("verb preposition noun");this.game.printInferred(direct_preposition+" "+direct_object.articlename)}}else{this.game.debug("D1021",this.name+".js "," no direct object received or inferred");msg+=`{We} try to ${this.name} ${direct_preposition}, and fail. `;this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun")){if(!subject.can.kneel||!direct_object.aspects[direct_preposition].canCharacter("kneel")){this.game.debug("D1327",this.name+".js ",` subject.can.kneel is false or ${direct_object.id}.aspects.${direct_preposition}.nest.can.kneel is false`);msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(nest_asset&&nest_asset.id!==direct_object.id)if((input=this.canCharacterGoThereFromNest(direct_preposition,direct_object)).failure){this.handleFailure(input.msg);return null}if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition!==direct_preposition){this.game.debug("D1614",this.name+".js ",` subject is otherwise nested ${nest_preposition} ${nest_asset.id} `);msg+=`{We} can't do that from {our} position ${subject.getPostureGerund()} ${nest_preposition} ${nest_asset.articlename}. `;this.handleFailure(msg);return null}if(subject.is.kneeling){if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition===direct_preposition)already_on_it=true;if(!nest_asset&&direct_object instanceof adventurejs.Floor)already_on_it=true;if(already_on_it){this.game.debug("D1613",this.name+".js ",` ${subject.id}.is.kneeling ${direct_preposition} ${direct_object.id} `);msg+=`{We're} already kneeling ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}}}if((input=direct_object)?.placePreventsNesting(subject)){this.game.debug("D1164",this.name+".js ",` ${input.id}.is.deep_nest is false `);msg+=`{We} can't do that while ${input.articlename_is} 
          ${input.getPrettyPlacePreposition()}
          ${input.getPlaceAsset().articlename}. `;this.handleFailure(msg);return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),do_nest,do_unnest,fromfloor,tofloor,results,msg="",tofloor=direct_object instanceof adventurejs.Floor,fromfloor=!input||input instanceof adventurejs.Floor;if(fromfloor&&tofloor){do_nest=true;this.game.log("L1378","log","high",`[${this.name}.js] from floor to floor`,"verbs");msg+=`{We} ${subject.isOnFloor()?"shift positions to":""} ${this.name} on the floor. `}else if(fromfloor&&!tofloor||input&&input.id===direct_object.id){do_nest=fromfloor&&!tofloor;this.game.log("L1379","log","high",`[${this.name}.js] from floor to asset or change position on asset`,"verbs");msg+=`${fromfloor&&"stand"!==subject.posture?"{We} rise from the floor and ":"{We} "} ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&tofloor){do_unnest=true;this.game.log("L1380","log","high",`[${this.name}.js] from asset to floor `,"verbs");msg+=`{We} get ${subject.getPrettyUnnestPreposition()} ${input.articlename} and ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&!tofloor&&direct_object.id===input.id){if(subject.is.lying||subject.is.sitting||subject.is.standing){this.game.debug(` | ${this.name}.js | change posture on floor `);msg+=`{We} ${this.agree()} ${nest_preposition} ${direct_object.articlename}. `}}else if(!fromfloor&&!tofloor&&direct_object.id!==input.id){do_unnest=do_nest=true;this.game.log("L1381","log","high",`[${this.name}.js] move from one asset to another `,"verbs");msg+=`{We} move over to ${direct_object.articlename} and ${this.name} ${direct_preposition} it. `}if(do_unnest&&input)if(void 0!==(results=subject.onUnnestThisFromThat(input)))return results;if(do_nest&&direct_object)if(void 0!==(results=subject.onNestThisToThat(direct_object,direct_preposition)))return results;subject.posture=this.name;return this.handleSuccess(msg)}};A.Preverbs.knock={name:"knock",prettyname:"knock",past_tense:"knocked",synonyms:["knock"],gerund:"knocking",accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true,visible:true},accepts_preposition:true},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true,visible:true},accepts_preposition:true,preposition_must_be:["with","on","against"]},let_verb_handle_disambiguation:false,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(input.hasStructure("verb"));else{if(!direct_object.isDOV(this.name)){this.game.debug("D2087",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_preposition?direct_preposition:""} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2088",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} ${this.past_tense} ${direct_preposition?direct_preposition:"on"} ${direct_object.articlename} enough. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun"));else{if(input.hasStructure("verb preposition noun"))if(direct_object.allowVerbWithPreposition(this.name,direct_preposition,"dov"))return true;else if("off"===direct_preposition);else if("on"===direct_preposition||("in"===direct_preposition||"under"===direct_preposition||"behind"===direct_preposition)&&direct_object.hasAspectAt(direct_preposition))return true;else if(!direct_object.allowVerbWithPreposition(this.name,direct_preposition,"dov")){this.game.debug("D1371",this.name+".js ",` ${this.name} ${direct_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun"))if("on"===indirect_preposition||"against"===indirect_preposition){input.swapPhrases(1,2);input.setPreposition(1,"on");input.setPreposition(2,"with");input.setStructure("verb preposition noun preposition noun");direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2)}if(input.hasStructure("verb noun preposition noun")||input.hasStructure("verb preposition noun preposition noun")){if("with"===indirect_preposition&&!indirect_object.isIn(subject)){this.game.debug("D2089",this.name+".js ",` ${indirect_object.id} is not in subject `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2090",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_preposition?direct_preposition:""} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2091",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2092",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb preposition noun preposition noun"));}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.lasso={name:"lasso",prettyname:"lasso",past_tense:"lassoed",synonyms:["lasso","rope"],gerund:"lassoing",subject_must_be:{not_constrained:true},accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{on_lasso_set_tied:false,on_lasso_set_attached:false,on_lasso_remove_from_player:false,on_lasso_set_held:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),subject,indirect_inferred,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1330",this.name+".js ",` ${direct_object.id}.dov.lasso is unset `);msg+=`{We} can't lasso ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2171",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2172",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of anything that can be used to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2173",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(indirect_object.isAttached(direct_object)||indirect_object.isConnectedToAsset("tie",direct_object,"iov")){var subject=indirect_object.isAttached(direct_object)?"attached":"tied";this.game.debug("D2179",this.name+".js ",` ${indirect_object.id} is ${subject} to `+direct_object.id);msg+=`${indirect_object.Articlename_is} already ${subject} to ${direct_object.articlename}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!indirect_object.isIOV(this.name)){this.game.debug("D1331",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2175",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2174",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't use ${indirect_object.articlename} to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results,tied,attached,removed,held,hold;if(true===indirect_object.getVerbParam(this.name,"iov","on_lasso_remove_from_player")&&subject.has(indirect_object)){if(void 0!==(results=subject.onRemoveThatFromThis(indirect_object)))return results;removed=true}else if(true===indirect_object.getVerbParam(this.name,"iov","on_lasso_set_held"))if(!indirect_object.isDOV("hold"))this.game.debug("D2178",this.name+".js ",` ${indirect_object.id}.dov.hold is unset. ${indirect_object.id} won't be held by subject. `);else{if(subject.has(indirect_object))if(void 0!==(results=subject.onRemoveThatFromThis(indirect_object)))return results;this.game.dictionary.verbs.hold.setVerbConnection(indirect_object,subject);held=true}if(indirect_object.getVerbParam(this.name,"iov","on_lasso_set_tied"))if(!direct_object.isIOV("tie")||!indirect_object.isDOV("tie"))this.game.debug("D2176",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.with_params.on_lasso_set_tied is true but ${!direct_object.isIOV("tie")?direct_object.id+".iov.tie is unset":""} ${!indirect_object.isDOV("tie")?indirect_object.id+".dov.tie is unset":""}. ${direct_object.id} won't be tied to ${direct_object.id}. `);else{this.game.debug(`Fxxx | ${this.name}.js | on_lasso_set_tied > move ${indirect_object.id} in `+direct_object.id);if(void 0!==(results=indirect_object.onTieThisToThat(direct_object)))return results;indirect_object.moveTo("on",direct_object);console.warn("BUH?");tied=true}if(true===indirect_object.getVerbParam(this.name,"iov","on_lasso_set_attached"))if(!direct_object.hasAspectAt("attached"))this.game.debug("D2177",this.name+".js ",` on_lasso_set_attached > ${indirect_object.id}.iov.${this.name}.with_params.on_lasso_set_attached is true but ${direct_object.id+".aspects.attached is unset"}. ${indirect_object.id} won't be attached to ${direct_object.id}. `);else{this.game.debug(`Fxxx | ${this.name}.js | move ${indirect_object.id} attached `+direct_object.id);indirect_object.moveTo("attached",direct_object);attached=true}msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". "+indirect_object.Articlename+" "+(tied||attached?(tied?"ties ":"attaches ")+"tightly to ":"settles over ")+direct_object.articlename+((tied||attached)&&removed?" and":"")+(removed?" slips from {our} hands":"")+(held?" leaving {us} holding the other end":"")+". ";return this.handleSuccess(msg)}};A.Preverbs.lick={name:"lick",prettyname:"lick",past_tense:"licked",synonyms:["lick"],gerund:"licking",accepts_structures:["verb noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},with_params:{},doTry:function(){var input,direct_object=this.game.getInput().getAsset(1),msg="";if(!direct_object.isDOV("lick")){this.game.debug("D1332",this.name+".js ",` ${direct_object.id}.dov.lick.enabled is false `);msg+=`{We} can't lick ${direct_object.articlename}. `;this.handleFailure(msg)}else{if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1993",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} already ${this.past_tense} ${direct_object.articlename} enough. `;this.handleFailure(msg);return false}if(direct_object.hasDescription("taste"))return true;this.game.debug("D1333",this.name+".js ",` ${direct_object.id}.descriptions.taste is unset `);msg+=direct_object.Articlename+" has no particular taste. ";this.handleFailure(msg)}return null},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,input="",input=(input+=`{We} lick ${direct_object.articlename}. `)+this.game.getDescription({asset:direct_object,identifier:"taste"});return this.handleSuccess(input)}};A.Preverbs.lie={name:"lie",prettyname:"lie",past_tense:"lay",gerund:"laying",accepts_structures:["verb","verb noun","verb preposition","verb preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,not_direction:true,not_in_inventory:true},accepts_preposition:true,accepts_preposition_without_noun:true,requires_preposition:true},with_params:{},in_can_mean_on:true,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),nest_asset=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),input,msg="",input,already_on_it;if(input.hasStructure("verb")){if(subject.is.lying){this.game.debug("D1010",this.name+".js "," subject.is.lying");this.handleFailure(msg+="{We're} already lying! ");return null}direct_preposition=subject.getNestOrPlacePreposition();input.setPreposition(1,direct_preposition);direct_object=subject.getNestOrPlaceAsset();input.setStructure("verb preposition noun")}if(input.hasStructure("verb preposition"))if("down"===direct_preposition){if(subject.is.lying){this.game.debug("D1153",this.name+".js ",` ${subject.id}.is.lying`);this.handleFailure(msg+="{We} roll over fitfully. ");return null}if(nest_asset){direct_object=nest_asset;direct_preposition=nest_preposition}else{direct_object=this.game.getRoomFloor();direct_preposition="on"}if(direct_object){input.setAsset(1,direct_object);input.setPreposition(1,direct_preposition);input.setInferred(1,true);input.setStructure("verb preposition noun");this.game.printInferred(direct_preposition+" "+direct_object.articlename)}}else{this.game.debug("D1240",this.name+".js "," no direct object received or inferred");msg+=`{We} try to ${this.name} ${direct_preposition}, and fail. `;this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun")){if(!subject.can.lie||!direct_object.aspects[direct_preposition].canCharacter("lie")){this.game.debug("D1011",this.name+".js ",` subject.can.lie is false or ${direct_object.id}.aspects.${direct_preposition}.nest.can.lie is false`);msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(nest_asset&&nest_asset.id!==direct_object.id)if((input=this.canCharacterGoThereFromNest(direct_preposition,direct_object)).failure){this.handleFailure(input.msg);return null}if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition!==direct_preposition){this.game.debug("D1013",this.name+".js ",` subject is otherwise nested ${nest_preposition} `+nest_asset.id);msg+=`{We} can't do that from {our} position ${subject.getPostureGerund()} ${nest_preposition} ${nest_asset.articlename}. `;this.handleFailure(msg);return null}if(subject.is.lying){if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition===direct_preposition)already_on_it=true;if(!nest_asset&&direct_object instanceof adventurejs.Floor)already_on_it=true;if(already_on_it){this.game.debug("D1090",this.name+".js ",` ${subject.id}.is.lying ${direct_preposition} `+direct_object.id);msg+=`{We're} already lying ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}}}if((input=direct_object)?.placePreventsNesting(subject)){this.game.debug("D1170",this.name+".js ",` ${input.id}.is.deep_nest is false `);msg+=`{We} can't do that while ${input.articlename_is} 
          ${input.getPrettyPlacePreposition()}
          ${input.getPlaceAsset().articlename}. `;this.handleFailure(msg);return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),do_nest,do_unnest,fromfloor,tofloor,results,msg="",tofloor=direct_object instanceof adventurejs.Floor,fromfloor=!input||input instanceof adventurejs.Floor;if(fromfloor&&tofloor){do_nest=true;this.game.log("L1360","log","high",`[${this.name}.js] from floor to floor `,"verbs");msg+=`{We} ${subject.isOnFloor()?"shift positions to":""} ${this.name} on the floor. `}else if(fromfloor&&!tofloor||input&&input.id===direct_object.id){do_nest=fromfloor&&!tofloor;this.game.log("L1361","log","high",`[${this.name}.js] from floor to asset or change position on asset `,"verbs");msg+=`${fromfloor&&"stand"!==subject.posture?"{We} rise from the floor and ":"{We} "} ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&tofloor){do_unnest=true;this.game.log("L1362","log","high",`[${this.name}.js] from asset to floor `,"verbs");msg+=`{We} get ${subject.getPrettyUnnestPreposition()} ${input.articlename} and ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&!tofloor&&direct_object.id===input.id){if(subject.is.lying||subject.is.sitting||subject.is.kneeling){this.game.log("L1363","log","high",`[${this.name}.js] change posture on floor `,"verbs");msg+=`{We} ${this.agree()} ${nest_preposition} ${direct_object.articlename}. `}}else if(!fromfloor&&!tofloor&&direct_object.id!==input.id){do_unnest=do_nest=true;this.game.log("L1364","log","high",`[${this.name}.js] move from one asset to another `,"verbs");msg+=`{We} move over to ${direct_object.articlename} and ${this.name} ${direct_preposition} it. `}if(do_unnest&&input)if(void 0!==(results=subject.onUnnestThisFromThat(input)))return results;if(do_nest&&direct_object)if(void 0!==(results=subject.onNestThisToThat(direct_object,direct_preposition)))return results;subject.posture=this.name;return this.handleSuccess(msg)}};A.Preverbs.listen={name:"listen",synonyms:["listen"],past_tense:"listened",gerund:"listening",accepts_structures:["verb","verb noun","verb preposition noun","verb preposition noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,present:true},accepts_preposition:true,require_preposition:true,preposition_must_be:["to"]},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,room=this.game.getRoom(),room,hook,msg="";if(!subject.can.hear){this.game.debug("D1336",this.name+".js ",` ${subject.id}.can.hear is false `);this.handleFailure(msg+="{We} can't hear anything at all. ");return null}if(!subject.getNestOrPlaceAspect().canCharacter("hear")){this.game.debug("D1598",this.name+".js ",` ${subject.getNestOrPlaceAsset().id}.aspects.${subject.getNestOrPlacePreposition()}.nest.can.hear is false`);this.handleFailure(msg+="{We} can't hear anything here. ");return null}if(input.hasStructure("verb")){if(room.hasDescription("sound"))input.verb_params.source=room.descriptions.sound;else input.verb_params.source=this.game.getAreaScenery("global_sound");if(input.verb_params.source)return true;else{this.game.debug("D1782",this.name+".js "," no sound found ");this.handleFailure(msg+="{We} {don't} hear any particular sound. ");return null}}if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1599",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't hear ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(!direct_object.hasDescription("sound")){this.game.debug("D1413",this.name+".js ",` ${direct_object.id}.descriptions.sound is unset `);msg+=`{We} can't hear any particular sound from ${direct_object.articlename}. `;this.handleFailure(msg);return null}else input.verb_params.source=this.game.getDescription({asset:direct_object,identifier:"sound"});if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1783",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} have any way to ${this.name} to ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((room=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1784",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} to ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(room.success){indirect_object=room.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb preposition noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1786",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets does not include ${indirect_object.id} `);msg+=`${indirect_object.Articlename} can't be used to ${this.name} to ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1902",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1808",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(subject.id!==this.game.getPlayer().id)msg+=subject.articlename+" cocks {our} head to listen. ";else msg=(msg=(msg+=direct_object?"{We} tilt an ear toward "+direct_object.articlename:"")+(indirect_object?`${indirect_preposition} ${indirect_object.articlename}}`:"")+(direct_object?". ":""))+(input.verb_params.source?A.getSAF.call(this.game,input.verb_params.source):"{We} {don't} hear anything in particular. ");return this.handleSuccess(msg)}};A.Preverbs.locations={name:"locations",synonyms:["locations"],accepts_structures:["verb"],do:function(){for(var input=this.game.getInput(),player=this.game.getPlayer(),rooms=[],i=0;i<this.game.room_lookup.length;i++){var room=this.game.room_lookup[i];room=this.game.world[room];if(player.knowsAbout(room))rooms.push(room)}if(0===rooms.length){var msg="{We} haven't been anywhere. ";this.handleFailure(msg)}else if(0<rooms.length){for(var msg="Places {we've} visited include ",i=0;i<rooms.length;i++){var room=rooms[i];if(0<i&&i<rooms.length-1)msg+=", ";if(1<rooms.length&&i===rooms.length-1)msg+=" and ";msg=(msg+=room.use_definite_article_in_lists?room.definite_article+" ":"")+room.name}if(msg+=". ")this.game.print(msg,input.output_class)}return true}};A.Preverbs.lock={name:"lock",prettyname:"lock",past_tense:"locked",synonyms:["lock"],state:"locked",related:["unlock","pick"],state_strings:{state:"locked",unstate:"unlocked"},state_string:"locked",unstate_string:"unlocked",gerund:"locking",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,soft_prompt_for_asset,asset_in_player,subject,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1346",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1347",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1824",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1348",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1706",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1344",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1903",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1809",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="",autoclose;this.setState(direct_object,true);if(!direct_object.is.closed){direct_object.setIs("closed",true);direct_object.incrementDoVerbCount("close","dov");autoclose=true}msg=(msg=(msg=(msg+=`{We} ${autoclose?"close and ":""} `+this.name)+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:""))+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")).trim();return this.handleSuccess(msg+=". ")}};A.Preverbs.look={name:"look",prettyname:"look",past_tense:"looked",synonyms:["look","l"],gerund:"looking",accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun","verb preposition noun preposition noun preposition noun"],accepts_adverbs:["carefully","left","right","back","backward","forward","towards","upstairs","downstairs","sideways","over","out"],phrase1:{accepts_noun:true,noun_must_be:{known:true,matter:true,present:true,visible:true},accepts_preposition:true,accepts_preposition_without_noun:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true},accepts_preposition:true,requires_preposition:true},phrase3:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true},accepts_preposition:true,requires_preposition:true},with_params:{worn:false,held:false,must_be_worn:false,must_be_held:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),adverb=input.getAdverb(),room=this.game.getRoom(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),direct_container,indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_substance=input.getSubstance(2),indirect_container,indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),indirect_substance2=input.getSubstance(3),indirect_container2,msg="",results,atcount=0,wornoptics,lightemitters,contained;if(!subject.can.see){this.game.debug("D2135",this.name+".js ",` ${subject.id}.can.see is unset`);this.handleFailure(msg+="{We} can't see anything. ");return null}if(direct_object&&!direct_preposition);if(adverb)input.pushViewModifier(adverb,null,"input");wornoptics=subject.getWornOptics();for(let i=0;i<wornoptics.length;i++)this.pushViewModifierAndDeletePhrase("through",wornoptics[i],"auto");lightemitters=room.findNestedAssetsWithProperty("is.emitting_light");for(let i=0;i<lightemitters.length;i++){var light=lightemitters[i];if(light.must.hold_to_see_with&&!this.game.parser.selectInHands(light.id).length);else if(light.must.wear_to_see_with&&!this.game.parser.selectInHands(light.id).length);else this.pushViewModifierAndDeletePhrase("with",light,"auto")}if(subject.isNested())this.pushViewModifierAndDeletePhrase("from",subject.getNestAsset(),"auto");input.pushViewModifier("in",this.game.getRoom(),"auto");if(input.hasStructure("verb noun preposition noun")&&direct_object.direction){input.deletePhrase(1);direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);direct_substance=input.getSubstance(1);indirect_preposition="";indirect_substance=indirect_object=null}for(let phrase=input.getPhraseCount();0<phrase;phrase--){var prep=input.getPreposition(phrase),asset=input.getAsset(phrase),substance,nest;if(input.getSubstance(phrase)&&input.getPhrase(phrase+1)&&"in"===input.getPreposition(phrase+1))input.verified_sentence["phrase"+phrase].player_specified_container=true;switch(prep){case"at":if(1<++atcount){this.game.debug("D1595",this.name+".js ",' input includes multiple "at" targets ');msg+="That doesn't even make sense. ";this.handleFailure(msg);return null}if(asset.hasClass("Tangible"))this.pushViewModifierAndDeletePhrase(asset.getNestOrPlacePreposition(),asset.getNestOrPlaceAsset(),"auto");break;case"with":if(asset.is.viewport){if(void 0!==(results=this.tryThroughViewport(asset)))return results;this.pushViewModifierAndDeletePhrase("through",asset,"input")}else if(asset.is.light_source&&asset.is.on){if(void 0!==(results=this.tryWith(asset)))return results;this.pushViewModifierAndDeletePhrase(asset.is.viewport?"through":"with",asset,"input")}else if(asset.is.light_source&&!asset.is.on);else if(void 0!==(results=this.tryWith(asset)))return results;break;case"through":if(asset.is.viewport){if(void 0!==(results=this.tryThroughViewport(asset)))return results;this.pushViewModifierAndDeletePhrase("through",asset,"input")}else if(void 0!==(results=this.tryThroughDescription(asset)))return results;break;case"from":if(void 0!==(results=this.tryFrom(asset)))return results;this.pushViewModifierAndDeletePhrase("from",asset,"input");break;case"in":case"on":case"under":case"behind":break;default:break}}if(input.hasStructure("verb")){input.setPreposition(1,"at");input.setAsset(1,room);input.updateStructure()}else{if(input.hasStructure("verb preposition")){if(this.game.dictionary.getDirection(direct_preposition)){let exit=this.game.getExitFromDirection(direct_preposition);if(exit)exit=this.game.getAsset(exit);if(exit){input.setAsset(1,exit);input.setPreposition(1,"at");input.setStructure("verb preposition noun")}return true}this.game.debug("D1100",this.name+".js ",` received preposition/${direct_preposition} with no noun, soft prompt noun1`);input.setSoftPrompt({index:1,type:"noun",noun1:true});this.handleFailure(msg+=`Look ${direct_preposition} what? `);return null}direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);direct_substance=input.getSubstance(1);indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2);indirect_substance=input.getSubstance(2);indirect_object2=input.getAsset(2);indirect_preposition2=input.getPreposition(2);indirect_substance2=input.getSubstance(2);let reordered=false;if(input.hasStructure("verb preposition noun preposition noun")&&"at"===indirect_preposition){input.swapPhrases(1,2);reordered=true}if(input.hasStructure("verb preposition noun preposition noun preposition noun")&&"at"===indirect_preposition){reordered=true;input.swapPhrases(1,4);input.swapPhrases(2,1);input.swapPhrases(3,2);input.swapPhrases(4,3);input.deletePhrase(4)}if(input.hasStructure("verb preposition noun preposition noun preposition noun")&&"at"===indirect_preposition2){reordered=true;input.swapPhrases(3,4);input.swapPhrases(2,3);input.swapPhrases(1,2);input.swapPhrases(4,1);input.deletePhrase(4)}if(reordered){this.game.debug("D1852",this.name+".js "," reordering phrases in sentence");direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);direct_substance=input.getSubstance(1);indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2);indirect_substance=input.getSubstance(2);indirect_object2=input.getAsset(2);indirect_preposition2=input.getPreposition(2);indirect_substance2=input.getSubstance(2)}if(direct_substance){direct_container=direct_object;direct_object=direct_substance}if(indirect_substance){indirect_container=indirect_object;indirect_object=indirect_substance}if(indirect_substance2){indirect_container2=indirect_object2;indirect_object2=indirect_substance2}if(!direct_object.isDOV(this.name)){this.game.debug("D2127",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_preposition?direct_preposition:""} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1659",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} ${this.past_tense} ${direct_preposition?direct_preposition:"at"} ${direct_object.articlename} enough. `;this.handleFailure(msg);return false}if(direct_substance){this.game.debug("D2142",this.name+".js "," found substance ");if(indirect_substance){this.game.debug("D1406",this.name+".js ",` ${direct_object.id} and ${indirect_object.id} are both substances `);msg+=`{We} can't see any ${direct_substance.name} in ${indirect_substance.name}. `;this.handleFailure(msg);return null}if(indirect_object)if("in"===indirect_preposition){if(!indirect_object.containsSubstanceAt(direct_substance.id,indirect_preposition)){this.game.debug("D1651",this.name+".js ",` ${indirect_object.id}${indirect_preposition?".aspects."+indirect_preposition:""} doesn't contain ${direct_substance.id} `);msg+=`{We} can't see any ${direct_substance.name} ${indirect_preposition?indirect_preposition:"in"} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_container.id!==indirect_object.id){input.setContainer(1,indirect_object);direct_container=indirect_object}input.deletePhrase(2)}input.pushViewModifier("in",direct_container,"auto")}else{if(input.hasStructure("verb preposition noun")&&input.parsedNoun1.matches.direction){if("at"===direct_preposition)return true;if(direct_object.hasDescription(direct_preposition))return true;this.game.debug("D1587",this.name+".js ",` ${direct_object.id}.descriptions.${direct_preposition} is unset`);msg+=`{We} {don't} know how to ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun")){if("at"===direct_preposition)return true;if(["in","on","under","behind"].includes(direct_preposition)&&!direct_object.hasAspectAt(direct_preposition)){this.game.debug("D2141",this.name+".js ",` ${direct_object.id}.aspects.${direct_preposition} is unset`);msg+=`{We} {don't} see anything ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg)}else{if(direct_object.hasDescription(direct_preposition)||direct_object.hasAspectAt(direct_preposition))return true;this.game.debug("D1017",this.name+".js ",` ${direct_object.id}.aspects.${direct_preposition} is not defined`);msg+=`{We} can't see anything ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg)}return null}else if(input.hasStructure("verb noun preposition noun")||input.hasStructure("verb preposition noun preposition noun")){if(!indirect_preposition){this.game.debug("D1228",this.name+".js "," no indirect_preposition");msg+=`{We} can't look ${direct_preposition} ${direct_object.articlename} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if("with"===indirect_preposition&&indirect_object.hasQuirk("look_with_means_look_through")){this.game.debug("D1848",this.name+".js "," direct_preposition 'with' means 'through'");input.setPreposition(2,indirect_preposition="through")}if("with"===indirect_preposition){if(void 0!==(results=this.tryWith(indirect_object)))return results}else if("through"===indirect_preposition){this.game.debug("D1849",this.name+".js "," direct_preposition 'through'");if(void 0!==(results=this.tryThroughViewport(indirect_object)))return results;if(void 0!==(results=this.tryThroughDescription(indirect_object)))return results}else if("out"===indirect_preposition){this.game.debug("D1387",this.name+".js "," direct_preposition 'out'");if(void 0!==(results=this.tryThroughViewport(indirect_object)))return results}else if("from"===indirect_preposition){this.game.debug("D1850",this.name+".js "," direct_preposition 'from'");if(void 0!==(results=this.tryFrom(indirect_object)))return results}else if(!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D1226",this.name+".js ",` ${indirect_object.id} has no ${indirect_preposition} aspect`);msg+=`${direct_object.Articlename_is} not ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}else if(indirect_object.hasAspectAt(indirect_preposition)&&!direct_object.isPlacedAtAspectAndAsset(indirect_preposition,indirect_object.id)){this.game.debug("D1225",this.name+".js ",` ${direct_object.id} not ${indirect_preposition} `+indirect_object.id);msg+=`${direct_object.Articlename_is} not ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}else if("at"!==direct_preposition&&!direct_object.hasAspectAt(direct_preposition)){this.game.debug("D1227",this.name+".js ",` ${direct_preposition} is not at`);msg+=`{We} can't look ${indirect_preposition} ${indirect_object.articlename} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}}}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),adverb=input.getAdverb(),nest_asset=subject.getNestAsset(),room=this.game.getRoom(),msg="",direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),direct_container,direct_container_preposition,player_specified_container=input.verified_sentence.phrase1.player_specified_container,indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_substance=input.getSubstance(2),indirect_container,indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),indirect_substance2=input.getSubstance(3),indirect_container2;if(subject.id!==this.game.getPlayer().id)msg+=`${subject.articlename} glances 
          ${direct_object&&direct_object.hasClass("Room")?"around":direct_object?"towards "+direct_object.articlename:"around"}. `;else{if(direct_substance){direct_container=direct_object;direct_object=direct_substance;direct_container_preposition=direct_container.getVessel().preposition}if(indirect_substance){indirect_container=indirect_object;indirect_object=indirect_substance}if(indirect_substance2){indirect_container2=indirect_object2;indirect_object2=indirect_substance2}if(direct_object.id===room.id)this.game.printRoom({verbose:true});else{if(direct_object.is.global)msg+=this.game.getAreaScenery(direct_object);else if(direct_object.direction||direct_object.hasClass("Exit"))msg+=this.game.getModifiedDescription({asset:direct_object,identifier:direct_preposition,fallback_base:false})||this.game.getDescription({asset:direct_object,identifier:direct_preposition})||`{We} see a passage leading ${direct_object.direction}${direct_object.destination&&direct_object.is.used?" to the "+direct_object.destination:""}. `;else if(direct_substance){if(!player_specified_container)if(direct_container.is.reservoir)msg+=`{We} consider the ${direct_substance.name} of ${direct_container.articlename}. `;else msg+=`{We} see some ${direct_substance.name} ${direct_container_preposition} ${direct_container.articlename}. `;if("in"===direct_preposition)direct_preposition="at";if("at"===direct_preposition){msg+=this.game.getModifiedDescription({asset:direct_object,identifier:direct_preposition,fallback_base:false})||this.game.getDescription({asset:direct_object,identifier:direct_preposition});subject.knowAspect(direct_container,direct_container_preposition,true);if(!direct_container.hasClass("Room")&&direct_container.aspects[direct_container_preposition].list_contents_in_examine)msg+=direct_container.getPrintableListOfContentsAt(direct_container_preposition,{exclude_substance:true})}else{this.game.debug("D1048",this.name+".js ",` not at, ${direct_preposition} `+direct_substance.id);msg+=this.game.getModifiedDescription({asset:direct_substance,identifier:direct_preposition,fallback_base:false})||this.game.getDescription({asset:direct_object,identifier:direct_preposition});subject.knowAspect(direct_container,direct_container_preposition,true);if(!direct_container.hasClass("Room"))msg+=direct_container.getPrintableListOfContentsAt(direct_container_preposition,{caller:"examine",exclude_substance:true});if(!msg)msg+=`Looking ${adverb?adverb:""} ${direct_preposition?direct_preposition:"at"} ${direct_object.articlename} doesn't reveal anything notable. `}}else{if("in"===direct_preposition&&direct_object.isDOV("close")&&direct_object.is.closed&&direct_object.appearance.opacity<=1)msg+=this.game.getModifiedDescription({asset:direct_object,identifier:direct_preposition})||`{We} can't see into ${direct_object.articlename} while it's closed. `;if("at"===direct_preposition){msg+=this.game.getModifiedDescription({asset:direct_object,identifier:direct_preposition,fallback_base:false})||this.game.getDescription({asset:direct_object,identifier:direct_preposition});this.game.log("L1330","log","high",`[${this.name}.js] at: print ${direct_object.id}.aspects`,"Verbs");for(var item in direct_object.aspects){var item=direct_object.aspects[item];if("in"===item.name&&direct_object.isDOV("open")&&direct_object.is.closed&&1<=direct_object.appearance.opacity);else{if(item.know_contents_with_parent)subject.knowAspect(direct_object,item,true);if(!item.list_contents_in_examine);else msg+=direct_object.getPrintableListOfContentsAt(item.name,{})}}}else if(direct_object.hasAspectAt(direct_preposition)||direct_object.hasDescription(direct_preposition)){this.game.debug("D1051",this.name+".js "," not at, hasAspectAt || hasDescription");msg+=this.game.getModifiedDescription({asset:direct_object,identifier:direct_preposition,fallback_base:false});if(direct_object.hasAspectAt(direct_preposition)){subject.knowAspect(direct_object,direct_preposition,true);msg+=direct_object.getPrintableListOfContentsAt&&direct_object.getPrintableListOfContentsAt(direct_preposition,{caller:"examine",exclude_substance:true})||""}}else msg+=direct_object.getPrintableListOfContents&&direct_object.getPrintableListOfContents({caller:"examine"})||`Looking ${adverb?adverb:""} ${direct_preposition?direct_preposition:"at"} ${direct_object.articlename} doesn't reveal anything notable. `;if(direct_object.appearance.scribbles)msg+="A few scribbles have been drawn on it. ";if(direct_object.written_strings.length&&direct_object.append_written_strings_to_description){if(1===direct_object.written_strings.length)msg=(msg+=`A line of text has been written on it in ${this.game.settings.apply_color_classes_to_written_strings?direct_object.written_strings[0].color:""} ${direct_object.written_strings[0].class.toLowerCase()}: `)+`<br> <span class="${direct_object.written_strings[0].class.toLowerCase()} ${direct_object.written_strings[0].color}">"${direct_object.written_strings[0].data}"</span>`;else{msg+="Several lines of text have been written on it: ";for(var i=0;i<direct_object.written_strings.length;i++)msg+=`<br> <span class="string ${direct_object.written_strings[i].class.toLowerCase()} ${this.game.settings.apply_color_classes_to_written_strings?direct_object.written_strings[i].color:""}">"${direct_object.written_strings[i].data}"</span>`}msg=msg.trim();msg+=". "}if(direct_object.typed_strings.length&&direct_object.append_typed_strings_to_description)if(1===direct_object.typed_strings.length)msg=msg+"A line of text has been typed on it: "+`<br> "${direct_object.typed_strings[0]}"`;else{msg+="Several lines of text have been typed on it: ";for(var i=0;i<direct_object.typed_strings.length;i++)msg+=`<br> "${direct_object.typed_strings[i]}"`}if(direct_object.drawn_things?.length)if(1===direct_object.drawn_things.length)msg+=`${A.capitalize(direct_object.drawn_things[0].data)} has been drawn there in ${this.game.settings.apply_color_classes_to_drawn_things?direct_object.drawn_things[0].color:""} ${direct_object.drawn_things[0].class.toLowerCase()}. `;else{msg+="Some things been drawn there: ";for(let i=0;i<direct_object.drawn_things.length;i++){if(0<i&&i<direct_object.drawn_things[i].length-1)msg+=", ";if(1<direct_object.drawn_things[i].length&&i===direct_object.drawn_things[i].length-1)msg+=" and ";msg+="a "+direct_object.drawn_things[i].data}msg+=". "}if(direct_object.isConnectedToAnything("tie","to_iov")){var indirect_substance={objects:direct_object.getVerbConnections("tie","to_iov")},msg=(msg=(msg=(msg+=direct_object.Articlename_is+" tied to ")+this.game.getPrintableObjectList(indirect_substance))+(direct_object.isWithin(subject)?", while {we} hold an end of it":"")).trim();msg+=". "}else if(direct_object.isConnectedToAnything("tie","to_dov")){var connections=direct_object.getVerbConnections("tie","to_dov");for(let r=0;r<connections.length;r++){var rope=this.game.getAsset(connections[r]);msg+=`Tied to ${direct_object.articlename} is a `+rope.name;if(1<rope.getVerbConnectionCount("tie","to_iov")){let objects={objects:rope.getVerbConnections("tie","to_iov"),exclusions:direct_object.id};msg+=", which is also tied to "+this.game.getPrintableObjectList(objects)}msg=(msg+=rope.isWithin(subject)?", while {we} hold an end of it":"").trim();msg+=". "}}}if(input.view_modifiers.length){var indirect_object="",indirect_substance2="";let middle="",count=0,adverb_modifier="";for(let i=0;i<input.view_modifiers.length;i++){var modifier=input.view_modifiers[i];if("input"===modifier.type&&!modifier.used)if(modifier.adverb)adverb_modifier=modifier.identifier;else{var comma=0===count?"":",";count++;middle=(middle+=comma)+(` ${modifier.identifier} `+(modifier.asset?modifier.asset.articlename:""))+comma}}indirect_object=(indirect_object+=`Looking ${adverb_modifier?adverb_modifier:""} `)+`${direct_preposition?direct_preposition:"at"} `+(""+direct_object.articlename);indirect_substance2+=" reveals nothing new. ";if(1<count)middle=", "+middle;if(middle)msg=indirect_object+middle+indirect_substance2+msg}if(!msg){this.game.debug("D1031",this.name+".js "," no description found");msg+=`Looking ${adverb?adverb:""} ${direct_preposition?direct_preposition:"at"} ${direct_object.articlename} doesn't reveal anything notable. `}}}return this.handleSuccess(msg)},tryThroughViewport:function(asset){var msg="";if(asset.must.wear_to_look_through&&!asset.is.worn){this.game.debug("D1015",this.name+".js ",` ${asset.id}.must.wear_to_look_through and ${asset.id}.is.worn is false`);msg+=`{We're} not wearing ${asset.articlename}. `;this.handleFailure(msg);return null}if(asset.must.hold_to_see_through&&!this.game.parser.selectInHands(asset.id).length){this.game.debug("D1014",this.name+".js ",` ${asset.id}.must.hold_to_see_through and ${asset.id} is not held`);msg+=`{We're} not holding ${asset.articlename}. `;this.handleFailure(msg);return null}},tryThroughDescription:function(asset){var msg="";if(!asset.hasDescription("through")){this.game.debug("D1851",this.name+".js ",` ${asset.id}.descriptions.through not found`);if(1<asset.appearance.opacity)msg+=`Though ${asset.articlename} is 
              ${.5<asset.appearance.opacity?"translucent":"transparent"}, 
              {we} can't ${this.name} through it. `;else msg+=`{We} can't ${this.name} through ${asset.articlename}. `;this.handleFailure(msg);return null}},tryWith:function(asset){var msg="";if(!asset.isIOV("look")){this.game.debug("D1224",this.name+".js ",` ${asset.id}.iov.look.enabled is false`);msg+=`{We} can't look with ${asset.articlename}. `;this.handleFailure(msg);return null}if(asset.must.wear_to_look_with&&!asset.is.worn){this.game.debug("D1845",this.name+".js ",` ${asset.id}.must.wear_to_look_with and ${asset.id}.is.worn is false`);msg+=`{We're} not wearing ${asset.articlename}. `;this.handleFailure(msg);return null}if(asset.must.hold_to_see_with&&!this.game.parser.selectInHands(asset.id).length){this.game.debug("D2140",this.name+".js ",` ${asset.id}.must.hold_to_see_with and ${asset.id} is not held`);msg+=`{We're} not holding ${asset.articlename}. `;this.handleFailure(msg);return null}},tryFrom:function(asset){var msg="";if(asset.id===this.game.getInput().getSubject().getNestOrPlaceAsset().id);else{this.game.debug("D1016",this.name+".js "," subject not nested within "+asset.id);msg+=`{We're} not ${asset.default_aspect} ${asset.articlename}. `;this.handleFailure(msg);return null}},pushViewModifierAndDeletePhrase:function(identifier,asset,type){var input=this.game.getInput();for(let m=0;m<input.view_modifiers.length;m++)if(input.view_modifiers[m].asset&&asset?.id===input.view_modifiers[m].asset.id){input.view_modifiers[m].type=type;return}for(let phrase=input.getPhraseCount();0<phrase;phrase--){var inputprep=input.getPreposition(phrase),inputasset=input.getAsset(phrase);if(inputprep===identifier&&inputasset?.id===asset.id){input.deletePhrase(phrase);type="input"}}if(identifier)input.pushViewModifier(identifier,asset,type)}};A.Preverbs.move={name:"move",prettyname:"move",past_tense:"moved",synonyms:["move","slide"],gerund:"moving",accepts_structures:["verb","verb noun","verb noun noun","verb noun preposition","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,accepts_preposition_without_noun:true},phrase3:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),room,msg="",direct_object_place_asset=direct_object?.getPlaceAsset(),direct_object_place_preposition=direct_object?.getPlacePreposition(),room=this.game.getRoom();if(input.hasStructure("verb"));else{if((indirect_object&&indirect_object.hasClass("Floor")||indirect_object2&&indirect_object2.hasClass("Floor"))&&!room.has_floor){this.game.debug("D1680",this.name+".js ",` ${room.id}.has_floor is false `);this.handleFailure(msg+="{We} can't see a floor here. ");return null}if(indirect_object&&indirect_object.hasClass("Floor")){indirect_object=this.game.getRoom();input.setAsset(2,indirect_object)}if(indirect_object2&&indirect_object2.hasClass("Floor")){indirect_object2=this.game.getRoom();input.setAsset(3,indirect_object2)}if(!direct_object.isDOV(this.name)&&!direct_object.isDOV("take")){this.game.debug("D1351",this.name+".js ",` ${direct_object.id}.dov.move.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(indirect_object&&indirect_object.direction&&!direct_object.can.drag_between_rooms&&!direct_object.isDOV("take")){this.game.debug("D1352",this.name+".js ",` ${direct_object.id}.can.drag_between_rooms is false `);msg+=`{We} try to ${this.name} ${direct_object.articlename} ${indirect_object.direction}, but ${direct_object.getPronoun("we're")} not going anywhere. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition")){if(this.game.dictionary.direction_lookup[indirect_preposition]||"over"!==!indirect_preposition)return true;this.game.debug("D2083",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun noun"))if(!indirect_object.direction){this.game.debug("D1675",this.name+".js ",` ${indirect_object.id} is not direction `);msg+=this.game.settings.getUnparsedMessage(input.getInput());this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun")){if(direct_object===indirect_object){this.game.debug("D1676",this.name+".js ",` direct_object ${direct_object.id} is indirect_object ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${direct_object.getPronoun("ourself")}. `;this.handleFailure(msg);return null}if("across"===indirect_preposition||"over"===indirect_preposition)indirect_preposition="on";if(direct_object_place_preposition===indirect_preposition&&direct_object_place_asset.id===indirect_object.id){this.game.debug("D1109",this.name+".js ",` ${direct_object.id} is already ${indirect_preposition} ${indirect_object.id} `);msg+=`{We} ${this.agree()} ${direct_object.articlename} around ${indirect_preposition} ${indirect_object.articlename} a bit. `;this.handleFailure(msg);return null}if("from"===indirect_preposition)if(!direct_object.isWithin(indirect_object)){this.game.debug("D1107",this.name+".js ",` ${direct_object.id} is not within ${indirect_object.id} `);msg+=`${direct_object.Articlename_isnt}  anywhere within ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if("off"===indirect_preposition){if(!direct_object.isOn(indirect_object)){this.game.debug("D1107",this.name+".js ",` ${direct_object.id} is not on ${indirect_object.id} `);msg+=`${direct_object.Articlename_isnt}  on ${indirect_object.articlename}. `;this.handleFailure(msg);return null}input.setPreposition(2,"from");indirect_preposition="from"}if("out"===indirect_preposition){if(!direct_object.isIn(indirect_object)){this.game.debug("D2065",this.name+".js ",` ${direct_object.id} is not in ${indirect_object.id} `);msg+=`${direct_object.Articlename_isnt}  in ${indirect_object.articlename}. `;this.handleFailure(msg);return null}input.setPreposition(2,"from");indirect_preposition="from"}}if(input.hasStructure("verb noun preposition noun")&&"to"===indirect_preposition){if(direct_object_place_asset.id===indirect_object.id){this.game.debug("D2086",this.name+".js ",` ${direct_object.id} is already ${direct_object_place_preposition} ${indirect_object.id} `);msg+=`${direct_object.Articlename_is} already ${direct_object_place_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}this.game.debug("D2067",this.name+".js ",` move ${direct_object.id} to ${indirect_object.id} `);input.setAsset(3,direct_object_place_asset);input.setPreposition(3,"from");input.swapPhrases(2,3);input.setStructure("verb noun preposition noun preposition noun");indirect_object=input.getAsset(2);indirect_object2=input.getAsset(3);indirect_preposition=input.getPreposition(2);indirect_preposition2=input.getPreposition(3)}if(input.hasStructure("verb noun preposition noun")&&"from"===indirect_preposition){if(indirect_object.hasClass("Room")){this.game.debug("D2066",this.name+".js ",` ${direct_object.id} can't be ${this.past_tense} from ${indirect_object.id} `);msg+=`${direct_object.Articlename} can't be ${this.past_tense} from ${indirect_object.articlename}. `;this.handleFailure(msg);return null}input.setAsset(3,direct_object.getPlaceAsset());input.setPreposition(3,"to");input.setStructure("verb noun preposition noun preposition noun");indirect_object2=input.getAsset(3);indirect_preposition2=input.getPreposition(3)}if(input.hasStructure("verb noun preposition noun")){if("toward"===indirect_preposition||"near"===indirect_preposition){if(direct_object.isWithin(subject)&&indirect_object.isWithin(subject)){this.game.debug("D1110",this.name+".js ",` subject is carrying ${direct_object.id} and ${indirect_object.id} `);msg+=`{We} rub ${direct_object.articlename} against ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.isWithin(subject)&&!indirect_object.isWithin(subject)){this.game.debug("D1683",this.name+".js ",` subject is carrying ${direct_object.id} and not ${indirect_object.id} `);msg+=`{We} wave ${direct_object.articlename} toward ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object_place_asset.id===indirect_object.id){this.game.debug("D1677",this.name+".js ",` ${direct_object.id} is ${direct_object_place_preposition} `+indirect_object.id);msg+=`${direct_object.Articlename_is} already as close to ${indirect_object.articlename} as ${direct_object.getPronoun("we")} can get. `;this.handleFailure(msg);return null}if(direct_object_place_asset.id!==indirect_object.getPlaceAssetId()){this.game.debug("D1682",this.name+".js ",` ${direct_object.id} is not in the same place as ${indirect_object.id} `);msg+=`{We} slide ${direct_object.articlename} slightly in the direction of ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}else if(!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D1679",this.name+".js ",` ${indirect_object.id} has no aspect at ${indirect_preposition} `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(indirect_object.hasAspectAt(indirect_preposition))if((room=this.tryToPutThisInThatAspect(direct_object,indirect_preposition,indirect_object)).fail){msg=room.msg;this.handleFailure(msg);if(room.end_turn)return false;else return null}}if(input.hasStructure("verb noun preposition noun preposition noun")){if("to"===indirect_preposition&&"from"===indirect_preposition2){input.swapPhrases(2,3);indirect_preposition="from";indirect_preposition2="to";indirect_object=input.getAsset(2);indirect_object2=input.getAsset(3)}if("from"!==indirect_preposition||"to"!==indirect_preposition2){this.game.debug("D1686",this.name+".js "," sentence structure is 'verb noun preposition noun preposition noun' but phrase is not handled");msg+=this.game.settings.getUnparsedMessage(input.getInput());this.handleFailure(msg);return null}if(direct_object.getPlaceAssetId()!==indirect_object.id){this.game.debug("D1687",this.name+".js ",` ${direct_object.id} is not ${indirect_object.default_aspect} `+indirect_object.id);msg+=`${direct_object.Articlename_is} not ${indirect_object.default_aspect} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),msg="",results,results1,results2,direction;if(input.hasStructure("verb"))msg+=`{We} ${this.agree()} around a bit. `;if(input.hasStructure("verb noun"))msg+=`{We} ${this.agree()} ${direct_object.articlename} a bit. `;if(input.hasStructure("verb noun preposition"))msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} a bit. `;if(indirect_object&&indirect_object.direction)if(direct_object.can.drag_between_rooms){results=this.game.tryTravel(indirect_object.direction,{with:[direct_object.id]});if(A.isFalseOrNull(results))return results}else var direction=this.game.getVerb(indirect_object.direction),adjective=direction?.adjective,direction=direction?.article,msg=(msg+=`{We} ${this.agree()} ${direct_object.articlename} a bit`)+(" "+(direction?"to "+direction:"towards"))+` ${indirect_object.direction}. `;if(input.hasStructure("verb noun preposition noun"))if(direct_object.getPlaceAsset().id===indirect_object.id&&("across"===indirect_preposition||"over"===indirect_preposition||indirect_preposition===direct_object.getPlacePreposition()))msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;else if(["toward","near"].includes(indirect_preposition))msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;else{if(void 0!==(results=(direction=direct_object.getPlaceAsset()).onRemoveThatFromThis(direct_object)))return results;if(direction.id!==subject.id){if(void 0!==(results=subject.onMoveThatToThis(direct_object)))return results;if(void 0!==(results=subject.onRemoveThatFromThis(direct_object)))return results}if("off"===indirect_preposition){indirect_preposition=indirect_object.getPlacePreposition();results=(indirect_object=indirect_object.getPlaceAsset()).onMoveThatToThis(direct_object,indirect_object.getPlacePreposition())}else results=indirect_object.onMoveThatToThis(direct_object,indirect_preposition);if(void 0!==results)return results;msg=`{We} ${this.agree()} ${direct_object.articlename} from ${direction.hasClass("Room")?"the floor":direction.articlename} to ${indirect_object.hasClass("Room")?"the floor":indirect_object.articlename}. `}if(input.hasStructure("verb noun preposition noun preposition noun")){if(void 0!==(results=indirect_object.onRemoveThatFromThis(direct_object)))return results;if(indirect_object.id!==subject.id){if(void 0!==(results=subject.onMoveThatToThis(direct_object)))return results;if(void 0!==(results=subject.onRemoveThatFromThis(direct_object)))return results}if(void 0!==(results=indirect_object2.onMoveThatToThis(direct_object,indirect_object2.default_aspect)))return results;if(indirect_object.id===subject.id&&indirect_object2.hasClass("Room"))msg+=`{We} drop ${direct_object.articlename}. `;else if(indirect_object.id===subject.id)msg=(msg+=`{We} put ${direct_object.articlename} `)+(indirect_object.hasClass("Room")?" on the floor":indirect_object2.default_aspect+" "+indirect_object2.articlename);else if(indirect_object2.id===subject.id){msg=(msg=(msg+=`It's a strange way to phrase it, but {we} take ${direct_object.articlename} from `)+(indirect_object.hasClass("Room")?"the floor":""+indirect_object.articlename)).trim();msg+=". "}else{msg=(msg=(msg=(msg+=`{We} ${this.agree()} ${direct_object.articlename} from `)+(indirect_object.hasClass("Room")?"the floor":""+indirect_object.articlename)+" to ")+(indirect_object2.hasClass("Room")?"the floor":""+indirect_object2.articlename)).trim();msg+=". "}}return this.handleSuccess(msg)}};A.Preverbs.nothing={name:"nothing",prettyname:"nothing",synonyms:["nothing"],accepts_structures:["verb"],do:function(){var input=this.game.getInput(),msg="{We} do nothing.";if(msg)this.game.print(msg,input.output_class)}};A.Preverbs.oops={name:"oops",synonyms:["o"],accepts_structures:["verb noun","verb verb"],phrase1:{accepts_noun:true,requires_noun:true},let_verb_handle_disambiguation:true,let_verb_handle_remaining_input:true,msgNoObject:"Oops?",do:function(){var input,replacementWord=this.game.getInput().input.substring(4).trim();this.game.log("L1359","log","high","oops "+replacementWord,"verbs");if("object"==typeof replacementWord)replacementWord=replacementWord.input;var lastInput=this.game.parser.input_history[1].parsed_input;if(!this.game.parser.input_history[1].unknown_word){var msg="Oops indeed.";this.handleFailure(msg);return false}var lastInputUnknownWord=this.game.parser.input_history[1].unknown_word;if(void 0!==lastInputUnknownWord){lastInput=lastInput.replace(lastInputUnknownWord,replacementWord);this.game.parser.input_queue.push({input:lastInput,printInput:false})}else{if(!replacementWord){var msg="Oops found nothing to oops.";this.handleFailure(msg);return false}var msg=`Oops found ${replacementWord}. `;this.handleFailure(msg);return true}}};A.Preverbs.open={name:"open",prettyname:"open",past_tense:"opened",synonyms:["open"],unstate:"closed",enqueue_collections:true,gerund:"opening",accepts_structures:["verb noun","verb noun preposition noun"],accepts_adverbs:["quietly","quickly","gently","slowly","carefully","cautiously"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,singular:false}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(direct_object.linked_components?.Drain){if(!(direct_object=this.game.getAsset(direct_object.linked_components.Drain)))return null;input.setAsset(1,direct_object);input.setInferred(1,true)}if(direct_object.isDOV("unplug")&&direct_object.is.plugged){this.game.debug("D1367",this.name+".js ",` ${direct_object.id}.dov.plug, doVerb plug `);return this.game.dictionary.doVerb("unplug")}for(var openverbs=["unlock","pick","unseal","unzip"],i=0;i<openverbs.length;i++)if(direct_object.isDOV(openverbs[i])&&!direct_object.isVerbState(openverbs[i])){if(direct_object.allowVerbWithNothing(openverbs[i],"dov")){input.verb_params.auto_open=true;this.game.log("L1087","log","high",`[${this.name}.js] ${direct_object.id}.is.locked, doVerb unlock `,"verbs");return this.game.dictionary.doVerb(openverbs[i])}this.game.debug("D1703",this.name+".js ",` ${direct_object.id}.is.`+this.game.dictionary.verbs[openverbs[i]].getState());msg+=`${direct_object.Articlename_is} ${this.game.dictionary.verbs[openverbs[i]].getState()}. `;this.handleFailure(msg);return false}if(!direct_object.isDOV(this.name)){this.game.debug("D1144",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1145",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_isnt}  ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1825",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1754",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).allow)return true;if(subject.prompt){this.game.debug("D1756",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1357",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1904",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1810",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;this.setState(direct_object,false);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";if(direct_object.hasContentsAtAspect("in")){subject.knowAspect(direct_object,"in",true);msg+=direct_object.getPrintableListOfContentsAt("in")}return this.handleSuccess(msg)}};A.Preverbs.peddle={name:"peddle",prettyname:"peddle",past_tense:"peddled",synonyms:["peddle"],type:{locomotion:true,travel:true},extends:{ride:true},gerund:"peddling",subject_must_be:{not_constrained:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb noun noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("ride")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.pick={name:"pick",prettyname:"pick",past_tense:"picked",synonyms:["pick"],unstate:"locked",gerund:"picking",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(!direct_object.isDOV("pick")){this.game.debug("D1362",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=direct_object.isDOV("unlock")?`{We're} unable to pick ${direct_object.articlename}. `:`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1363",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is false`);msg+=`${direct_object.Articlename_isnt}  ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1826",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1466",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1364",this.name+".js "," soft prompt for noun2 ");msg=(msg+=input.verb_params.auto_open?direct_object.Articlename_is+" locked. ":"")+`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1702",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1905",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1811",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="",auto_open=false;if(input.verb_params.auto_open){direct_object.setIs("closed",false);direct_object.incrementDoVerbCount("open","dov");auto_open=true}this.setState(direct_object,false);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+(auto_open?" and open it":"")+". ";if(auto_open&&direct_object.hasContentsAtAspect("in"))msg+=direct_object.getPrintableListOfContentsAt("in");return this.handleSuccess(msg)}};A.Preverbs.plug={name:"plug",prettyname:"plug",past_tense:"plugged",synonyms:["plug"],state:"plugged",state_strings:{state:"plugged",unstate:"unplugged"},state_string:"plugged",unstate_string:"unplugged",gerund:"plugging",makes_connections:true,accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,in_inventory_if_takeable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with","in"]},with_params:{on_take_break_connections:true,on_take_take_connections:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,drain,msg="",drain;if(direct_object.linked_components?.Drain)if(drain=this.game.getAsset(direct_object.linked_components.Drain)){input.setAsset(1,direct_object=drain);input.setInferred(1)}if(indirect_preposition&&"in"===indirect_preposition&&indirect_object.isDOV(this.name)){input.swapPhrases(1,2);input.setPreposition(1,"");input.setPreposition(2,"with");input.updateStructure;direct_object=input.getAsset(1);indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2)}if(!direct_object.isDOV(this.name)){this.game.debug("D1730",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1766",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1827",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1366",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((drain=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1470",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(drain.success){indirect_object=drain.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1715",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1906",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1812",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_place=direct_object.getPlaceAsset(),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results;if(input.hasStructure("verb noun preposition noun")){if(indirect_object.isWithin(subject))if(void 0!==(results=indirect_object.moveFrom(subject)))return results;if(void 0!==(results=indirect_object.moveTo("in",direct_object)))return results}this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.plugIn={name:"plugIn",prettyname:"plug in",past_tense:"plugged in",verb_noun_prep:["plug in"],verb_prep_noun:["plug in"],verb_noun_prep_noun:["plug into","plug in"],state:"pluggedIn",state_string:"plugged in",unstate_string:"not plugged in",gerund:"plugging in",makes_connections:true,accepts_structures:["verb noun","verb noun noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["in"]},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["to","in","with"]},with_params:{max_connections:1,on_take_break_connections:true,on_take_take_connections:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,results,msg="",drain;if(!direct_object.isDOV(this.name)){if(indirect_object?.isDOV("plug")){input.swapPhrases(1,2);input.setPreposition(1,"");input.setPreposition(2,"with");input.updateStructure();return this.game.dictionary.doVerb("plug")}else if(direct_object?.isDOV("plug"))return this.game.dictionary.doVerb("plug");this.game.debug("D1765",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if("plug in"===input.verb_phrase&&(input.hasStructure("verb preposition noun")||input.hasStructure("verb noun preposition")))input.setStructure("verb noun");if(direct_object.allowVerbWithNothing(this.name,"dov")&&direct_object.isConnectedToNothing(this.name,"dov")){this.game.debug("D1358",this.name+".js ",` ${direct_object.id}.is.connected_by.plugIn.to_iov contains null `);msg+=direct_object.Articlename_is+" already plugged in. ";this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1690",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.prettyname} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((results=this.tryToInferIndirectObject({direct_object:direct_object,context:this.game.getRoom(),handle_input:false,infer_first_use:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1692",this.name+".js "," soft prompt for noun2 ");input.setSoftPrompt({index:2,type:"noun",noun2:true,structure:"verb noun noun"});msg+=`What would {we} like to plug ${direct_object.articlename} into? `;this.handleFailure(msg);return false}else if(results.success){indirect_object=results.indirect_object;input.pushPhrase({asset:indirect_object,preposition:indirect_preposition="to"});input.setStructure("verb noun noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1763",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't plug ${direct_object.articlename} into ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1907",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1813",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}if(direct_object.getVerbConnectionCount(this.name,"to_iov")>=direct_object.getVerbMaxConnections(this.name,"dov")){this.game.debug("D1752",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_params.max_connections reached `);msg+=direct_object.isConnectedToAsset(this.name,indirect_object,"to_iov")?`${direct_object.Articlename_is} already plugged into ${indirect_object.articlename}. `:direct_object.Articlename+" can't be plugged into any more things. ";this.handleFailure(msg);return null}if(indirect_object.is.connected_by[this.name]&&indirect_object.getVerbConnectionCount(this.name,"to_dov")>=indirect_object.getVerbMaxConnections(this.name,"iov")){this.game.debug("D1760",this.name+".js ",` ${indirect_object.id}.iov.plugIn.with_params.max_connections reached `);msg+=indirect_object.Articlename+" can't have any more things plugged into it. ";this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_place=direct_object.getPlaceAsset(),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results;if(input.hasStructure("verb noun"))this.setVerbConnection(direct_object,null);if(input.hasStructure("verb noun noun"))this.setVerbConnection(direct_object,indirect_object);this.setState(direct_object,true);msg=(msg=(msg=(msg+="{We} plug")+(indirect_object?"":" in")+(direct_object?" "+direct_object.articlename:""))+(indirect_object?" into "+indirect_object.articlename:"")).trim();return this.handleSuccess(msg+=". ")}};A.Preverbs.point={name:"point",prettyname:"point",past_tense:"pointed",synonyms:["point"],state:"pointed",gerund:"pointing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,accepts_preposition:true,requires_preposition:true,noun_must_be:{known:true,matter:true,present_if_tangible:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1733",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1828",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1798",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1799",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1800",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1908",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1814",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.poke={name:"poke",prettyname:"poke",past_tense:"poked",synonyms:["poke"],gerund:"poking",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV("poke")){this.game.debug("D1370",this.name+".js ",` ${direct_object.id}.dov.poke.enabled is false `);msg+=`{We} can't poke ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1977",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1619",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1978",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1979",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1980",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1981",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.pour={name:"pour",prettyname:"pour",past_tense:"poured",synonyms:["pour"],gerund:"pouring",accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true,prefer_carried_if_ambiguous:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true},accepts_preposition:true,requires_preposition:true},phrase3:{accepts_noun:true,accepts_preposition:true,requires_preposition:true,noun_must_be:{known:true,matter:true,present_if_tangible:true,reachable_if_tangible:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),noun3=input.getAsset(3),preposition3=input.getPreposition(3),containers,container,msg="",results;if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(input.hasStructure("verb preposition noun"));if(input.hasStructure("verb noun preposition noun"));if(input.hasStructure("verb noun preposition noun preposition noun"));if(input.hasStructure("verb preposition noun")){if("from"!==direct_preposition){this.game.debug("D1584",this.name+".js ",` pour ${direct_preposition} isn't currently handled `);msg+=`{We} {don't} know how to pour ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object instanceof adventurejs.Substance){this.game.debug("D1736",this.name+".js ",` ${direct_object.id} isn't Tangible class `);msg+=`{We} {don't} know how to pour from ${direct_object.name}. `;this.handleFailure(msg);return null}input.setPreposition(1,"");input.setStructure("verb noun")}if(direct_object instanceof adventurejs.Substance&&(input.hasStructure("verb noun")||input.hasStructure("verb noun preposition noun")&&"from"!==indirect_preposition)){if(!(containers=this.game.findSubstanceContainers(direct_object.id,subject,["InInventory"])).length){this.game.debug("D1739",this.name+".js "," no containers found ");msg+=`{We're} not carrying anything with ${direct_object.name} in it. `;this.handleFailure(msg);return null}if(1<containers.length&&!this.game.settings.auto_pick_inferred_container){this.game.debug("D1740",this.name+".js "," multiple containers found, disambiguate ");input.setParsedNounMatchesQualified(1,containers);this.game.parser.printNounDisambiguation({parsedNoun:input.getParsedNoun(1),nounIndex:1});return null}if(!container)container=containers[0];input.verb_params.substance=direct_object;direct_object=this.game.getAsset(containers[0]);input.setAsset(1,direct_object);input.setInferred(1,true);this.game.printInferred("from "+direct_object.articlename)}if(input.hasStructure("verb noun"))if(direct_object instanceof adventurejs.Tangible){if(!direct_object.containsAnySubstance()&&direct_object.hasAnyPartContainingAnySubstance()){direct_object=direct_object.getAnyPartContainingAnySubstance();input.setAsset(1,direct_object)}if(!direct_object.containsAnySubstance()){this.game.debug("D1737",this.name+".js ",` ${direct_object.id} doesn't contain substance `);msg+=direct_object.Articlename+" doesn't contain anything pourable. ";this.handleFailure(msg);return null}indirect_object=subject.getNestOrPlaceAsset();indirect_preposition=subject.getNestOrPlacePreposition();input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setInferred(2,true);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_object.hasClass("Room")?"on the floor":indirect_preposition+" "+indirect_object.articlename)}if(input.hasStructure("verb noun preposition noun preposition noun")){if("from"!==indirect_preposition){this.game.debug("D1737",this.name+".js ",` pour ${indirect_preposition} isn't currently handled `);msg+=`{We} {don't} know how to pour ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!(direct_object instanceof adventurejs.Substance)){this.game.debug("D1738",this.name+".js ",` ${direct_object.id} isn't Substance class `);msg+=`{We} {don't} know how to pour ${direct_object.name}. `;this.handleFailure(msg);return null}if(!indirect_object.containsSubstance(direct_object.id)){this.game.debug("D1557",this.name+".js ",` ${indirect_object.id} does not contain ${direct_object.id} `);msg+=`${indirect_object.Articlename} doesn't contain ${direct_object.name}. `;this.handleFailure(msg);return null}if("to"===preposition3){preposition3=noun3.default_aspect;input.setPreposition(3,preposition3)}input.verb_params.substance=direct_object;input.setPhrase(1,input.getPhrase(2));direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);input.setPhrase(2,input.getPhrase(3));indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2);input.setPhrase(3,{});input.setStructure("verb noun preposition noun")}if(input.hasStructure("verb noun preposition noun")){if(!direct_object.isWithin(subject)){this.game.debug("D1552",this.name+".js ",` ${direct_object.id}.place not in subject `);msg+=`{We're} not carrying ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(!direct_object.hasVessel()){this.game.debug("D1271",this.name+".js ",` ${direct_object.id} has no aspect with vessel `);msg+=`{We} can't pour ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.hasAspectAt(indirect_preposition)&&"on"!==indirect_preposition){this.game.debug("D1550",this.name+".js ",` ${indirect_object.id} does not have ${indirect_preposition} aspect `);msg+=`{We} can't pour ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.isDOV("open")){this.game.debug("D1272",this.name+".js ",` ${direct_object.id}.is.closed `);msg+=direct_object.Articlename_is+" closed. ";this.handleFailure(msg);return null}if(!direct_object.containsAnySubstance()){this.game.debug("D1551",this.name+".js ",` ${direct_object.id}.in.vessel.getVolume is 0 `);msg+=direct_object.Articlename_is+" empty. ";this.handleFailure(msg);return null}if("in"===indirect_preposition&&indirect_object.isDOV("open")){this.game.debug("D1554",this.name+".js ",` ${indirect_object.id}.is.closed `);msg+=indirect_object.Articlename_is+" closed. ";this.handleFailure(msg);return null}if(indirect_object instanceof adventurejs.Floor){indirect_object=this.game.getRoom();input.setAsset(2,indirect_object)}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results,room=indirect_object instanceof adventurejs.Room,target_object,target_preposition,emptied_count=0,transferred=[],spillover=[],overflow=false,input,empty_this=false,mixer;if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(indirect_object);msg+="{We} tip "+direct_object.articlename;if("under"===indirect_preposition||"behind"===indirect_preposition)msg+=` ${indirect_preposition} `+indirect_object.articlename;else msg+=" over "+(room?"the floor":indirect_object.articlename);msg=msg.trim();msg+=". ";if(direct_object.hasVesselAtAspect("in")){if(0<direct_object.aspects.in.vessel.getVolume()){input=this.game.getAsset(direct_object.aspects.in.vessel.substance_id);if(room||"under"===indirect_preposition||"behind"===indirect_preposition){msg+=input.Name+" spills to the floor. ";empty_this=true}else if("on"===indirect_preposition&&!indirect_object.hasVesselAtAspect(indirect_preposition)){msg+=`${input.Name} pours over ${indirect_object.articlename} and then drains away. `;empty_this=true}else if(indirect_object.hasVesselAtAspect(indirect_preposition)){results=(mixer=new adventurejs.SubstanceMixer(this.game.game_name).set({source_input:direct_object.id,source_aspect:"in",source_substance_id:direct_object.aspects.in.vessel.substance_id,target_input:indirect_object.id,target_aspect:indirect_preposition})).mix();if(A.isFalseOrNull(results))return results;mixer.target_vessel.is.known=true;msg+=`${mixer.source_substance_asset.Name} 
              pours from 
              ${mixer.source_asset.articlename} 
              ${indirect_preposition} 
              ${"in"===indirect_preposition||"on"===indirect_preposition?"to ":""}
              `+mixer.target_asset.articlename;if(mixer.can_drain_target)msg+=", where it quickly drains away";else if(mixer.did_overflow_target)msg+=`, overflowing ${mixer.target_asset.articlename} with {mixer.did_mix_substances ? mixer.output_substance_asset.name : mixer.source_substance_asset.name}`;else if(mixer.did_fill_target)msg+=`, filling ${mixer.target_asset.articlename} with `+(mixer.did_mix_substances?mixer.output_substance_asset.name:mixer.source_substance_asset.name);else if(mixer.did_mix_substances)msg+=", resulting in "+mixer.output_substance_asset.name;msg=msg.trim();msg+=". "}else{msg+=`${input.Name} pours over ${indirect_object.articlename} and then spills to the floor. `;empty_this=true}}if(empty_this&&isFinite(direct_object.aspects.in.vessel.getVolume()))direct_object.aspects.in.vessel.setVolume(0)}if(0<direct_object.aspects.in.contents.length)for(var i=direct_object.aspects.in.contents.length-1;-1<i;i--){var content_object=this.game.getAsset(direct_object.aspects.in.contents[i]),target_object=indirect_object,target_preposition=indirect_preposition,overflow=false;emptied_count++;if(room)transferred.push(content_object);else if(indirect_object.canContainAssetAt(content_object,indirect_preposition))transferred.push(content_object);else{target_object=this.game.getRoom();target_preposition="in";spillover.push(content_object)}if(void 0!==(results=direct_object.onRemoveThatFromThis(content_object)))return results;if(void 0!==(results=target_object.onMoveThatToThis(content_object,target_preposition)))return results}if(room)switch(emptied_count){case 0:break;case 1:msg+="A single item tumbles out and falls to the floor. ";break;case 2:msg+="Two items tumble out and fall to the floor. ";break;case 3:msg+="Several items tumble out and fall to the floor. ";break;default:msg+="A number of items tumble out and fall to the floor. ";break}else{var to_target=indirect_preposition+("in"===indirect_preposition||"on"===indirect_preposition?" to ":" ")+indirect_object.articlename;switch(emptied_count){case 0:break;case 1:msg+="A single item tumbles "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=" then falls to the floor. ";break}break;case 2:msg+="Two items tumble "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=", and one falls to the floor. ";break;case 2:msg+=" then fall to the floor. ";break}break;case 3:msg+="Several items tumble "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=", and one falls to the floor. ";break;case 2:msg+=", and a couple of them fall to the floor. ";break;case 3:msg+=" then fall to the floor. ";break}break;default:msg+="A number of items tumble "+to_target;switch(spillover.length){case 0:msg+=". ";break;case 1:msg+=", and one falls to the floor. ";break;case 2:msg+=", and a couple of them fall to the floor. ";break;case 3:msg+=", and several fall to the floor. ";break;default:msg+=" and some fall to the floor. ";break}break}}return this.handleSuccess(msg)}};A.Preverbs.press={name:"press",prettyname:"press",past_tense:"pressed",synonyms:["press"],gerund:"pressing",accepts_structures:["verb noun","verb preposition noun","verb noun preposition","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,accepts_preposition_without_noun:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,direct_preposition,msg="";if(direct_object.hasQuirk("press_means_toggle")&&direct_object.isDOV("toggle")){this.game.debug("D2041",this.name+".js ",` ${direct_object.id}.quirks.press_means_toggle is true, doVerb toggle `);return this.game.dictionary.doVerb("toggle")}if(input.hasStructure("verb noun preposition"))if("down"===indirect_preposition){input.setPreposition(1,"");input.deletePhrase(2);input.setStructure("verb noun")}else{this.game.debug("D2031",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb preposition noun"))if("down"===direct_preposition||"on"===direct_preposition){input.setPreposition(1,"");input.deletePhrase(2);input.setStructure("verb noun")}else{this.game.debug("D2032",this.name+".js ",` ${this.name} ${direct_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if(!direct_object.isDOV("press")){this.game.debug("D1379",this.name+".js ",` ${direct_object.id}.dov.press.enabled is false `);msg+=`{We} can't press ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2033",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} already ${this.past_tense} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2034",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((direct_preposition=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2035",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_preposition.success){indirect_object=direct_preposition.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if("with"===indirect_preposition)if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D2036",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2037",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2038",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2039",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.pull={name:"pull",prettyname:"pull",past_tense:"pulled",synonyms:["pull"],gerund:"pulling",accepts_structures:["verb noun","verb noun noun","verb preposition noun","verb noun preposition","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,accepts_preposition_without_noun:true},phrase3:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),direct_preposition,msg="";if(input.hasStructure("verb noun preposition")){input.setPreposition(1,indirect_preposition);input.deletePhrase(2);input.setStructure("verb preposition noun")}if(input.hasStructure("verb preposition noun"))if(direct_object.allowVerbWithPreposition(this.name,direct_preposition,"dov"))return true;if(direct_object.hasQuirk("pull_means_open")&&direct_object.isDOV("open")){this.game.debug("D1672",this.name+".js ",` ${direct_object.id}.quirks.pull_means_open is true, doVerb open`);if(input.hasStructure("verb preposition noun")){input.setPreposition(1,"");input.setStructure("verb noun")}return this.game.dictionary.doVerb("open")}if(direct_object.hasQuirk("pull_means_toggle")&&direct_object.isDOV("toggle")){this.game.debug("D2042",this.name+".js ",` ${direct_object.id}.quirks.pull_means_toggle is true, doVerb toggle `);return this.game.dictionary.doVerb("toggle")}if(!direct_object.isDOV(this.name)){this.game.debug("D1380",this.name+".js ",` ${direct_object.id}.dov.${this.name} is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(indirect_object&&indirect_object.direction&&!direct_object.can.drag_between_rooms&&!direct_object.isDOV("take")){this.game.debug("D2019",this.name+".js ",` ${direct_object.id}.can.drag_between_rooms is false `);msg+=`{We} try to ${this.name} ${direct_object.articlename} ${indirect_object.direction}, but ${direct_object.getPronoun("we're")} not going anywhere. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun noun"))if(!indirect_object.direction){this.game.debug("D2020",this.name+".js ",` ${indirect_object.id} is not direction `);msg+=this.game.settings.getUnparsedMessage(input.getInput());this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun preposition noun")){if("from"===indirect_preposition&&"to"===indirect_preposition2){input.swapPhrases(2,3);indirect_preposition="to";indirect_preposition2="from";indirect_object=input.getAsset(2);indirect_object2=input.getAsset(3)}if("to"!==indirect_preposition||"from"!==indirect_preposition2){this.game.debug("D2021",this.name+".js "," sentence structure is 'verb noun preposition noun preposition noun' but phrase is not handled");msg+=this.game.settings.getUnparsedMessage(input.getInput());this.handleFailure(msg);return null}if(direct_object.getPlaceAssetId()!==indirect_object2.id){this.game.debug("D2022",this.name+".js ",` ${direct_object.id} is not ${indirect_object2.default_aspect} ${indirect_object2.id} `);msg+=`${direct_object.Articlename_is} not ${indirect_object2.default_aspect} ${indirect_object2.articlename}. `;this.handleFailure(msg);return null}input.setStructure("verb noun preposition noun")}if(input.hasStructure("verb noun preposition noun")){if(direct_object===indirect_object){this.game.debug("D2023",this.name+".js ",` direct_object ${direct_object.id} is indirect_object ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} itself. `;this.handleFailure(msg);return null}if([direct_object.getPlacePreposition(),"across","over"].includes(indirect_preposition)&&direct_object.getPlaceAsset().id!==indirect_object.id){this.game.debug("D2024",this.name+".js ",` ${direct_object.id} is not ${indirect_preposition} ${indirect_object.id} `);msg+=`${direct_object.Articlename_is} not on ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if([direct_object.getPlacePreposition(),"across","over"].includes(indirect_preposition)&&direct_object.getPlaceAsset().id===indirect_object.id);else if("off"===indirect_preposition){if("on"!==direct_object.getPlacePreposition()||direct_object.getPlaceAssetId()!==indirect_object.id){this.game.debug("D2025",this.name+".js ",` ${direct_object.id} is not on ${indirect_object.id} `);msg+=`${direct_object.Articlename_isnt}  on ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}else if(["to","toward","near"].includes(indirect_preposition)){if(direct_object.getPlaceAssetId()!==indirect_object.getPlaceAssetId()||direct_object.getPlacePreposition()!==indirect_object.getPlacePreposition()){this.game.debug("D2026",this.name+".js ",` ${direct_object.id} isn't in same parent as ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}else if(!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D2027",this.name+".js ",` ${indirect_object.id} has no aspect at ${indirect_preposition} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(-1!=="in on under behind".indexOf(indirect_preposition)&&!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D2028",this.name+".js ",` ${indirect_object.id} has no aspect at ${indirect_preposition} `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(indirect_object.hasAspectAt(indirect_preposition))if((direct_preposition=this.tryToPutThisInThatAspect(direct_object,indirect_preposition,indirect_object)).fail){msg=direct_preposition.msg;this.handleFailure(msg);if(direct_preposition.end_turn)return false;else return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results,results1,results2;if(input.hasStructure("verb noun"))msg+=`{We} ${this.agree()} ${direct_object.articlename}. `;if(indirect_object&&indirect_object.direction)if(direct_object.can.drag_between_rooms){results=this.game.tryTravel(indirect_object.direction,{with:[direct_object.id]});if(A.isFalseOrNull(results))return results}else msg+=`{We} ${this.agree()} ${direct_object.articlename} a bit to the ${indirect_object.direction}. `;if(input.hasStructure("verb noun preposition noun"))if([direct_object.getPlacePreposition(),"across","over"].includes(indirect_preposition)&&direct_object.getPlaceAsset().id===indirect_object.id)msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;else if(-1<"in on under behind".indexOf(indirect_preposition)&&indirect_object.hasAspectAt(indirect_preposition)){results1=direct_object.getPlaceAsset().onRemoveThatFromThis(direct_object);if(!A.isFalseOrNull(results1))results2=indirect_object.onMoveThatToThis(direct_object,"behind");if(A.isFalseOrNull(results1)||A.isFalseOrNull(results2))msg+=`{We're} prevented from ${this.gerund} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `}else if("off"===indirect_preposition){results1=indirect_object.onRemoveThatFromThis(direct_object);if(!A.isFalseOrNull(results1))results2=indirect_object.getPlaceAsset().onMoveThatToThis(direct_object,indirect_object.getPlacePreposition());if(A.isFalseOrNull(results1)||A.isFalseOrNull(results2))msg+=`{We're} prevented from ${this.gerund} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;else msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `}else if(["to","toward","near"].includes(indirect_preposition))msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;return this.handleSuccess(msg)}};A.Preverbs.punch={name:"punch",prettyname:"punch",past_tense:"punched",synonyms:["punch"],gerund:"punching",accepts_structures:["verb noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(!direct_object.isDOV("punch")){this.game.debug("D1382",this.name+".js ",` ${direct_object.id}.dov.punch.enabled is false `);msg+=`{We} can't punch ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1982",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun"))if(direct_object.allowVerbWithNothing(this.name,"dov"));return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.push={name:"push",prettyname:"push",past_tense:"pushed",synonyms:["push","shove"],gerund:"pushing",accepts_structures:["verb noun","verb noun noun","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase3:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),indirect_preposition2,msg="";if(direct_object.hasQuirk("push_means_press")&&direct_object.isDOV("press")){this.game.debug("D2029",this.name+".js ",` ${direct_object.id}.quirks.push_means_press is true, doVerb press `);return this.game.dictionary.doVerb("press")}if(direct_object.hasQuirk("push_means_toggle")&&direct_object.isDOV("toggle")){this.game.debug("D2043",this.name+".js ",` ${direct_object.id}.quirks.push_means_toggle is true, doVerb toggle `);return this.game.dictionary.doVerb("toggle")}if(!direct_object.isDOV(this.name)){this.game.debug("D1384",this.name+".js ",` ${direct_object.id}.dov.${this.name} is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(indirect_object&&indirect_object.direction&&!direct_object.can.drag_between_rooms&&!direct_object.isDOV("take")){this.game.debug("D1386",this.name+".js ",` ${direct_object.id}.can.drag_between_rooms is false `);msg+=`{We} try to ${this.name} ${direct_object.articlename} ${indirect_object.direction}, but ${direct_object.getPronoun("we're")} not going anywhere. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun noun"))if(!indirect_object.direction){this.game.debug("D1385",this.name+".js ",` ${indirect_object.id} is not direction `);msg+=this.game.settings.getUnparsedMessage(input.getInput());this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun preposition noun")){if("from"===indirect_preposition&&"to"===indirect_preposition2){input.swapPhrases(2,3);indirect_preposition="to";indirect_preposition2="from";indirect_object=input.getAsset(2);indirect_object2=input.getAsset(3)}if("to"!==indirect_preposition||"from"!==indirect_preposition2){this.game.debug("D1688",this.name+".js "," sentence structure is 'verb noun preposition noun preposition noun' but phrase is not handled");msg+=this.game.settings.getUnparsedMessage(input.getInput());this.handleFailure(msg);return null}if(direct_object.getPlaceAssetId()!==indirect_object2.id){this.game.debug("D1689",this.name+".js ",` ${direct_object.id} is not ${indirect_object2.default_aspect} ${indirect_object2.id} `);msg+=`${direct_object.Articlename_is} not ${indirect_object2.default_aspect} ${indirect_object2.articlename}. `;this.handleFailure(msg);return null}input.setStructure("verb noun preposition noun")}if(input.hasStructure("verb noun preposition noun")){if(direct_object===indirect_object){this.game.debug("D1673",this.name+".js ",` direct_object ${direct_object.id} is indirect_object ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} itself. `;this.handleFailure(msg);return null}if([direct_object.getPlacePreposition(),"across","over"].includes(indirect_preposition)&&direct_object.getPlaceAsset().id!==indirect_object.id){this.game.debug("D1674",this.name+".js ",` ${direct_object.id} is not ${indirect_preposition} ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if([direct_object.getPlacePreposition(),"across","over"].includes(indirect_preposition)&&direct_object.getPlaceAsset().id===indirect_object.id);else if("off"===indirect_preposition){if("on"!==direct_object.getPlacePreposition()||direct_object.getPlaceAssetId()!==indirect_object.id){this.game.debug("D1138",this.name+".js ",` ${direct_object.id} is not on ${indirect_object.id} `);msg+=`${direct_object.Articlename_isnt}  on ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}else if(["to","toward","near"].includes(indirect_preposition)){if(direct_object.getPlaceAssetId()!==indirect_object.getPlaceAssetId()||direct_object.getPlacePreposition()!==indirect_object.getPlacePreposition()){this.game.debug("D1681",this.name+".js ",` ${direct_object.id} isn't in same parent as ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}else if(!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D1204",this.name+".js ",` ${indirect_object.id} has no aspect at ${indirect_preposition} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(-1!=="in on under behind".indexOf(indirect_preposition)&&!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D1188",this.name+".js ",` ${indirect_object.id} has no aspect at ${indirect_preposition} `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(indirect_object.hasAspectAt(indirect_preposition))if((indirect_preposition2=this.tryToPutThisInThatAspect(direct_object,indirect_preposition,indirect_object)).fail){msg=indirect_preposition2.msg;this.handleFailure(msg);if(indirect_preposition2.end_turn)return false;else return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results,results1,results2;if(input.hasStructure("verb noun"))msg+=`{We} ${this.agree()} ${direct_object.articlename}. `;if(indirect_object&&indirect_object.direction)if(direct_object.can.drag_between_rooms){results=this.game.tryTravel(indirect_object.direction,{with:[direct_object.id]});if(A.isFalseOrNull(results))return results}else msg+=`{We} ${this.agree()} ${direct_object.articlename} a bit to the ${indirect_object.direction}. `;if(input.hasStructure("verb noun preposition noun"))if([direct_object.getPlacePreposition(),"across","over"].includes(indirect_preposition)&&direct_object.getPlaceAsset().id===indirect_object.id)msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;else if(-1<"in on under behind".indexOf(indirect_preposition)&&indirect_object.hasAspectAt(indirect_preposition)){results1=direct_object.getPlaceAsset().onRemoveThatFromThis(direct_object);if(!A.isFalseOrNull(results1))results2=indirect_object.onMoveThatToThis(direct_object,"behind");if(A.isFalseOrNull(results1)||A.isFalseOrNull(results2))msg+=`{We're} prevented from ${this.gerund} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `}else if("off"===indirect_preposition){results1=indirect_object.onRemoveThatFromThis(direct_object);if(!A.isFalseOrNull(results1))results2=indirect_object.getPlaceAsset().onMoveThatToThis(direct_object,indirect_object.getPlacePreposition());if(A.isFalseOrNull(results1)||A.isFalseOrNull(results2))msg+=`{We're} prevented from ${this.gerund} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;else msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `}else if(["to","toward","near"].includes(indirect_preposition))msg+=`{We} ${this.agree()} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;return this.handleSuccess(msg)}};A.Preverbs.put={name:"put",prettyname:"put",past_tense:"put",synonyms:["put","place","set"],enqueue_collections:true,gerund:"putting",accepts_structures:["verb noun","verb noun preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,accepts_plural_noun:true,noun_must_be:{known:true,present:true,reachable:true,visible:true,takeable:true,not_worn_if_all:true,not_nested_inventory_if_all:true}},phrase2:{accepts_noun:true,noun_must_be:{tangible:true,present:true,visible:true,reachable:true,known:true,not_in_prior_plural:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_aspect,room=this.game.getRoom(),msg="",subject,input_verb=this.game.dictionary.getVerb(input.input_verb);if(input.hasStructure("verb noun")&&direct_object.isDOV("drop")){this.game.log("L1337","log","high",`[${this.name}.js] no indirect object, doVerb drop`,"Verbs");return this.game.dictionary.doVerb("drop")}if(!direct_object.isDOV(this.name)){this.game.debug("D1722",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(subject.getNestId()===direct_object.id){this.game.debug("D1181",this.name+".js "," subject is nested on "+direct_object.id);msg+=`{We} can't ${input_verb.name} ${direct_object.articlename} ${indirect_preposition?indirect_preposition:""} ${indirect_object?indirect_object.articlename:""} while {we're} ${subject.getPostureGerund()} ${subject.getNestPreposition()} it. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition"))if(["on","down"].includes(indirect_preposition)){input.setPreposition(1,indirect_preposition);input.deletePhrase(2);input.setStructure("verb preposition noun")}else{this.game.debug("D1925",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${input_verb.name} ${direct_object.articlename} ${indirect_preposition}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun")){if("down"===direct_preposition&&this.game.hasVerb("drop")){this.game.debug("D1926",this.name+".js "," put down, doVerb drop ");return this.game.dictionary.doVerb("drop")}if("on"===direct_preposition&&direct_object.isDOV("wear")){this.game.debug("D1891",this.name+".js "," put on, doVerb wear ");return this.game.dictionary.doVerb("wear")}this.game.debug("D1927",this.name+".js ",` ${this.name} ${direct_preposition} not handled `);msg+=`{We} {don't} know how to ${input_verb.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun")){if(direct_object===indirect_object){this.game.debug("D1154",this.name+".js ",` direct_object ${direct_object.id} is indirect_object ${indirect_object.id} `);msg+=`{We} can't put ${direct_object.articlename} ${indirect_preposition} itself. `;this.handleFailure(msg);return null}if("on"===indirect_preposition&&!indirect_object.hasAspectAt(indirect_preposition)&&(direct_object.canBePut("attached",indirect_object)||indirect_object.canBePut("attached",direct_object))&&this.game.hasVerb("attach")){input.setPreposition(2,"attached");this.game.debug("D1155",this.name+".js ",` ${direct_object.id} and ${indirect_object.id} can attach, doVerb attach `);return this.game.dictionary.doVerb("attach")}if(!indirect_object.isIOV(this.name)){this.game.debug("D1026",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is unset `);msg+=`Nothing can be ${input_verb.past_tense} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(indirect_object instanceof adventurejs.Floor){if(!room.has_floor){this.game.debug("D1678",this.name+".js ",` ${room.id}.has_floor is false `);this.handleFailure(msg+="{We} can't see a floor here. ");return null}if("on"!==indirect_preposition){this.game.debug("D1685",this.name+".js ",` ${this.name} ${indirect_preposition} floor is not handled `);msg+=`{We} {don't} know how to ${input_verb.name} anything ${indirect_preposition} the floor. `;this.handleFailure(msg);return null}this.game.debug("D1162",this.name+".js "," indirect_object is floor, doVerb drop ");return this.game.dictionary.doVerb("drop")}if(!indirect_object.hasAspectAt(indirect_preposition)){this.game.debug("D1156",this.name+".js ",` ${indirect_object.id} has no ${indirect_preposition} aspect `);msg+=`{We} can't ${input_verb.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.getPlacePreposition()===indirect_preposition&&direct_object.getPlaceAssetId()===indirect_object.id){this.game.debug("D1163",this.name+".js ",` ${indirect_object.id} is ${indirect_preposition} `+indirect_object.id);msg+=`${direct_object.Articlename_is} already ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToPutThisInThatAspect(direct_object,indirect_preposition,indirect_object)).fail){msg=subject.msg;this.handleFailure(msg);if(subject.end_turn)return false;else return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results,moved=false,input_verb=this.game.dictionary.getVerb(input.input_verb);if(direct_object.is.worn){msg=msg+((results=direct_object.unfasten())?`{We} ${results} and remove `:"{We} remove ")+(direct_object.articlename+" first. ");direct_object.incrementDoVerbCount("remove","dov");direct_object.is.worn=false}if(input.hasStructure("verb noun preposition noun")){msg+="{We}";if(direct_object.getPlaceAssetId()!==subject.id){msg+=` take ${direct_object.articlename} from ${direct_object.getPlaceAsset().articlename} and `;if(void 0!==(results=direct_object.getPlaceAsset().onRemoveThatFromThis(direct_object)))return results;if(void 0!==(results=subject.onMoveThatToThis(direct_object)))return results;moved=true}msg+=` ${this.agree()} ${moved?direct_object.getPronoun("we"):direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;if(void 0!==(results=subject.onRemoveThatFromThis(direct_object)))return results;if(void 0!==(results=indirect_object.onMoveThatToThis(direct_object,indirect_preposition)))return results;if(1<input.parsedNoun1.matches.qualified.length&&-1===input.output_class.indexOf("concatenate_output"))input.output_class+=" concatenate_output"}return this.handleSuccess(msg)}};A.Preverbs.quiet={name:"quiet",synonyms:["quiet"],accepts_structures:["verb"],do:function(){var input=this.game.getInput(),msg=(this.game.settings.quiet=true,"Ok, I'll try to show fewer random events. ");if(msg)this.game.print(msg,input.output_class);return true}};A.Preverbs.quit={name:"quit",synonyms:["q"],accepts_structures:["verb","verb noun"],phrase1:{accepts_noun:true},let_verb_handle_disambiguation:true,let_verb_handle_remaining_input:true,msgNoObject:"You can't quit, you're fired!",do:function(){var input=this.game.getInput(),msg=(this.game.log("L1577","log","high","quit ","verbs"),"You can't quit, you're fired! ");return this.handleSuccess(msg)}};A.Preverbs.read={name:"read",prettyname:"read",past_tense:"read",synonyms:["read"],gerund:"reading",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,msg="",subject;if(!direct_object.isDOV("read")){this.game.debug("D1388",this.name+".js ",` ${direct_object.id}.dov.read.enabled is false `);msg+=`{We} can't read ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.must.hold_to_read&&subject.id!==direct_object.getPlaceAssetId()){this.game.debug("D1389",this.name+".js ",` ${direct_object.id}.must.hold_to_read `);msg+=`{We} have to be holding ${direct_object.articlename} in order to read it. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1604",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} already ${this.name} ${direct_object.articlename} enough. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1605",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1606",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if("with"===indirect_preposition)if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D1608",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1609",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2111",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2112",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";if(direct_object.hasDescription("read"))msg+=this.game.getDescription({asset:direct_object,identifier:"read"});if(direct_object.appearance.scribbles)msg+="A few scribbles have been drawn on it. ";if(direct_object.written_strings?.length){if(1===direct_object.written_strings.length)msg+=`A phrase has been written there in ${this.game.settings.apply_color_classes_to_written_strings?direct_object.written_strings[0].color:""} ${direct_object.written_strings[0].class.toLowerCase()}: `;else msg+="Some phrases have been written there: ";for(let i=0;i<direct_object.written_strings.length;i++)msg+=`<br> <span class="string ${direct_object.written_strings[i].class.toLowerCase()} ${this.game.settings.apply_color_classes_to_written_strings?direct_object.written_strings[i].color:""}">"${direct_object.written_strings[i].data}"</span>`}if(direct_object.typed_strings?.length){msg+=`${1<direct_object.typed_strings.length?"Some phrases have":"A phrase has"} been typed there: `;for(let i=0;i<direct_object.typed_strings.length;i++)msg+=`<br> <span class="string">"${direct_object.typed_strings[i]}"</span> `}if(direct_object.drawn_things?.length)if(1===direct_object.drawn_things.length)msg+=`${A.capitalize(direct_object.drawn_things[0].data)} has been drawn there in ${this.game.settings.apply_color_classes_to_drawn_things?direct_object.drawn_things[0].color:""} ${direct_object.drawn_things[0].class.toLowerCase()}. `;else{msg+="Some things been drawn there: ";for(let i=0;i<direct_object.drawn_things.length;i++){if(0<i&&i<direct_object.drawn_things[i].length-1)msg+=", ";if(1<direct_object.drawn_things[i].length&&i===direct_object.drawn_things[i].length-1)msg+=" and ";msg+="a "+direct_object.drawn_things[i].data}msg+=". "}return this.handleSuccess(msg)}};A.Preverbs.recall={name:"recall",prettyname:"recall",past_tense:"recalled",synonyms:["think","recall","consider"],verb_prep_noun:["think about"],gerund:"thinking",phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true}},with_params:{},doTry:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),msg="";if("think about"===verb_phrase);return true},doSuccess:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),player,direct_object,input="";input+=`{We} recall ${direct_object.articlename}. `;return this.handleSuccess(input)}};A.Preverbs.release={name:"release",prettyname:"release",synonyms:["release"],verb_prep_noun:["let go"],verb_prep_prep_noun:["let go of"],gerund:"releasing",accepts_structures:["verb","verb noun"],phrase1:{accepts_noun:true,noun_must_be:{tangible:true,known:true,present:true,visible:true,reachable:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),nest_asset=subject.getNestAsset(),results,asset,msg="";if("let go"===verb_phrase||"let go of"===verb_phrase);if(input.hasStructure("verb")){if("release"===input.input_verb){input.setSoftPrompt({index:1,type:"noun",noun1:true,verb:input.input_verb,verb_phrase:input.verb_phrase});this.game.debug("D1355",this.name+".js "," no noun provided or inferrable, soft prompt noun1");this.handleFailure(msg+="What did {we} want to release? ");return null}if(subject.isNested()&&nest_asset.hasQuirk("let_go_of_means_go_off"))asset=nest_asset;else if(1===subject.getVerbConnectionCount("hold","to_dov"))asset=this.game.getAsset(subject.getVerbConnections("hold","to_dov")[0]);if(!asset){this.game.debug("D1709",this.name+".js "," no noun supplied or inferred, soft prompt noun1 ");input.setSoftPrompt({index:1,type:"noun",noun1:true,verb:this.name});this.handleFailure(msg+="Let go of what? ");return null}direct_object=asset;input.setAsset(1,asset);input.setInferred(1);input.setStructure("verb noun");this.game.printInferred(""+asset.articlename)}if(input.hasStructure("verb noun")){if(direct_object.isWithin(subject)&&direct_object.isDOV("drop")){this.game.debug("D1710",this.name+".js ",` infer 'drop ${direct_object.name}', doVerb drop`);return this.game.dictionary.doVerb("drop")}if(subject.isNested()&&direct_object.id===nest_asset.id&&direct_object.hasQuirk("let_go_of_means_go_off")&&this.game.hasVerb("go")){this.game.debug("D1711",this.name+".js "," infer 'go off', doVerb go");if(subject.isConnectedToAsset("hold",direct_object,"to_dov"))this.unsetVerbConnection(direct_object,subject);input.setVerb(1,"go");input.setPreposition(1,"off");input.setStructure("verb preposition noun");return this.game.dictionary.doVerb("go")}if(subject.isNested()&&direct_object.id===nest_asset.id&&direct_object.hasQuirk("let_go_of_means_go_down")){this.game.debug("D1712",this.name+".js "," infer 'go down', doVerb down");return results=this.game.tryTravel("down")}if(!subject.isConnectedToAsset("hold",direct_object,"to_dov")){msg+=`{We're} not holding ${direct_object.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;if(subject.isConnectedToAsset("hold",direct_object,"to_dov"))this.game.dictionary.verbs.hold.unsetVerbConnection(direct_object,subject);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.remove={name:"remove",prettyname:"remove",past_tense:"removed",synonyms:["remove"],gerund:"removing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["from"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),msg="";if(input.hasStructure("verb noun")){var parent=direct_object.getPlaceAsset();input.setAsset(2,parent);input.setPreposition(2,"from");input.setInferred(2);input.setStructure("verb noun preposition noun");this.game.printInferred("from "+(indirect_object=parent).articlename)}if(input.hasStructure("verb noun preposition noun")){if(direct_object.getVerbConnectionCount("tie","to_iov")&&direct_object.isDOV("untie")){this.game.debug("D1254",this.name+".js ",` ${direct_object.id}.dov.tie, infer untie `);return this.game.dictionary.doVerb("untie")}if(direct_object.isPlacedAtAspect("attached")&&this.game.hasVerb("detach")){this.game.debug("D1254",this.name+".js ",` ${direct_object.id} is attached, infer detach `);return this.game.dictionary.doVerb("detach")}if(!direct_object.isWithin(indirect_object)){this.game.debug("D1255",this.name+".js ",` ${direct_object.id} place is not ${indirect_object.id} `);msg+=`${direct_object.Articlename_isnt}  in ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.is.worn&&direct_object.isDOV("remove")&&indirect_object.id===subject.id)return true;if(direct_object.is.worn&&!direct_object.isDOV("remove")&&indirect_object.id===subject.id){this.game.debug("D1256",this.name+".js ",` ${direct_object.id}.dov.remove.enabled is false `);msg+=`{We} can't remove ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.is.worn&&indirect_object!==subject.id&&(!direct_object.isDOV("remove")||!indirect_object.isIOV("take"))){this.game.debug("D1257",this.name+".js ",` ${direct_object.id}.dov.remove is unset or ${indirect_object.id}.iov.take is unset`);msg+=`{We} can't remove ${direct_object.articlename} from ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.is.worn&&indirect_object.id!==subject.id&&direct_object.isDOV("remove")&&indirect_object.isIOV("take"))return true;if(!indirect_object.isIOV("take")){this.game.debug("D1258",this.name+".js ",` ${indirect_object.id}.iov.take is unset`);msg+=`{We} can't take anything from ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.is.worn&&!direct_object.isDOV("remove")){this.game.debug("D1259",this.name+".js ",` ${direct_object.id}.dov.remove.enabled is false`);msg+=`{We} can't remove ${direct_object.articlename} from ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}if(this.game.hasVerb("take")){this.game.debug("D1260",this.name+".js "," infer take");return this.game.dictionary.doVerb("take")}},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),input=input.getAsset(2),parent=direct_object.getPlaceAsset(),msg="",closedAnscestors=[],results;if(direct_object.isWithin(subject)&&direct_object.areAnscestorsClosed()){for(var closedAnscestors=direct_object.getClosedAnscestors(),i=0;i<closedAnscestors.length;i++){this.game.getAsset(closedAnscestors[i]).is.closed=false;closedAnscestors[i]=this.game.getAsset(closedAnscestors[i]).name}if(0<closedAnscestors.length){msg+="{We} open the ";for(var i=0;i<closedAnscestors.length;i++){if(2<closedAnscestors.length&&i<closedAnscestors.length-2)msg+=", ";if(1<closedAnscestors.length&&i===closedAnscestors.length-1)msg+=" and the ";msg+=closedAnscestors[i]}msg+=". "}}if(direct_object.is.worn&&input.id==subject.id){msg=msg+((results=direct_object.unfasten())?`{We} ${results}, then remove, `:"{We} remove ")+(direct_object.articlename+". ");direct_object.is.worn=false}if(direct_object.is.worn&&input.id!==subject.id&&input.isIOV("take")){msg=msg+((results=direct_object.unfasten())?`{We} ${results}, then remove, `:"{We} remove ")+`${direct_object.articlename} from ${input.articlename}. `;direct_object.is.worn=false}if(input.id!==subject.id&&direct_object.takeable){if(void 0!==(results=parent.onRemoveThatFromThis(direct_object)))return results;if(void 0!==(results=subject.onMoveThatToThis(direct_object,"in")))return results}return this.handleSuccess(msg)}};A.Preverbs.restore={name:"restore",synonyms:["restore","restore game"],verb_prep_noun:["restore game"],accepts_structures:["verb"],do:function(){this.game.log("L1373","log","high","Opening restore manager.","verbs");this.game.restoreManager.openDialog();return true}};A.Preverbs.revive={name:"revive",prettyname:"revive",past_tense:"revived",synonyms:["revive","resurrect","resuscitate"],unstate:"dead",gerund:"reviving",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"],noun_must_be:{known:true,tangible:true,in_inventory:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV("revive")){this.game.debug("D1968",this.name+".js ",` ${direct_object.id}.dov.revive.enabled is false `);msg+=`{We} can't revive ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1969",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.propername} isn't ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1970",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1971",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1972",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1973",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1974",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1975",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";this.setState(direct_object,false);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.ride={name:"ride",prettyname:"ride",past_tense:"ridden",synonyms:["ride"],verb_prep_noun:["ride on"],gerund:"riding",accepts_structures:["verb","verb noun","verb noun noun","verb preposition noun","verb noun noun","verb noun preposition noun"],subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_ride:true},phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,singular:false}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,input_verb=input.input_verb,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),nest_asset=subject.getNestAsset(),room=this.game.getRoom(),msg="",verb_phrase;if("ride on"===verb_phrase);if(direct_object&&indirect_object&&direct_object.direction){if(!indirect_object.isDOV(input_verb)){this.game.debug("D1149",this.name+".js ",` ${indirect_object.id}.dov.${input_verb}.enabled is unset `);msg+=`{We} can't ${input_verb} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}input.swapPhrases(1,2);direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2)}if(input.hasStructure("verb")){if(!nest_asset||!nest_asset.isDOV(input_verb)){input.setSoftPrompt({index:1,type:"noun",noun1:true,verb:input_verb});this.game.debug("D1122",this.name+".js "," no direct_object received or inferred, soft prompt noun1 ");this.handleFailure(msg+=`What would {we} like to ${input_verb}? `);return null}this.game.log("L1366","log","high",`[${this.name}.js] infer ${direct_object.id} as direct_object `,"verbs");input.setAsset(1,direct_object=nest_asset);input.setStructure("verb noun")}if(input.hasStructure("verb noun")){if(!direct_object.direction&&!direct_object.isDOV(input_verb)){this.game.debug("D1135",input_verb+".js ",` subject is not nested on an asset with asset.dov.${input_verb}.enabled set `);msg+=`{We} can't ${input_verb} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.direction)if(nest_asset&&nest_asset.isDOV(input_verb)){input.swapPhrases(1,2);input.setAsset(1,nest_asset);input.setStructure("verb noun noun");direct_object=nest_asset;indirect_object=input.getAsset(2);this.game.printInferred(subject.getNestPreposition()+" "+nest_asset.articlename)}else{var verb_phrase=subject.findNestedAssetsWithProperty("dov.ride");if(verb_phrase.length){input.swapPhrases(1,2);input.setAsset(1,verb_phrase[0]);input.setStructure("verb noun noun");direct_object=verb_phrase[0];indirect_object=input.getAsset(2);input.verb_params.mount=true}else{this.game.debug("D1139",this.name+".js ",` subject is not nested on an asset with asset.dov.${input_verb}.enabled set `);this.handleFailure(msg+=`{We're} not on anything {we} can ${input_verb}. `);return null}}else if(direct_object.isDOV(input_verb)){if(nest_asset&&nest_asset.id===direct_object.id)return true;input.setVerb(1,"go");input.setPreposition(1,direct_object.default_aspect);input.setPreposition(1,"on");input.setStructure("verb preposition noun");return this.game.dictionary.doVerb("go")}else{input.setSoftPrompt({index:2,type:"noun",noun2:true,verb:input_verb});this.game.debug("D1143",this.name+".js "," no destination received or inferred, soft prompt noun2 ");this.handleFailure(msg+=`Where would {we} like to ${input_verb}? `);return null}}if(input.hasStructure("verb noun noun")||input.hasStructure("verb noun preposition noun"))if(direct_object.direction&&indirect_object.isDOV(input_verb)){input.swapPhrases(1,2);direct_object=input.getAsset(1);direct_preposition=input.getPreposition(1);indirect_object=input.getAsset(2);indirect_preposition=input.getPreposition(2)}if(!nest_asset||nest_asset.id!==direct_object.id){if(indirect_object){this.game.debug("D1217",this.name+".js ",` subject must be on ${direct_object.id} `);msg+=`{We're} not on ${direct_object.articlename}. `;this.handleFailure(msg);return null}input.setVerb(1,"go");input.setPreposition(1,"on");input.setStructure("verb preposition noun");return this.game.dictionary.doVerb("go")}if(indirect_object&&indirect_object.direction){if(input.verb_params.mount)if(void 0!==(verb_phrase=subject.onNestThisToThat(nest_asset)))return verb_phrase;return this.game.tryTravel(indirect_object.direction,{with:[direct_object.id]})}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),input_verb=input.input_verb,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),nest_asset=subject.getNestAsset(),subject="",results;if(!input.did.tryTravel)subject+=`{We} ${input_verb} ${direct_object.articlename} about a bit. `;return this.handleSuccess(subject)}};A.Preverbs.rochambeau={name:"rochambeau",prettyname:"rochambeau",past_tense:"rochambeaued",synonyms:["rochambeau"],gerund:"rochambeauing",accepts_structures:["verb noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,character:true,present:true,visible:true,reachable:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,results,input="";if(!direct_object.isDOV(this.name)){this.game.debug("D1629",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);input+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(input);return null}if("male"===!direct_object.gender){this.game.debug("D1630",this.name+".js ",` ${direct_object.id}.gender !== male `);input+=direct_object.Articlename+" hasn't even got balls, that {we're} aware of. ";this.handleFailure(input);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1631",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);input+=`{We've} already ${this.past_tense} ${direct_object.articlename} enough. `;this.handleFailure(input);return false}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,input="";input+=`{We} ${this.agree()} ${direct_object.articlename}, right in the nuts! `;return this.handleSuccess(input)}};A.Preverbs.run={name:"run",prettyname:"run",past_tense:"ran",synonyms:["run"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"running",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_run:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.save={name:"save",synonyms:["save","save game"],verb_prep_noun:["save game"],accepts_structures:["verb"],do:function(){this.game.log("L1336","log","high","Opening save manager.","verbs");this.game.saveManager.openDialog();return true}};A.Preverbs.say={name:"say",prettyname:"say",past_tense:"said",synonyms:["say"],gerund:"saying",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["to","at","in"]},with_params:{},doTry:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),msg="";return true},doSuccess:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),player,direct_object,msg="",msg=(msg+=`{We} say ${direct_object.articlename} ${input?input:""} `+(indirect_object?indirect_object.articlename:" to {ourself}")).trim();return this.handleSuccess(msg+=". ")}};A.Preverbs.screw={name:"screw",prettyname:"screw",past_tense:"screwed",synonyms:["screw"],state:"screwed",gerund:"screwing",accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{in_inventory_if_takeable:true,known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["in","on","into","onto","off","out"]},phrase2:{accepts_noun:true,noun_must_be:{in_inventory_if_takeable:true,known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["to","in","into","onto","with"]},phrase3:{accepts_noun:true,noun_must_be:{in_inventory_if_takeable:true,known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{max_turns:1},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),target_object,target_preposition,tool_preposition="with",tool_object,tool_inferred,results,msg="";if("screw to"===verb_phrase);if("screw in to"===verb_phrase||"screw into"===verb_phrase);if("screw on to"===verb_phrase||"screw onto"===verb_phrase);if(direct_preposition&&("off"===direct_preposition||"out"===direct_preposition)){if(direct_object.isDOV("unscrew"))return this.game.dictionary.doVerb("unscrew");this.game.debug("D2155",this.name+".js ",` not handling ${this.name} `+direct_preposition);msg+=`{We} {don't} know how to  ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if("with"===indirect_preposition)tool_object=indirect_object;if("with"===indirect_preposition2)tool_object=indirect_object2;if(indirect_preposition&&"with"!==indirect_preposition){target_object=indirect_object;target_preposition=indirect_preposition}if(!direct_object.isDOV(this.name)){this.game.debug("D2136",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2139",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1396",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2149",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((results=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2150",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(results.success){tool_inferred=true;tool_object=results.indirect_object;this.game.printInferred((tool_preposition="with")+" "+tool_object.articlename)}}if(tool_object){input.verb_params.tool_object=tool_object;input.verb_params.tool_preposition=tool_preposition;if(!this.game.parser.selectInHands(tool_object.id).length&&!tool_inferred){this.game.debug("D2151",this.name+".js ",` ${tool_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${tool_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:tool_object,ov:"dov"})){this.game.debug("D2153",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${tool_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${tool_preposition} ${tool_object.articlename}. `;this.handleFailure(msg);return null}if(!tool_object.isIOV(this.name)){this.game.debug("D2154",this.name+".js ",` ${tool_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_preposition?direct_preposition:""} anything ${tool_preposition} ${tool_object.articlename}. `;this.handleFailure(msg);return false}if(tool_object.allowVerbOnce(this.name,"iov")&&tool_object.iDidVerb(this.name,"iov")){this.game.debug("D1395",this.name+".js ",` ${tool_object.id}.iov.${this.name}.once and ${tool_object.id}.did.${this.name}.indirectly is ${tool_object.did[this.name].indirectly} `);msg+=`${tool_object.Articlename} has already been used to ${this.name} ${direct_preposition?direct_preposition:""} something. `;this.handleFailure(msg);return null}}if(target_object){input.verb_params.target_object=target_object;input.verb_params.target_preposition=target_preposition;if(direct_object.getPlaceAssetId===target_object.id&&direct_object.isPlacedAtAspect("attached")){if(direct_object.is.screwed>=direct_object.dov[this.name].with_params.max_turns){this.game.debug("D1394",this.name+".js ",` ${direct_object.id} is already screwed  ${target_preposition} `+target_object.id);msg+=`${direct_object.Articlename_is} already screwed ${target_preposition}    } to ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}else if((results=this.tryToPutThisInThatAspect(direct_object,target_preposition,target_object)).fail){msg=results.msg;this.handleFailure(msg);if(results.end_turn)return false;else return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),tool_object=input.verb_params.tool_object,tool_preposition=input.verb_params.tool_preposition,target_object=input.verb_params.target_object,input=input.verb_params.target_preposition,doParent=direct_object.getPlaceAsset(),msg="",doParent;if(target_object&&target_object.id!==doParent.id){if(void 0!==(doParent=direct_object.moveFrom(doParent)))return doParent;if(void 0!==(doParent=direct_object.moveTo("attached",target_object)))return doParent}direct_object.is.screwed=Math.min(direct_object.is.screwed+1,direct_object.dov[this.name].with_params.max_turns);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(target_object?" "+target_object.articlename:"")+(tool_preposition?" "+tool_preposition:"")+(tool_object?" "+tool_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.seal={name:"seal",prettyname:"seal",past_tense:"sealed",synonyms:["seal"],state:"sealed",related:["unseal"],state_strings:{state:"sealed",unstate:"unsealed"},state_string:"sealed",unstate_string:"unsealed",gerund:"sealing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1400",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1401",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1829",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1252",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1756",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1404",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1909",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1815",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.shake={name:"shake",prettyname:"shake",past_tense:"shook",synonyms:["shake"],gerund:"shaking",state:"shaken",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1405",this.name+".js ",` ${direct_object.id}.dov.${this.name} is unset `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2057",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2058",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2059",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2061",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2062",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2063",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(direct_object.is[this.state]?" again":"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.shine={name:"shine",prettyname:"shine",past_tense:"shone",synonyms:["shine"],state:"shone",gerund:"shining",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1774",this.name+".js ",` ${direct_object.id}.dov.${this.name} is unset `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1830",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1793",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1794",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} on? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1795",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1910",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2064",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.show={name:"show",prettyname:"show to",past_tense:"showed",synonyms:[],gerund:"showing",accepts_structures:["verb noun noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true,tangible:true,visible:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true},requires_preposition:true,preposition_must_be:["to"]},with_params:{},doTry:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),msg="";if(input.hasStructure("verb noun noun")){input.swapPhrases(1,2);input.setPreposition(2,"to");direct_object=input.getAsset(1);indirect_object=input.getAsset(2)}if(!(indirect_object instanceof adventurejs.Character)){this.game.debug("D1187",this.name+".js ",` ${direct_object.id} is not class Character `);msg+=direct_object.Articlename+" doesn't appear to be interested. ";this.handleFailure(msg)}else{if(indirect_object.isIOV(this.name))return true;this.game.debug("D1350",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset`);msg+=indirect_object.Articlename+" doesn't seem interested. ";this.handleFailure(msg)}return null},doSuccess:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),input=input.getAsset(2),player,direct_object,msg="";msg+=`{We} show ${direct_object.articlename} to ${input.articlename}. `;input.knowAsset(direct_object,true);input.seeAsset(direct_object,true);return this.handleSuccess(msg)}};A.Preverbs.sit={name:"sit",prettyname:"sit",past_tense:"sat",synonyms:["sit"],gerund:"sitting",accepts_structures:["verb","verb noun","verb preposition","verb preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,not_direction:true},accepts_preposition:true,accepts_preposition_without_noun:true,requires_preposition:true},with_params:{},in_can_mean_on:true,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),nest_preposition=subject.getNestPreposition(),nest_asset=subject.getNestAsset(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),input,msg="",input,already_on_it;if(input.hasStructure("verb")){if(subject.is.sitting){this.game.debug("D1019",this.name+".js ",` ${subject.id}.is.sitting`);this.handleFailure(msg+="{We're} already sitting! ");return null}direct_preposition=subject.getNestOrPlacePreposition();input.setPreposition(1,direct_preposition);direct_object=subject.getNestOrPlaceAsset();input.setStructure("verb preposition noun")}if(input.hasStructure("verb preposition")){if("up"===direct_preposition){if(subject.is.sitting){this.game.debug("D1097",this.name+".js "," 'sit up'");this.handleFailure(msg+="{We} sit up a bit straighter. ");return null}if(!subject.is.lying){this.game.debug("D1446",this.name+".js "," 'sit up'");msg+=`{We} can't sit up while {we're} ${subject.getPostureGerund()}. `;this.handleFailure(msg);return null}}else if("down"===direct_preposition){if(subject.is.sitting){this.game.debug("D1098",this.name+".js ",` ${subject.id}.is.sitting`);this.handleFailure(msg+="{We} slouch down a bit lower. ");return null}}else{this.game.debug("D1098",this.name+".js "," no direct object received or inferred");msg+=`{We} try to ${this.name} ${direct_preposition}, and fail. `;this.handleFailure(msg);return null}if(nest_asset){direct_object=nest_asset;direct_preposition=nest_preposition}else{direct_object=this.game.getRoomFloor();direct_preposition="on"}if(direct_object){input.setAsset(1,direct_object);input.setPreposition(1,direct_preposition);input.setInferred(1,true);input.setStructure("verb preposition noun");this.game.printInferred(direct_preposition+" "+direct_object.articlename)}}if(input.hasStructure("verb preposition noun")){if(!subject.can.sit||!direct_object.aspects[direct_preposition].canCharacter("sit")){this.game.debug("D1087",this.name+".js ",` subject.can.sit is false or ${direct_object.id}.aspects.${direct_preposition}.nest.can.sit is false`);msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(nest_asset&&nest_asset.id!==direct_object.id)if((input=this.canCharacterGoThereFromNest(direct_preposition,direct_object)).failure){this.handleFailure(input.msg);return null}if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition!==direct_preposition){this.game.debug("D1022",this.name+".js ",` subject is otherwise nested ${nest_preposition} ${nest_asset.id} `);msg+=`{We} can't do that from {our} position ${subject.getPostureGerund()} ${nest_preposition} ${nest_asset.articlename}. `;this.handleFailure(msg);return null}if(subject.is.sitting){if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition===direct_preposition)already_on_it=true;if(!nest_asset&&direct_object instanceof adventurejs.Floor)already_on_it=true;if(already_on_it){this.game.debug("D1089",this.name+".js ",` subject.is.sitting ${direct_preposition} `+direct_object.id);msg+=`{We're} already sitting ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}}}if((input=direct_object)?.placePreventsNesting(subject)){this.game.debug("D1172",this.name+".js ",` ${input.id}.is.deep_nest is false `);msg+=`{We} can't do that while ${input.articlename_is} 
            ${input.getPrettyPlacePreposition()}
            ${input.getPlaceAsset().articlename}. `;this.handleFailure(msg);return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),nest_preposition=subject.getNestPreposition(),nest_asset=subject.getNestAsset(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),do_nest,do_unnest,fromfloor,tofloor,results,input="",tofloor=direct_object instanceof adventurejs.Floor,fromfloor=!nest_asset||nest_asset instanceof adventurejs.Floor;if(fromfloor&&tofloor){do_nest=true;this.game.log("L1354","log","high",`[${this.name}.js] from floor to floor `,"verbs");input+=`{We} ${this.agree()} ${subject.is.lying?"up":"down"} on the floor. `}else if(fromfloor&&!tofloor||nest_asset&&nest_asset.id===direct_object.id){do_nest=fromfloor&&!tofloor;this.game.log("L1355","log","high",`[${this.name}.js] from floor to asset or change position on asset `,"verbs");input+=`${fromfloor&&"stand"!==subject.posture?"{We} rise from the floor and ":"{We} "} ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&tofloor){do_unnest=true;this.game.log("L1356","log","high",`[${this.name}.js] from asset to floor `,"verbs");input+=`{We} get ${subject.getPrettyUnnestPreposition()} ${nest_asset.articlename} and ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&!tofloor&&direct_object.id===nest_asset.id){if(subject.is.lying||subject.is.sitting||subject.is.kneeling){this.game.log("L1357","log","high",`[${this.name}.js] change posture on floor `,"verbs");input+=`{We} ${this.agree()} ${nest_preposition} ${direct_object.articlename}. `}}else if(!fromfloor&&!tofloor&&direct_object.id!==nest_asset.id){do_unnest=do_nest=true;this.game.log("L1358","log","high",`[${this.name}.js] move from one asset to another `,"verbs");input+=`{We} move over to ${direct_object.articlename} and ${this.name} ${direct_preposition} it. `}if(do_unnest&&nest_asset)if(void 0!==(results=subject.onUnnestThisFromThat(nest_asset)))return results;if(do_nest&&direct_object)if(void 0!==(results=subject.onNestThisToThat(direct_object,direct_preposition)))return results;subject.posture=this.name;return this.handleSuccess(input)}};A.Preverbs.skate={name:"skate",prettyname:"skate",past_tense:"skated",synonyms:["skate"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"skating",subject_must_be:{not_constrained:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("ride")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.slap={name:"slap",prettyname:"slap",past_tense:"slapped",synonyms:["slap"],gerund:"slapping",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV("slap")){this.game.debug("D1407",this.name+".js ",` ${direct_object.id}.dov.slap.enabled is false`);msg+=`{We} can't slap ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1983",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1984",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1985",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1986",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1987",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1988",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.sleep={name:"sleep",prettyname:"sleep",past_tense:"slept",synonyms:["sleep"],gerund:"skating",verb_prep_prep_noun:["go to sleep"],subject_must_be:{},accepts_adverbs:[],accepts_structures:["verb","verb preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb preposition noun")){var matchasset=subject.getNestOrPlaceAsset().id===direct_object.id;let matchaspect=subject.getNestOrPlacePreposition()===direct_preposition;if(matchasset&&!matchaspect)if("in"===direct_preposition&&"on"===subject.getNestOrPlacePreposition()&&direct_object.hasQuirk("in_means_on")){matchaspect=true;input.setPreposition(1,direct_preposition="on")}if(!matchasset||!matchaspect){this.game.debug("D1374",this.name+".js ",` ${subject.id} is not ${direct_preposition} `+direct_object.id);msg+=`{We're} not ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return false}}},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),input=input.getPreposition(1),msg="";msg+="{We} "+this.agree()+(input?" "+input:"")+(direct_object?" "+direct_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.slither={name:"slither",prettyname:"slither",past_tense:"slithered",synonyms:["slither"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"slithering",subject_must_be:{not_constrained:true,able_to_slither:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.smell={name:"smell",synonyms:["smell"],past_tense:"smelled",gerund:"smelling",accepts_structures:["verb","verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{present:true,matter:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,room=this.game.getRoom(),room,msg="";if(input.hasStructure("verb")){if(room.hasDescription("smell"))input.verb_params.source=room.descriptions.smell;else input.verb_params.source=this.game.getAreaScenery("global_smell");if(input.verb_params.source)return true;else{this.game.debug("D1776",this.name+".js "," no smell found ");this.handleFailure(msg+="{We} {don't} detect any particular odor. ");return null}}if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1412",this.name+".js ",` ${direct_object.id}.dov.smell.enabled is false `);msg+=`{We} can't smell ${direct_object.articlename} . `;this.handleFailure(msg);return null}if(!direct_object.hasDescription("smell")){this.game.debug("D1413",this.name+".js ",` ${direct_object.id}.descriptions.smell is unset `);msg+=`{We} can't detect any particular odor from ${direct_object.articlename}. `;this.handleFailure(msg);return null}else input.verb_params.source=this.game.getDescription({asset:direct_object,identifier:"smell"});if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1780",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} have any way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((room=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1781",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(room.success){indirect_object=room.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1777",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1911",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1816",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(subject.id!==this.game.getPlayer().id)msg+=subject.articlename+" sniffs the air. ";else msg+=(direct_object?"{We} sniff at "+direct_object.articlename:"")+(indirect_preposition?indirect_preposition:"")+(indirect_object?indirect_object.articlename:"")+(direct_object?". ":"")+(input.verb_params.source?A.getSAF.call(this.game,input.verb_params.source):"{We} {don't} smell anything in particular.");return this.handleSuccess(msg)}};A.Preverbs.squeeze={name:"squeeze",prettyname:"squeeze",past_tense:"squeezed",synonyms:["squeeze"],gerund:"squeezing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV("squeeze")){this.game.debug("D1547",this.name+".js ",` ${direct_object.id}.dov.squeeze.enabled is false `);msg+=`{We} can't squeeze ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1558",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1568",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1602",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1616",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1617",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1618",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.stand={name:"stand",prettyname:"stand",past_tense:"stood",synonyms:["stand"],gerund:"standing",accepts_structures:["verb","verb noun","verb preposition","verb preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true,not_direction:true},accepts_preposition:true,accepts_preposition_without_noun:true,requires_preposition:true},with_params:{},in_can_mean_on:true,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),nest_asset=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),current_room=this.game.getRoom(),input,msg="",results,already_on_it;if(input.hasStructure("verb")){if(subject.is.standing){this.game.debug("D1099",this.name+".js ",` ${subject.id}.is.standing`);this.handleFailure(msg+="{We're} already standing! ");return null}if(nest_asset&&!nest_asset.hasQuirk("stand_means_get_off")){direct_preposition=subject.getNestOrPlacePreposition();direct_object=nest_asset}else{direct_preposition="on";direct_object=this.game.getRoomFloor()}input.setAsset(1,direct_object);input.setPreposition(1,direct_preposition);input.setStructure("verb preposition noun")}if(input.hasStructure("verb preposition")){if("down"===direct_preposition){this.game.debug("D1023",this.name+".js "," no response for idiom 'stand down'");this.handleFailure(msg+="YES, SIR! ");return null}if("up"!==direct_preposition){this.game.debug("D1096",this.name+".js "," no response for idiom 'stand down'");this.handleFailure(msg+=`{We} {don't} know how to stand ${direct_preposition}. `);return null}if(subject.is.standing){this.game.debug("D1024",this.name+".js "," subject.is.standing");this.handleFailure(msg+="{We're} already standing! ");return null}}if(input.hasStructure("verb")||input.hasStructure("verb preposition")){if(nest_asset&&(nest_asset.hasQuirk("stand_means_get_off")||"get"===input.input_verb&&nest_asset.hasQuirk("get_up_means_get_off"))){direct_object=this.game.getRoomFloor();direct_preposition="on"}else if(nest_asset){direct_object=nest_asset;direct_preposition=nest_preposition}else{direct_object=this.game.getRoomFloor();direct_preposition="on"}if(direct_object){input.setAsset(1,direct_object);input.setPreposition(1,direct_preposition);input.setInferred(1,true);input.setStructure("verb preposition noun");if(nest_asset&&direct_object.hasClass("Floor"))this.game.printInferred(subject.getPrettyUnnestPreposition()+" "+nest_asset.articlename);else this.game.printInferred(direct_preposition+" "+direct_object.articlename)}}if(input.hasStructure("verb preposition noun")){if(!subject.can.stand||!direct_object.aspects[direct_preposition]?.canCharacter("stand")){this.game.debug("D1025",this.name+".js "," "+(!subject.can.stand?subject.id+".can.stand is unset":direct_object.id+".aspects."+direct_preposition+".nest.can.stand is unset"));msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(nest_asset&&nest_asset.id!==direct_object.id)if((results=this.canCharacterGoThereFromNest(direct_preposition,direct_object)).failure)return this.game.dictionary.doVerb("go");if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition!==direct_preposition){this.game.debug("D1028",this.name+".js ",` subject is otherwise nested ${nest_preposition} `+nest_asset.id);msg+=`{We} can't do that from {our} position ${subject.getPostureGerund()} ${nest_preposition} ${nest_asset.articlename}. `;this.handleFailure(msg);return null}if(subject.is.standing){if(nest_asset&&nest_asset.id===direct_object.id&&nest_preposition===direct_preposition)already_on_it=true;if(!nest_asset&&direct_object instanceof adventurejs.Floor)already_on_it=true;if(already_on_it){this.game.debug("D1029",this.name+".js ",` subject.is.standing ${direct_preposition} ${direct_object.id} `);msg+=`{We're} already standing ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}}}if((input=direct_object)?.placePreventsNesting(subject)){this.game.debug("D2095",this.name+".js ",` ${input.id}.is.deep_nest is false `);msg+=`{We} can't do that while ${input.articlename_is} 
          ${input.getPrettyPlacePreposition()}
          ${input.getPlaceAsset().articlename}. `;this.handleFailure(msg);return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),input=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),do_nest,do_unnest,fromfloor,tofloor,results,msg="",tofloor=direct_object instanceof adventurejs.Floor,fromfloor=!input||input instanceof adventurejs.Floor;if(fromfloor&&tofloor){do_unnest=true;this.game.log("L1338","log","high",`[${this.name}.js] from floor to floor `,"verbs");msg+=`{We} rise to ${this.name}. `}else if(fromfloor&&!tofloor||input&&input.id===direct_object.id){do_unnest=input&&input.id!==direct_object.id;do_nest=fromfloor&&!tofloor;this.game.log("L1339","log","high",`[${this.name}.js] from floor to asset or change position on asset `,"verbs");msg+=`${fromfloor&&"stand"!==subject.posture?"{We} rise from the floor and ":"{We} "} ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&tofloor){do_unnest=true;this.game.log("L1340","log","high",`[${this.name}.js] from asset to floor `,"verbs");msg+=`{We} get ${subject.getPrettyUnnestPreposition()} ${input.articlename} and ${this.name} ${direct_preposition} ${direct_object.articlename}. `}else if(!fromfloor&&!tofloor&&direct_object.id===input.id){if(subject.is.lying||subject.is.sitting||subject.is.kneeling){this.game.log("L1341","log","high",`[${this.name}.js] change posture on floor `,"verbs");msg+=`{We} ${this.agree()} ${nest_preposition} ${direct_object.articlename}. `}}else if(!fromfloor&&!tofloor&&direct_object.id!==input.id){do_unnest=do_nest=true;this.game.log("L1342","log","high",`[${this.name}.js] move from one asset to another `,"verbs");msg+=`{We} move over to ${direct_object.articlename} and ${this.name} ${direct_preposition} it. `}if(do_unnest&&input)if(void 0!==(results=subject.onUnnestThisFromThat(input)))return results;if(do_nest&&direct_object)if(void 0!==(results=subject.onNestThisToThat(direct_object,direct_preposition)))return results;subject.posture=this.name;return this.handleSuccess(msg)}};A.Preverbs.step={name:"step",prettyname:"step",past_tense:"stepped",synonyms:["step"],gerund:"stepping",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true},accepts_structures:["verb","verb noun","verb preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,matter:true,present:true,reachable:true,reservoir_if_substance:true,visible:true,not_in_inventory:true},accepts_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),direct_container,nest_asset=subject.getNestAsset(),msg="",containers,container,results;if(!direct_object)return true;if(direct_object.direction)if(!direct_preposition||"through"===direct_preposition||"in"===direct_preposition){this.game.log("L1374","log","high",this.name+".js | infer tryTravel "+direct_object.direction,"verbs");return this.game.tryTravel(direct_object.direction)}if(!direct_preposition){this.game.debug("D1644",this.name+".js "," preposition required ");msg+=this.game.settings.getUnparsedMessage(input.getInput());this.handleFailure(msg)}else if(direct_object.id===nest_asset.id){this.game.debug("D2094",this.name+".js ",` subject is ${direct_preposition} ${direct_object.id} `);msg+=`{We're} ${subject.getPostureGerund()} ${subject.getNestPreposition()} ${direct_object.articlename}. `;this.handleFailure(msg)}else{if("on"===direct_preposition&&direct_object.hasQuirk("step_on_means_stand_on")&&this.game.hasVerb("stand")){this.game.log("L1375","log","high",this.name+".js | infer verb stand","verbs");return this.game.dictionary.doVerb("stand")}if("out"===direct_preposition&&nest_asset&&nest_asset.id===direct_object.id){this.game.log("L1376","log","high",this.name+".js | infer verb go","verbs");input.setVerb(1,"go");return this.game.dictionary.doVerb("go")}if(direct_object.hasAspectAt(direct_preposition)&&direct_object.getAspectAt(direct_preposition).canCharacter("enter")){this.game.log("L1377","log","high",this.name+".js | infer verb go","verbs");input.setVerb(1,"go");return this.game.dictionary.doVerb("go")}if(direct_object.hasAspectAt(direct_preposition)&&!direct_object.getAspectAt(direct_preposition).canCharacter("enter")){this.game.debug("D1417",this.name+".js ",` ${direct_object.id}.aspects.${direct_preposition}.nest.can.enter is false `);msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg)}else if("on"!==direct_preposition&&!direct_object.getAspectAt(direct_preposition)?.canCharacter("enter")){this.game.debug("D1647",this.name+".js ",` ${direct_object.id}.aspects.${direct_preposition} is unset ${direct_object.id}.aspects.${direct_preposition}.nest.can.enter is false `);msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg)}else{if(direct_object.hasClass("Room")||direct_object.getPlaceAssetId()===subject.getPlaceAssetId()||direct_object.getPlaceAssetId()===subject.getNestId())return true;var nest_asset=subject.getNestOrPlaceAsset(),input=nest_asset.hasClass("Room");this.game.debug("D1652",this.name+".js ",` 
          ${direct_object.id}'s place is 
          ${direct_object.getPlacePreposition()} 
          ${direct_object.getPlaceAssetId()} and subject is 
          ${subject.getPlacePreposition()} 
          ${subject.getPlaceAssetId()} `);msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename} `+"from {our} position "+`${input?"on":subject.getNestOrPlacePreposition()} `+`${input?"the floor":nest_asset.articlename} `+`while ${direct_object.getPronoun("we're")} `+direct_object.getPlacePreposition()+" "+direct_object.getPlaceAsset().articlename+". ";this.handleFailure(msg)}}return null},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_substance?" "+direct_substance.articlename+" of ":"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.stomp={name:"stomp",prettyname:"stomp",past_tense:"stamped",synonyms:["stomp","stamp"],gerund:"stomping",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true},accepts_structures:["verb noun","verb preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,matter:true,present:true,reachable:true,reservoir_if_substance:true,visible:true,not_in_inventory:true},accepts_preposition:true,preposition_must_be:["on","in"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_substance=input.getSubstance(1),direct_container,direct_preposition=input.getPreposition(1),msg="",results;if(!direct_object){this.game.debug("D1652",this.name+".js "," no direct object ");this.handleFailure(msg+="{We} stomp {our} pretty little feet. ")}else{if(direct_object.direction)if(!direct_preposition||"through"===direct_preposition||"in"===direct_preposition)return this.game.tryTravel(direct_object.direction);if(direct_substance){direct_container=direct_object;direct_object=direct_substance}if(!direct_object.isDOV(this.name)){this.game.debug("D1989",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_preposition?direct_preposition:""} ${direct_object.articlename}. `;this.handleFailure(msg)}else{if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1991",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} already ${this.past_tense} ${direct_preposition?direct_preposition:""} ${direct_object.articlename} enough. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){input.setPreposition(1,direct_preposition="on");input.setStructure("verb preposition noun")}if(direct_substance){if(direct_container.id===subject.getNestOrPlaceAsset().id)return true;this.game.debug("D1658",this.name+".js ",` ${direct_object.id} !== `+subject.getNestOrPlaceAsset().id);this.handleFailure(msg+="{We're} not standing in it. ")}else{if(subject.getNestOrPlaceAsset().id===direct_object.id&&subject.getNestOrPlacePreposition()===direct_preposition){this.game.debug("D1654",this.name+".js "," allow stomp ");return true}if("on"!==direct_preposition&&!direct_object.getAspectAt(direct_preposition)?.canCharacter("enter")){this.game.debug("D1660",this.name+".js ",` ${direct_object}.aspects.${direct_preposition}.nest.can.enter is unset `);msg+=`{We} can't stomp ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg)}else if(direct_object.getPlaceAssetId()!==subject.getPlaceAssetId()&&direct_object.getPlaceAssetId()!==subject.getNestId()){this.game.debug("D1655",this.name+".js ",` ${direct_object.id} is ${direct_object.getPlacePreposition()} ${direct_object.getPlaceAssetId()} and subject is ${subject.getPlacePreposition()} `+subject.getPlaceAssetId());msg+=`{We} can't stomp ${direct_preposition} ${direct_object.articlename} ${direct_object.getPlacePreposition()} ${direct_object.getPlaceAsset().articlename}. `;this.handleFailure(msg)}else{if(direct_object.getPlaceAssetId()!==subject.id)return true;this.game.debug("D1990",this.name+".js ",` ${direct_object.id} is in subject `);msg+=`{We} can't ${this.name} ${direct_preposition} ${direct_object.articlename} while holding it. `;this.handleFailure(msg)}}}}return null},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),direct_substance=input.getSubstance(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,input="";input+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_substance?direct_substance.articlename+" of ":"")+(direct_object?" "+direct_object.articlename:"")+". ";return this.handleSuccess(input)}};A.Preverbs.swim={name:"swim",prettyname:"swim",past_tense:"swam",synonyms:["swim"],type:{locomotion:true,travel:true},extends:{go:true},gerund:"swimming",subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_swim:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.take={name:"take",prettyname:"take",past_tense:"took",synonyms:["take","grab","obtain"],enqueue_collections:true,gerund:"taking",verb_noun_prep:["pick up"],verb_prep_noun:["pick up"],accepts_structures:["verb noun","verb preposition noun","verb noun preposition","verb noun preposition noun"],accepts_adverbs:["*"],phrase1:{accepts_noun:true,requires_noun:true,accepts_plural_noun:true,noun_must_be:{known:true,not_global:true,not_scenery:true,not_exit:true,tangible:true,present:true,visible:true,reachable:true,takeable:true,not_in_hands:true,not_nested_inventory_if_all:true,prefer_uncarried_if_ambiguous:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,not_global:true,not_scenery:true,not_exit:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,accepts_preposition_without_noun:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),adverb=input.getAdverb(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),closedAnscestors=[],msg="",takefrom="",substance,results,substance=input.getParsedNoun(1).matches.substance;if(!direct_object.isDOV("take")){this.game.debug("D1922",this.name+".js ",` ${direct_object.id}.dov.${this.name} not enabled `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition"))if(["off"].includes(indirect_preposition))if(direct_object.is.worn){direct_preposition=indirect_preposition;input.setPreposition(1,indirect_preposition);input.deletePhrase(2);input.setStructure("verb preposition noun")}else{indirect_preposition="";input.setStructure("verb noun");input.deletePhrase(2)}else if(["down"].includes(indirect_preposition)){indirect_preposition="";input.deletePhrase(2);input.setStructure("verb noun")}else{this.game.debug("D1925",this.name+".js ",` ${this.name} ${indirect_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename} ${indirect_preposition}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb preposition noun"))if("off"===direct_preposition)if(direct_object.is.worn&&direct_object.isDOV("remove")){input.setPreposition(1,direct_preposition="");input.setStructure("verb noun");this.game.debug("D1927",this.name+".js "," take off, doVerb remove ");return this.game.dictionary.doVerb("remove")}else{direct_preposition="";input.setStructure("verb noun");input.deletePhrase(2)}else if("down"===direct_preposition)input.setStructure("verb noun");else{this.game.debug("D1928",this.name+".js ",` ${this.name} ${direct_preposition} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_preposition} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")){if(substance)indirect_object=direct_object;else indirect_object=direct_object.getPlaceAsset();indirect_preposition="from";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setInferred(2);input.setStructure("verb noun preposition noun");this.game.printInferred("from "+(indirect_object.hasClass("Room")?"the floor":indirect_object.articlename))}if("from"===indirect_preposition||"out"===indirect_preposition)takefrom="from";if("fromin"===indirect_preposition)takefrom="in";else if("fromon"===indirect_preposition)takefrom="on";else if("fromunder"===indirect_preposition||"outfromunder"===indirect_preposition)takefrom="under";else if("frombehind"===indirect_preposition||"outfrombehind"===indirect_preposition)takefrom="behind";if(input.hasStructure("verb noun preposition noun"));if(direct_object.hasQuirk("take_means_hold")&&direct_object.isDOV("hold"))if("all"!==input.parsedNoun1.original_input){this.game.debug("D1422",this.name+".js ",` ${direct_object.id}.quirks.take_means_hold, doVerb hold `);return this.game.dictionary.doVerb("hold")}if(direct_object instanceof adventurejs.Exit){this.game.debug("D1425",this.name+".js ",` ${direct_object.id} is exit `);this.handleFailure(msg+="Pity {we} can't take direction.");return null}if(substance){this.game.debug("D1372",this.name+".js ",` substance ${substance} can only be carried in a vessel `);msg+=this.game.getAsset(substance).Articlename+" slips through {our} fingers. ";this.handleFailure(msg);return null}if(direct_object.getPlaceAssetId()===this.game.getPlayer().id){this.game.debug("D1426",this.name+".js ",` ${direct_object.id} is in subject `);msg+=`{We're} already ${direct_object.is.worn?"wearing":"carrying"} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.isDOV("tie")&&direct_object.hasVerbMaxConnections("tie","to_iov")){if(direct_object.isDOV("hold")&&!subject.isConnectedToAsset("hold",direct_object,"to_dov")&&!subject.hasVerbMaxConnections("hold","to_dov")){this.game.debug("D1427",this.name+".js ",` ${direct_object.id} is tied to things and .dov.hold.enabled, doVerb hold `);this.game.dictionary.doVerb("hold")}else{if(subject.isConnectedToAsset("hold",direct_object,"to_dov")){this.game.debug("D1428",this.name+".js ",` ${direct_object.id} is in ${subject.id}.is.connected_by.hold.to_dov `);msg+=`{We're} holding ${direct_object.articlename} already. `}this.game.debug("D1429",this.name+".js ",` ${direct_object.id} is tied to things `);msg+=`{We} can't take ${direct_object.articlename} while it's tied to
            ${this.game.getPrintableObjectList({objects:direct_object.getVerbConnections("tie","to_iov")})}. `;this.handleFailure(msg)}return null}if(indirect_object){if(!direct_object.isWithin(indirect_object)){this.game.debug("D1512",this.name+".js ",` ${direct_object.id} is not in ${indirect_object.id} `);if(indirect_object instanceof adventurejs.Character)msg+=`${indirect_object.Articlename} hasn't got ${direct_object.articlename}. `;else msg+=`There's no ${direct_object.name} 
              ${takefrom&&"from"!==takefrom?takefrom:indirect_object.default_aspect} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(takefrom&&"from"!==takefrom)if(direct_object.getPlacePreposition()!==takefrom){this.game.debug("D1513",this.name+".js ",` ${direct_object.id} is not ${takefrom} ${indirect_object.id} `);msg+=`There's no ${direct_object.name} ${takefrom} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV("take")){this.game.debug("D1929",this.name+".js ",` ${indirect_object.id}.iov.take is unset `);msg+=`{We} can't take ${direct_object.articlename} from ${direct_object.getPlaceAsset().articlename}. `;this.handleFailure(msg);return null}if(direct_object.is.worn&&!direct_object.isDOV("remove")){this.game.debug("D1930",this.name+".js ",` ${direct_object.id}.dov.remove is unset `);msg+=`{We} can't remove ${direct_object.articlename} from ${direct_object.getPlaceAsset().articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),adverb=input.getAdverb(),closedAnscestors=[],direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="",results;if(direct_object.isWithin(subject)&&direct_object.areAnscestorsClosed())for(var closedAnscestors=direct_object.getClosedAnscestors(),i=0;i<closedAnscestors.length;i++){this.game.getAsset(closedAnscestors[i]).is.closed=false;closedAnscestors[i]=this.game.getAsset(closedAnscestors[i]).name}if(void 0!==(results=direct_object.moveFrom(indirect_object)))return results;if(void 0!==(results=direct_object.moveTo("in",subject)))return results;if(0<closedAnscestors.length){msg+="{We} open the ";for(var i=0;i<closedAnscestors.length;i++){if(2<closedAnscestors.length&&i<closedAnscestors.length-2)msg+=", ";if(1<closedAnscestors.length&&i===closedAnscestors.length-1)msg+=" and the ";msg+=closedAnscestors[i]}msg=msg.trim();msg+=". "}msg=(msg=(msg+=`{We} ${adverb?adverb:""} take `+direct_object.articlename)+(!(indirect_object instanceof adventurejs.Room)?` ${indirect_preposition} `+indirect_object.articlename:"")).trim();msg+=". ";if(1<input.parsedNoun1.matches.qualified.length&&-1===input.output_class.indexOf("concatenate_output"))input.output_class+=" concatenate_output ";return this.handleSuccess(msg)}};A.Preverbs.tap={name:"tap",prettyname:"tap",past_tense:"tapped",synonyms:["tap"],gerund:"tapping",accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(input.hasStructure("verb")){this.game.debug("D1995",this.name+".js "," no object given");this.handleFailure(msg+="{We} drum {our} fingers on the nearest surface. ");return null}if(!direct_object.isDOV("tap")){this.game.debug("D1430",this.name+".js ",` ${direct_object.id}.dov.tap.enabled is false `);msg+=`{We} can't tap ${direct_preposition?direct_preposition+" ":""}${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2002",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} already ${this.past_tense} ${direct_object.articlename} enough. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2003",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2004",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb preposition noun"))if("with"===direct_preposition)if(!this.game.parser.selectInHands(direct_object.id).length){this.game.debug("D2001",this.name+".js ",` ${direct_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun")){if("with"===indirect_preposition)if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D2008",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2005",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2006",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2007",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.taste={name:"taste",prettyname:"taste",past_tense:"tasted",synonyms:["taste"],gerund:"tasting",accepts_structures:["verb noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},with_params:{},doTry:function(){var input,direct_object=this.game.getInput().getAsset(1),msg="";if(!direct_object.isDOV("taste")){this.game.debug("D1432",this.name+".js ",` ${direct_object.id}.dov.taste.enabled is false `);msg+=`{We} can't taste ${direct_object.name}. `;this.handleFailure(msg)}else{if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1994",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We've} already ${this.past_tense} enough of ${direct_object.articlename}. `;this.handleFailure(msg);return false}if(direct_object.hasDescription("taste"))return true;this.game.debug("D1433",this.name+".js ",` ${direct_object.id}.descriptions.taste is unset `);msg+=direct_object.Articlename+" has no particular taste. ";this.handleFailure(msg)}return null},doSuccess:function(){var input,direct_object=this.game.getInput().getAsset(1),msg="",msg=(msg+=`{We} gently nibble at ${direct_object.articlename}. `)+this.game.getDescription({asset:direct_object,identifier:"taste"});return this.handleSuccess(msg)}};A.Preverbs.tear={name:"tear",prettyname:"tear",past_tense:"tore",synonyms:["tear","rip"],state:"torn",gerund:"tearing",accepts_structures:["verb noun","verb preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["up"]},with_params:{},doTry:function(){var input,direct_object=this.game.getInput().getAsset(1),msg="";if(!direct_object.isDOV("tear")){this.game.debug("D1435",this.name+".js ",` ${direct_object.id}.dov.tear.enabled is false `);msg+=`{We} can't tear ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1992",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,input="",already_torn=direct_object.isVerbState(this.state);this.setState(direct_object,true);input+=`{We} tear ${direct_object.articlename}${already_torn?" some more":""}. `;return this.handleSuccess(input)}};A.Preverbs.teleport={name:"teleport",prettyname:"teleport",synonyms:["teleport"],gerund:"teleporting",accepts_structures:["verb preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{tangible:true,present:false},accepts_preposition:true,requires_preposition:true,preposition_must_be:["to"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),input=input.getAsset(1),nest_preposition=subject.getNestPreposition(),subject=subject.getNestAsset(),room=this.game.getRoom(),msg="";if(input instanceof adventurejs.Room&&input.id==room.id){this.game.debug("D1437","teleport.js ",` subject is in " + ${room.id} + " `);this.handleFailure(msg+="{We're} already there. ")}else if(subject&&subject.id===input.id){this.game.debug("D1438","teleport.js "," subject is nested in "+subject.id);msg+=`{We're} already ${nest_preposition} ${input.articlename}. `;this.handleFailure(msg)}else{if(input.getRoomId()!==room.id)return true;this.game.debug("D1439","teleport.js "," subject is in "+room.id);this.handleFailure(msg="{We're} already there. ")}return null},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),nest_asset=subject.getNestAsset(),newRoom,subject,msg="";if(direct_object instanceof adventurejs.Room)newRoom=direct_object;else newRoom=this.game.getAsset(direct_object.getRoomId());if(nest_asset&&!nest_asset.isWithin(subject))if(void 0!==(subject=subject.onUnnestThisFromThat(nest_asset)))return subject;this.game.setRoom(newRoom,input);msg+=`{We} teleport to ${direct_object.definite_name}. `;return this.handleSuccess(msg)}};A.Preverbs.tell={name:"tell",prettyname:"tell about",past_tense:"told",synonyms:["tellabout","t"],gerund:"telling",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true}},with_params:{},doTry:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object=input.getAsset(2),input="";if("tell about"===verb_phrase);if(!(direct_object instanceof adventurejs.Character)){this.game.debug("D1441",this.name+".js ",` ${direct_object.id} is not class Character `);input+=direct_object.Articlename+" can't hear {us}. ";this.handleFailure(input)}else{if(direct_object.isDOV(this.name))return true;this.game.debug("D1334",this.name+".js ",` ${direct_object.id}.dov.${this.name} is unset`);input+=direct_object.Articlename+" doesn't seem interested. ";this.handleFailure(input)}return null},doSuccess:function(){var input=this.game.getInput(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),input=input.getAsset(2),player,direct_object,msg="";msg+=`{We} tell ${direct_object.articlename}${input?" about "+input.articlename:""}. `;direct_object.knowAsset(input);return this.handleSuccess(msg)}};A.Preverbs.test={name:"test",prettyname:"test",past_tense:"tested",state:"tested",unstate:"untested",synonyms:["test"],gerund:"testing",verb_noun_prep:[],verb_prep_noun:[],verb_prep_prep_noun:[],verb_prep_prep_prep_noun:[],verb_noun_prep_noun:[],verb_noun_prep_prep_noun:[],verb_noun_prep_noun_prep_noun:[],verb_prep_noun_prep_noun_prep_noun:[],accepts_structures:["verb","verb preposition","verb noun","verb preposition noun","verb noun noun","verb noun preposition noun","verb noun preposition noun preposition noun","verb preposition noun preposition noun preposition noun"],subject_must_be:{},phrase1:{accepts_noun:true,accepts_plural_noun:true,noun_must_be:{},accepts_preposition:true,accepts_preposition_without_noun:true},phrase2:{accepts_noun:true,accepts_plural_noun:true,noun_must_be:{},accepts_preposition:true,accepts_preposition_without_noun:true},phrase3:{accepts_noun:true,accepts_plural_noun:true,noun_must_be:{},accepts_preposition:true,accepts_preposition_without_noun:true},let_verb_handle_disambiguation:false,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(input.hasStructure("verb preposition"));if(input.hasStructure("verb preposition noun"));if(input.hasStructure("verb noun preposition noun"));},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),input=input.getPreposition(3),msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+(input?" "+input:"")+(indirect_object2?" "+indirect_object2.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.throw={name:"throw",prettyname:"throw",past_tense:"threw",synonyms:["throw","toss"],gerund:"throwing",accepts_structures:["verb noun","verb noun noun","verb noun preposition","verb noun preposition noun","verb noun preposition noun preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present:true,reachable:true,visible:true,in_hands_unless_reservoir:true,prefer_carried_if_ambiguous:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,matter:true,present:true},accepts_preposition:true,accepts_preposition_without_noun:true},phrase3:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,matter:true,present:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),asset1=input.getAsset(1),substance1=input.getSubstance(1),asset2=input.getAsset(2),substance2=input.getSubstance(2),preposition2=input.getPreposition(2),asset3=input.getAsset(3),preposition3=input.getPreposition(3),substance3=input.getSubstance(3),room=this.game.getRoom(),msg="",results,inhands,thrown_asset,subject,substance1,target_asset,target_substance,target_tangible,target_preposition,tool_asset,tool_preposition;if(subject.getNestId()===asset1.id){this.game.debug("D1211",this.name+".js "," subject is nested on "+asset1.id);msg+=`{We} can't ${this.name} ${asset1.articlename} ${preposition2?preposition2:""} ${asset2?asset2.articlename:""} while {we're} ${subject.getPostureGerund()} ${subject.getNestPreposition()} it. `;this.handleFailure(msg);return null}if(substance1&&"from"===preposition2){if(!this.game.parser.selectReachable(asset2.id).length){this.game.debug("D1612",this.name+".js ",` ${asset2.id} is not reachable `);msg=(msg=(msg+="{We} can't reach "+substance1.articlename)+(asset2 instanceof adventurejs.Room?"":" in"+asset2.articlename)).trim();this.handleFailure(msg+=". ");return null}if(!this.game.parser.selectVisible(asset2.id).length){this.game.debug("D2134",this.name+".js ",` ${asset2.id} is not visible `);msg=(msg=(msg+="{We} can't see "+substance1.articlename)+(asset2 instanceof adventurejs.Room?"":" in"+asset2.articlename)).trim();this.handleFailure(msg+=". ");return null}if(!asset2.containsSubstance(substance1.id)){this.game.debug("D2100",this.name+".js ",` ${asset2.id} doesn't contain ${substance1.id} `);msg+=`${asset2.Articlename} doesn't contain ${substance1.id}. `;this.handleFailure(msg);return null}if(asset1.id===asset2.id){input.setAsset(1,asset2);input.deletePhrase(2);asset1=input.getAsset(1);asset2=input.getAsset(2);preposition2=input.getPreposition(2);preposition3=asset3=false}}if("with"===preposition2&&asset3){input.swapPhrases(2,3);asset2=input.getAsset(2);preposition2=input.getPreposition(2);asset3=input.getAsset(3);preposition3=input.getPreposition(3)}if(input.hasStructure("verb noun preposition"))if(["up","down"].includes(preposition2)){input.deletePhrase(2);preposition2=false}else{this.game.debug("D1956",this.name+".js ",` no handling for ${this.name} ${thrown_asset.id} ${preposition2} `);msg+=`{We} {don't} know how to ${this.name} ${thrown_asset.id} ${preposition2}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun noun"))if(!asset2.direction){this.game.debug("D1233",this.name+".js ",` no handling for ${this.name} ${asset1.id} ${asset2.id} `);msg+=`{We} {don't} know how to ${this.name} ${asset1.articlename} ${asset2.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")&&thrown_asset instanceof adventurejs.Tangible)target_asset=target_tangible=room;subject=substance1;substance1=asset1;if("with"===preposition2){tool_asset=asset2;tool_preposition=preposition2}else{target_substance=substance2;if((target_tangible=asset2||room).hasClass("Floor"))target_tangible=room;if(target_tangible.hasClass("Room"))target_preposition=target_tangible.default_aspect;if(!target_tangible.hasClass("Room"))if(["in","on","to","at"].includes(preposition2))target_preposition=target_tangible.default_aspect||"at";else target_preposition=preposition2||"toward"}if("with"===preposition3){tool_asset=asset3;tool_preposition=preposition3}input.verb_params={thrown_asset:thrown_asset=subject||substance1,thrown_substance:subject,thrown_tangible:substance1,target_asset:target_asset=target_substance||target_tangible,target_substance:target_substance,target_tangible:target_tangible,target_preposition:target_preposition,tool_asset:tool_asset,tool_preposition:tool_preposition};if(!thrown_asset?.isDOV(this.name)){this.game.debug("D1495",this.name+".js ",` ${thrown_asset.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${thrown_asset.articlename}. `;this.handleFailure(msg);return null}if(thrown_asset.allowVerbOnce(this.name,"dov")&&thrown_asset.didVerb(this.name,"dov")){this.game.debug("D2108",this.name+".js ",` ${thrown_asset.id}.dov.${this.name}.once and ${thrown_asset.id}.did.${this.name}.directly `);msg+=`{We} can't ${this.name} ${thrown_asset.articlename} again. `;this.handleFailure(msg);return false}if(thrown_asset instanceof adventurejs.Tangible)if(!(inhands=this.game.parser.selectInHands(thrown_asset.id)).length){this.game.debug("D1601",this.name+".js ",` ${thrown_asset.id} not in subject's hands `);msg+=`{We're} not holding ${thrown_asset.articlename}. `;this.handleFailure(msg);return null}if(tool_asset){if(tool_asset.isDOV("take")&&!this.game.parser.selectInHands(tool_asset.id).length){this.game.debug("D2102",this.name+".js ",` ${tool_asset.id}.$is("inhands") is false `);msg+=`{We're} not holding ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(!tool_asset.isDOV("take")&&!this.game.parser.selectReachable(tool_asset.id).length){this.game.debug("D2103",this.name+".js ",` ${tool_asset.id}.$is("reachable") is false `);msg+=`{We} can't reach ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(thrown_asset.allowVerbWithAnything(this.name,"dov"))return true;if(!thrown_asset.allowVerbWithAsset({verb:this.name,asset:tool_asset,ov:"dov"})){this.game.debug("D2104",this.name+".js ",` ${thrown_asset.id}.dov.${this.name}.with_assets/with_classes does not include ${tool_asset.id} `);msg+=`{We} can't ${this.name} ${thrown_asset.articlename} ${preposition3} ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(!tool_asset.isIOV(this.name)){this.game.debug("D2106",this.name+".js ",` ${tool_asset.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${preposition3} ${tool_asset.articlename}. `;this.handleFailure(msg);return false}if(tool_asset.allowVerbOnce(this.name,"iov")&&tool_asset.iDidVerb(this.name,"iov")){this.game.debug("D2107",this.name+".js ",` ${tool_asset.id}.iov.${this.name}.once and ${tool_asset.id}.did.${this.name}.indirectly is ${tool_asset.did[this.name].indirectly} `);msg+=`${tool_asset.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb noun preposition noun preposition noun"))if(!("with"!==preposition2&&"with"===preposition3)){this.game.debug("D2106",this.name+".js ",` ${this.name} ${asset1.id} ${preposition2} ${asset2.id} ${preposition3} ${asset3.id} not handled `);msg+=`{We} {don't} know how to ${this.name} ${asset1.articlename} ${preposition2} ${asset2.articlename} ${preposition3} ${asset3.articlename}. `;this.handleFailure(msg);return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),room=this.game.getRoom(),msg="",results,mixer,quantity=0,thrown_asset=input.verb_params.thrown_asset,thrown_tangible=input.verb_params.thrown_tangible,thrown_substance=input.verb_params.thrown_substance,thrown_vessel;if(thrown_substance)thrown_vessel=thrown_tangible.getVesselAt(thrown_tangible.getVesselPreposition());var target_asset=input.verb_params.target_asset,target_tangible=input.verb_params.target_tangible,target_substance,target_vessel;if(input.verb_params.target_substance)target_vessel=target_tangible.getVesselAt(target_tangible.getVesselPreposition());var target_preposition=input.verb_params.target_preposition;if(!target_tangible)target_preposition=(target_tangible=room).default_aspect;var bounce_target=target_tangible,bounce_preposition=target_preposition,bounce_inferred,tool_asset=input.verb_params.tool_asset,input=input.verb_params.tool_preposition;if(thrown_asset.hasClass("Tangible")){if(thrown_asset.isWithin(subject))if(void 0!==(results=subject.onRemoveThatFromThis(thrown_asset)))return results;if(void 0!==(results=(bounce_target=(results=this.tryToPutThisInThatAspectOrParent(thrown_asset,target_preposition,target_tangible)).indirect_object).onMoveThatToThis(thrown_asset,bounce_preposition=results.indirect_preposition)))return results}if(thrown_asset.hasClass("Substance")){if(thrown_tangible.isWithin(subject))if(thrown_vessel.getVolume()===1/0)quantity=thrown_vessel.volume_of_flow_per_turn;else{quantity=thrown_vessel.getVolume();thrown_vessel.empty()}else{quantity=this.game.settings.handful;if(thrown_vessel.volume!==1/0)thrown_vessel.subtractVolume(quantity)}if(target_asset.hasClass("Tangible")&&!target_asset.hasClass("Room")&&target_asset.canContainSubstances()&&("in"===target_preposition||"at"===target_preposition||"to"===target_preposition||"on"===target_preposition)){target_preposition=target_asset.getVesselPreposition();target_vessel=target_asset.getVesselAt(target_preposition)}if(target_vessel){mixer=target_vessel.addSubstance(quantity,thrown_substance.id);if(void 0!==(results=target_tangible.onAddSubstanceToThis(thrown_substance)))return results}else bounce_preposition=(bounce_target=room).default_aspect}let bounced=false;if(thrown_asset.hasClass("Tangible")&&bounce_target?.id!==target_tangible.id||thrown_asset.hasClass("Substance")&&!target_tangible.hasAspectAt(target_preposition))bounced=true;var thrown_vessel=bounced?"try to":"";msg+="{We}";if(thrown_substance&&!thrown_tangible.isWithin(subject)){msg+=` scoop up a handful of ${thrown_substance.name} `;if(!thrown_tangible.hasClass("Room"))msg+=" from "+thrown_tangible.articlename;msg+=` and ${thrown_vessel} ${this.name} it`}else msg+=" "+this.name;if(thrown_asset.hasClass("Substance")&&thrown_tangible?.isWithin(subject))msg+=` a ${thrown_tangible.noun}-full of `+thrown_substance.name;if(thrown_asset.hasClass("Tangible"))msg+=" "+thrown_asset.articlename;if(!target_tangible.hasClass("Room"))msg=msg+(target_preposition?" "+target_preposition:"")+(" "+target_tangible.articlename);else msg+=" across the room";msg=msg+(input?" "+input:"")+(tool_asset?" "+tool_asset.articlename:"");if(bounce_target?.id===target_tangible.id){msg=msg.trim();msg+=". "}else{msg=(msg=(msg+=", where ")+(thrown_asset.getPronoun("we")+" "))+`${thrown_asset.hasClass("Substance")?"spills":"bounces"} `;if(bounce_target.hasClass("Room"))msg+=" to the ground. ";else msg+=` to ${bounce_target.articlename}. `}return this.handleSuccess(msg)}};A.Preverbs.tie={name:"tie",prettyname:"tie",synonyms:["tie"],past_tense:"tied",state:"tied",state_string:"tied",unstate_string:"untied",gerund:"tying",verb_prep_noun:["tie up"],verb_noun_prep:["tie up"],makes_connections:true,accepts_structures:["verb noun","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,accepts_plural_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,accepts_plural_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["to","with","in"]},phrase3:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["to","with"]},with_params:{can_knot:true,max_connections:2,must_hold_to_use:false,on_max_connections_drop_rope:true,on_take_break_connections:false,on_take_take_connections:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object1=input.getAsset(2),indirect_preposition1=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2=input.getPreposition(3),results,inferred_rope,msg="",rope,targets=[];if("tie up"===verb_phrase);if(indirect_preposition1&&indirect_preposition2&&indirect_preposition1===indirect_preposition2){this.game.debug("D1594",this.name+".js ",` can't handle "${indirect_preposition1}" and "${indirect_preposition2}"`);this.handleFailure(msg+="That doesn't even make sense. ");return false}if(input.hasStructure("verb noun")){if(direct_object.isDOV(this.name)&&direct_object.allowVerbWithNothing(this.name,"dov")){if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D2165",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return false}return true}if(direct_object.isDOV(this.name)){msg+=`To what would {we} like to ${this.name} ${direct_object.articlename}? `;input.setPreposition(2,"to");input.setSoftPrompt({index:2,type:"noun",noun2:true,preposition2:true,structure:"verb noun preposition noun"});this.handleFailure(msg);return false}else if(direct_object.isIOV(this.name)){this.game.debug(`Fxxxx | ${this.name}.js | direct_object.isIOV `);if((results=this.tryToInferRope([direct_object])).prompt){var index=2;input.setPreposition(2,"with");input.setSoftPrompt({index:2,type:"noun",noun2:true,preposition2:true,structure:"verb noun preposition noun"});this.game.debug("D2166",this.name+".js "," soft prompt for noun2 ");msg+=`With what would {we} like to ${this.name} ${direct_object.articlename}? `;this.handleFailure(msg);return false}else if(results.ropes.length){this.game.debug(`Fxxxx | ${this.name}.js | found a rope `);inferred_rope=true;rope=results.ropes[0];input.setPreposition(2,"with");input.setAsset(2,rope);input.setStructure("verb noun preposition noun")}}else{msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}}for(let i=1;i<=3;i++){var asset=input.getAsset(i);if(!asset);else{var preposition=input.getPreposition(i);if(input.getSubstance(i)){this.game.debug("D2164",this.name+".js "," substances can't be tied ");msg+=input.getSubstance(i).Name+" can't be tied. ";this.handleFailure(msg);return false}if(!asset.isOV(this.name)){this.game.debug("D1590",this.name+".js ",` neither ${asset.id}.dov.${this.name} nor ${asset.id}.iov.${this.name} is set `);msg+=asset.Articlename+" can't be tied. ";this.handleFailure(msg);return false}if(!preposition)if(asset.isDOV(this.name)){rope=asset;continue}else if(asset.isIOV(this.name)){targets.push(asset);continue}if(preposition&&"with"===preposition){if(!asset.isDOV(this.name)){this.game.debug("D2162",this.name+".js ",` ${asset.id}.iov.${this.name} is unset`);msg+=`{We} can't ${this.name} anything with ${asset.articlename}. `;this.handleFailure(msg);return false}rope=asset}else if(preposition&&"to"===preposition)if(asset.isIOV(this.name))targets.push(asset);else if(asset.isDOV(this.name))if(!rope)rope=asset;else{this.game.debug("D2163",this.name+".js ",` ${asset.id}.dov.${this.name} is set but already found `+rope.id);msg+=`{We} can't ${this.name} anything to ${asset.articlename}. `;this.handleFailure(msg);return false}}}if(targets.length&&!rope){results=this.tryToInferRope();let index=targets.length+1;if(results.prompt){this.game.debug("D1593",this.name+".js ",` soft prompt for noun${index} `);input.setPreposition(index,"with");input.setSoftPrompt({index:index,type:"noun",["noun"+index]:true,structure:"verb noun preposition noun"+("3"===index?" preposition noun":"")});msg+=`With what would {we} like to ${this.name} ${0<targets.length?targets[0].articlename:""} ${1<targets.length?"to "+targets[1].articlename:""}? `;this.handleFailure(msg);return false}inferred_rope=true;rope=results.ropes[0];this.game.printInferred("with "+rope.articlename)}if(!rope){this.game.debug("D2158",this.name+".js "," no ropes ");msg+=`{We} {don't} know how to ${this.name} ${direct_preposition?direct_preposition:""} ${direct_object.articlename}${indirect_preposition1?" "+indirect_preposition1:""}${indirect_object1?" "+indirect_object1.articlename:""}${indirect_preposition2?" "+indirect_preposition2:""}${indirect_object2?" "+indirect_object2.articlename:""}. `;this.handleFailure(msg);return false}if(rope.dov[this.name].with_params.must_hold_to_use&&!subject.has(rope)){this.game.debug("D1591",this.name+".js ",` ${rope.id}.dov.${this.name}.with_params.must_hold_to_use is true`);msg+=`{We}'re not holding ${rope.articlename}. `;this.handleFailure(msg);return false}if(1<targets.length&&rope.isConnectedToAsset("tie",targets[0],"to_iov")&&rope.isConnectedToAsset("tie",targets[1],"to_iov")){msg+=`${rope.Articlename} is already tied to both ${targets[0].articlename} and ${targets[1].articlename}. `;this.handleFailure(msg);return false}for(let i=0;i<targets.length;i++){if(targets[i]&&!targets[i].isIOV(this.name)){this.game.debug("D1649",this.name+".js ",` ${targets[i].id}.iov.${this.name} is unset`);msg+=`{We} can't tie anything to ${targets[i].articlename}. `;this.handleFailure(msg);return false}if(!rope.allowVerbWithAnything(this.name,"dov")&&!rope.allowVerbWithAsset({verb:"tie",asset:targets[i].id,ov:"dov"})){this.game.debug("D2167",this.name+".js ",` ${rope.id}.dov.${this.name}.with_anything is false and neither .with_assets / .with_classes includes ${targets[i].id} / ${targets[i].class} `);msg+=`${rope.Articlename} can't be ${this.past_tense} to ${targets[i].articlename}. `;this.handleFailure(msg);return false}if(targets[i]&&targets[i].iov[this.name].with_params.must_hold_to_use&&!subject.has(targets[i])){this.game.debug("D2159",this.name+".js ",` ${targets[i].id}.iov.${this.name}.with_params.must_hold_to_use is true`);msg+=`{We}'re not holding ${targets[i].articlename}. `;this.handleFailure(msg);return false}if(rope.isConnectedToAsset("tie",targets[i],"to_iov")){this.game.debug("D1483",this.name+".js ",` ${rope.id}.is.connected_by.${this.name}.to_iov contains `+targets[i].id);msg+=`${rope.Articlename} is already tied to ${targets[i].articlename}. `;this.handleFailure(msg);return false}if(targets[i].getVerbConnectionCount("tie","to_dov")>=targets[i].getVerbMaxConnections("tie","iov")){this.game.debug("D2169",this.name+".js ",` ${targets[i].id}.is.connected_by.${this.name}.to_dov has the maximum number of connections specified at ${targets[i].id}.iov.${this.name}.with_params.max_connections`);msg+=targets[i].Articlename+" can't have any more things tied to it. ";this.handleFailure(msg);return false}}if(rope.getVerbConnectionCount("tie","to_iov")>=rope.getVerbMaxConnections("tie","dov")){this.game.debug("D2170",this.name+".js ",` ${rope.id}.is.connected_by.${this.name}.to_iov has the maximum number of connections specified at ${rope.id}.dov.${this.name}.with_params.max_connections`);msg+=rope.Articlename+" can't be tied to any more things. ";this.handleFailure(msg);return false}input.verb_params.rope=rope;input.verb_params.targets=targets;return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),indirect_object1=input.getAsset(2),indirect_object2=input.getAsset(3),results,msg="",rope=input.verb_params.rope,targets=input.verb_params.targets;if(input.hasStructure("verb noun")){msg=`{We} ${this.agree()} ${direct_object.articlename}. `;this.setState(direct_object,true);this.handleSuccess(msg)}else{var direct_object=rope.getVerbMaxConnections("tie","dov")-rope.getVerbConnectionCount("tie","to_iov");msg+="{We} "+this.agree()+(direct_object<=1?" the free":" one")+" end of "+rope.articlename+(targets[0]?" to "+targets[0].articlename:"")+(targets[1]?", and the other end to "+targets[1].articlename:"");if(targets.length)for(let i=0;i<targets.length;i++){this.setVerbConnection(rope,targets[i]);if(rope.isWithin(subject)&&rope.dov[this.name].with_params.on_take_take_connections&&!targets[i].isWithin(subject)&&targets[i].isDOV("take")){if(void 0!==(results=subject.onMoveThatToThis(targets[i],"in")))return results;msg+=", and take "+targets[i].articlename}}var tiedObjectsNotInInventory=0,direct_object=rope.getVerbConnectionCount("tie","to_iov")===rope.getVerbMaxConnections("tie","dov");if(direct_object)for(var count=rope.getVerbConnectionCount("tie","to_iov"),i=0,tiedObject;i<count;i++){if(!this.game.getAsset(rope.getVerbConnections("tie","to_iov")[i]).isWithin(subject))tiedObjectsNotInInventory++}var noTiedObjectsInInventory=tiedObjectsNotInInventory===rope.getVerbMaxConnections("tie","dov");if(rope.dov.tie.with_params.on_max_connections_drop_rope&&rope.isWithin(subject)&&direct_object&&noTiedObjectsInInventory){var direct_object=this.game.getRoom(),results;if(void 0!==(results=subject.onRemoveThatFromThis(rope)))return results;if(void 0!==(results=direct_object.onMoveThatToThis(rope,"in")))return results;msg+=", and let go of "+rope.articlename}msg+=". ";if(this.game.parser.isParsingMultiple()&&-1===input.output_class.indexOf("concatenate_output"))input.output_class+=" concatenate_output ";this.handleSuccess(msg)}return true},tryToInferRope:function(targets){var result={prompt:false,ropes:[]},input,subject=this.game.getInput().getSubject(),ropes=subject.findNestedAssetsWithClass("Rope");if(!this.game.settings.infer_objects)result.prompt=true;if(!ropes||!ropes.length)ropes=subject.findNestedAssetsWithProperty("dov.tie");for(let i=ropes.length-1;0<i;i--){var rope=ropes[i];if(rope.allowVerbWithNothing())ropes.splice(i,1);else if(!rope.allowVerbWithAnything(this.name,"dov"))for(let t=0;t<targets.length;t++){var target=targets[t];if(!rope.allowVerbWithAsset({verb:"tie",asset:target.id,ov:"dov"}))ropes.splice(i,1)}}if(!(result.ropes=ropes)||!ropes.length)result.prompt=true;if(1<ropes.length&&!this.game.settings.auto_pick_inferred_objects)result.prompt=true;return result}};A.Preverbs.toggle={name:"toggle",prettyname:"toggle",past_tense:"toggled",synonyms:["toggle"],gerund:"toggling",phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV("toggle")){this.game.debug("D1450",this.name+".js ",` ${direct_object.id}.dov.toggle.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2044",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We} can't ${this.name} ${direct_object.articlename} again. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2045",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2046",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if("with"===indirect_preposition)if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D2047",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2048",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2049",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2050",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.turn={name:"turn",prettyname:"turn",past_tense:"turned",synonyms:["turn"],gerund:"turning",accepts_adverbs:["left","right","around","back","towards"],accepts_structures:["verb","verb noun","verb noun preposition noun","verb preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,adverb=input.getAdverb(),msg="",adverb;if(input.hasStructure("verb")){if(adverb);}else{if(!direct_object.isDOV(this.name)){this.game.debug("D1455",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}${direct_preposition?" "+direct_preposition:""}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1933",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1934",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((adverb=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1935",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(adverb.success){indirect_object=adverb.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun"))if(!["to","from","with"].includes(indirect_preposition)){this.game.debug("D1072",this.name+".js ",` ${this.name} ${direct_object} ${indirect_preposition} ${indirect_object.id} not handled `);msg+=`{We} {don't} know how to ${this.name} ${direct_object} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun")||input.hasStructure("verb preposition noun preposition noun")&&"with"===indirect_preposition){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1603",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1499",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset `);msg+=`${indirect_object.Articlename} can't be used to ${this.name} anything. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1932",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),input=input.getAdverb(),results,msg="";msg+="{We} "+this.agree()+(input?" "+input:"")+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.turnIn={name:"turnIn",prettyname:"turn in",past_tense:"turned in",verb_noun_prep:["turn in"],verb_prep_noun:["turn in"],synonyms:[],gerund:"turning in",accepts_adverbs:[],accepts_structures:["verb","verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,adverb=input.getAdverb(),msg="",direct_preposition;if(input.hasStructure("verb"))if("turn in"===input.verb_phrase&&this.game.hasVerb("sleep"))return this.game.dictionary.doVerb("sleep");else{input.setSoftPrompt({index:1,type:"noun",verb:input.verb_phrase,noun1:true,structure:"verb noun"});this.game.debug("D1068",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${input.verb_phrase||input.input_verb}? `;this.handleFailure(msg);return null}if(!direct_object.isDOV(this.name)){this.game.debug("D1157",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}${direct_preposition?" "+direct_preposition:""}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1183",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1411",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.prettyname} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((direct_preposition=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1414",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.prettyname} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_preposition.success){indirect_object=direct_preposition.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1416",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.prettyname} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1418",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset `);msg+=`${indirect_object.Articlename} can't be used to ${this.prettyname} anything. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1424",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.prettyname} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),adverb=input.getAdverb(),results,input="";input+=`{We} ${this.agree("turn")} in`+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(input)}};A.Preverbs.turnOff={name:"turnOff",prettyname:"turn off",past_tense:"turned off",verb_noun_prep:["turn off"],verb_prep_noun:["turn off"],synonyms:["disable"],unstate:"turnedOn",state_string:"turned off",unstate_string:"turned on",gerund:"turning off",accepts_adverbs:[],accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,adverb=input.getAdverb(),msg="",direct_preposition;if(!direct_object.isDOV(this.name)){this.game.debug("D1431",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}${direct_preposition?" "+direct_preposition:""}. `;this.handleFailure(msg);return null}if(!direct_object.is.on){this.game.debug("D1544",this.name+".js ",` ${direct_object.id}.is.on is unset `);msg+=direct_object.Articlename+" is already off. ";this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1434",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1436",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.prettyname} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((direct_preposition=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1440",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.prettyname} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_preposition.success){indirect_object=direct_preposition.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1449",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.prettyname} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1451",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset `);msg+=`${indirect_object.Articlename} can't be used to ${this.prettyname} anything. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1451",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.prettyname} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),adverb=input.getAdverb(),results,input="",results=direct_object.onDeactivate(direct_object);if(void 0!==results)return results;this.setState(direct_object,false);direct_object.is.on=false;input+=`{We} ${this.agree("turn")} off`+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(input)}};A.Preverbs.turnOn={name:"turnOn",prettyname:"turn on",past_tense:"turned on",verb_noun_prep:["turn on"],verb_prep_noun:["turn on"],synonyms:["enable"],state:"turnedOn",state_string:"turned on",unstate_string:"turned off",gerund:"turning on",accepts_adverbs:[],accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,adverb=input.getAdverb(),msg="",direct_preposition;if(!direct_object.isDOV(this.name)){this.game.debug("D1157",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}${direct_preposition?" "+direct_preposition:""}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1183",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1411",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.prettyname} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((direct_preposition=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1414",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.prettyname} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_preposition.success){indirect_object=direct_preposition.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1416",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.prettyname} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1418",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset `);msg+=`${indirect_object.Articlename} can't be used to ${this.prettyname} anything. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1424",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.prettyname} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),adverb=input.getAdverb(),results,input="",results=direct_object.onActivate(direct_object);if(void 0!==results)return results;this.setState(direct_object,true);direct_object.is.on=true;input+=`{We} ${this.agree("turn")} on`+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(input)}};A.Preverbs.turnOver={name:"turnOver",prettyname:"turn over",past_tense:"turned over",verb_noun_prep:["turn over"],verb_prep_noun:["turn over"],synonyms:["flip"],gerund:"turning over",accepts_adverbs:[],accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),direct_preposition=input.getPreposition(1),indirect_preposition=input.getPreposition(2),indirect_inferred,adverb=input.getAdverb(),msg="",direct_preposition;if(!direct_object.isDOV(this.name)){this.game.debug("D1454",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is unset `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}${direct_preposition?" "+direct_preposition:""}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1456",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1458",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.prettyname} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((direct_preposition=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1459",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.prettyname} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(direct_preposition.success){indirect_object=direct_preposition.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1472",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.prettyname} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1476",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset `);msg+=`${indirect_object.Articlename} can't be used to ${this.prettyname} anything. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1481",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.prettyname} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),adverb=input.getAdverb(),results,input="";input+=`{We} ${this.agree("turn")} over`+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(input)}};A.Preverbs.twist={name:"twist",prettyname:"twist",past_tense:"twisted",synonyms:["twist"],state:"twisted",gerund:"twisting",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1457",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} try to ${this.name} ${direct_object.articlename} and fail {fail_adverb}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D2051",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D2052",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D2053",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D2054",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D2055",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D2056",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.type={name:"type",prettyname:"type on",past_tense:"typed",synonyms:[],gerund:"typing",allow_iov_on_iov:true,accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present_if_tangible:true,reachable_if_tangible:true},accepts_preposition:true,preposition_must_be:["on","with"]},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present_if_tangible:true,reachable_if_tangible:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["on","with"]},phrase3:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present_if_tangible:true,reachable_if_tangible:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["on","with"]},with_params:{tool:false,target:false},doTry:function(){var input=this.game.getInput(),target_asset_place,room=this.game.getRoom(),msg="";let info_asset,info_preposition,target_asset,target_preposition,tool_asset,tool_preposition,count=input.getPhraseCount();for(let i=count;0<i;i--){let asset=input.getAsset(i);var preposition=input.getPreposition(i);if(asset?.is.information){if(info_asset){this.game.debug("D1496",this.name+".js "," can't handle multiple information assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(preposition){this.game.debug("D1529",this.name+".js "," can't handle preposition");msg+=`{We} don't know how to ${this.name} ${preposition} "${asset.articlename}." `;this.handleFailure(msg);return null}info_asset=input.verb_params.info_asset=asset}else if(asset?.isIOV(this.name)&&asset.iov[this.name].with_params.tool){if(tool_asset){this.game.debug("D1505",this.name+".js "," can't handle multiple tool assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(!["on","with"].includes(preposition)){this.game.debug("D1524",this.name+".js "," can't handle preposition");msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}tool_asset=input.verb_params.tool_asset=asset;tool_preposition=input.verb_params.tool_preposition=preposition}else if(asset?.isIOV(this.name)&&asset.iov[this.name].with_params.target){if(target_asset){this.game.debug("D1504",this.name+".js "," can't handle multiple target assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if("on"!==preposition){this.game.debug("D1514",this.name+".js "," can't handle preposition");msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}target_asset=input.verb_params.target_asset=asset;target_preposition=input.verb_params.target_preposition=preposition}else{this.game.debug("D1665",this.name+".js ",` unusable asset ${asset.id} found`);msg+=`{We} don't know how to ${this.name} ${preposition?preposition:""} ${asset?asset.articlename:""}. `;this.handleFailure(msg);return null}}if(!info_asset&&!target_asset&&!tool_asset){this.game.debug("D1663",this.name+".js "," no relevant assets found");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(!info_asset){info_asset=input.verb_params.info_asset=this.game.getAsset("global_string");input.shiftPhrase({asset:info_asset})}if(target_asset&&!tool_asset){if(!(target_asset_place=target_asset.getPlaceAsset()).isIOV(this.name)){this.game.debug("D1510",this.name+".js ",` ${target_asset.id} is not in a typewriter `);msg+=`{We} can't ${this.name} directly on ${target_asset.articlename}. `;this.handleFailure(msg);return null}count++;tool_asset=input.verb_params.tool_asset=target_asset_place;input.setAsset(count,tool_asset);input.setInferred(count,true);this.game.printInferred("with "+tool_asset.articlename)}if(!tool_asset){for(var room_contents=room.getAllNestedContents(),asset=null,keyboards=[],i=0;i<room_contents.length;i++){var id=room_contents[i],asset=this.game.getAsset(id);if(!asset);else if(asset.isIOV(this.name)&&asset.iov[this.name].with_params.tool)keyboards.push(id)}if(keyboards.length){keyboards=this.game.parser.selectKnown(keyboards);keyboards=this.game.parser.selectReachable(keyboards);keyboards=this.game.parser.selectVisible(keyboards)}if(!keyboards.length){this.game.debug("D1663",this.name+".js "," no assets found with .iov.type.enabled set to true ");this.handleFailure(msg+="{We} {don't} see anything to type on. ");return null}count++;if(1<keyboards.length&&!this.game.settings.auto_pick_inferred_objects){this.game.debug("D1664",this.name+".js "," multiple keyboards found, disambiguate ");input.setParsedNoun(count,new adventurejs.ParsedNoun);input.setPreposition(count,"on");input.setParsedNounMatchesQualified(count,keyboards);input.setStructure(input.getStructure()+" preposition noun");this.game.parser.printNounDisambiguation({parsedNoun:input.getParsedNoun(count),nounIndex:count});return null}tool_asset=input.verb_params.tool_asset=this.game.getAsset(keyboards[0]);tool_preposition=input.verb_params.tool_preposition="on";input.setPhrase(count,{});input.setAsset(count,tool_asset);input.setPreposition(count,"on");input.setInferred(count,true);input.setStructure(input.getStructure()+" preposition noun");this.game.printInferred("on "+tool_asset.articlename)}if(tool_asset&&!target_asset){var target_asset_place=tool_asset.getAspectAt("in");let contents;if(target_asset_place)contents=target_asset_place.contents;if(contents?.length)for(var i=0;i<contents.length;i++){var asset=this.game.getAsset(contents[i]);if(!asset);else if(asset.isDOV(this.name)){target_asset=input.verb_params.target_asset=asset;break}}}if(target_asset&&tool_asset&&!target_asset.isIn(tool_asset)){this.game.debug("D1402",this.name+".js ",` ${target_asset.id} is not in ${tool_asset.id} `);msg+=`${target_asset.Articlename} isn't in ${tool_asset.articlename}. `;this.handleFailure(msg);return null}var phrase_count=input.getPhraseCount(),room=input.getAsset(1);if(info_asset&&room&&info_asset.id!==room.id){let info_found_in_slot;for(let i=1;i<=phrase_count;i++)if(input.getAsset(i).id===info_asset.id){info_found_in_slot=i;break}input.swapPhrases(info_found_in_slot,1)}var target_asset_place=input.getAsset(2);if(target_asset&&target_asset_place&&target_asset.id!==target_asset_place.id){let target_found_in_slot;for(let i=1;i<=phrase_count;i++)if(input.getAsset(i).id===target_asset.id){target_found_in_slot=i;break}if(target_found_in_slot)input.swapPhrases(target_found_in_slot,2)}var room=input.getAsset(phrase_count);if(tool_asset&&room&&tool_asset.id!==room.id){let tool_found_in_slot;for(let i=1;i<=phrase_count;i++){let asset=input.getAsset(i);if(asset&&asset.id===tool_asset.id){tool_found_in_slot=i;break}}if(tool_found_in_slot)input.swapPhrases(tool_found_in_slot,phrase_count)}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),results,msg="",{info_asset,info_preposition,target_asset,target_preposition,tool_asset,tool_preposition}=input.verb_params;if(target_asset?.isIn(tool_asset))msg+=`Using ${tool_asset.articlename}, {we} `;else msg+="{We} ";msg+="type ";if(input.strings.length){if(target_asset)target_asset.typed_strings.push(input.strings[0]);msg+=`"${input.strings[0]}" `}if(target_asset?.isIn(tool_asset))msg+=`on ${target_asset.articlename}. `;else msg+=`on ${tool_asset.articlename}. `;return this.handleSuccess(msg)}};A.Preverbs.unbutton={name:"unbutton",synonyms:["unbutton"],past_tense:"unbuttoned",prettyname:"unbutton",unstate:"buttoned",gerund:"unbuttoning",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,not_global:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1883",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1884",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is false`);msg+=`${direct_object.Articlename_isnt}  ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1885",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1885",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1886",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1888",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1912",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1889",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";this.setState(direct_object,false);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.undo={name:"undo",synonyms:["undo"],msgNoObject:"msgNoObject - shouldn't be seeing this.",accepts_structures:["verb"],do:function(){this.game.log("L1382","log","high","undo","verbs");var input=this.game.getInput(),msg="";if(0<this.game.world_history.length){var worldString=this.game.world_history[0],restored;delete this.game.world_history[0];this.game.world_history.shift();if(A.restoreWorld.call(this.game,worldString)){this.game.parser.input_history.shift();this.game.debug("D1461",this.name+".js "," undo successful ");if(msg+="Undoing one turn. ")this.game.print(msg,"");this.game.reactor.emit("undoComplete");return true}else{this.game.debug("D1462",this.name+".js "," undo failed ");if(msg+='Undo failed! (You might say, "undo undone.") ')this.game.print(msg,"");return false}}this.game.debug("D1463",this.name+".js "," undo default ");if(msg+="Nothing to undo. ")this.game.print(msg,"");return true}};A.Preverbs.unlock={name:"unlock",prettyname:"unlock",past_tense:"unlocked",synonyms:["unlock"],unstate:"locked",related:["lock","pick"],gerund:"unlocking",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{on_unlock_open:true},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(direct_object?.isDOV("pick")&&indirect_object&&direct_object.allowVerbWithAsset({verb:"pick",asset:indirect_object.id,ov:"dov"}))return this.game.dictionary.doVerb("pick");if(!direct_object.isDOV(this.name)){if(direct_object.isDOV("pick"))return this.game.dictionary.doVerb("pick");this.game.debug("D1464",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1465",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is false`);msg+=`${direct_object.Articlename_isnt}  ${this.getState()}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1831",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1466",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of anything that unlocks ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1757",this.name+".js "," soft prompt for noun2 ");msg=(msg+=input.verb_params.auto_open?direct_object.Articlename_is+" locked. ":"")+`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun")}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1698",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1913",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1817",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="",auto_open=false;if(input.verb_params.auto_open){direct_object.setIs("closed",false);direct_object.incrementDoVerbCount("open","dov");auto_open=true}this.setState(direct_object,false);msg+=`{We} ${this.agree()}${direct_preposition?" "+direct_preposition:""}${direct_object?" "+direct_object.articlename:""}${indirect_preposition?" "+indirect_preposition:""}${indirect_object?" "+indirect_object.articlename:""}${auto_open?" and open it":""}. `;if(auto_open&&direct_object.hasContentsAtAspect("in"))msg+=direct_object.getPrintableListOfContentsAt("in");return this.handleSuccess(msg)}};A.Preverbs.unplug={name:"unplug",prettyname:"unplug",past_tense:"unplugged",synonyms:["unplug"],gerund:"unplugging",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["from","with"]},with_params:{on_unplug_take_plug:true},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,can_plugIn,msg="",drain,drain,can_plugIn,unverb,unstate,drain,is_plug_asset_takeable;if(direct_object.linked_components?.Drain)if(drain=this.game.getAsset(direct_object.linked_components.Drain)){input.setAsset(1,direct_object=drain);input.setInferred(1)}drain=direct_object.isDOV("plug");can_plugIn=direct_object.isDOV("plugIn");if(drain&&can_plugIn)if(direct_object.is.plugged)unverb="plug";else if(direct_object.is.pluggedIn)unverb="plugIn";if(!unverb)unverb=drain?"plug":can_plugIn?"plugIn":null;if(unverb)unstate=this.game.dictionary.verbs[unverb].state;input.verb_params.unverb=unverb;input.verb_params.unstate=unstate;if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(!direct_object.isDOV(this.name)){this.game.debug("D1470",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(unstate&&!direct_object.is[unstate]){this.game.debug("D1766",this.name+".js ",` ${direct_object.id}.is.${unstate} is false `);msg+=direct_object.Articlename_is+` not ${"pluggedIn"===unstate?"plugged in":unstate}. `;this.handleFailure(msg);return false}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1832",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if("plug"===unverb){if(drain=direct_object.is.connected_by.plug?.to_iov[0])drain=this.game.getAsset(drain);if(drain)input.verb_params.plug_asset=drain}if(input.hasStructure("verb noun"))if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;if(input.hasStructure("verb noun")&&"plugIn"===unverb)switch(direct_object.getVerbConnectionCount("plugIn","to_iov")){case 0:this.game.debug("D1717",this.name+".js ",` ${direct_object.id}.is.connected_by.plugIn is unset `);msg+=direct_object.Articlename+" doesn't appear to be plugged in. ";this.handleFailure(msg);return null;case 1:input.setStructure("verb noun preposition noun");indirect_object=this.game.getAsset(direct_object.getVerbConnections("plugIn","to_iov")[0]);input.setAsset(2,indirect_object);input.setPreposition(2,"from");indirect_preposition="from";break;default:input.setPreposition(2,"from");input.setSoftPrompt({index:2,type:"noun",noun2:true});this.game.debug("D1469",this.name+".js ",` ${direct_object.id}.is.connected_by.plugIn.to_iov.length > 1, soft prompt for indirect object`);msg+=`What would {we} like to unplug ${direct_object.articlename} from? `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")&&"plug"===unverb){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1713",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((can_plugIn=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1714",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return null}else if(can_plugIn.success){indirect_object=can_plugIn.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if("with"===indirect_preposition){if(indirect_object.isDOV("take")&&!indirect_object.isWithin(subject)){this.game.debug("D1734",this.name+".js ",` ${indirect_object.id} is not in subject inventory `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1727",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1895",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1818",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}if("from"===indirect_preposition)if(!direct_object.isConnectedToAsset("plugIn",indirect_object,"to_iov"))if(indirect_object.isConnectedToAsset("plugIn",direct_object,"to_iov")){input.swapPhrases(1,2);input.setPreposition(1,"");input.setPreposition(2,"from")}else{this.game.debug("D1735",this.name+".js ",` ${direct_object.id}.is.connected_by.plugIn.to_iov does not include ${indirect_object.id} `);msg+=`${direct_object.Articlename} doesn't appear to be plugged into ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),msg="",direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),direct_place=direct_object.getPlaceAsset(),results,plug_asset=input.verb_params.plug_asset;if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(input.hasStructure("verb noun")&&"plugIn"===input.verb_params.unverb){this.game.dictionary.verbs.plugIn.unsetVerbConnection(direct_object,null);direct_object.is.pluggedIn=false}if(input.hasStructure("verb noun")&&direct_object.allowVerbWithNothing("plug","dov"))direct_object.is.plugged=false;if("plug"===input.verb_params.unverb&&plug_asset){console.warn("try to remove plug from sink");if(void 0!==(results=plug_asset.moveFrom(direct_object)))return results;if(plug_asset.isDOV("take"))results=plug_asset.moveTo("in",subject);else results=plug_asset.moveTo(direct_place.default_aspect,direct_place);if(void 0!==results)return results}if(input.hasStructure("verb noun preposition noun"))if("plugIn"===input.verb_params.unverb&&"from"===indirect_preposition){this.game.dictionary.verbs.plugIn.unsetVerbConnection(direct_object,indirect_object);if(0===direct_object.getVerbConnectionCount("plugIn","to_iov"))direct_object.is.pluggedIn=false}msg=(msg=(msg=(msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:""))+(plug_asset&&plug_asset.isWithin(subject)?" and take "+plug_asset.articlename:""))+(plug_asset&&!plug_asset.isWithin(subject)?` and leave 
          ${plug_asset.articlename} 
          ${plug_asset.getPlacePreposition()} 
          `+plug_asset.getPlaceAsset().articlename:"")).trim();return this.handleSuccess(msg+=". ")}};A.Preverbs.unquiet={name:"unquiet",synonyms:["unquiet"],accepts_structures:["verb"],do:function(){var input=this.game.getInput(),msg=(this.game.settings.quiet=false,"Ok, I'll stop suppressing random events. ");if(msg)this.game.print(msg,input.output_class);return true}};A.Preverbs.unscrew={name:"unscrew",synonyms:["unscrew"],past_tense:"unscrewed",prettyname:"unscrew",unstate:"screwed",gerund:"unscrewing",accepts_structures:["verb noun","verb noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["from","with"]},phrase3:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{max_turns:1,on_unscrew_take:true},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_object2=input.getAsset(3),indirect_preposition2,target_object,target_preposition,tool_preposition="with",tool_object,tool_inferred,results,msg="";if("with"===indirect_preposition)tool_object=indirect_object;if("with"===input.getPreposition(3))tool_object=indirect_object2;if(indirect_preposition&&"with"!==indirect_preposition){target_object=indirect_object;target_preposition=indirect_preposition}if(!direct_object.isDOV("unscrew")){this.game.debug("D1474",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1473",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D2156",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return null}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1018",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((results=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1101",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(results.success){tool_inferred=true;tool_object=results.indirect_object;this.game.printInferred((tool_preposition="with")+" "+tool_object.articlename)}}if(tool_object){input.verb_params.tool_object=tool_object;input.verb_params.tool_preposition=tool_preposition;if(!this.game.parser.selectInHands(tool_object.id).length&&!tool_inferred){this.game.debug("D1102",this.name+".js ",` ${tool_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${tool_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:tool_object,ov:"dov"})){this.game.debug("D1223",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${tool_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${tool_preposition} ${tool_object.articlename}. `;this.handleFailure(msg);return null}if(!tool_object.isIOV(this.name)){this.game.debug("D1229",this.name+".js ",` ${tool_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_preposition?direct_preposition:""} anything ${tool_preposition} ${tool_object.articlename}. `;this.handleFailure(msg);return false}if(tool_object.allowVerbOnce(this.name,"iov")&&tool_object.iDidVerb(this.name,"iov")){this.game.debug("D1397",this.name+".js ",` ${tool_object.id}.iov.${this.name}.once and ${tool_object.id}.did.${this.name}.indirectly is ${tool_object.did[this.name].indirectly} `);msg+=`${tool_object.Articlename} has already been used to ${this.name} ${direct_preposition?direct_preposition:""} something. `;this.handleFailure(msg);return null}}if(target_object){input.verb_params.target_object=target_object;input.verb_params.target_preposition=target_preposition;if(direct_object.getPlaceAssetId===target_object.id&&direct_object.isPlacedAtAspect("attached")){if(direct_object.is.screwed>=direct_object.dov[this.name].with_params.max_turns){this.game.debug("D1475",this.name+".js ",` ${direct_object.id} is already screwed  ${target_preposition} `+target_object.id);msg+=`${direct_object.Articlename_is} already screwed ${target_preposition}    } to ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}else if((results=this.tryToPutThisInThatAspect(direct_object,target_preposition,target_object)).fail){msg=results.msg;this.handleFailure(msg);if(results.end_turn)return false;else return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),tool_object=input.verb_params.tool_object,input=input.verb_params.tool_preposition,doParent=direct_object.getPlaceAsset(),msg="",doParent,removed=false,taken=false;direct_object.is.screwed=Math.max(direct_object.is.screwed-1,0);if(removed=direct_object.is.screwed<=0){if(void 0!==(doParent=direct_object.moveFrom(doParent)))return doParent;if(direct_object&&direct_object.isDOV("take")){if(void 0!==(doParent=direct_object.moveTo("in",subject)))return doParent;taken=true}else if(void 0!==(doParent=direct_object.moveTo("in",this.game.getRoom())))return doParent}msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+!removed+' ?" a turn":""'+(input?" "+input:"")+(tool_object?" "+tool_object.articlename:"")+`${taken} ? " and take " + ${direct_object.articlename}:""`+". ";return this.handleSuccess(msg)}};A.Preverbs.unseal={name:"unseal",prettyname:"unseal",past_tense:"unsealed",synonyms:["unseal"],unstate:"sealed",related:["seal"],gerund:"unsealing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{in_inventory:true,known:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{on_unseal_open:true},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1477",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1478",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is false`);msg+=`${direct_object.Articlename_isnt}  ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1833",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1705",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1758",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1700",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1893",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1819",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;this.setState(direct_object,false);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";if(direct_object.hasContentsAtAspect("in"))msg+=direct_object.getPrintableListOfContentsAt("in");return this.handleSuccess(msg)}};A.Preverbs.untie={name:"untie",synonyms:["untie"],past_tense:"untied",prettyname:"untie",gerund:"untying",unstate:"tied",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["from","with","in"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(input.hasStructure("verb noun")){if(direct_object.is.tied)return true;if(direct_object.isDOV("tie")&&direct_object.getVerbConnectionCount("tie","to_iov")){input.setAsset(2,this.game.getAsset(direct_object.getVerbConnections("tie","to_iov")[0]));input.setPreposition(2,"from");indirect_object=input.getAsset(2);indirect_preposition="from";input.setStructure("verb noun preposition noun")}if(direct_object.isIOV("tie")&&direct_object.getVerbConnectionCount("tie","to_dov")){input.setAsset(2,this.game.getAsset(direct_object.getVerbConnections("tie","to_dov")[0]));input.swapNouns(1,2);input.setPreposition(2,"from");direct_object=input.getAsset(1);indirect_object=input.getAsset(2);indirect_preposition="from";input.setStructure("verb noun preposition noun")}}if(!direct_object.isDOV(this.name)&&!direct_object.isIOV(this.name)){this.game.debug("D1482",this.name+".js ",` ${direct_object.id}.dov.untie and .iov.untie are unset `);msg+=direct_object.Articlename+" can't be untied. ";this.handleFailure(msg);return null}if(input.hasStructure("verb noun preposition noun"))if(""===indirect_preposition);if(direct_object.isDOV("tie")){if(!direct_object.getVerbConnectionCount("tie","to_iov"))if(direct_object.isIOV("tie")&&direct_object.getVerbConnectionCount("tie","to_dov")){var indirect_preposition=this.game.getAsset(direct_object.getVerbConnections("tie","to_dov")[0]);if(indirect_preposition){input.setAsset(1,indirect_preposition);direct_object=indirect_preposition}}else{this.game.debug("D1484",this.name+".js ",` ${direct_object.id}.is.connected_by.tie.to_iov is unset `);msg+=direct_object.Articlename_isnt+" tied to anything. ";this.handleFailure(msg);return null}}else if(direct_object.isIOV("tie"))if(!direct_object.getVerbConnectionCount("tie","to_dov")){this.game.debug("D1485",this.name+".js ",` ${direct_object.id}.is.connected_by.tie.to_dov is empty`);if(direct_object.allowVerbWithNothing("tie","dov"))msg+=`${direct_object.Articlename_is} already ${this.past_tense}. `;else msg+=`Nothing is tied to ${direct_object.articlename}. `;this.handleFailure(msg);return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(input.hasStructure("verb noun")){direct_object.is.tied=false;msg=`{We} ${this.agree()} ${direct_object.articlename}. `;this.handleSuccess(msg);return true}var tie=this.game.dictionary.verbs.tie;if(tie)tie.unsetVerbConnection(direct_object,indirect_object);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"");if(direct_object.getVerbConnectionCount("tie","dov"))msg+=", leaving it tied to "+this.game.getPrintableObjectList({objects:direct_object.getVerbConnections("tie","to_iov")});msg=msg.trim();msg+=". ";if(this.game.parser.isParsingMultiple()&&-1===input.output_class.indexOf("concatenate_output"))input.output_class+=" concatenate_output ";return this.handleSuccess(msg)}};A.Preverbs.unzip={name:"unzip",synonyms:["unzip"],past_tense:"unzipped",prettyname:"unzip",unstate:"zipped",gerund:"unzipping",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,not_global:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1488",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return null}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1391",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is false`);msg+=`${direct_object.Articlename_isnt}  ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1392",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1393",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return false}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1419",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1421",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1423",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";this.setState(direct_object,false);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.use={name:"use",prettyname:"use",past_tense:"used",synonyms:["use"],state:"used",gerund:"using",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true,present:true,reachable:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1146",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} {don't} know how to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1916",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1917",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1918",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}else if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1920",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1729",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1921",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";this.setState(direct_object,true);return this.handleSuccess(msg)}};A.Preverbs.verb_template={name:"verb_template",prettyname:"verb to",past_tense:"verbed",state:"verbed",unstate:"unverbed",synonyms:["verb"],gerund:"verbing",verb_noun_prep:[],verb_prep_noun:[],verb_prep_prep_noun:[],verb_prep_prep_prep_noun:[],verb_noun_prep_noun:[],verb_noun_prep_prep_noun:[],verb_noun_prep_noun_prep_noun:[],verb_prep_noun_prep_noun_prep_noun:[],accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{}},phrase2:{noun_must_be:{}},phrase3:{noun_must_be:{}},let_verb_handle_disambiguation:false,doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(input.hasStructure("verb"));if(input.hasStructure("verb noun"));if(input.hasStructure("verb preposition"));if(input.hasStructure("verb preposition noun"));if(input.hasStructure("verb noun preposition noun"));},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),verb_phrase=input.verb_phrase,direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),results,msg="";if(input.hasStructure("verb noun"));if(input.hasStructure("verb preposition noun"));if(input.hasStructure("verb noun preposition noun"));msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.verbose={name:"verbose",synonyms:["verbose"],accepts_structures:["verb"],do:function(){var input=this.game.getInput();if(this.game.settings.verbosity<this.game.settings.max_verbosity)this.game.settings.verbosity+=1;var msg="Ok, I'll try to show longer room descriptions. ";if(msg)this.game.print(msg,input.output_class);return true}};A.Preverbs.verbs={name:"verbs",synonyms:["verbs"],accepts_structures:["verb"],do:function(){var input=this.game.getInput(),verbList="Available verbs: ",count=0,prop;for(prop in this.dictionary.verbs){if(0<count)verbList+=", ";verbList+=this.dictionary.verbs[prop].prettyname;count++}this.game.print(verbList+=". ",input.output_class);return true}};A.Preverbs.wait={name:"wait",past_tense:"waited",synonyms:["wait","z"],gerund:"waiting",accepts_structures:["verb","verb noun noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true}},doTry:function(){var input=this.game.getInput(),asset1=input.getAsset(1),asset2=input.getAsset(2),msg="";if(asset1&&!asset1.hasClass("GlobalNumber")){this.game.debug("D1536",this.name+".js ",` ${asset1.id} can only be a number `);msg+=`{We} {don't} know how to ${input.input}. `;this.handleFailure(msg)}else{if(!asset2||asset2.is.time)return true;this.game.debug("D1537",this.name+".js ",` ${asset2.id} can only be a measure of turns or time `);msg+=`{We} {don't} know how to ${input.input}. `;this.handleFailure(msg)}return null},doSuccess:function(){var input=this.game.getInput(),asset1=input.getAsset(1),input=input.getAsset(2),msg="";if(asset1&&input)for(let i=0;i<asset1.values[0];i++)this.game.parser.input_queue.push({input:"wait",printInput:false});else{msg+=`{We} ${this.agree()} a turn. `;return this.handleSuccess(msg)}}};A.Preverbs.walk={name:"walk",prettyname:"walk",past_tense:"walked",synonyms:["walk"],gerund:"walking",type:{locomotion:true,travel:true},extends:{go:true},subject_must_be:{not_constrained:true,not_on_floor:true,not_nested_elsewhere:true,able_to_walk:true},accepts_adverbs:["left","right","around","back","towards","over"],accepts_structures:["verb","verb noun","verb preposition","verb preposition noun","verb noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true,reachable:true},accepts_preposition:true},with_params:{},doTry:function(){return this.game.dictionary.doVerb("go")},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.wave={name:"wave",past_tense:"waved",synonyms:["wave"],gerund:"waving",accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun"],subject_must_be:{not_constrained:true},phrase1:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true},accepts_preposition:true,preposition_must_be:["with","at","to"]},phrase2:{accepts_noun:true,noun_must_be:{known:true,tangible:true,present:true,visible:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["at","to","with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),msg="";if(input.hasStructure("verb noun")||input.hasStructure("verb noun preposition noun")){if(!direct_object.isDOV(this.name)){this.game.debug("D1996",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(0===this.game.parser.selectInHands(direct_object.id).length){this.game.debug("D1600",this.name+".js ",` ${direct_object.id}.isWithin subject is false `);msg+=`{We're} not holding ${direct_object.articlename}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1997",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`{We} can't ${this.name} ${direct_object.articlename} any more. `;this.handleFailure(msg);return false}}if(input.hasStructure("verb noun preposition noun")||input.hasStructure("verb preposition noun")){if(!indirect_object)indirect_object=direct_object;if(!indirect_preposition)indirect_preposition=direct_preposition;if("with"===indirect_preposition)if(!this.game.parser.selectInHands(indirect_object.id).length){this.game.debug("D2000",this.name+".js ",` ${indirect_object.id}.$is("inhands") is false `);msg+=`{We're} not holding ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1998",this.name+".js ",` ${indirect_object.id}.iov.${this.name} is unset `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1999",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`{We've} already ${this.past_tense} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}}if(input.hasStructure("verb noun preposition noun"));return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),results,msg="";msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+"! ";return this.handleSuccess(msg)}};A.Preverbs.wear={name:"wear",prettyname:"wear",past_tense:"wore",synonyms:["wear"],gerund:"wearing",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{dov:true,known:true,tangible:true,present:true,visible:true,reachable:true,takeable:true,in_inventory:true}},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{iov:true,known:true,tangible:true,present:true,visible:true,reachable:true,takeable:true,in_inventory:true},accepts_preposition:true},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),input=input.getAsset(1),parent=input.getPlaceAsset(),msg="";if(!input.isDOV("wear")){this.game.debug("D1497",this.name+".js ",` ${input.id}.dov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} ${input.articlename}. `;this.handleFailure(msg);return null}if(input.is.worn){this.game.debug("D1498",this.name+".js ",` ${input.id}.is.worn `);msg+=`{We're} already ${this.gerund} ${input.articlename}. `;this.handleFailure(msg);return null}if(input.is.zipped||input.is.buttoned){var state=input.is.zipped?"zipped":"buttoned",verb=input.is.zipped?"unzip":"unbutton";this.game.debug("D1892",this.name+".js ",` ${input.id}.is.${state} is true `);msg+=`{We'll} need to ${verb} ${input.articlename} first. `;this.handleFailure(msg);return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),closedAnscestors=[],direct_object=input.getAsset(1),parent=direct_object.getPlaceAsset(),tookFromParent,indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),input,msg="",input;if(parent.id!==subject.id){if(direct_object.isWithin(subject)&&direct_object.areAnscestorsClosed())for(var closedAnscestors=direct_object.getClosedAnscestors(),i=0;i<closedAnscestors.length;i++){this.game.getAsset(closedAnscestors[i]).is.closed=false;closedAnscestors[i]=this.game.getAsset(closedAnscestors[i]).name}if(void 0!==(input=parent.onRemoveThatFromThis(direct_object)))return input;if(void 0!==(input=subject.onMoveThatToThis(direct_object,"in")))return input;tookFromParent=true}if(0<closedAnscestors.length){msg+="{We} open the ";for(var i=0;i<closedAnscestors.length;i++){if(2<closedAnscestors.length&&i<closedAnscestors.length-2)msg+=", ";if(1<closedAnscestors.length&&i===closedAnscestors.length-1)msg+=" and the ";msg+=closedAnscestors[i]}msg+=". "}if(tookFromParent){msg+="{We} take "+direct_object.articlename;if(false==parent instanceof adventurejs.Room)msg+=" from "+parent.articlename;msg+=" and put it on. "}else msg+="{We} wear "+direct_object.articlename+". ";direct_object.is.worn=true;return this.handleSuccess(msg)}};A.Preverbs.where={name:"where",prettyname:"where is",synonyms:[],verb_prep_noun:["where is"],accepts_structures:["verb noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,tangible:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),input=input.getAsset(1),room=input.getRoomId(),results,msg="";if("Room"===input.class){this.game.debug("D1500","where.js ",' " + direct_object.id + ".class is Room ');this.handleFailure(msg+="Maybe {we} should draw a map? ")}else if(!input.areAnscestorsKnown()){this.game.debug("D1501","where.js ",` ${input.id} has unknown ancestors `);msg+=`{We} {don't} know where ${input.articlename} is. `;this.handleFailure(msg)}else if(!room){this.game.debug("D1502","where.js ",` ${input.id} has no room `);msg+=`{We} {don't} know where ${input.articlename} is. `;this.handleFailure(msg)}else{if(room!==this.game.world._room)return true;this.game.debug("D1503","where.js ",` ${input.id} is in current room `);msg+=input.Articlename_is+" right here in the room with {us}! ";this.handleFailure(msg)}return null},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),input=input.getAsset(1),room=this.game.getAsset(input.getRoomId()),results,msg="";msg+=`{We} last saw ${input.articlename} in ${room.use_definite_article_in_lists?room.definite_article+" ":""} ${room.name}. `;return this.handleSuccess(msg)}};A.Preverbs.write={name:"write",prettyname:"write on",past_tense:"wrote",synonyms:["write"],gerund:"writing",allow_iov_on_iov:true,accepts_structures:["verb noun","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun","verb noun preposition noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true,visible:true,reachable:true},accepts_preposition:true,preposition_must_be:["on","with"]},phrase2:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true,visible:true,reachable:true,prefer_carried_if_ambiguous:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["in","on","with"]},phrase3:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,present:true,visible:true,reachable:true,prefer_carried_if_ambiguous:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["in","on","with"]},with_params:{tool:false,target:false},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),msg="",info_asset,tool_asset,tool_preposition,tool_asset_inferred,target_asset,target_preposition,subject,count;for(let i=input.getPhraseCount();0<i;i--){var asset=input.getAsset(i),preposition=input.getPreposition(i);if(asset?.is.information){if(info_asset){this.game.debug("D1221",this.name+".js "," can't handle multiple information assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(preposition){this.game.debug("D1093",this.name+".js ",` no handling for "${preposition} ${asset.id}" `);msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.name}. `;this.handleFailure(msg);return false}info_asset=input.verb_params.info_asset=asset}else if(asset?.isIOV(this.name)&&asset.iov[this.name].with_params.tool){if(tool_asset){this.game.debug("D1597",this.name+".js "," can't handle multiple tool assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if("with"!==preposition){this.game.debug("D1243",this.name+".js "," can't handle preposition");msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}tool_asset=input.verb_params.tool_asset=asset;tool_preposition=input.verb_params.tool_preposition=preposition}else if(asset?.isIOV(this.name)&&asset.iov[this.name].with_params.target){if(target_asset){this.game.debug("D1301",this.name+".js "," can't handle multiple target assets");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(!["in","on"].includes(preposition)){this.game.debug("D1343",this.name+".js "," can't handle preposition");msg+=`{We} don't know how to ${this.name} ${preposition} ${asset.articlename}. `;this.handleFailure(msg);return null}target_asset=input.verb_params.target_asset=asset;target_preposition=input.verb_params.target_preposition=preposition}else{this.game.debug("D1203",this.name+".js ",` unusable asset ${asset.id} found`);msg+=`{We} don't know how to ${this.name} ${preposition?preposition:""} ${asset?asset.articlename:""}. `;this.handleFailure(msg);return null}}if(!info_asset&&!target_asset&&!tool_asset){this.game.debug("D1356",this.name+".js "," no relevant assets found");msg+=`{We} don't know how to ${input.input}. `;this.handleFailure(msg);return null}if(!info_asset){info_asset=input.verb_params.info_asset=this.game.getAsset("global_string");input.shiftPhrase({asset:info_asset})}if(!target_asset){var index=input.getPhraseCount()+1;input.setPreposition(index,"on");input.setSoftPrompt({index:index,type:"noun",["noun"+index]:true});this.game.debug("D1525",this.name+".js "," soft prompt for target asset ");this.handleFailure(msg+="What would {we} like to write on? ");return null}if(tool_asset&&!this.game.parser.selectInHands([tool_asset.id]).length){this.game.debug("D1549",this.name+".js ",` ${tool_asset.id}.place is not ${subject.id} `);msg+=`{We're} not holding ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(tool_asset&&!tool_asset.allowVerbWithAsset({verb:this.name,asset:target_asset,ov:"iov"})&&!tool_asset.allowVerbWithAnything(this.name,"iov")){this.game.debug("D1517",this.name+".js ",` neither ${tool_asset.id} nor ${target_asset.id} lists the other in dov/iov.${this.name}.with_assets or dov/iov.${this.name}.with_classes `);msg+=`${target_asset.Articlename} doesn't present a good writing surface for ${tool_asset.articlename}. `;this.handleFailure(msg);return null}if(!tool_asset&&this.game.settings.infer_objects)if((subject=this.tryToInferIndirectObject({direct_object:target_asset,context:subject,handle_input:false,infer_first_use:true})).fail);else if(subject.prompt);else if(subject.success){var tool_asset=input.verb_params.tool_asset=subject.indirect_object,tool_preposition=input.verb_params.tool_preposition="with",index=input.pushPhrase({asset:tool_asset,preposition:"with"});this.game.printInferred("with "+tool_asset.articlename)}if(!tool_asset){var index=input.hasPhrase(2)?3:2;input.setSoftPrompt({index:index,type:"noun",["noun"+index]:true,structure:input.getStructure()+" preposition noun"});input.setPreposition(index,"with");this.game.debug("D1759",this.name+".js "," soft prompt for noun2 ");this.handleFailure(msg+="What would {we} like to write with? ");return false}var phrase_count=input.getPhraseCount(),subject=input.getAsset(1);if(info_asset&&subject&&info_asset.id!==subject.id){let info_found_in_slot;for(let i=1;i<=phrase_count;i++)if(input.getAsset(i).id===info_asset.id){info_found_in_slot=i;break}input.swapPhrases(info_found_in_slot,1)}var index=input.getAsset(2);if(target_asset&&index&&target_asset.id!==index.id){let target_found_in_slot;for(let i=1;i<=phrase_count;i++)if(input.getAsset(i).id===target_asset.id){target_found_in_slot=i;break}if(target_found_in_slot)input.swapPhrases(target_found_in_slot,2)}var subject=input.getAsset(phrase_count);if(tool_asset&&subject&&tool_asset.id!==subject.id){let tool_found_in_slot;for(let i=1;i<=phrase_count;i++){let asset=input.getAsset(i);if(asset&&asset.id===tool_asset.id){tool_found_in_slot=i;break}}if(tool_found_in_slot)input.swapPhrases(tool_found_in_slot,phrase_count)}return true},doSuccess:function(){var input,results,msg="",{info_asset,info_preposition,target_asset,target_preposition,tool_asset,tool_preposition}=this.game.getInput().verb_params;msg+="{We} write ";if(target_asset){if(info_asset&&(info_asset.value||info_asset.values[0])){var info_asset=info_asset.value||info_asset.values[0]||"";info_asset.replace(/^"(.*)"$/,"$1");msg+=`<em class="string ${tool_asset.class.toLowerCase()} ${this.game.settings.apply_color_classes_to_written_strings?tool_asset.appearance.color:""}">${info_asset}</em> `;target_asset.written_strings.push({class:tool_asset.class,erasable:tool_asset.is.erasable,data:info_asset,color:tool_asset.appearance.color||""})}else{msg+=" a few scribbles ";target_asset.appearance.scribbles=true}msg=(msg+=target_asset.hasQuirk("write_on_means_write_in")?"in ":"on ")+target_asset.articlename}else msg+=" a few scribbles in the air";if(tool_asset)msg+=" with "+tool_asset.articlename;return this.handleSuccess(msg+=". ")}};A.Preverbs.xyzzy={name:"xyzzy",prettyname:"xyzzy",synonyms:[],accepts_structures:["verb"],do:function(){var input=this.game.getInput(),msg="Clever xyzzy response! ";if(msg)this.game.print(msg,input.output_class);return true}};A.Preverbs.yell={name:"yell",past_tense:"yelled",synonyms:["yell","scream","shout"],gerund:"yelling",accepts_structures:["verb","verb noun","verb preposition noun","verb noun preposition noun","verb preposition noun preposition noun"],phrase1:{accepts_noun:true,noun_must_be:{known:true},accepts_preposition:true},phrase2:{accepts_noun:true,noun_must_be:{known:true},accepts_preposition:true,requires_preposition:true},with_params:{},doTry:function(){var input,subject=this.game.getInput().getSubject(),room=this.game.getRoom(),msg="";if(subject.is.mute){this.game.debug("D1506",this.name+".js ",` ${subject.id}.is.mute `);this.handleFailure(msg+="{We} can't yell at all. ");return null}if(room.is.vacuum){this.game.debug("D1507",this.name+".js ",` ${room.id}.is.vacuum `);this.handleFailure(msg+="In space, no one can hear you scream. ");return null}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),room=this.game.getRoom(),results,msg="";if(input.hasStructure("verb"))msg+="WILHELM!!! ";else msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?direct_object.hasClass("GlobalString")?" "+input.strings[0]:" "+direct_object.articlename:"")+(indirect_preposition?" "+indirect_preposition:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.zip={name:"zip",synonyms:["zip"],past_tense:"zipped",prettyname:"zip",state:"zipped",gerund:"zipping",accepts_structures:["verb noun","verb noun preposition noun"],phrase1:{accepts_noun:true,requires_noun:true,noun_must_be:{known:true,not_global:true,tangible:true,present:true,reachable:true}},phrase2:{accepts_noun:true,noun_must_be:{known:true,in_inventory:true},accepts_preposition:true,requires_preposition:true,preposition_must_be:["with"]},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),indirect_object=input.getAsset(2),indirect_preposition=input.getPreposition(2),indirect_inferred,subject,msg="";if(!direct_object.isDOV(this.name)){this.game.debug("D1286",this.name+".js ",` ${direct_object.id}.dov.${this.name}.enabled is false `);msg+=`${direct_object.Articlename} can't be ${this.past_tense}. `;this.handleFailure(msg);return false}if(this.hasState()&&direct_object.isVerbState(this.name)){this.game.debug("D1287",this.name+".js ",` ${direct_object.id}.is.${this.getState()} is `+direct_object.isVerbState(this.name));msg+=`${direct_object.Articlename_is} already ${this.getState()}. `;this.handleFailure(msg);return null}if(direct_object.allowVerbOnce(this.name,"dov")&&direct_object.didVerb(this.name,"dov")){this.game.debug("D1288",this.name+".js ",` ${direct_object.id}.dov.${this.name}.once and ${direct_object.id}.did.${this.name}.directly `);msg+=`${direct_object.Articlename} has already been ${this.past_tense}. `;this.handleFailure(msg);return false}if(input.hasStructure("verb noun")){if(!direct_object.hasIndirectObjects(this.name)&&!direct_object.allowVerbWithNothing(this.name,"dov")){this.game.debug("D1289",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_nothing is false `);msg+=`{We} {don't} know of a way to ${this.name} ${direct_object.articlename}. `;this.handleFailure(msg);return null}if((subject=this.tryToInferIndirectObject({direct_object:direct_object,context:subject,handle_input:true})).prompt){if(direct_object.allowVerbWithNothing(this.name,"dov"))return true;this.game.debug("D1300",this.name+".js "," soft prompt for noun2 ");msg+=`What would {we} like to ${this.name} ${direct_object.articlename} with? `;this.handleFailure(msg);return false}if(subject.success){indirect_object=subject.indirect_object;indirect_preposition="with";input.setAsset(2,indirect_object);input.setPreposition(2,indirect_preposition);input.setStructure("verb noun preposition noun");this.game.printInferred(indirect_preposition+" "+indirect_object.articlename)}}if(input.hasStructure("verb noun preposition noun")){if(direct_object.allowVerbWithAnything(this.name,"dov"))return true;if(!direct_object.allowVerbWithAsset({verb:this.name,asset:indirect_object,ov:"dov"})){this.game.debug("D1302",this.name+".js ",` ${direct_object.id}.dov.${this.name}.with_assets/with_classes does not include ${indirect_object.id} `);msg+=`{We} can't ${this.name} ${direct_object.articlename} ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return null}if(!indirect_object.isIOV(this.name)){this.game.debug("D1914",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.enabled is false `);msg+=`{We} can't ${this.name} anything ${indirect_preposition} ${indirect_object.articlename}. `;this.handleFailure(msg);return false}if(indirect_object.allowVerbOnce(this.name,"iov")&&indirect_object.iDidVerb(this.name,"iov")){this.game.debug("D1915",this.name+".js ",` ${indirect_object.id}.iov.${this.name}.once and ${indirect_object.id}.did.${this.name}.indirectly is ${indirect_object.did[this.name].indirectly} `);msg+=`${indirect_object.Articlename} has already been used to ${this.name} something. `;this.handleFailure(msg);return null}}return true},doSuccess:function(){var input=this.game.getInput(),subject=input.getSubject(),direct_object=input.getAsset(1),direct_preposition=input.getPreposition(1),indirect_object=input.getAsset(2),input=input.getPreposition(2),msg="",results;this.setState(direct_object,true);msg+="{We} "+this.agree()+(direct_preposition?" "+direct_preposition:"")+(direct_object?" "+direct_object.articlename:"")+(input?" "+input:"")+(indirect_object?" "+indirect_object.articlename:"")+". ";return this.handleSuccess(msg)}};A.Preverbs.aft={name:"aft",is_direction:true,is_relative_direction:true,synonyms:["aft","rearward","stern"],adjective:"aftward",type:{direction:true},accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.backward={name:"backward",is_direction:true,is_relative_direction:true,synonyms:["backward","backwards","back"],type:{direction:true},adjective:"backward",article:"",accepts_structures:["verb"],doTry:function(){var results;if(this.game.getRoom().exits.fore){if(!(results=this.game.tryTravel("fore")))this.handleFailure()}else if(this.game.getRoom().exits.backward){if(!(results=this.game.tryTravel("backward")))this.handleFailure();return results}return true},doSuccess:function(){var msg=`{We} move ${this.name} a bit. `;return this.handleSuccess(msg)}};A.Preverbs.down={name:"down",is_direction:true,is_relative_direction:true,synonyms:["down","d"],type:{direction:true},adjective:"downward",accepts_structures:["verb"],doTry:function(){var input,subject=(input=this.game.getInput()).getSubject(),nest_asset=subject.getNestAsset(),nest_aspect=subject.getNestAspect(),input=this.game.getInput(),msg="",subject,newverb,newprep;if(nest_asset){if(0<nest_aspect.scale_increment&&subject.getY()>nest_asset.getY()+nest_aspect.scale_increment){newverb="go";newprep="down"}else if(nest_asset){newverb="go";newprep="off"}if(newverb){this.game.debug("D1137",this.name+".js ",` subject is nested ${nest_aspect.preposition} ${nest_asset.id}, infer doVerb ${newverb} `+newprep);input.input_verb=newverb;input.setVerb(1,newverb);input.setAsset(1,nest_asset);input.setPreposition(1,newprep);input.setStructure("verb preposition noun");return this.game.dictionary.doVerb(newverb)}}if(!(subject=this.game.tryTravel(this.name)))this.handleFailure();return subject},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.east={name:"east",is_direction:true,is_compass_direction:true,synonyms:["east","e","eastward"],adjectives:["eastern","easterly","easternly"],adjective:"easterly",article:"the",type:{direction:true},accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.enter={name:"enter",past_tense:"entered",synonyms:["enter","in"],is_direction:false,type:{direction:false},gerund:"entering",accepts_structures:["verb","verb noun"],phrase1:{accepts_noun:true,noun_must_be:{tangible:true,known:true,present:true,visible:true}},with_params:{},doTry:function(){var input=this.game.getInput(),direct_object=input.getAsset(1),room=this.game.getRoom(),direct_object,msg="";if(direct_object){input.setPreposition(1,"in");input.setStructure("verb preposition noun");return this.game.dictionary.doVerb("go")}if(room.default_entrance){if(!(direct_object=this.game.tryTravel(room.default_entrance)))this.handleFailure();return direct_object}else{this.game.debug("D1487",this.name+".js "," no direction, soft prompt noun1");msg+="What did {we} want to enter? ";input.setSoftPrompt({index:1,type:"noun",noun1:true,verb_phrase:"go",verb:"go",structure:"verb noun"});this.handleFailure(msg);return null}},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.exit={name:"exit",past_tense:"exited",is_direction:false,synonyms:["exit","leave"],gerund:"exiting",type:{direction:false},default_direction:"out",accepts_structures:["verb","verb noun"],phrase1:{accepts_noun:true,noun_must_be:{parent_or_room:true}},with_params:{},doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),room=this.game.getRoom(),nest_asset=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),subject=subject.getUnnestPreposition(),direct_object=input.getAsset(1),msg="",nest_preposition;if(direct_object){if(nest_asset){if(nest_asset.id===direct_object.id){this.game.debug("D1277",this.name+".js "," infer go "+subject);input.setPreposition(1,subject);input.setStructure("verb preposition noun");return this.game.dictionary.doVerb("go")}if(nest_asset.id!==direct_object.id&&!direct_object.hasClass("Room")){this.game.debug("D1220",this.name+".js ",` subject is ${nest_preposition} ${nest_asset.id}, not `+direct_object.id);msg+=`{We} can't exit 
              ${direct_object.articlename}
              from {our} position 
              ${nest_preposition}
              ${nest_asset.articlename}. `;this.handleFailure(msg);return null}}if(!nest_asset)if(direct_object.id===room.id)this.game.debug("D1276",this.name+".js "," tryTravel exit")}if(!direct_object)if(nest_asset){input.setAsset(1,nest_asset);input.setPreposition(1,subject);input.setStructure("verb preposition noun");this.game.debug("D1278",this.name+".js "," infer go "+subject);return this.game.dictionary.doVerb("go")}if(room.default_exit){if(!(nest_preposition=this.game.tryTravel(room.default_exit)))this.handleFailure();return nest_preposition}else{this.game.debug("D1070",this.name+".js "," no direction, soft prompt noun1");msg+="What direction did {we} want to go? ";input.setSoftPrompt({index:1,type:"noun",noun1:true,verb_phrase:"go",verb:"go",structure:"verb noun"});this.handleFailure(msg);return null}},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.fore={name:"fore",is_direction:true,is_relative_direction:true,synonyms:["fore","bow"],type:{direction:true},adjective:"foreward",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.forward={name:"forward",is_direction:true,is_relative_direction:true,synonyms:["forward","forwards"],type:{direction:true},adjective:"forward",article:"",accepts_structures:["verb"],doTry:function(){var results;if(this.game.getRoom().exits.fore){if(!(results=this.game.tryTravel("fore")))this.handleFailure()}else if(this.game.getRoom().exits.forward){if(!(results=this.game.tryTravel("forward")))this.handleFailure();return results}return true},doSuccess:function(){var msg=`{We} move ${this.name} a bit. `;return this.handleSuccess(msg)}};A.Preverbs.in={name:"in",is_direction:true,is_relative_direction:true,synonyms:["in"],type:{direction:true},adjective:"inward",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.left={name:"left",is_direction:true,is_relative_direction:true,synonyms:["left"],type:{direction:true},adjective:"leftward",article:"the",accepts_structures:["verb"],doTry:function(){var results;if(this.game.getRoom().exits.port){if(!(results=this.game.tryTravel("port")))this.handleFailure()}else if(this.game.getRoom().exits.left){if(!(results=this.game.tryTravel("left")))this.handleFailure();return results}return true},doSuccess:function(){var msg=`{We} turn to the ${this.name}. `;return this.handleSuccess(msg)}};A.Preverbs.north={name:"north",is_direction:true,is_compass_direction:true,synonyms:["north","n","northward"],adjectives:["northern","northernly"],article:"the",type:{direction:true},adjective:"northerly",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.northeast={name:"northeast",is_direction:true,is_compass_direction:true,synonyms:["northeast","ne","northeastward"],adjectives:["northeastern","northeasterly","northeasternly"],article:"the",type:{direction:true},adjective:"northeasterly",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.northwest={name:"northwest",is_direction:true,is_compass_direction:true,synonyms:["northwest","nw","northwestward"],adjectives:["northwestern","northwesterly","northwesternly"],article:"the",type:{direction:true},adjective:"northwesterly",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.out={name:"out",is_direction:true,is_relative_direction:true,synonyms:["out"],type:{direction:true},adjective:"outward",accepts_structures:["verb"],doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),msg="",p;if(subject.isNested()){var p=subject.getNestPreposition();if("in"===p||"under"===p||"behind"===p){this.game.debug("D1141",this.name+".js",`infer 'get out of ${subject.getNestId()}', doVerb go out`);input.setVerb(1,"go");input.setPreposition(1,"out");input.setStructure("verb preposition noun");input.setAsset(1,subject.getNestAsset());return this.game.dictionary.doVerb("go")}}if(!(p=this.game.tryTravel(this.name)))this.handleFailure();return p},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.port={name:"port",is_direction:true,is_relative_direction:true,synonyms:["port"],type:{direction:true},adjective:"portward",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.right={name:"right",is_direction:true,is_relative_direction:true,synonyms:["right"],type:{direction:true},adjective:"rightward",article:"the",accepts_structures:["verb"],doTry:function(){var results;if(this.game.getRoom().exits.starboard){if(!(results=this.game.tryTravel("starboard")))this.handleFailure()}else if(this.game.getRoom().exits.right){if(!(results=this.game.tryTravel("right")))this.handleFailure();return results}return true},doSuccess:function(){var msg=`{We} turn to the ${this.name}. `;return this.handleSuccess(msg)}};A.Preverbs.south={name:"south",is_direction:true,is_compass_direction:true,synonyms:["south","s","southward"],adjective:"southerly",adjectives:["southern","southerly","southernly"],article:"the",type:{direction:true},accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.southeast={name:"southeast",is_direction:true,is_compass_direction:true,synonyms:["southeast","se","southeastward"],adjectives:["southeastern","southeasterly","southeasternly"],article:"the",type:{direction:true},adjective:"southeasterly",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.southwest={name:"southwest",is_direction:true,is_compass_direction:true,synonyms:["southwest","sw","southwestward"],adjectives:["southwestern","southwesterly","southwesternly"],article:"the",type:{direction:true},adjective:"southwesterly",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.starboard={name:"starboard",is_direction:true,is_relative_direction:true,synonyms:["starboard","right"],type:{direction:true},adjective:"starboardward",accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.up={name:"up",is_direction:true,is_relative_direction:true,synonyms:["up","u"],type:{direction:true},adjective:"upward",accepts_structures:["verb"],doTry:function(){var input=this.game.getInput(),subject=input.getSubject(),nest_asset=subject.getNestAsset(),subject,newverb,newprep;if(nest_asset&&subject.position.y<nest_asset.getYTop()){newverb="go";newprep="up";this.game.debug("D1142",this.name+".js ",` subject is nested below the top of ${nest_asset.id}, which is scalable, infer doVerb go up`);input.input_verb="go";input.setVerb(1,"go");input.setAsset(1,nest_asset);input.setPreposition(1,"up");input.setStructure("verb preposition noun");return this.game.dictionary.doVerb("go")}if(!(subject=this.game.tryTravel(this.name)))this.handleFailure();return subject},doSuccess:function(){return this.handleSuccess()}};A.Preverbs.west={name:"west",is_direction:true,is_compass_direction:true,synonyms:["west","w","westward"],adjectives:["western","westerly","westernly"],adjective:"westerly",article:"the",type:{direction:true},accepts_structures:["verb"],doTry:function(){var results=this.game.tryTravel(this.name);if(!results)this.handleFailure();return results},doSuccess:function(){return this.handleSuccess()}};(()=>{class Display{constructor(displayElId,game){game.log("L1005","log",1,"[Display.js] Constructing display.","Display");this.game=game;this.compasses=[];this.verbdocks=[];this.roomdocks=[];this.inventorydocks=[];this.imagedocks=[];this.displayEl=null;this.displayElId=null;this.initialize(displayElId)}appendClassesToLastInput(classes){var inputs=this.outputEl.querySelectorAll(".ajs-player-input"),last_input;inputs.item(inputs.length-1).classList.add(classes)}appendClassesToLastOutput(classes){var outputs=this.outputEl.querySelectorAll(".ajs-p:not(.ajs-player-input):not(.ajs-debug)"),last_output;outputs.item(outputs.length-1).classList.add(classes)}get title(){return this.titleEl.innerText}set title(title){this.titleEl.innerText=title}get version(){return this.versionEl.innerText}set version(version){this.versionEl.innerText=version}get author(){return this.authorEl.innerText}set author(author){this.authorEl.innerText=author}get room(){return this.roomEl.innerText}set room(room){this.roomEl.innerHTML=room}get score(){return this.scoreEl.innerText}set score(score){this.scoreEl.innerText=score}}adventurejs.Display=Display})();(()=>{var p;adventurejs.Display.prototype.clearInput=function Display_clearInput(value){this.inputEl.value="";this.inputContainerEl.classList.remove("active")}})();(()=>{var p;adventurejs.Display.prototype.clearOutput=function Display_clearOutput(){this.outputEl.innerHTML=""}})();(()=>{var p;adventurejs.Display.prototype.createCompass=function Display_createCompass(properties){var compass,status;let author_element,exits;if("marine"===properties.type)exits=[["ud","updown"],["fore","marine"],["aft","marine"],["port","marine"],["starboard","marine"]];else exits=[["northwest","ordinal"],["north","cardinal"],["northeast","ordinal"],["west","cardinal"],["ud","updown"],["east","cardinal"],["southwest","ordinal"],["south","cardinal"],["southeast","ordinal"]];if(properties.id)author_element=document.querySelector("#"+properties.id);compass=author_element?author_element:document.createElement("div");if(properties.id)compass.setAttribute("id",properties.id);compass.classList.add("ajs-compass-wrapper","ajs-dock-wrapper");if(properties.cssclasses)for(var item in properties.cssclasses)compass.classList.add(properties.cssclasses[item]);if(properties.createnodes){var exitsEl=document.createElement("div");exitsEl.classList.add("ajs-compasspoints");compass.appendChild(exitsEl);var exitsHoverCatchEl=document.createElement("div"),exit;exitsHoverCatchEl.classList.add("ajs-compass-hover-trap");exitsHoverCatchEl.game=this.game;exitsEl.appendChild(exitsHoverCatchEl);exitsHoverCatchEl.addEventListener("mouseenter",()=>{});for(exit in exits){let exitEl;if("ud"===exits[exit][0]){exitEl=document.createElement("div");var u=document.createElement("div");u.classList.add("ajs-compasspoint","up","ajs-compasspoint-button");u.dataset.exit="up";u.innerHTML="up";u.game=this.game;u.setAttribute("aria-disabled","true");exitEl.appendChild(u);var u=document.createElement("div");u.classList.add("ajs-compasspoint","down","ajs-compasspoint-button");u.dataset.exit="down";u.innerHTML="down";u.game=this.game;u.setAttribute("aria-disabled","true");exitEl.appendChild(u)}else{(exitEl=document.createElement("button")).setAttribute("aria-disabled","true");exitEl.innerHTML=exits[exit][0]}exitEl.classList.add("ajs-compasspoint","ajs-compasspoint-button",exits[exit][0],exits[exit][1]);exitEl.dataset.exit=exits[exit][0];exitEl.game=this.game;exitsEl.appendChild(exitEl)}compass.querySelectorAll(".ajs-compasspoint-button").forEach(function(el){el.addEventListener("mouseenter",function(event){this.classList.add("active")});el.addEventListener("mouseleave",function(event){this.classList.remove("active")});el.addEventListener("click",function(event){console.warn("clicked",this);this.game.sendToParser(el.dataset.exit)})})}if(!properties.statusbar&&!author_element)this.displayEl.appendChild(compass);this.compasses.push(compass);return compass}})();(()=>{var p;adventurejs.Display.prototype.createImageDock=function Display_createImageDock({id,cssclasses,type,messages}={}){console.warn("createImageDock",{id:id,cssclasses:cssclasses,type:type,messages:messages});let author_element;var dock;if(id)author_element=document.querySelector("#"+id);dock=author_element?author_element:document.createElement("div");if(id)dock.setAttribute("id",id);if(type)dock.dataset.type=type;dock.classList.add("game_imagedock_container","ajs-dock-wrapper");if(cssclasses)for(var item in cssclasses)dock.classList.add(cssclasses[item]);dock.game=this.game;if(messages)dock.messages=messages;dock.addEventListener("click",function(event){console.warn("clicked dock");if(this.messages)this.game.print(A.getSAF.call(this.game,this.messages))});this.imagedocks.push(dock);if(!author_element)this.displayEl.appendChild(dock);return dock}})();(()=>{var p;adventurejs.Display.prototype.createInventoryDock=function Display_createInventoryDock(properties){console.warn("createInventoryDock",properties);let author_element;var dock;if(properties.id)author_element=document.querySelector("#"+properties.id);dock=author_element?author_element:document.createElement("div");if(properties.id)dock.setAttribute("id",properties.id);dock.classList.add("game_inventorydock_container","ajs-dock-wrapper");if(properties.cssclasses)for(var item in properties.cssclasses)dock.classList.add(properties.cssclasses[item]);if(properties.assetclasses)dock.dataset.assetclasses=properties.assetclasses.join(",");if(properties.is)dock.dataset.is=properties.is.join(",");if(properties.is_in)dock.dataset.is_in=properties.is_in.join(",");this.inventorydocks.push(dock);if(!author_element)this.displayEl.appendChild(dock);return dock}})();(()=>{var p;adventurejs.Display.prototype.createRoomDock=function Display_createRoomDock(properties){console.warn("createRoomDock",properties);let author_element;var dock;if(properties.id)author_element=document.querySelector("#"+properties.id);dock=author_element?author_element:document.createElement("div");if(properties.id)dock.setAttribute("id",properties.id);dock.classList.add("game_roomdock_container","ajs-dock-wrapper");if(properties.cssclasses)for(var item in properties.cssclasses)dock.classList.add(properties.cssclasses[item]);this.roomdocks.push(dock);if(!author_element)this.displayEl.appendChild(dock);return dock}})();(()=>{var p;adventurejs.Display.prototype.createVerbDock=function Display_createVerbDock(properties){console.warn("createVerbDock",properties);let author_element;var dock;if(properties.id)author_element=document.querySelector("#"+properties.id);dock=author_element?author_element:document.createElement("div");if(properties.id)dock.setAttribute("id",properties.id);dock.classList.add("game_verbdock_container","ajs-dock-wrapper");if(properties.cssclasses)for(var item in properties.cssclasses)dock.classList.add(properties.cssclasses[item]);let verbs=document.createElement("div");verbs.classList.add("verbdock","verbs");dock.appendChild(verbs);if(properties.clear){var clearbtn=document.createElement("button");clearbtn.classList.add("dock_button","btn_verb","btn_clearverbs");clearbtn.innerHTML="&#x2716;";clearbtn.game=this.game;clearbtn.addEventListener("click",function(){this.game.clearInput()});verbs.appendChild(clearbtn)}properties.verbs.forEach(function(verb){if("string"==typeof verb)verb={verb:verb,parse:this.game.dictionary.verbs[verb]?.canBeIntransitive()?false:true};var btn=document.createElement("button");btn.dataset.verb=verb.verb;btn.dataset.parse=verb.parse?verb.parse:false;btn.classList.add(btn.dataset.verb,"dock_button","btn_verb");if(verb.cssclasses)for(var item in verb.cssclasses)btn.classList.add(verb.cssclasses[item]);btn.innerHTML+=`<span class="ajs-verb ajs-name">${verb.verb}</span>`;if(this.game.image_lookup[verb.verb]){btn.classList.add("hasimage");btn.innerHTML+=`<span class="ajs-verb ajs-icon"><img src="${this.game.image_lookup[verb.verb]}"/></span>`}btn.game=this.game;btn.addEventListener("click",function(){console.warn("clicked",this);if("true"===this.dataset.parse)this.game.sendToParser(this.dataset.verb);else this.game.sendToInput(this.dataset.verb)});verbs.appendChild(btn)},this);this.verbdocks.push(dock);if(!author_element)this.displayEl.appendChild(dock);return dock}})();(()=>{var p;adventurejs.Display.prototype.initialize=function Display_initialize(displayElId){function getPreferredTheme(){return localStorage.getItem("theme")||(window.matchMedia("(prefers-color-scheme: dark)").matches?"dark":"light")}var theme=getPreferredTheme();if("string"==typeof displayElId)this.displayEl=document.getElementById(displayElId);if(!this.displayEl){var el=document.createElement("div");el.setAttribute("id",displayElId);document.getElementsByTagName("body")[0].appendChild(el);this.displayEl=el}this.displayEl.classList.add("ajs-display",theme);this.displayEl.dataset.theme=theme;this.displayElId=displayElId;this.contentEl=document.createElement("div");this.contentEl.classList.add("ajs-content");this.displayEl.appendChild(this.contentEl);this.dialogsEl=document.createElement("div");this.dialogsEl.classList.add("ajs-dialogs");this.displayEl.appendChild(this.dialogsEl);this.titlebarEl=document.createElement("div");this.titlebarEl.classList.add("ajs-titlebar");this.contentEl.appendChild(this.titlebarEl);this.titleEl=document.createElement("span");this.titleEl.classList.add("ajs-title");this.titleEl.innerText="Unnamed Game";this.titlebarEl.appendChild(this.titleEl);this.versionEl=document.createElement("span");this.versionEl.classList.add("ajs-version");this.versionEl.innerText="v0.0";this.titlebarEl.appendChild(this.versionEl);this.authorEl=document.createElement("span");this.authorEl.classList.add("ajs-author");this.authorEl.innerText="Unnamed Author";this.titlebarEl.appendChild(this.authorEl);this.themerEl=document.createElement("div");this.themerEl.classList.add("ajs-themer-container");this.titlebarEl.appendChild(this.themerEl);this.themerEl.innerHTML=`
      <label for="${this.game.game_name}-ajs-themer" class="ajs-hidden-label">Choose a Theme:</label>
      <select id="${this.game.game_name}-ajs-themer" class="ajs-themer">
        <option value="light" ${"light"===theme?"selected":""}>Light</option>
        <option value="dark" ${"dark"===theme?"selected":""}>Dark</option>
        <!-- <option value="solarized" ${"solarized"===theme?"selected":""}>Solarized</option> -->
        <!-- <option value="high-contrast" ${"dark"===theme?"high-contrast":""}>High Contrast</option> -->
      </select>
    `;let themer=this.themerEl,self=this;function applyTheme(theme){document.documentElement.setAttribute("data-theme",theme);self.displayEl.setAttribute("data-theme",theme);localStorage.setItem("theme",theme);themer.value=theme}this.themerEl.addEventListener("change",event=>{applyTheme(event.target.value)});applyTheme(getPreferredTheme());this.statusbarEl=document.createElement("div");this.statusbarEl.classList.add("ajs-statusbar");this.contentEl.appendChild(this.statusbarEl);this.exitsContainerEl=this.createCompass({statusbar:true,createnodes:true,cssclasses:["statusbar"]});this.statusbarEl.appendChild(this.exitsContainerEl);if(!this.game.settings.show_compass_rose_in_status)this.exitsContainerEl.classList.add("hidden");if(this.game.settings.magnify_compass_rose_on_hover)this.exitsContainerEl.classList.add("magnify");this.roomEl=document.createElement("span");this.roomEl.classList.add("ajs-room");this.statusbarEl.appendChild(this.roomEl);this.scoreEl=document.createElement("span");this.scoreEl.classList.add("ajs-score");this.statusbarEl.appendChild(this.scoreEl);this.outputWrapperEl=document.createElement("div");this.outputWrapperEl.classList.add("ajs-output-wrapper");this.contentEl.appendChild(this.outputWrapperEl);this.outputEl=document.createElement("div");this.outputEl.classList.add("ajs-output");this.outputWrapperEl.appendChild(this.outputEl);this.inputContainerEl=document.createElement("div");this.inputContainerEl.classList.add("ajs-input-wrapper");this.contentEl.appendChild(this.inputContainerEl);this.inputPromptEl=document.createElement("span");this.inputPromptEl.classList.add("ajs-input-arrow");this.inputPromptEl.innerHTML=">";this.inputContainerEl.appendChild(this.inputPromptEl);this.inputEl=document.createElement("input");this.inputEl.maxLength=75;this.inputEl.placeholder="type your input here";(this.inputEl.display=this).inputEl.game=this.game;this.inputEl.setAttribute("id",this.game.game_name+"-ajs-input");this.inputEl.setAttribute("autocomplete","off");this.inputEl.classList.add("ajs-input");this.inputContainerEl.appendChild(this.inputEl);this.inputEl.addEventListener("input",function(event){if(!this.value||""===this.value||!this.value.length)this.display.inputContainerEl.classList.remove("active");else this.display.inputContainerEl.classList.add("active")});this.inputEl.addEventListener("keyup",function(event){if("Enter"===event.key)this.game.sendToParser(this.value);else if("ArrowUp"===event.key)this.value=this.game.parser.getOlderInput();else if("ArrowDown"===event.key)this.value=this.game.parser.getNewerInput()});this.clearBtn=document.createElement("button");this.clearBtn.classList.add("clear","icon");(this.clearBtn.display=this).inputContainerEl.appendChild(this.clearBtn);this.clearBtn.addEventListener("click",function(){this.display.clearInput()});this.enterBtn=document.createElement("button");this.enterBtn.classList.add("enter","icon");(this.enterBtn.display=this).enterBtn.game=this.game;this.inputContainerEl.appendChild(this.enterBtn);this.enterBtn.addEventListener("click",function(){this.game.sendToParser(this.display.inputEl.value)});this.displayEl.classList.remove("unplayed","loading");this.displayEl.classList.add("initialized")}})();(()=>{var p;adventurejs.Display.prototype.print=function Display_print(msg,classes){this.outputEl.innerHTML=this.outputEl.innerHTML+(msg=`<span class="ajs-p ${classes}">${msg}</span>`);this.outputWrapperEl.scrollTo({top:this.outputWrapperEl.scrollHeight,left:0,behavior:"smooth"});console.warn({msg:msg});return msg}})();(()=>{var p;adventurejs.Display.prototype.printInput=function Display_printInput(input){if(void 0!==input)this.print("> "+input,"ajs-player-input");else if(0<this.game.parser.getInputCount())this.print("> "+this.game.parser.getLastInput(),"ajs-player-input")}})();(()=>{var p;adventurejs.Display.prototype.printWithInput=function Display_printWithInput(msg,classes){if(0<this.game.parser.getInputCount())this.print("> "+this.game.parser.getLastInput(),"input");this.print(msg,classes)}})();(()=>{var p;adventurejs.Display.prototype.sendToInput=function Display_sendToInput(value){if(this.inputEl.value.length)this.inputEl.value+=" ";this.inputEl.value+=value;this.clearBtn.classList.add("active")}})();(()=>{var p;adventurejs.Display.prototype.set=function Display_set(props){if(null!=props)for(var n in props)this[n]=props[n];return this}})();(()=>{var p;adventurejs.Display.prototype.setRoomImage=function Display_setRoomImage(id){this.imagedocks.forEach(function(dock){if(dock.dataset.type&&"room"===dock.dataset.type.toLowerCase())if(this.game.image_lookup[id])dock.innerHTML=`<img src="${this.game.image_lookup[id]}" class="room_image id_${id}"/>`;else dock.innerHTML=""},this);return this}})();(()=>{var p;adventurejs.Display.prototype.setRoomName=function Display_setRoomName(name){this.roomEl.innerHTML=name;return this}})();(()=>{var p;adventurejs.Display.prototype.setScore=function Display_setScore(score){this.scoreEl.innerText=score;return this}})();(()=>{var p;adventurejs.Display.prototype.unsetCompasses=function Display_unsetCompasses(){this.compasses.forEach(function(element){element.querySelector(".ajs-compasspoints")?.setAttribute("class","ajs-compasspoints")})}})();(()=>{var p;adventurejs.Display.prototype.unsetImageDocks=function Display_unsetImageDocks(properties){}})();(()=>{var p;adventurejs.Display.prototype.unsetInventoryDocks=function Display_unsetInventoryDocks(properties){}})();(()=>{var p;adventurejs.Display.prototype.unsetRoomDocks=function Display_unsetRoomDocks(properties){}})();(()=>{var p;adventurejs.Display.prototype.unsetVerbDocks=function Display_unsetVerbDocks(properties){}})();(()=>{var p;adventurejs.Display.prototype.updateCompasses=function Display_updateCompasses(exitlist){let exitnames=Object.keys(exitlist).join(" ");this.compasses.forEach(function(element){var element=element.querySelector(".ajs-compasspoints");element?.setAttribute("class","ajs-compasspoints "+exitnames);element?.querySelectorAll(".ajs-compasspoint").forEach(function(point){var exit=exitlist[point.dataset.exit];if(exitnames.includes(point.dataset.exit)){point.setAttribute("aria-disabled",false);if(exit){if(exit.is.used)point.classList.add("ajs-used");if(exit.is.closed)point.classList.add("ajs-closed");if(exit.is.locked)point.classList.add("ajs-locked");if(exit.is.locked)point.classList.add("ajs-sealed")}}else{point.setAttribute("aria-disabled",true);point.classList.remove("ajs-used");point.classList.remove("ajs-closed");point.classList.remove("ajs-locked");point.classList.remove("ajs-sealed")}})})}})();(()=>{var p;adventurejs.Display.prototype.updateImageDocks=function Display_updateImageDocks(properties){}})();(()=>{var p;adventurejs.Display.prototype.updateInventoryDocks=function Display_updateInventoryDocks(inventory){this.inventorydocks.forEach(function(dock){let html='<div class="inventorydock">',assetclasses,is,is_in;if(dock.dataset.assetclasses)assetclasses=dock.dataset.assetclasses.split(",");if(dock.dataset.is)is=dock.dataset.is.split(",");if(dock.dataset.is_in)is_in=dock.dataset.is_in.split(",");inventory.forEach(function(item){var asset=this.game.getAsset(item);let image="",hasimage="";if(asset.image){image=`<span class="inventory icon"><img src="${this.game.image_lookup[asset.image]}"/></span>`;hasimage="hasimage"}let allow=true;if(assetclasses&&assetclasses.length){let allowed_class=false;for(var klas in assetclasses)if(asset instanceof adventurejs[assetclasses[klas]])allowed_class=true;if(!allowed_class)allow=false}if(is&&is.length){let allowed_is=false;for(var truth in is)if(asset.is[is[truth]])allowed_is=true;if(!allowed_is)allow=false}if(is_in&&is_in.length){console.warn("asset",asset);console.warn("is_in",is_in);let allowed_is_in=false;for(var id in is_in)if(asset.isWithin(is_in[id]))allowed_is_in=true;if(!allowed_is_in)allow=false}if(allow){var item=`<button data-id="${asset.id}" data-name="${asset.name}" class="dock_button btn_inventory inventory id_${asset.id} class_${asset.class} ${hasimage}" data-name="${asset.name}"><span class="inventory name">${asset.name}</span>${image}</button>`;html+=item}},this);html+="</div>";dock.innerHTML=html;dock.querySelectorAll(".btn_inventory").forEach(function(el){el.game=this.game;el.addEventListener("click",function(){if(this.game.display.inputEl.value.length)this.game.sendToInput(el.dataset.name);else this.game.sendToParser("examine "+el.dataset.name)})},this)},this)}})();(()=>{var p;adventurejs.Display.prototype.updateRoomDocks=function Display_updateRoomDocks(properties){}})();(()=>{var p;adventurejs.Display.prototype.updateVerbDocks=function Display_updateVerbDocks(properties){}})();(()=>{class Input{constructor(params){this.game_name=params.game_name||"";this.game.log("L1032","log","high","[Input.js] new input created","Parser");this.character=this.game.getPlayer();this.input="";this.verified_sentence={};this.view_modifiers=[];this.parsed_word={enabled:false};this.parsed_sentence=[];this.verified_sentence_structure="";this.printer={output:"",append:[],prepend:[],override:[],appended:[],prepended:[],overrode:[]};this.unparsed_input="";this.parsed_input="";this.output_class="";this.found_word="";this.input_verb="";this.verb_phrase="";this.verb_phrase_prepositions="";this.unknown_word=void 0;this.soft_prompt={verb:null,input_verb:null,noun:false,noun1:false,noun2:false,noun3:false,nouns:[],container1:false,container2:false,container3:false,containers:[],preposition1:false,preposition2:false,preposition3:false,prepositions:[],enabled:false,satisfied:false,structure:""};this.disambiguate={index:null,noun1:false,noun2:false,noun3:false,container:false,enabled:false,nouns:[]};this.verb_chain=[];this.allow_circular_verb=false;this.verb_params={};this.replacements={};this.strings=[];this.verb_phrasal_pattern="";if(params&&params.first_turn){this.input=params.first_turn;this.found_word=params.first_turn;this.input_verb=params.first_turn;this.verb_phrase=params.first_turn;this.parsed_input=params.first_turn;this.unparsed_input=params.first_turn;this.setVerb(1,params.first_turn)}this.did={doSuccess:false,doBeforeTry:false,doTry:false,doAfterTry:false,doBeforeSuccess:false,doAfterSuccess:false,phases:[],print:false,tryTravel:false}}get game(){return window[this.game_name]||false}printOutput(){this.game.print(this.printer.output,this.output_class);return this.did.print=true}appendOutput(msg){if("string"!=typeof msg)return false;this.printer.append.push(msg);return true}overrideOutput(msg){if("string"!=typeof msg)return false;this.printer.override.push(msg);return true}prependOutput(msg){if("string"!=typeof msg)return false;this.printer.prepend.push(msg);return true}hasVerb(index){var bool=false;if(!index)index=1;if(this.verified_sentence["verb"+index])bool=true;return bool}getVerb(index){var verb=false;if(!index)index=1;if(this.verified_sentence["verb"+index])verb=this.verified_sentence["verb"+index].verb;return verb}getDictionaryVerb(index){var verb=false;if(!index)index=1;if(this.verified_sentence["verb"+index])verb=this.verified_sentence["verb"+index].verb;return verb=this.game.getVerb(verb)}setVerb(index,value){if(!index)index=1;if(!this.verified_sentence["verb"+index])this.verified_sentence["verb"+index]={};this.verified_sentence["verb"+index].verb=value}getAdverb(index){var adverb="";if(!index)index=1;if(this.verified_sentence["verb"+index])adverb=this.verified_sentence["verb"+index].adverb||"";return adverb}setAdverb(index,value){if(!index)index=1;if(!this.verified_sentence["verb"+index])this.verified_sentence["verb"+index]={};this.verified_sentence["verb"+index].adverb=value}setPhrase(index,phrase){this.verified_sentence["phrase"+index]=A.clone.call(this.game,phrase)}deletePhrase(index){if(!this.verified_sentence["phrase"+index]);else{delete this.verified_sentence["phrase"+index];if(this.getPhraseCount()>index)for(let i=index+1;i<=this.getPhraseCount();i++){this.verified_sentence["phrase"+(i-1)]=this.verified_sentence["phrase"+i];delete this.verified_sentence["phrase"+i]}this.updateStructure();return true}}updateStructure(){this.verified_sentence_structure="";if(this.verified_sentence.verb1?.verb)this.verified_sentence_structure+="verb";for(let i=1;i<4;i++){var phrase=this.verified_sentence["phrase"+i];if(phrase&&phrase.preposition)this.verified_sentence_structure+=" preposition";if(phrase&&phrase.noun)this.verified_sentence_structure+=" noun"}this.verified_sentence_structure=this.verified_sentence_structure.trim();return true}getInput(){var last_turn,prompt=this.game.getLastTurn().soft_prompt;if(!prompt.enabled)return this.input;let newinput="";var index=prompt.index,type=prompt.type;if(this.verified_sentence.verb1?.verb){newinput+=this.verified_sentence.verb1.verb;if(this.verified_sentence.verb1.adverb)newinput+=" "+this.verified_sentence.verb1.adverb}for(let i=1;i<4;i++){var phrase=this.verified_sentence["phrase"+i];if(!phrase);else{if(i===index&&"preposition"===type)newinput+=" "+this.input;else if(phrase.preposition)newinput+=" "+phrase.preposition;if(i===index&&"noun"===type)newinput+=" "+this.input;else if(phrase.noun)newinput+=" "+phrase.noun}}return newinput}getPhrase(index){var phrase;return this.verified_sentence["phrase"+index]||{}}getNounCount(){for(var count=0,i=1;i<=3;i++)if(this.verified_sentence["phrase"+i]&&(this.verified_sentence["phrase"+i].noun||this.verified_sentence["phrase"+i].parsedNoun))count++;return count}hasPhrase(index){if(this.verified_sentence["phrase"+index])return true;else return false}getNoun(index){return this.getInPhrase(index,"noun")}setNoun(index,value){return this.setInPhrase(index,"noun",value)}getExclusion(index){return this.getInPhrase(index,"exclusion")}setExclusion(index,value){return this.setInPhrase(index,"exclusion",value)}getAsset(index){var asset=null,index=this.getInPhrase(index,"parsedNoun");if(index)asset=this.game.getAsset(index.object_id);return asset}getSubstance(index){var asset=null,index=this.getInPhrase(index,"parsedNoun");if(index){var index=index.object_id;if(3===index.split(":").length)asset=this.game.getAsset(index.split(":")[2])}return asset}setAsset(index,asset){if("string"==typeof asset)if(this.game.dictionary.isDirection(asset))asset=this.game.getExitFromDirection(asset);else asset=this.game.getAsset(asset);if(!asset);else{if(!this.verified_sentence["phrase"+index])this.verified_sentence["phrase"+index]={};this.verified_sentence["phrase"+index].parsedNoun=new adventurejs.ParsedNoun(asset);this.verified_sentence["phrase"+index].noun=asset.id}}setContainer(index,asset){if(!index)return false;if("string"==typeof asset)asset=this.game.getAsset(asset);if(!asset)return false;if(!this.verified_sentence["phrase"+index])this.verified_sentence["phrase"+index]={};var index=this.verified_sentence["phrase"+index];index.container=asset.id;let container=index.parsedNoun.matches.qualified[index.parsedNoun.matches.qualifiedIndex];container=container.replace(/^[^:]+/,asset.id);index.parsedNoun.matches.qualified[index.parsedNoun.matches.qualifiedIndex]=container;index.parsedNoun.qualified_object_id=container}getContainer(index){return this.getInPhrase(index,"container")}getContainerAsset(index){return this.game.getAsset(this.getInPhrase(index,"container"))}pushPhrase({asset,preposition}){var index=this.getPhraseCount()+1;if(3<index)this.game.log("L1515","error","high",`[Input.js] pushPhrase called, resulting in ${index} phrases. No more than 3 phrases can be handled. `,"Verbs");this.verified_sentence["phrase"+index]={inferred:true};if(preposition){this.verified_sentence_structure+=" preposition";this.verified_sentence["phrase"+index].preposition=preposition}if(asset){if("string"==typeof asset)asset=this.game.getAsset(asset);this.verified_sentence_structure+=" noun";this.verified_sentence["phrase"+index].parsedNoun=new adventurejs.ParsedNoun(asset);this.verified_sentence["phrase"+index].noun=asset.id}return index}shiftPhrase({asset,preposition}){var count;for(let i=this.getPhraseCount();0<i;i--)this.swapPhrases(i,i+1);this.verified_sentence.phrase1={inferred:true};let verified="";if(preposition){verified+="preposition ";this.verified_sentence.phrase1.preposition=preposition}if(asset){verified+="noun ";if("string"==typeof asset)asset=this.game.getAsset(asset);this.verified_sentence.phrase1.parsedNoun=new adventurejs.ParsedNoun(asset);this.verified_sentence.phrase1.noun=asset.id}this.updateStructure()}getPhraseCount(){var index=0;if(this.hasPhrase(1))index=1;if(this.hasPhrase(2))index=2;if(this.hasPhrase(3))index=3;return index}getPreposition(index){return this.getInPhrase(index,"preposition")}setPreposition(index,value){return this.setInPhrase(index,"preposition",value)}getDirection(index){return this.getInPhrase(index,"direction")}setDirection(index,value){return this.setInPhrase(index,"direction",value)}getParsedNoun(index){return this.getInPhrase(index,"parsedNoun")}setParsedNoun(index,parsedNoun){this.setInPhrase(index,"parsedNoun",parsedNoun)}setParsedNounMatchesQualified(index,value){if(this.verified_sentence["phrase"+index]&&this.verified_sentence["phrase"+index].parsedNoun)this.verified_sentence["phrase"+index].parsedNoun.matches.qualified=value}getInferred(index){return this.getInPhrase(index,"inferred")}setInferred(index,value){if(void 0===value)value=true;this.setInPhrase(index,"inferred",value)}swapPhrases(index1,index2){if(!this.getPhrase(index1))this["phrase"+index1]={};if(!this.getPhrase(index2))this["phrase"+index2]={};var swap1=A.clone.call(this.game,this.getPhrase(index1)),swap2=A.clone.call(this.game,this.getPhrase(index2));this.setPhrase(index1,swap2);this.setPhrase(index2,swap1);this.updateStructure()}swapNouns(index1,index2){var noun1=String(this.getInPhrase(index1,"noun")),noun2=String(this.getInPhrase(index2,"noun")),parsedNoun1=A.clone.call(this.game,this.getInPhrase(index1,"parsedNoun")),parsedNoun2=A.clone.call(this.game,this.getInPhrase(index2,"parsedNoun"));this.setInPhrase(index1,"noun",noun2);this.setInPhrase(index2,"noun",noun1);this.setInPhrase(index1,"parsedNoun",parsedNoun2);this.setInPhrase(index2,"parsedNoun",parsedNoun1)}swapPrepositions(index1,index2){var swap1=String(this.getPreposition(index1)),swap2=String(this.getPreposition(index2));this.setPreposition(index1,swap2);this.setPreposition(index2,swap1)}getInPhrase(index,property){if(this.verified_sentence["phrase"+index]&&this.verified_sentence["phrase"+index][property])return this.verified_sentence["phrase"+index][property];else return null}setInPhrase(index,property,value){if(!this.verified_sentence["phrase"+index])this.verified_sentence["phrase"+index]={};this.verified_sentence["phrase"+index][property]=value}hasInput(){var bool;return Object.keys(this.verified_sentence).length?true:false}setSoftPrompt(params){this.soft_prompt.enabled=true;for(var key in params){this.soft_prompt[key]=params[key];if(-1<key.indexOf("noun"))this.soft_prompt.noun=key}}setOneWord(params){this.parsed_word.enabled=true;for(var key in params)this.parsed_word[key]=params[key]}setDisambiguate(params){this.disambiguate.enabled=true;for(var key in params)this.disambiguate[key]=params[key]}getStructure(){return this.verified_sentence_structure}setStructure(value){this.verified_sentence_structure=value}hasStructure(value){return this.verified_sentence_structure===value}pushParsedWord(params){this.parsed_sentence.push(params)}pushViewModifier(identifier,asset,type){for(let m=0;m<this.view_modifiers.length;m++)if(asset&&this.view_modifiers[m].asset&&asset.id===this.view_modifiers[m].asset.id||!asset&&this.view_modifiers[m].adverb&&identifier===this.view_modifiers[m].identifier){this.view_modifiers[m].type=type;return}this.view_modifiers.push({identifier:identifier,asset:asset,type:type,string:""+identifier+(asset?" "+asset.name:""),used:false,adverb:asset?false:true,equivalencies:[""+identifier+(asset?" "+asset.name:"")]})}setVerbParam(param,value){this.verb_params[param]=value}getVerbParam(param,comparator){if(comparator)return JSON.stringify(comparator)===JSON.stringify(this.verb_params[param]);else return this.verb_params[param]}getSubject(){return this.character}isObject(id){return id===this.getNoun(1)||this.getNoun(2)||this.getNoun(3)}setCharacter(character){this.character=character}get preposition1(){return this.getInPhrase(1,"preposition")}set preposition1(value){this.setInPhrase(1,"preposition",value)}get preposition2(){return this.getInPhrase(2,"preposition")}set preposition2(value){this.setInPhrase(2,"preposition",value)}get preposition3(){return this.getInPhrase(3,"preposition")}set preposition3(value){this.setInPhrase(3,"preposition",value)}get parsedNoun1(){return this.getInPhrase(1,"parsedNoun")}set parsedNoun1(value){this.setInPhrase(1,"parsedNoun",value)}get parsedNoun2(){return this.getInPhrase(2,"parsedNoun")}set parsedNoun2(value){this.setInPhrase(2,"parsedNoun",value)}get parsedNoun3(){return this.getInPhrase(3,"parsedNoun")}set parsedNoun3(value){this.setInPhrase(3,"parsedNoun",value)}get parsedNoun1_is_assumed(){return this.getInPhrase(1,"inferred")}set parsedNoun1_is_assumed(value){this.setInPhrase(1,"inferred",value)}get parsedNoun2_is_assumed(){return this.getInPhrase(2,"inferred")}set parsedNoun2_is_assumed(value){this.setInPhrase(2,"inferred",value)}get parsedNoun3_is_assumed(){return this.getInPhrase(3,"inferred")}set parsedNoun3_is_assumed(value){this.setInPhrase(3,"inferred",value)}set(props){return A.deepSet.call(this.game,props,this)}}adventurejs.Input=Input})();(()=>{class Parser{constructor(game){this.game=game;this.dictionary=game.dictionary;this.display=game.display;this.custom_parsers={};this.custom_parsers_enabled={};this.input_string="";this.input_history=[];this.input_history.push(new adventurejs.Input({game_name:this.game.game_name,first_turn:"wait"}));this.input_history_index=0;this.input_queue=[];this.input_object={};this.is_input_queued=false}clearQueue(){this.is_input_queued=false;this.input_queue=[]}getOlderInput(){if(void 0===this.input_history_index)return"";if(-1===this.input_history_index)this.input_history_index=0;else if(this.input_history_index<this.input_history.length-2)this.input_history_index++;return this.input_history[this.input_history_index].unparsed_input}getNewerInput(){if(0<this.input_history_index)this.input_history_index--;if(void 0!==this.input_history[this.input_history_index]&&void 0!==this.input_history[this.input_history_index].unparsed_input)return this.input_history[this.input_history_index].unparsed_input;else return""}isParsingMultiple(){return 0<this.input_queue.length||this.is_input_queued}parseNoInput(){if(this.game.settings.if_input_is_empty_print_room_description)this.game.printRoom();else this.game.print(A.getSAF.call(this.game,this.game.settings.if_input_is_empty_print_this))}getLastInput(){return this.input_history[1].unparsed_input}getInputCount(){return this.input_history.length}excludeFromParsedNoun(parsedNoun,excludable_assets){for(var item in excludable_assets){var item=excludable_assets[item];parsedNoun.matches.qualified.splice(parsedNoun.matches.qualified.indexOf(item),1)}return parsedNoun}categorizeParsedNoun(parsedNoun){var present_assets=[],carried_assets=[],uncarried_assets=[],local_assets=[],global_assets=[],excludable_assets=[],reservoirs=[],emitters=[];for(let qualified=0;qualified<parsedNoun.matches.qualified.length;qualified++){var match=parsedNoun.matches.qualified[qualified],asset=this.game.getAsset(match);if(asset.$is("present")){present_assets.push(match);if(!asset.$is("global"))local_assets.push(match)}if(asset.$is("global"))global_assets.push(match);if(asset.$is("carried"))carried_assets.push(match);if(!asset.$is("carried"))uncarried_assets.push(match);if(asset.exclude_from_disambiguation)excludable_assets.push(match);if(asset.$is("reservoir"))reservoirs.push(match);if(asset.$is("emitting"))emitters.push(match)}return{present_assets:present_assets,carried_assets:carried_assets,uncarried_assets:uncarried_assets,local_assets:local_assets,global_assets:global_assets,excludable_assets:excludable_assets,reservoirs:reservoirs,emitters:emitters}}set(props){if(null!=props)for(var n in props)this[n]=props[n];return this}}adventurejs.Parser=Parser})();(()=>{var p;adventurejs.Parser.prototype.createParser=function Parser_createParser(parsers){for(var keys=Object.keys(parsers),i=0;i<keys.length;i++){var parser_name=keys[i],msg="";if(void 0!==this.custom_parsers[parser_name]){this.game.log("L1104","warn",0,msg="createParser received more than one parser named "+parser_name+". ","parser");return false}if("function"!=typeof parsers[parser_name]){this.game.log("L1105","warn",0,msg="createParser received something that is not a function for parser "+parser_name+". ","parser");return false}this.custom_parsers[parser_name]=parsers[parser_name];this.custom_parsers_enabled[parser_name]=false;this.game.log("L1106","log","high",msg="[createParser.js] registered "+parser_name+". ","Parser")}}})();(()=>{var p;adventurejs.Parser.prototype.disableParser=function Parser_disableParser(parser){if("function"!=typeof this.custom_parsers[parser]){var msg;console.warn("disableParser received invalid parser "+parser+". ");return false}this.custom_parsers_enabled[parser]=false;return this}})();(()=>{var p;adventurejs.Parser.prototype.enableParser=function Parser_enableParser(parser){if("function"!=typeof this.custom_parsers[parser]){var msg;console.warn("enableParser received invalid parser "+parser+". ");return false}this.custom_parsers_enabled[parser]=true}})();(()=>{var p;adventurejs.Parser.prototype.findCharacterComma=function Parser_findCharacterComma(input){var this_turn=this.input_history[0],player=this.game.getPlayer(),pattern=/^(\w+),\s/,match=input.match(pattern);function isPresentAndCharacter(){}if(match){var name=match[1],match=input.replace(pattern,""),parsed_noun=this.parseNoun(name);let char;var chars=[];let msg="",debug="";switch(parsed_noun.matches.qualified.length){case 0:msg=`{We} {don't} know of anyone named ${name}. `;debug="not found";break;case 1:if(!(char=this.game.getAsset(parsed_noun.matches.qualified[0]))){msg=`{We} {don't} know of anyone named ${name}. `;debug="not found"}else if(!player.knowsAbout(char)){msg=`{We} {don't} know of anyone named ${name}. `;debug="not known";break}else if(!char.hasClass("Character")){msg=char.is.present?char.Articlename+" ignores {us}. ":`{We} {don't} see any ${name} here. `;debug="not a character";break}else if(!char.is.present){msg=`{We} {don't} see ${char.articlename} here. `;debug="not present";break}break;default:for(let i=0;i<parsed_noun.matches.qualified.length;i++){var asset=this.game.getAsset(parsed_noun.matches.qualified[i]);if(asset.hasClass("Character")&&asset.is.present)chars.push(asset)}switch(chars.length){case 0:msg=`No one named ${name} is present. `;debug="not found";break;case 1:char=chars[0];break;default:msg="{We'll} have to be more specific. ";debug="not unique";break}break}if(msg){this.game.debug("D1178","findCharacterComma.js ",` ${name} is `+debug);this.game.print(msg);return false}if(char){this_turn.setCharacter(char);return match}}return input}})();(()=>{var p;adventurejs.Parser.prototype.findMatchIn=function Parser_findMatchIn(newQualified,oldQualified){if(!newQualified||!oldQualified)return false;for(var foundMatch,i=0;i<newQualified.length;i++)for(var nq=newQualified[i].split(":")[0],j=0,oq;j<oldQualified.length;j++){if(nq===oldQualified[j].split(":")[0]){foundMatch=nq;break}if(void 0!==foundMatch)break}return foundMatch}})();(()=>{var p;adventurejs.Parser.prototype.handleSentence=function Parser_handleSentence(){this.game.log("L1198","log","high","[handleSentence.js] handleSentence() begin","Parser");var this_turn=this.input_history[0],last_turn=this.input_history[1],parsed_verb_name="",dictionary_verb=null,dictionary_verb_name="",nouns=[],containers=[],exclusions=[],prepositions=[],parsedNouns=[],count={phrase:0},msg="",key,phrase,parsedNoun;if(this_turn.parsed_word.enabled){this_turn.verified_sentence=A.clone.call(this.game,last_turn.verified_sentence);if(this_turn.parsed_word.verb)this_turn.setVerb(1,this_turn.parsed_word.verb);for(let i=1;i<=3;i++){if(this_turn.parsed_word["noun"+i])this_turn.setNoun(i,this_turn.parsed_word["noun"+i]);if(this_turn.parsed_word["parsedNoun"+i])this_turn.setParsedNoun(i,this_turn.parsed_word["parsedNoun"+i]);if(this_turn.parsed_word["container"+i])this_turn.setContainer(i,this_turn.parsed_word["container"+i]);if(this_turn.parsed_word["preposition"+i])this_turn.setPreposition(i,this_turn.parsed_word["preposition"+i])}}if(this_turn.hasInput()){if(this_turn.hasVerb())parsed_verb_name=this_turn.getVerb();for(let i=1;i<=3;i++)if(this_turn.hasPhrase(i)){prepositions[i]=this_turn.getPreposition(i);nouns[i]=this_turn.getNoun(i);containers[i]=this_turn.getContainer(i);exclusions[i]=this_turn.getExclusion(i)}}else{this.game.debug("D1207","handleSentence.js "," didn't receive words ");msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg,this_turn.output_class)}if("oops "===this_turn.input.substring(0,5))return this.game.dictionary.doVerb("oops");if(!parsed_verb_name||!this.dictionary.verbs[parsed_verb_name])if("preposition noun"===this_turn.verified_sentence_structure&&last_turn.soft_prompt.enabled)for(let i=1;i<=3;i++)if(last_turn.soft_prompt["noun"+i]&&last_turn.soft_prompt["preposition"+i]){var new_phrase=Object.assign({},this_turn.verified_sentence.phrase1);this_turn.verified_sentence=A.clone.call(this.game,last_turn.verified_sentence);this_turn.setPhrase(i,new_phrase);this_turn.verified_sentence_structure=last_turn.soft_prompt.structure||last_turn.verified_sentence_structure;parsed_verb_name=this_turn.getVerb()}if(!parsed_verb_name||!this.dictionary.verbs[parsed_verb_name]){var err=`parser.handleSentence > Verb not found. This may happen if a compound phrase is improperly found. Original input: ${this_turn.input} Parsed input: `+this_turn.parsed_input;this.game.log("L1199","warn","high",err,"Parser");this.game.debug("D1721","handleSentence.js "," verb not found. Check the console for more info. ");msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg,this_turn.output_class);return false}if(this.dictionary.verbs[parsed_verb_name].let_verb_handle_remaining_input){this.dictionary.doVerb(parsed_verb_name);return false}if(!(dictionary_verb=this.qualifyParsedVerb({parsed_verb_name:parsed_verb_name})))return false;for(key in this_turn.verified_sentence)if(key.startsWith("phrase"))count.phrase++;for(let n=1;n<=count.phrase;n++){var phrase,noun=(phrase=this_turn.verified_sentence["phrase"+n]).noun,preposition=phrase.preposition,exclusion=phrase.exclusion;this.game.log("L1200","log","high","[handleSentence.js] handle phrase "+n,"Parser");if(!noun&&!preposition){this.game.debug("D1034","handleSentence.js ",` ${dictionary_verb.name} didn't receive a noun or preposition`);msg+=`How did {we} want to ${this_turn.input}? `;this.game.print(msg,this_turn.output_class);return false}if(noun&&!dictionary_verb["phrase"+n].accepts_noun){this.game.debug("D2018","handleSentence.js ",` ${dictionary_verb.name} received a noun it can't handle`);msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg,this_turn.output_class);return false}if(preposition&&!noun&&!dictionary_verb["phrase"+n].accepts_preposition_without_noun){this.game.debug("D1033","handleSentence.js ",` ${dictionary_verb.name} received preposition without noun, soft prompt noun`+n);msg+=`What would {we} like to ${this_turn.input}? `;this_turn.setSoftPrompt({index:n,type:"noun",["noun"+n]:true,verb:this_turn.input_verb,verb_phrase:this_turn.verb_phrase});this.game.print(msg,this_turn.output_class);return false}if(noun){if("global_string"===noun){var authoritative=this.game.world.global_string.values.length?this.game.world.global_string.values:phrase.strings?.length?phrase.strings:this_turn.strings?.length?this_turn.strings:[];phrase.strings=this.game.world.global_string.values=this_turn.strings=authoritative}if("global_number"===noun){let authoritative=this.game.world.global_number.values.length?this.game.world.global_number.values:phrase.strings?.length?phrase.strings:this_turn.strings?.length?this_turn.strings:[];phrase.strings=this.game.world.global_number.values=this_turn.strings=authoritative}var split_noun=noun.split("&"),noun_is_plural;if(("all"===noun||1<split_noun.length)&&!dictionary_verb["phrase"+n].accepts_plural_noun){this.game.debug("D1032","handleSentence.js ",` ${dictionary_verb.name}.phrase${n}.accepts_plural_noun is false`);msg+=`{We} can't ${dictionary_verb.prettyname} more than one thing at a time. `;this.game.print(msg,this_turn.output_class);return false}if(1<split_noun.length){for(let i=1;i<split_noun.length;i++)this.input_queue.push({input:this_turn.parsed_input.replace(noun,split_noun[i]),printInput:false});noun=split_noun[0]}if(!phrase.parsedNoun)phrase.parsedNoun=this.parseNoun(noun)}if(noun&&!preposition&&dictionary_verb["phrase"+n].requires_preposition){this.game.debug("D1041","handleSentence.js ",` ${dictionary_verb.name} received noun without preposition, soft prompt preposition`+n);switch(n){case 1:msg+=`Where in relation to ${this.game.getAsset(this_turn.verified_sentence.phrase1.parsedNoun.object_id).articlename} did {we} want to ${dictionary_verb.prettyname}? `;break;case 2:msg+=`Where in relation to ${this.game.getAsset(this_turn.verified_sentence.phrase2.parsedNoun.object_id).articlename} did {we} want to ${dictionary_verb.prettyname} ${this.game.getAsset(this_turn.verified_sentence.phrase1.parsedNoun.object_id).articlename}? `;break;case 3:msg+="That seems to be missing a preposition. Can {we} try phrasing that another way? ";break}this_turn.setSoftPrompt({index:2,type:"preposition",["preposition"+n]:true,verb:this_turn.input_verb,verb_phrase:this_turn.verb_phrase});this.game.print(msg,this_turn.output_class);return false}if(preposition&&dictionary_verb["phrase"+n].preposition_must_be.length&&-1===dictionary_verb["phrase"+n].preposition_must_be.indexOf(preposition)){this.game.debug("D1222","handleSentence.js ",` ${dictionary_verb.name}.phrase${n}.preposition_must_be: `+dictionary_verb["phrase"+n].preposition_must_be.join(", "));var authoritative=this.game.getAsset(this_turn.verified_sentence["phrase"+n].parsedNoun.object_id);msg+=`{We} {don't} seem to know how to ${dictionary_verb.name} anything ${preposition} ${authoritative&&this.game.getPlayer().knowsAbout(authoritative)?authoritative.articlename:noun?noun:""}. `;this.game.print(msg,this_turn.output_class);return false}if(phrase.parsedNoun&&!phrase.parsedNoun.matches.all.length){this.game.log("L1201","log","high",["[handleSentence.js] input: "+this_turn.input+`, phrase${n}.parsedNoun: `,phrase.parsedNoun],"Parser");this_turn.unknown_word=noun;this.game.debug("D1035","handleSentence.js ",` ${noun} isn't recognized `);if(this_turn.replacements[noun])msg+=`{We} {don't} know of any ${this_turn.replacements[noun].source}. `;else if(adventurejs[A.propercase(noun)])msg+=`{We} {don't} know of any ${noun}. `;else msg+=this.game.settings.getUnparsedMessage(this_turn.unparsed_input);this.game.print(msg,this_turn.output_class);return false}this.game.log("L1202","log","medium",[`[handleSentence.js] phrase${n}.parsedNoun:`,phrase.parsedNoun],"Parser");if(phrase.parsedNoun&&!dictionary_verb["phrase"+n].accepts_noun){this.game.debug("D1036","handleSentence.js ",` ${dictionary_verb.name} received a noun it can't handle`);msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg,this_turn.output_class);return false}if(phrase.parsedNoun&&"in"===preposition&&this.game.getAsset(phrase.parsedNoun.object_id).quirks.in_means_on&&dictionary_verb.in_can_mean_on)this_turn.setInPhrase(n,"preposition","on");if(exclusion&&"string"==typeof exclusion){var exclusion_split=exclusion.split("&");for(let x=0;x<exclusion_split.length;x++){var excluded_noun=exclusion_split[x],excluded_parsed_noun=this.parseNoun(excluded_noun);this.game.log("L1203","log","medium",["[handleSentence.js] exclude:",excluded_parsed_noun],"Parser");if(excluded_parsed_noun)for(let i=0;i<excluded_parsed_noun.matches.all.length;i++){var excluded_id=excluded_parsed_noun.matches.all[i];phrase.parsedNoun.matches.all.splice(phrase.parsedNoun.matches.all.indexOf(excluded_id),1);phrase.parsedNoun.matches.qualified.splice(phrase.parsedNoun.matches.qualified.indexOf(excluded_id),1);if(phrase.parsedNoun.matches.unambiguous===excluded_id)phrase.parsedNoun.matches.unambiguous=""}}this.game.log("L1204","log","medium",[`[handleSentence.js] phrase${n}.parsedNoun minus exclusions: `,phrase.parsedNoun],"Parser")}if(1<n){var first_phrase=this_turn.getPhrase(1),preposition=[],preposition=first_phrase.noun&&first_phrase.noun.split("&"),exclusion="all"===first_phrase.noun||1<preposition.length,preposition=dictionary_verb["phrase"+n].not_in_prior_plural;if(exclusion&&preposition)if(phrase.parsedNoun.matches.unambiguous){let excluded_id=phrase.parsedNoun.matches.unambiguous;var exclusion=first_phrase.parsedNoun.matches.all.indexOf(excluded_id),preposition=first_phrase.parsedNoun.matches.qualified.indexOf(excluded_id);first_phrase.parsedNoun.matches.all.splice(exclusion,1);first_phrase.parsedNoun.matches.qualified.splice(preposition,1);if(first_phrase.parsedNoun.matches.unambiguous===excluded_id)first_phrase.parsedNoun.matches.unambiguous="";if(-1<exclusion||-1<preposition)if(first_phrase.parsedNoun){first_phrase.parsedNoun=this.qualifyParsedNoun({parsedNoun:first_phrase.parsedNoun,parsedVerb:dictionary_verb.name,nounIndex:n-1});if(!phrase.parsedNoun)return false}}if(phrase.parsedNoun&&phrase.parsedNoun.object_id&&first_phrase.parsedNoun.object_id&&1<first_phrase.parsedNoun.matches.qualified.length)for(var i=first_phrase.parsedNoun.matches.qualified.length-1;-1<i;i--)if(phrase.parsedNoun.qualified_object_id===first_phrase.parsedNoun.matches.qualified[i])first_phrase.parsedNoun.matches.qualified.splice(i,1)}if(phrase.parsedNoun){phrase.parsedNoun=this.qualifyParsedNoun({parsedNoun:phrase.parsedNoun,parsedVerb:dictionary_verb.name,nounIndex:n});if(!phrase.parsedNoun)return false}if(1===n&&phrase.parsedNoun&&phrase.parsedNoun.qualified_object_id){let direct_object=this.game.getAsset(phrase.parsedNoun.qualified_object_id);if(direct_object.redirected_verbs[dictionary_verb.name])if(!(dictionary_verb=this.qualifyParsedVerb({parsed_verb_name:direct_object.redirected_verbs[""]})))return false}}for(let n=1;n<=count.phrase;n++){if(!(parsedNoun=(phrase=this_turn.verified_sentence["phrase"+n]).parsedNoun));else{this.game.log("L1205","log","high","[handleSentence.js] final check on phrase "+n,"Parser");if(1<parsedNoun.matches.qualified.length&&!parsedNoun.matches.unambiguous||1<parsedNoun.matches.qualified.length&&parsedNoun.matches.unambiguous&&parsedNoun.matches.substance){var is_plural=false,lookup=this.game.world_lookup[parsedNoun.serialized_input],phrase,parsedNoun;if(lookup)if("plural"===lookup.type||"group"===lookup.type)is_plural=true;if(1<parsedNoun.original_input.split("&").length)is_plural=true;if(is_plural)if(!dictionary_verb["phrase"+n].accepts_plural_noun){var q=parsedNoun.matches.qualified.slice();for(let index=q.length-1;-1<index;index--){var qid=q[index],qasset;if(!this.game.getAsset(qid).isDOV(dictionary_verb.name))q.splice(index,1)}if(1===q.length)parsedNoun.matches.qualified=q.slice();if(1<parsedNoun.matches.qualified.length){var collections=[],cid;for(cid in parsedNoun.matches.qualified){var casset=this.game.getAsset(parsedNoun.matches.qualified[cid]);if(!casset);else if(casset.hasClass("Collection"))collections.push(casset)}if(1===collections.length)parsedNoun.matches.qualified=[collections[0].id]}var{excludable_assets:lookup}=this.categorizeParsedNoun(parsedNoun);if(1<parsedNoun.matches.qualified.length&&lookup.length){let{excludable_assets}=this.categorizeParsedNoun(parsedNoun);if(excludable_assets.length<parsedNoun.matches.qualified.length)parsedNoun=this.excludeFromParsedNoun(parsedNoun,excludable_assets)}if(1<parsedNoun.matches.qualified.length){this.game.debug("D1202","handleSentence.js ",` ${dictionary_verb.name} doesn't handle multiple objects `);this.game.log("L1206","warn","high",`[handleSentence.js] ${dictionary_verb.name} doesn't handle multiple objecs: `+parsedNoun.original_input,"Parser");this.printNounDisambiguation({parsedNoun:parsedNoun,nounIndex:n});return false}}if(!is_plural&&!dictionary_verb.let_verb_handle_disambiguation){if(parsedNoun.matches.substance){this.game.debug("D1447","handleSentence.js ",` phrase${n}.parsedNoun found multiple substance containers `);if(this.game.settings.disambiguation_considers_last_turn)for(let phrase=1;phrase<last_turn.getPhraseCount();phrase++){var last_turn_asset=last_turn.getAsset(phrase);if(last_turn_asset.contains===parsedNoun.matches.substance)for(let container=0;container<parsedNoun.matches.qualified.length;container++){var match=parsedNoun.matches.qualified[container];let asset=this.game.getAsset(match);if(asset.id===last_turn_asset.id){parsedNoun.matches.qualified=[match];parsedNoun.qualified_object_id=match}}}if(1<parsedNoun.matches.qualified.length&&this.game.settings.infer_containers_prefers_reservoir){var{reservoirs:lookup,emitters:is_plural}=this.categorizeParsedNoun(parsedNoun);if(lookup.length){parsedNoun.matches.qualified=[lookup[0]];parsedNoun.qualified_object_id=lookup[0]}else if(is_plural.length){parsedNoun.matches.qualified=[is_plural[0]];parsedNoun.qualified_object_id=is_plural[0]}}if(1<parsedNoun.matches.qualified.length)if(this.game.settings.auto_pick_inferred_container){let match=parsedNoun.matches.qualified[0];parsedNoun.matches.qualified=[match];parsedNoun.qualified_object_id=match}}else if(!parsedNoun.matches.substance){this.game.debug("D1201","handleSentence.js ",` phrase${n}.parsedNoun needs disambiguation `);this.game.log("L1207","log","high",`[handleSentence.js] parsedNoun ${n} needs disambiguation: `+parsedNoun.matches.qualified,"Parser");if(1<(parsedNoun=(phrase=this_turn.verified_sentence["phrase"+n]).parsedNoun).matches.qualified.length&&this.game.settings.disambiguation_considers_last_turn)for(let phrasenum=1;phrasenum<=last_turn.getPhraseCount();phrasenum++){let phrase=last_turn.verified_sentence["phrase"+phrasenum];if(phrase?.parsedNoun?.matches?.unambiguous){var prior_id=phrase.parsedNoun.matches.unambiguous;if(prior_id)if(parsedNoun.matches.qualified.includes(prior_id)){this.game.debug("D1373","handleSentence.js "," disambiguation defaulting to last turn's "+prior_id);parsedNoun.matches.qualified=[prior_id];parsedNoun.qualified_object_id=prior_id}}}let{present_assets,carried_assets,uncarried_assets,local_assets,global_assets,excludable_assets}=this.categorizeParsedNoun(parsedNoun);if(1<parsedNoun.matches.qualified.length&&dictionary_verb["phrase"+n].noun_must_be.prefer_present_if_ambiguous)if(1===present_assets.length){parsedNoun.matches.qualified=present_assets;parsedNoun.qualified_object_id=present_assets[0]}if(1<parsedNoun.matches.qualified.length&&dictionary_verb["phrase"+n].noun_must_be.prefer_carried_if_ambiguous)if(1===carried_assets.length){parsedNoun.matches.qualified=carried_assets;parsedNoun.qualified_object_id=carried_assets[0]}if(1<parsedNoun.matches.qualified.length&&dictionary_verb["phrase"+n].noun_must_be.prefer_uncarried_if_ambiguous)if(1===uncarried_assets.length){parsedNoun.matches.qualified=uncarried_assets;parsedNoun.qualified_object_id=uncarried_assets[0]}if(1<parsedNoun.matches.qualified.length)if(1===local_assets.length){parsedNoun.matches.qualified=local_assets;parsedNoun.qualified_object_id=local_assets[0]}if(1<parsedNoun.matches.qualified.length&&this.game.settings.disambiguation_considers_last_turn&&!last_turn.plural)for(let phrase=1;phrase<=last_turn.getPhraseCount();phrase++){let last_turn_asset=last_turn.getAsset(phrase);if(last_turn_asset&&parsedNoun.matches.qualified.includes(last_turn_asset.id)){this.game.debug("D1589","handleSentence.js "," disambiguation defaulting to last turn's "+last_turn_asset.name);parsedNoun.matches.qualified=[last_turn_asset.id];parsedNoun.qualified_object_id=last_turn_asset.id}}if(1<parsedNoun.matches.qualified.length&&excludable_assets.length){let{excludable_assets}=this.categorizeParsedNoun(parsedNoun);if(excludable_assets.length<parsedNoun.matches.qualified.length)parsedNoun=this.excludeFromParsedNoun(parsedNoun,excludable_assets)}if(1<parsedNoun.matches.qualified.length&&2===n){var lookup=this_turn.verified_sentence.phrase1;if(lookup.parsedNoun?.matches.direction&&lookup.parsedNoun.qualified_object_id&&parsedNoun.matches.qualified.includes(lookup.parsedNoun.qualified_object_id)){parsedNoun.matches.qualified=[lookup.parsedNoun.qualified_object_id];parsedNoun.qualified_object_id=lookup.parsedNoun.qualified_object_id}}}if(1<parsedNoun.matches.qualified.length){this.printNounDisambiguation({parsedNoun:parsedNoun,nounIndex:n});return false}}}}}this.game.log("L1208","log","high","[handleSentence.js] handleSentence() end","Parser");var err=this_turn.getAsset(1);if(err?.is?.collection&&dictionary_verb.enqueue_collections){this.game.debug("D1091","handleSentence.js ",` ${this_turn.getAsset(1).name}.is.collection, enqueueing collection`);this.game.print(msg);dictionary_verb.enqueueCollection(err)}else{this.game.log("L1209","log","high","[handleSentence.js] doVerb "+dictionary_verb.name,"Parser");return dictionary_verb.do()}return true}})();(()=>{var p;adventurejs.Parser.prototype.handleWord=function Parser_handleWord(){var fx="handleWord.js",this_turn=(this.game.log("L1211","log","high","[${fx}] handleWord() Begin parse.","Parser"),this.input_history[0]),one_word=this_turn.found_word,parsed_noun,verb_name,last_turn=this.input_history[1],number="global_number"===one_word?Number(this.game.world.global_number.values[0]):Number(one_word),msg="",found_match=false;if(last_turn.soft_prompt.noun)parsed_noun=this.parseNoun(one_word);for(let i=1;i<=3;i++)if(last_turn.soft_prompt["preposition"+i]&&this.game.dictionary.isPreposition(one_word)){this_turn.verified_sentence_structure=last_turn.soft_prompt.structure||last_turn.verified_sentence_structure;this_turn.input_verb=last_turn.soft_prompt.input_verb||last_turn.input_verb;this_turn.verb_phrase=last_turn.soft_prompt.verb_phrase||last_turn.verb_phrase;this_turn.soft_prompt.satisfied=true;this_turn.setOneWord({["preposition"+i]:one_word});this.game.log("L1212","log","high",`[${fx}] last turn soft prompted for preposition${i} and ${one_word} recognized as preposition`,"Parser");return this.handleSentence()}verb_name=this.parseVerb(one_word);this.game.log("L1213","log","high",`[${fx}] `+verb_name,"Parser");if(verb_name&&last_turn.soft_prompt.noun1&&this.game.dictionary.verbs[verb_name].type.direction){this.game.log("L1214","log","high",`[${fx}] soft_prompt received ${one_word} which is direction+noun and satisfies `+last_turn.input_verb,"Parser");this_turn.setOneWord({noun1:verb_name});this_turn.input_verb=last_turn.soft_prompt.input_verb||last_turn.input_verb;this_turn.verb_phrase=last_turn.soft_prompt.verb_phrase||last_turn.verb_phrase;if(last_turn.soft_prompt.verb)this_turn.setOneWord({verb:last_turn.soft_prompt.verb});this.game.log("L1215","log","high",`[${fx}] handle soft prompt for noun1`,"Parser");this_turn.verified_sentence_structure=last_turn.soft_prompt.structure||last_turn.verified_sentence_structure;this_turn.soft_prompt.satisfied=true;return this.handleSentence()}if(verb_name&&!(parsed_noun&&parsed_noun.matches.all.length)){var verb=this.qualifyParsedVerb({parsed_verb_name:verb_name});if(!verb)return false;if(-1===verb.accepts_structures.indexOf("verb")){this.game.debug("D1052","handleWord.js ",` ${verb_name} doesn't accept structure > verb `);msg=(msg+=`${verb.type.travel?"Where":"What"} did {we} want to ${this_turn.verb_phrase||this_turn.input_verb}? `)||verb.msgNoObject;this_turn.setSoftPrompt({index:1,type:"noun",verb:verb.name,noun1:true,structure:"verb noun"});this.game.print(msg,this_turn.output_class);return false}this_turn.setVerb(1,verb_name);this_turn.setStructure("verb");this.game.log("L1216","log","high",`[${fx}] ${verb_name} recognized as verb`,"Parser");this.game.dictionary.doVerb(verb_name);return true}if(Number.isInteger(number)&&last_turn.disambiguate.index){this.game.display.appendClassesToLastInput("integer");if(!(one_word=last_turn.getParsedNoun(last_turn.disambiguate.index).matches.qualified[number-1])){this.game.debug("D1555","handleWord.js ",` ${number} is not a valid choice`);if(msg+=number+" doesn't seem to make sense. ")this.game.print(msg,this_turn.output_class);return false}found_match=one_word;parsed_noun=new adventurejs.ParsedNoun(this.game.getAsset(one_word))}else parsed_noun=this.parseNoun(one_word);if(!(parsed_noun=this.parseNoun(one_word)).matches.all.length){this.game.log("L1217","log","high",`[${fx}] no matching key found in world_lookup `,"Parser");msg+=this.game.settings.getUnparsedMessage(one_word);this.game.print(msg,this_turn.output_class);return false}if(last_turn.disambiguate.enabled){this.game.log("L1218","log","high",`[${fx}] handle noun disambiguation`,"Parser");if(!found_match)found_match=this.findMatchIn(parsed_noun.matches.qualified,last_turn["parsedNoun"+last_turn.disambiguate.index].matches.qualified);if(found_match){this_turn.verified_sentence_structure=last_turn.verified_sentence_structure;this_turn.strings=last_turn.strings;var verb=last_turn.disambiguate.container?"container":"noun";this_turn.setOneWord({[verb+last_turn.disambiguate.index]:found_match,["parsedNoun"+last_turn.disambiguate.index]:parsed_noun});this_turn.input_verb=last_turn.input_verb;this_turn.verb_phrase=last_turn.verb_phrase;this.game.log("L1219","log","high",`[${fx}] disambiguate found_match `+found_match,"Parser");return this.handleSentence()}else{this.game.debug("D1556","handleWord.js "," disambiguation failed");if(msg+=number+" doesn't seem to make sense. ")this.game.print(msg,this_turn.output_class);return false}}if(last_turn.soft_prompt.enabled){this.game.log("L1220","log","high",`[${fx}] soft_prompt received `+one_word,"Parser");var verb_name=last_turn.soft_prompt,verb=verb_name.noun1?"noun1":verb_name.noun2?"noun2":verb_name.noun3?"noun3":verb_name.container1?"container1":verb_name.container2?"container2":verb_name.container3?"container3":verb_name.preposition1?"preposition1":verb_name.preposition2?"preposition2":verb_name.preposition3?"preposition3":false;if(verb)this_turn.setOneWord({[verb]:parsed_noun?.matches?.unambiguous||one_word});this_turn.input_verb=last_turn.soft_prompt.input_verb||last_turn.input_verb;this_turn.verb_phrase=last_turn.soft_prompt.verb_phrase||last_turn.verb_phrase;if(last_turn.soft_prompt.verb)this_turn.setOneWord({verb:last_turn.soft_prompt.verb});this.game.log("L1221","log","high",`[${fx}] handle soft prompt for ${verb}: `+one_word,"Parser");this_turn.verified_sentence_structure=last_turn.soft_prompt.structure||last_turn.verified_sentence_structure;this_turn.soft_prompt.satisfied=true;return this.handleSentence()}if("global_string"===parsed_noun.object_id){this.game.log("L1222","log","high",`[${fx}] received string`,"Parser");msg+=this_turn.strings.toString()+"...?";this.game.print(msg,this_turn.output_class)}else{if(this.game.settings.if_input_is_an_asset_name_examine_it){this.game.log("L1223","log","high",`[${fx}] if_input_is_an_asset_name_examine_it`,"Parser");if(false===(parsed_noun=this.qualifyParsedNoun({parsedNoun:parsed_noun,parsedVerb:"examine",nounIndex:"1"})))return false;else if(1===parsed_noun.matches.qualified.length){this_turn.setParsedNoun(1,parsed_noun);this.game.dictionary.doVerb("examine");return}}msg+=this.game.settings.getUnparsedMessage(one_word);this.game.print(msg,this_turn.output_class);return false}}})();(()=>{var p;adventurejs.Parser.prototype.joinCompoundNames=function Parser_joinCompoundNames(input){this.game.log("L1544","log","high","[joinCompoundNames.js] joinCompoundNames() receive: "+input,"Parser");for(var prop in this.game.world){var name=this.game.world[prop].name;if(!name);else{var prop=this.game.world[prop].id,search,name=new RegExp("\\b"+name+"\\b","g");input=input.replace(name,prop)}}this.game.log("L1545","log","high","[joinCompoundNames.js] joinCompoundNames() return: "+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinCompoundPhrases=function Parser_joinCompoundPhrases(input){this.game.log("L1467","log","high","[joinCompoundPhrases.js] joinCompoundPhrases() receive: "+input,"Parser");for(var lookup_keys=Object.keys(this.game.world_lookup),longest_lookup,m=this.game.longest_lookup;0<m;m--)for(var i=1;i<lookup_keys.length;i++)if(lookup_keys[i].split(" ").length===m&&1<lookup_keys[i].split(" ").length&&1===lookup_keys[i].split("_").length){var lookup_value=this.game.world_lookup[lookup_keys[i]].IDs,search="\\b"+lookup_keys[i]+"\\b",regex=new RegExp(search,"g"),match;if(null!==input.match(regex))if(1===lookup_value.length){input=input.replace(regex,lookup_value);var search=`parser.joinCompoundPhrases found singular lookup value and replaced '${lookup_value[0]}' with '${lookup_keys[i]}'`;if(!this.game.getInput().replacements[lookup_value[0]])this.game.getInput().replacements[lookup_value[0]]={source:lookup_keys[i],context:search}}else{var foundOne=false;this.game.log("L1107","log","high","joinCompoundPhrases.js lookup_value: "+lookup_value,"Parser");for(var k=0;k<lookup_value.length;k++){this.game.log("L1108","log","high","joinCompoundPhrases.js lookup_value: "+lookup_value[k],"Parser");var lookup_value_deserialized=A.deserialize(lookup_value[k]);if(-1===lookup_value_deserialized.indexOf(" "));else if(-1!==input.indexOf(lookup_value_deserialized)){input=input.replace(regex,lookup_value[k]);foundOne=true;if(!this.game.getInput().replacements[lookup_value[k]])this.game.getInput().replacements[lookup_value[k]]={source:lookup_keys[i],context:"joinCompoundPhrases > found unambiguous match"}}}if(false===foundOne){this.game.log("L1109","log","high","joinCompoundPhrases > Need to disamiguate "+lookup_value,"Parser");input=input.replace(regex,A.serialize(lookup_keys[i])+"="+lookup_value.toString());if(!this.game.getInput().replacements[lookup_value])this.game.getInput().replacements[lookup_value]={source:lookup_keys[i],context:"parser.joinCompoundPhrases looking for disambiguation"}}}}var searchall="\\ball_",regexall=new RegExp("\\ball_","g");input=input.replace(regexall,"");this.game.log("L1110","log","high","[joinCompoundPhrases.js] joinCompoundPhrases() return: "+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinCompoundPrepositions=function Parser_joinCompoundPrepositions(parsed_input){this.game.log("L1546","log","high","[joinCompoundPrepositions.js] joinCompoundPrepositions() receive: "+parsed_input,"Parser");let game=this.game,compounds=this.game.dictionary.compound_prepositions,record=function(match,replacement){game.getInput().replacements[replacement.trim()]={source:match.trim(),context:"[joinCompoundPrepositions.js] found "+match.trim()};return replacement};for(let i=0;i<compounds.length;i++){var regex=new RegExp(compounds[i][0],"g");parsed_input=parsed_input.replace(regex,match=>record(match,compounds[i][1]))}this.game.log("L1257","log","high",`[joinCompoundPrepositions.js] joinCompoundPrepositions() return:
`+parsed_input,"Parser");return parsed_input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbNounPrepNounPrepNouns=function Parser_joinPhrasalVerbNounPrepNounPrepNouns(input){this.game.log("L1547","log","high","[joinPhrasalVerbNounPrepNounPrepNouns.js] joinPhrasalVerbNounPrepNounPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_noun_prep_noun_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_noun_prep_noun_prep_nouns[i][0],verb_id=this.dictionary.verb_noun_prep_noun_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],prep1=verb_phrase.split(" ")[1],prep2=verb_phrase.split(" ")[2],search,verb=new RegExp(verb+" ([,_=&A-Za-z0-9]*) "+prep1+" ([,_=&A-Za-z0-9]*) "+prep2,"g"),verb=input.replace(verb,verb_id+" $1 $2");if(verb!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrase_prepositions=prep1+" "+prep2;this.input_history[0].verb_phrasal_pattern="verb_noun_prep_noun_prep_noun";input=verb;break}}this.game.log("L1247","log","high",`[joinPhrasalVerbNounPrepNounPrepNouns.js] joinPhrasalVerbNounPrepNounPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbNounPrepNouns=function Parser_joinPhrasalVerbNounPrepNouns(input){this.game.log("L1548","log","high","[joinPhrasalVerbNounPrepNouns.js] joinPhrasalVerbNounPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_noun_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_noun_prep_nouns[i][0],verb_id=this.dictionary.verb_noun_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],prep=verb_phrase.split(" ")[1],search,verb=new RegExp(verb+" ([,_=&A-Za-z0-9]*) "+prep,"g"),verb=input.replace(verb,verb_id+" $1");if(verb!==input){console.warn("input",input);console.warn("input",input);this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrase_prepositions=""+prep;this.input_history[0].verb_phrasal_pattern="verb_noun_prep_noun";console.warn("this.input_history[0]",this.input_history[0]);input=verb;break}}this.game.log("L1245","log","high",`[joinPhrasalVerbNounPrepNouns.js] joinPhrasalVerbNounPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbNounPrepPrepNouns=function Parser_joinPhrasalVerbNounPrepPrepNouns(input){this.game.log("L1549","log","high","[joinPhrasalVerbNounPrepPrepNouns.js] joinPhrasalVerbNounPrepPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_noun_prep_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_noun_prep_prep_nouns[i][0],verb_id=this.dictionary.verb_noun_prep_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],prep1=verb_phrase.split(" ")[1],prep2=verb_phrase.split(" ")[2],search,verb=new RegExp(verb+" ([,_=&A-Za-z0-9]*) "+prep1+" "+prep2+" ([,_=&A-Za-z0-9]*)","g"),verb=input.replace(verb,verb_id+" $1 $2");if(verb!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrase_prepositions=prep1+" "+prep2;this.input_history[0].verb_phrasal_pattern="verb_noun_prep_prep_noun";input=verb;break}}this.game.log("L1256","log","high",`[joinPhrasalVerbNounPrepPrepNouns.js] joinPhrasalVerbNounPrepPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbNounPreps=function Parser_joinPhrasalVerbNounPreps(input){this.game.log("L1550","log","high","[joinPhrasalVerbNounPreps.js] joinPhrasalVerbNounPreps() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_noun_preps.length;i++){var verb_phrase=this.dictionary.verb_noun_preps[i][0],verb_id=this.dictionary.verb_noun_preps[i][1],verb=verb_phrase.split(" ")[0],prep=verb_phrase.split(" ")[1],search,verb=new RegExp(verb+" ([,_=&A-Za-z0-9]*) "+prep,"g"),verb=input.replace(verb,verb_id+" $1");if(verb!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrase_prepositions=""+prep;this.input_history[0].verb_phrasal_pattern="verb_noun_prep";input=verb;break}}this.game.log("L1261","log","high",`[joinPhrasalVerbNounPreps.js] joinPhrasalVerbNounPreps() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbPrepNounPrepNounPrepNouns=function Parser_joinPhrasalVerbPrepNounPrepNounPrepNouns(input){this.game.log("L1551","log","high","[joinPhrasalVerbPrepNounPrepNounPrepNouns.js] joinPhrasalVerbPrepNounPrepNounPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_prep_noun_prep_noun_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_prep_noun_prep_noun_prep_nouns[i][0],verb_id=this.dictionary.verb_prep_noun_prep_noun_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],prep1=verb_phrase.split(" ")[1],prep2=verb_phrase.split(" ")[2],prep3=verb_phrase.split(" ")[3],search,verb=new RegExp(verb+" "+prep1+" ([,_=&A-Za-z0-9]*) "+prep2+" ([,_=&A-Za-z0-9]*) "+prep3+" ([,_=&A-Za-z0-9]*)","g"),verb=input.replace(verb,verb_id+" $1 $2 $3");if(verb!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrase_prepositions=prep1+` ${prep2} `+prep3;this.input_history[0].verb_phrasal_pattern="verb_prep_noun_prep_noun_prep_noun";input=verb;break}}this.game.log("L1226","log","high",`[joinPhrasalVerbPrepNounPrepNounPrepNouns.js] joinPhrasalVerbPrepNounPrepNounPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbPrepNounPrepNouns=function Parser_joinPhrasalVerbPrepNounPrepNouns(input){this.game.log("L1552","log","high","[joinPhrasalVerbPrepNounPrepNouns.js] joinPhrasalVerbPrepNounPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_prep_noun_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_prep_noun_prep_nouns[i][0],verb_id=this.dictionary.verb_prep_noun_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],prep1=verb_phrase.split(" ")[1],prep2=verb_phrase.split(" ")[2],search,verb=new RegExp(verb+" "+prep1+" ([,_=&A-Za-z0-9]*) "+prep2+" ([,_=&A-Za-z0-9]*)","g"),verb=input.replace(verb,verb_id+" $1 $2");if(verb!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrase_prepositions=prep1+" "+prep2;this.input_history[0].verb_phrasal_pattern="verb_prep_noun_prep_noun";input=verb;break}}this.game.log("L1285","log","high",`[joinPhrasalVerbPrepNounPrepNouns.js] joinPhrasalVerbPrepNounPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbPrepNouns=function Parser_joinPhrasalVerbPrepNouns(input){this.game.log("L1553","log","high","[joinPhrasalVerbPrepNounPrepNouns.js] joinPhrasalVerbPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_prep_nouns[i][0],verb_id=this.dictionary.verb_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],search,regex=new RegExp("^(\\b"+verb_phrase+"\\b)","g"),regex=input.replace(regex,verb_id);if(regex!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrasal_pattern="verb_prep_noun";input=regex;break}}this.game.log("L1280","log","high",`[joinPhrasalVerbPrepNouns.js] joinPhrasalVerbPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbPrepPrepNouns=function Parser_joinPhrasalVerbPrepPrepNouns(input){this.game.log("L1554","log","high","[joinPhrasalVerbPrepPrepNouns.js] joinPhrasalVerbPrepPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_prep_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_prep_prep_nouns[i][0],verb_id=this.dictionary.verb_prep_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],search,regex=new RegExp("\\b"+verb_phrase+"\\b","g"),regex=input.replace(regex,verb_id);if(regex!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrasal_pattern="verb_prep_prep_noun";input=regex;break}}this.game.log("L1244","log","high",`[joinPhrasalVerbPrepPrepNouns.js] joinPhrasalVerbPrepPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.joinPhrasalVerbPrepPrepPrepNouns=function Parser_joinPhrasalVerbPrepPrepPrepNouns(input){this.game.log("L1555","log","high","[joinPhrasalVerbPrepPrepPrepNouns.js] joinPhrasalVerbPrepPrepPrepNouns() receive: "+input,"Parser");for(var i=0;i<this.dictionary.verb_prep_prep_prep_nouns.length;i++){var verb_phrase=this.dictionary.verb_prep_prep_prep_nouns[i][0],verb_id=this.dictionary.verb_prep_prep_prep_nouns[i][1],verb=verb_phrase.split(" ")[0],search,regex=new RegExp("\\b"+verb_phrase+"\\b","g"),regex=input.replace(regex,verb_phrase);if(regex!==input){this.input_history[0].input_verb=verb_id;this.input_history[0].verb_phrase=verb_phrase;this.input_history[0].verb_phrasal_pattern="verb_prep_prep_prep_noun";input=regex;break}}this.game.log("L1286","log","high",`[joinPhrasalVerbPrepPrepPrepNouns.js] joinPhrasalVerbPrepPrepPrepNouns() return:
`+input,"Parser");return input}})();(()=>{var p=adventurejs.Parser.prototype;p.phrasal_patterns=["joinPhrasalVerbPrepNounPrepNounPrepNouns","joinPhrasalVerbNounPrepPrepNouns","joinPhrasalVerbNounPrepNounPrepNouns","joinPhrasalVerbPrepNounPrepNouns","joinPhrasalVerbPrepPrepPrepNouns","joinPhrasalVerbPrepPrepNouns","joinPhrasalVerbNounPrepNouns","joinPhrasalVerbNounPreps","joinPhrasalVerbPrepNouns"];p.joinPhrasalVerbs=function Parser_joinPhrasalVerbs(input){this.game.log("L1556","log","high","[joinPhrasalVerbs.js] joinPhrasalVerbs() receive: "+input,"Parser");if(1<input.split(" ").length)for(let i=0;i<this.phrasal_patterns.length;i++){var phrasal_input=this[this.phrasal_patterns[i]](input);if(phrasal_input!==input)return phrasal_input}this.game.log("L1557","log","high",`[joinPhrasalVerbs.js] joinPhrasalVerbs() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.parseInput=function Parser_parseInput(input){this.game.log("L1091","log","high","[parseInput.js] parseInput() "+input,"Parser");var results;this.game.reactor.emit("inputParseBegin");if("undo"===input){this.game.printInput(input);this.game.dictionary.doVerb("undo")}else{var parsed_input=input,unparsed_input=input;A.addWorldToHistory.call(this.game,A.getBaselineDiff.call(this.game));this.input_history_index=-1;var output_class="";if(0<this.custom_parsers.length)for(var keys=Object.keys(this.custom_parsers),i=0;i<this.keys.length;i++){var parser_name=keys[i];if(true===this.custom_parsers_enabled[parser_name])if(false===(input=this.custom_parsers[parser_name].parseInput())){this.is_input_queued=false;this.game.endTurn();return false}else if(null===input){this.is_input_queued=false;this.game.endTurn();return null}}var carried_input=new adventurejs.Input({game_name:this.game.game_name});if(0<this.input_queue.length){carried_input.replacements=Object.assign(carried_input.replacements,this.input_history[0].replacements);carried_input.unparsed_input=this.input_history[0].unparsed_input;carried_input.multiple=this.input_history[0].multiple;if(this.input_queue[0].printInput)this.game.printInput(A.deserialize(input));if(void 0!==this.input_queue[0].output_class)output_class=this.input_queue[0].output_class;if(void 0!==this.input_queue[0].output)this.game.print(this.input_queue[0].output,output_class);if(void 0!==this.input_queue[0].linefeed&&this.input_queue[0].linefeed)this.game.print("","linefeed");this.input_queue.shift()}else{[parsed_input,unparsed_input]=this.sanitizeInput(parsed_input,unparsed_input);this.game.printInput(A.deserialize(parsed_input))}this.input_history.unshift(new adventurejs.Input({game_name:this.game.game_name}));var this_turn=this.input_history[0],last_turn=this.input_history[1],results;if(void 0!==(results=this.game.callPreScripts(input)))return results;this_turn.input=unparsed_input;this_turn.output_class+=output_class;this_turn.replacements=Object.assign(this_turn.replacements,carried_input.replacements);if(carried_input.unparsed_input)this_turn.unparsed_input=carried_input.unparsed_input;else this_turn.unparsed_input=unparsed_input;parsed_input=this.parseStrings(parsed_input);var parsed_input,but_arr=(parsed_input=this.parseNumbers(parsed_input)).split(" but ");let but_str="";for(let i=0;i<but_arr.length;i++){but_str+=this.joinCompoundPhrases(but_arr[i]);if(i<but_arr.length-1)but_str+=" but "}parsed_input=but_str;if(false===(parsed_input=this.findCharacterComma(parsed_input)))return false;if((parsed_input=this.stripArticles(parsed_input)).startsWith("with ")&&last_turn.soft_prompt.enabled&&last_turn.soft_prompt.noun)parsed_input=parsed_input.replace("with ","");parsed_input=this.joinCompoundPrepositions(parsed_input);parsed_input=this.joinPhrasalVerbs(parsed_input);parsed_input=this.stripConjunctions(parsed_input);var parsed_input_array=(this_turn.parsed_input=parsed_input).split(" ");this_turn.parsed_input_array=parsed_input_array;if(!this_turn.input_verb){if(parsed_input_array[0].includes("&")){var potential_verbs=parsed_input_array[0].split("&");let allverbs=true;for(let i in potential_verbs){var word=potential_verbs[i],potential_verb;if(!this.parseVerb(word))allverbs=false}if(allverbs){for(let i=1;i<potential_verbs.length;i++)this.input_queue.push({input:parsed_input.replace(parsed_input_array[0],potential_verbs[i]),printInput:true});parsed_input_array[0]=potential_verbs[0]}}var results=this.parseVerb(parsed_input_array[0]),input_verb;if(results)input_verb=parsed_input_array[0];else if(this.game.dictionary.getAdverb(parsed_input_array[0]))if(results=this.parseVerb(parsed_input_array[1]))input_verb=parsed_input_array[1];if(results)this_turn.input_verb=input_verb;else if(last_turn.soft_prompt.noun1){parsed_input_array.unshift(last_turn.getVerb());parsed_input=this.input_history[1].parsed_input+" "+parsed_input;parsed_input_array=(this_turn.parsed_input=parsed_input).split(" ");this_turn.parsed_input_array=parsed_input_array;this.game.log("L1093","log","high","[parseInput.js] handle soft prompt for noun1","Parser");this_turn.input_verb=last_turn.soft_prompt.input_verb||last_turn.input_verb;this_turn.verb_phrase=last_turn.soft_prompt.verb_phrase||last_turn.verb_phrase;this_turn.soft_prompt.satisfied=true}}var output_class=null!==last_turn.disambiguate.index&&!isNaN(Number(parsed_input_array[0]));if(1===parsed_input_array.length&&""===parsed_input_array[0]&&false==output_class)this.parseNoInput();else if(1===parsed_input_array.length){this_turn.found_word=parsed_input_array[0];this.handleWord()}else{if(false===this.parseSentence())return false;if(false===this.verifySentence())return false;if(false===this.verifyAdverbs())return false;if(false===this.verifySentenceStructure())return false;if(false===this.verifyCharacterCanDoVerb())return false;this.saveVerbPhrase();if(false===this.handleSentence())return false}this.game.updateDisplayRoom();if(0<this.input_queue.length){this.game.reactor.emit("inputQueueNext");this.is_input_queued=true;this.parseInput(this.input_queue[0].input)}else{this.is_input_queued=false;this.game.endTurn()}}}})();(()=>{var p;adventurejs.Parser.prototype.parseNoun=function Parser_parseNoun(word){this.game.log("L1098","log","high","[parseNoun.js] parseNoun() receive: "+word,"Parser");var room=this.game.getRoom(),this_turn=this.input_history[0],last_turn=this.input_history[1],parsedNoun=new adventurejs.ParsedNoun;parsedNoun.input=word;parsedNoun.serialized_input=A.serialize(word);parsedNoun.original_input=this_turn.replacements[word]?.source||this_turn.replacements[parsedNoun.serialized_input]?.source||A.deserialize(word);if("it"===word&&last_turn&&last_turn.parsedNoun1&&last_turn.parsedNoun1.qualified_object_id)word=last_turn.parsedNoun1.qualified_object_id;var this_turn=this.dictionary.getDirection(word);if(this_turn)parsedNoun.matches.direction=this_turn;var asset=this.game.getAsset(word);if(asset&&asset instanceof adventurejs.Substance)parsedNoun.matches.substance=asset.id;if(this_turn&&void 0!==room.exits[this_turn]){var asset=room.exits[this_turn];parsedNoun.matches.all.push(asset);parsedNoun.matches.qualified.push(asset);parsedNoun.qualified_object_id=asset}else if(this_turn&&void 0===room.exits[this_turn]){parsedNoun.matches.all.push("global_"+this_turn);parsedNoun.matches.qualified.push("global_"+this_turn)}else if("all"===word)if(last_turn.disambiguate.enabled)parsedNoun.matches.all=last_turn.verified_sentence["phrase"+last_turn.disambiguate.index].parsedNoun.matches.qualified;else parsedNoun.matches.all=room.getAllNestedContents();else if(1===word.split("&").length&&1===word.split("=").length)parsedNoun.matches.all=this.game.parser.selectAll(word);else if(1<word.split("&").length||1<word.split("=").length)for(var multipleInput=word.split("&"),mI=0;mI<multipleInput.length;mI++){console.log(multipleInput);var ambiguousInput=multipleInput[mI].split("=");if(1===ambiguousInput.length){parsedNoun.matches.all=parsedNoun.matches.all.concat(this.game.parser.selectAll(ambiguousInput[0]));this.game.log("L1099","log","low","[parseNoun.js] Unambiguous match: "+ambiguousInput[0],"Parser")}else{this.game.log("L1100","log","low","[parseNoun.js] Ambiguous matches:","Parser");var ambiguousMatches=ambiguousInput[1].split(",");parsedNoun.input=ambiguousInput[0];parsedNoun.serialized_input=ambiguousInput[0];parsedNoun.original_input=A.deserialize(ambiguousInput[0]);for(var aM=0;aM<ambiguousMatches.length;aM++){var tempParsedNoun=this.game.parser.selectAll(ambiguousMatches[aM]);this.game.log("L1101","log","low","[parseNoun.js] tempParsedNoun: "+tempParsedNoun,"Parser");for(var tPN=0;tPN<tempParsedNoun.length;tPN++)parsedNoun.matches.all.push(tempParsedNoun[tPN]);this.game.log("L1102","log","low","[parseNoun.js] ambiguousMatches: "+ambiguousMatches[aM],"Parser")}}}parsedNoun.matches.qualified=Object.assign([],parsedNoun.matches.all);if(0===parsedNoun.matches.all.length);else{if(1===parsedNoun.matches.all.length)parsedNoun.matches.unambiguous=parsedNoun.matches.all[0];var asset=this.game.world_lookup[parsedNoun.original_input];if(void 0!==asset){parsedNoun.type=asset.type;if("singular"===parsedNoun.type)parsedNoun.plural=asset.plural;if("plural"===asset.type){parsedNoun.isPlural=true;parsedNoun.singular=asset.singular}if("group"===asset.type){parsedNoun.isGroup=true;parsedNoun.singular=asset.singular}}this.game.log("L1103","log","high",`[parseNoun.js] parseNoun() return:
`+parsedNoun.matches.qualified,"Parser")}return parsedNoun}})();(()=>{var p;adventurejs.Parser.prototype.parseNumbers=function Parser_parseNumbers(input){this.game.log("L1558","log","high","[parseNumbers.js] parseNumbers() receive: "+input,"Parser");this.game.world.global_number.set({values:[]});var re=/\b\d+\b/g,match;let counter=0;for(;match=re.exec(input);){this.game.log("L1535","log","high",`parseNumbers > found number ${counter}: `+match[0],"Parser");input=input.replace(match[0],"global_number");var match=match[0];this.game.getInput().strings.push(match);this.game.world.global_number.values.push(match);counter++}this.game.log("L1536","log","high",`[parseNumbers.js] parseNumbers() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.parseSentence=function Parser_parseSentence(){var this_turn=this.input_history[0],firstverb;this.game.log("L1265","log","high","[parseSentence.js] parseSentence() "+this_turn.parsed_input_array,"Parser");let last_word_type,last_word;var count={noun:0,prep:0,verb:0,adverb:0,adjective:0,direction:0,exclusion:0,unknown:0,string:0,phrase:0};for(let position=0;position<this_turn.parsed_input_array.length;position++){let word=this_turn.parsed_input_array[position],verb=this.parseVerb(word),adverb=this.game.dictionary.getAdverb(word),direction=this.game.dictionary.getDirection(word);var compass_direction=direction&&this.game.dictionary.verbs[direction].is_compass_direction,relative_direction=direction&&this.game.dictionary.verbs[direction].is_relative_direction,parsed_direction=direction&&this.parseNoun(direction);let preposition=this.game.dictionary.getPreposition(word);var string="global_string"===word?word:false;let noun=void 0!==this.game.world[word]||0<this.parseNoun(word).matches.all.length||word.includes("&")||word.includes("=")||void 0!==adventurejs[A.propercase(word)];var exclusion="-"===word.charAt(0),number=!isNaN(Number(word))?word:false,adjective=this.game.dictionary.getAdjective(word),compass_direction={word:word,verb:verb,direction:direction,compass_direction:compass_direction,relative_direction:relative_direction,parsed_direction:parsed_direction,preposition:preposition,string:string,noun:noun,exclusion:exclusion,number:number,adjective:adjective};if(noun&&exclusion)noun=false;if(verb&&direction&&preposition)if(0===position||1===position&&0<count.adverb){direction=false;preposition=false}else if(1===position){verb=false;direction=false}else{verb=false;direction=false}if(verb&&direction&&adverb)if(0===position){direction=false;adverb=false;noun=false}else if(1===position||position===this_turn.parsed_input_array.length-1||"verb"===last_word_type){verb=false;direction=false;noun=false}else{verb=false;adverb=false}if(verb&&noun&&direction){this.game.log("L1532","log","high",`[parseSentence.js] word is verb, noun and direction: ${verb}, ${noun}, `+direction,"Parser");if(0===position||1===position&&0<count.adverb){direction=false;noun=false}else{direction=false;verb=false}}if(verb&&noun){this.game.log("L1531","log","high",`[parseSentence.js] word is verb and noun: ${verb}, `+noun,"Parser");if(0===position||1===position&&0<count.adverb)noun=false;else verb=false}if(verb&&direction){this.game.log("L1530","log","high",`[parseSentence.js] word is verb and direction: ${verb}, `+direction,"Parser");if(0===position||1===position&&0<count.adverb)direction=false;else verb=false}if(verb&&preposition){this.game.log("L1529","log","high",`[parseSentence.js] word is verb and preposition: ${verb}, `+preposition,"Parser");if(0===position||1===position&&0<count.adverb)preposition=false;else verb=false}if(verb){this.game.log("L1266","log","high","[parseSentence.js] word is verb: "+verb,"Parser");if(0===count.verb)firstverb=verb;count.verb++;this_turn.pushParsedWord({type:"verb",word:verb,properties:compass_direction});last_word_type="verb";last_word=word}else if(adverb){this.game.log("L1267","log","high","[parseSentence.js] word is adverb: "+adverb,"Parser");count.adverb++;this_turn.pushParsedWord({type:"adverb",word:adverb,properties:compass_direction});last_word_type="adverb";last_word=word}else if(direction){this.game.log("L1268","log","high","[parseSentence.js] word is direction: "+direction,"Parser");count.direction++;count.phrase++;this_turn.pushParsedWord({type:"direction",word:direction,properties:compass_direction});last_word_type="direction";last_word=word}else if(preposition){this.game.log("L1269","log","high","[parseSentence.js] word is preposition: "+word,"Parser");count.prep++;count.phrase++;this_turn.pushParsedWord({type:"preposition",word:word,phrase:count.phrase,properties:compass_direction});last_word_type="preposition";last_word=word}else if(noun){this.game.log("L1270","log","high","[parseSentence.js] word is noun: "+word,"Parser");count.noun++;this_turn.pushParsedWord({type:"noun",word:word,preposition:null,properties:compass_direction,adjective:adjective});last_word_type="noun";last_word=word}else if(exclusion){this.game.log("L1271","log","high","[parseSentence.js] exclude noun: "+word,"Parser");word=word.slice(1);if("noun"===last_word_type){var relative_direction=this_turn.parsed_sentence.length-1;this_turn.parsed_sentence[relative_direction].exclusion=word}else this_turn.pushParsedWord({type:"exclusion",word:word,properties:compass_direction});last_word_type="exclusion";last_word=word}else if(number){this.game.log("L1272","log","high","[parseSentence.js] word is number: "+word,"Parser");count.number++;count.phrase++;this_turn.pushParsedWord({type:"number",word:word,properties:compass_direction});last_word_type="number";last_word=word}else if(adjective){this.game.log("L1273","log","high","[parseSentence.js] word is adjective: "+word,"Parser");count.adjective++;this_turn.pushParsedWord({type:"adjective",word:word,properties:compass_direction});last_word_type="adjective";last_word=word}else{this.game.log("L1274","log","high","[parseSentence.js] word is unknown: "+word,"Parser");last_word_type="unknown";this_turn.pushParsedWord({type:"unknown",word:word,properties:compass_direction});last_word=word}}return true}})();(()=>{var p;adventurejs.Parser.prototype.parseStrings=function Parser_parseStrings(input){this.game.log("L1559","log","high","[parseStrings.js] parseStrings() receive: "+input,"Parser");this.game.world.global_string.set({values:[]});for(var re1,re2,reS=[/"(.*?)"/g,/'(.*?)'/g],i=0;i<reS.length;i++)for(var current,counter=0;current=reS[i].exec(input);){this.game.log("L1278","log","high","parseStrings > found quoted substring "+counter+": "+current[0],"Parser");input=input.replace(current[0],"global_string");var current=current[0].replace(/^"(.*)"$/,"$1");this.game.world.global_string.values.push(current);this.game.getInput().strings.push(current);counter++}this.game.log("L1279","log","high",`[parseStrings.js] parseStrings() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.parseVerb=function Parser_parseVerb(verb){this.game.log("L1525","log","high","[parseVerb.js] parseVerb() receive: "+verb,"Parser");for(var keys=Object.keys(this.dictionary.verbs),i=0;i<keys.length;i++)if(this.dictionary.testVerbSynonyms(verb,keys[i])){this.game.log("L1526","log","high","[parseVerb.js] parseVerb() found: "+this.dictionary.verbs[keys[i]].name,"Parser");return this.dictionary.verbs[keys[i]].name}return false}})();(()=>{var p;adventurejs.Parser.prototype.printNounDisambiguation=function Parser_printNounDisambiguation({parsedNoun,nounIndex,container}){var output_class="",definite_names=[],names=[],msg="Which did {we} mean? ";if(this.game.settings.show_disambiguation_as_ordered_list){msg+="<ol>";for(var i=0;i<parsedNoun.matches.qualified.length;i++)msg+=`<li>${this.game.getAsset(parsedNoun.matches.qualified[i]).articlename}</li>`;msg+="</ol>"}else for(var i=0;i<parsedNoun.matches.qualified.length;i++){var asset=this.game.getAsset(parsedNoun.matches.qualified[i]),name=asset.name,asset=asset.definite_name;if(i===parsedNoun.matches.qualified.length-1)msg+="or ";if(this.game.settings.show_disambiguation_as_numbered_paragraph)msg+=`<span class='ajs-choice'>${i+1}) </span>`;names.push(name);definite_names.push(asset);if(0===i)asset=A.propercase(asset);msg+=asset;if(i<parsedNoun.matches.qualified.length-1)msg+=", ";if(i===parsedNoun.matches.qualified.length-1)msg+="? "}var nounIndex={["noun"+nounIndex]:true,index:nounIndex};if(container)nounIndex.container=true;this.input_history[0].setDisambiguate(nounIndex);if(msg)this.game.print(msg,"")}})();(()=>{var p;adventurejs.Parser.prototype.qualifyParsedNoun=function Parser_qualifyParsedNoun({parsedNoun,parsedVerb,nounIndex}){var fx="qualifyParsedNoun.js",getQualifiedName=(this.game.log("L1111","log","high",`[${fx}] qualifyParsedNoun() begin`,"Parser"),qualified_asset=>{let qualified_name;var source=this.game.getInput().replacements[qualified_asset.id]?.source;if(source)qualified_name=source;else qualified_name=qualified_asset.noun;return qualified_name}),doVerbAction=function(qualified_asset,verb){return qualified_asset.doVerbAction({action:"try"+verb.Name,type:"VerbAction"})},getQualifiedId=function(parsedNoun){return 1===parsedNoun.matches.qualified.length?parsedNoun.matches.qualified[0]:null},input=this.game.getInput(),subject=input.getSubject(),player=this.game.getPlayer(),output_class="";let msg="";var verb=this.dictionary.verbs[parsedVerb],prettyverb=verb.prettyname,gerund=verb.gerund,must_be=this.dictionary.verbs[parsedVerb]["phrase"+nounIndex].noun_must_be,qualified_count;if(must_be.known){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectKnown(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1113","log","high",`[${fx}] must_be.known eliminated remaining assets `,"Parser");this.game.debug("D1056",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.known`);if(qualified_id){qualified_asset=this.game.getAsset(qualified_id);qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} {don't} know of any ${qualified_name}. `;else msg+=`{We} {don't} know of any ${A.deserialize(parsedNoun.input)}. `;this.game.print(msg,"");return false}}if(must_be.extant){parsedNoun.matches.qualified=this.selectExtant(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1190","log","high",`[${fx}] must_be.visible eliminated remaining assets `,"Parser");this.game.debug("D1310",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.extant`);msg+=`Was there any ${parsedNoun.original_input}? {We} can't recall. `;this.game.print(msg,"");return false}}if(must_be.present){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectPresent(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1115","log","high",`[${fx}] must_be.present eliminated remaining assets `,"Parser");this.game.debug("D1067",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.present`);if(qualified_id){qualified_asset=this.game.getAsset(qualified_id);qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`There doesn't appear to be any ${qualified_name} present. `;else msg+=`There doesn't appear to be any ${parsedNoun.original_input} present. `;this.game.print(msg,"");return false}}if(must_be.present_if_tangible){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectPresentIfTangible(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1117","log","high",`[${fx}] must_be.present_if_tangible eliminated remaining assets `,"Parser");this.game.debug("D1596",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.present_if_tangible`);if(qualified_id){qualified_asset=this.game.getAsset(qualified_id);qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`There doesn't appear to be any ${qualified_name} present. `;else msg+=`There doesn't appear to be any ${parsedNoun.original_input} present. `;this.game.print(msg,"");return false}}if(must_be.direction)if(false===parsedNoun.matches.direction){this.game.log("L1118","log","high",`[${fx}] must_be.direction eliminated remaining assets `,"Parser");this.game.debug("D1054",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.direction`);msg+="It appears that {we} meant to specify a direction, but that wasn't recognized as such. ";this.game.print(msg,"");return false}if(must_be.not_direction)if(parsedNoun.matches.direction){this.game.log("L1119","log","high",`[${fx}] must_be.not_direction eliminated remaining assets `,"Parser");this.game.debug("D1055",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_direction`);msg+=`{We} can't ${prettyverb} a direction. `;this.game.print(msg,"");return false}if(must_be.not_global){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotGlobal(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1121","log","high",`[${fx}] must_be.not_global eliminated remaining assets `,"Parser");this.game.debug("D1058",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_global`);if(qualified_id){var results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.not_scenery){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotScenery(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1123","log","high",`[${fx}] must_be.not_scenery eliminated remaining assets `,"Parser");this.game.debug("D1059",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_scenery`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.not_exit){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotExit(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1125","log","high",`[${fx}] must_be.not_exit eliminated remaining assets `,"Parser");this.game.debug("D1060",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_exit`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.intangible){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectIntangible(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1127","log","high",`[${fx}] must_be.intangible eliminated remaining assets `,"Parser");this.game.debug("D1061",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.intangible`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.not_substance){parsedNoun.matches.qualified=this.selectNotSubstance(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1129","log","high",`[${fx}] must_be.not_substance eliminated remaining assets `,"Parser");this.game.debug("D1062",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_substance`);msg+="{We} need to specify a source. ";this.game.print(msg,"");return false}}if(must_be.matter){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectMatter(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1131","log","high",`[${fx}] must_be.matter eliminated remaining assets `,"Parser");this.game.debug("D1534",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.matter`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.tangible){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectTangible(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1133","log","high",`[${fx}] must_be.tangible eliminated remaining assets `,"Parser");this.game.debug("D1063",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.tangible`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.dov){let qualified_id,qualified_name,qualified_asset;if(1===parsedNoun.matches.qualified.length)qualified_id=parsedNoun.matches.qualified[0];parsedNoun.matches.qualified=this.selectDOV(parsedNoun.matches.qualified,parsedVerb);if(!parsedNoun.matches.qualified.length){this.game.log("L1135","log","high",`[${fx}] must_be.dov eliminated remaining assets `,"Parser");this.game.debug("D1585",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.dov`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=qualified_asset.definite_article+" "+getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${prettyverb} ${qualified_name}. `;else msg+=`{We} can't ${prettyverb} any ${A.deserialize(parsedNoun.input)}. `;this.game.print(msg,"");return false}}if(must_be.iov){let qualified_count=parsedNoun.matches.qualified.length,qualified_id,qualified_name,qualified_asset;if(1===qualified_count)qualified_id=parsedNoun.matches.qualified[0];parsedNoun.matches.qualified=this.selectIOV(parsedNoun.matches.qualified,parsedVerb);if(!parsedNoun.matches.qualified.length){this.game.log("L1137","log","high",`[${fx}] must_be.iov eliminated remaining assets `,"Parser");this.game.debug("D1057",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.iov`);var prep=this.game.getInput().getPreposition(nounIndex)||"",dasset;let dname="";if(1<nounIndex){dasset=this.game.getInput().getAsset(1);dname=dasset.noun||(dasset.singlePluralPairs[0]&&dasset.singlePluralPairs[0][0]?dasset.singlePluralPairs[0][0]:this.game.getInput().getParsedNoun(1).input)}let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;if(qualified_name=qualified_asset.definite_article+" "+getQualifiedName(qualified_asset))msg+=`{We} can't use ${qualified_name} to ${prettyverb} ${this.game.getInput().getAsset(1).definite_article} ${dname}. `;else msg+=`{We} can't any ${A.deserialize(parsedNoun.input)} to ${prettyverb} ${this.game.getInput().getAsset(1).definite_article} ${dname}. `;this.game.print(msg,"");return false}}if(must_be.global_substance){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectGlobalSubstance(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1140","log","high",`[${fx}] must_be.global_substance eliminated remaining assets `,"Parser");this.game.debug("D1064",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.global_substance`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.substance){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectSubstance(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1142","log","high",`[${fx}] must_be.substance eliminated remaining assets `,"Parser");this.game.debug("D1065",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.substance`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.reservoir){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectReservoir(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1144","log","high",`[${fx}] must_be.reservoir eliminated remaining assets `,"Parser");this.game.debug("D2099",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.reservoir`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.reservoir_if_substance){let substance_id,substance;if(parsedNoun?.matches?.substance){substance_id=parsedNoun.matches.substance;substance=this.game.getAsset(parsedNoun.matches.substance)}let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectReservoirIfSubstance(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1146","log","high",`[${fx}] must_be.reservoir_if_substance eliminated remaining assets `,"Parser");this.game.debug("D2101",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.reservoir_if_substance`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} {don't} see any ${substance?substance.name:""} suitable for ${gerund}. `;this.game.print(msg,"");return false}}if(must_be.reservoir_or_carried_if_substance){let substance_id,substance,qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);if(parsedNoun?.matches?.substance){substance_id=parsedNoun.matches.substance;substance=this.game.getAsset(parsedNoun.matches.substance)}parsedNoun.matches.qualified=this.selectReservoirOrCarriedIfSubstance(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1148","log","high",`[${fx}] must_be.reservoir_or_carried_if_substance eliminated remaining assets `,"Parser");this.game.debug("D2126",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.reservoir_or_carried_if_substance`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} {don't} see any ${substance?substance.name:""} suitable for ${gerund}. `;this.game.print(msg,"");return false}}if(must_be.character){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectCharacter(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1150","log","high",`[${fx}] must_be.character eliminated remaining assets `,"Parser");this.game.debug("D1066",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.character`);let prep=this.game.getInput().getPreposition(nounIndex)||"",dobj="";if(2===nounIndex)dobj=this.game.getInput().getAsset(1)?.articlename||"";if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${prettyverb} ${dobj} ${prep} ${this.game.getAsset(qualified_id).articlename}. `;else msg+=`{We} {don't} know of anyone named "${parsedNoun.original_input}". `;this.game.print(msg,"");return false}}if(must_be.parent){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectParent(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1152","log","high",`[${fx}] must_be.self_parent eliminated remaining assets `,"Parser");this.game.debug("D1069",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.self_parent`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not ${qualified_asset.default_aspect?qualified_asset.default_aspect:"on"} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+="{We're} not on that. ";this.game.print(msg,"");return false}}if(must_be.not_parent){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotParent(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1154","log","high",`[${fx}] must_be.not_parent eliminated remaining assets `,"Parser");this.game.debug("D1071",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_parent`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} already ${subject.getPlacePreposition()} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.not_parent_or_room){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotParentOrRoom(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1521","log","high",`[${fx}] must_be.not_parent_or_room eliminated remaining assets `,"Parser");this.game.debug("D1398",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_parent_or_room`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} already ${qualified_asset.default_aspect?qualified_asset.default_aspect:"on"} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't ${input.getInput()}. `;this.game.print(msg,"");return false}}if(must_be.parent_or_room){let qualified_id,qualified_asset,qualified_name;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectParentOrRoom(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1519","log","high",`[${fx}] must_be.self_parent eliminated remaining assets `,"Parser");this.game.debug("D1390",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.self_parent`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not ${qualified_asset.default_aspect?qualified_asset.default_aspect:"on"} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+="{We're} not on that. ";this.game.print(msg,"");return false}}if(must_be.singular){parsedNoun.matches.qualified=this.selectSingular(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1156","log","high",`[${fx}] must_be.singular eliminated remaining assets `,"Parser");this.game.debug("D1073",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.singular`);msg+="{We'll} have to do that one at a time. ";this.game.print(msg,"");return false}}if(must_be.in_inventory_if_takeable){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectInInventoryIfTakeable(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1158","log","high",`[${fx}] must_be.in_inventory_if_takeable eliminated remaining assets `,"Parser");this.game.debug("D1074",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.in_inventory_if_takeable`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not carrying ${qualified_asset.definite_article} ${qualified_name}. `;else{var results=parsedNoun.original_input;msg+=`{We're} not carrying any${"all"===results?"thing":" "+results}. `}this.game.print(msg,"");return false}}if(must_be.in_inventory){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectInInventory(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1160","log","high",`[${fx}] must_be.in_inventory eliminated remaining assets `,"Parser");this.game.debug("D1075",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.in_inventory`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not carrying ${player.knowsAbout(qualified_asset)?qualified_asset.articlename:"any "+parsedNoun.original_input}. `;else{let it=parsedNoun.original_input;msg+=`{We're} not carrying any${"all"===it?"thing":" "+it}. `}this.game.print(msg,"");return false}}if(must_be.in_hands){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectInHands(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1162","log","high",`[${fx}] must_be.in_hands eliminated remaining assets `,"Parser");this.game.debug("D1076",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.in_hands`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not holding ${player.knowsAbout(qualified_asset)?qualified_asset.articlename:"any "+parsedNoun.original_input}. `;else msg+=`{We're} not holding any ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.in_hands_unless_reservoir){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectInHandsUnlessReservoir(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1164","log","high",`[${fx}] must_be.in_hands_unless_reservoir eliminated remaining assets `,"Parser");this.game.debug("D1448",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.in_hands_unless_reservoir`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not holding ${player.knowsAbout(qualified_asset)?qualified_asset.articlename:"any "+parsedNoun.original_input}. `;else msg+=`{We're} not holding any ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.not_in_hands){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotInHands(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1166","log","high",`[${fx}] must_be.not_in_hands eliminated remaining assets `,"Parser");this.game.debug("D1077",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_in_hands`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} carrying ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We're} carrying the ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.held){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectHeld(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1168","log","high",`[${fx}] must_be.held eliminated remaining assets `,"Parser");this.game.debug("D1716",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.held`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not holding ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We're} not holding any ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.not_in_inventory){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotInInventory(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1170","log","high",`[${fx}] must_be.not_in_inventory eliminated remaining assets `,"Parser");this.game.debug("D1078",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_in_inventory`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not carrying ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We're} carrying the ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.worn){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectWorn(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1172","log","high",`[${fx}] must_be.worn eliminated remaining assets `,"Parser");this.game.debug("D1079",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.worn`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} not wearing ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We're} not wearing any ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.not_worn){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotWorn(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1174","log","high",`[${fx}] must_be.not_worn eliminated remaining assets `,"Parser");this.game.debug("D1080",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_worn`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We're} wearing ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We're} wearing any ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if("all"===parsedNoun.input&&must_be.not_worn_if_all){parsedNoun.matches.qualified=this.selectNotWornIfAll(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1176","log","high",`[${fx}] must_be.not_worn_if_all eliminated remaining assets `,"Parser");this.game.debug("D1081",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_worn_if_all`);msg+="{We're} not carrying anything. ";this.game.print(msg,"");return false}}if("all"===parsedNoun.input&&must_be.not_nested_inventory_if_all){parsedNoun.matches.qualified=this.selectNotNestedInventoryIfAll(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1178","log","high",`[${fx}] must_be.not_nested_inventory_if_all eliminated remaining assets `,"Parser");this.game.debug("D1082",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_nested_in_inventory_if_all`);msg+="{We're} not carrying anything. ";this.game.print(msg,"");return false}}if(must_be.visible){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectVisible(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1180","log","high",`[${fx}] must_be.visible eliminated remaining assets `,"Parser");this.game.debug("D1083",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.visible`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't see ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't see any ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.visible_if_tangible){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectVisibleIfTangible(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1182","log","high",`[${fx}] must_be.visible_if_tangible eliminated remaining assets `,"Parser");this.game.debug("D1610",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.visible`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't see ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't see any ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.reachable){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectReachable(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1184","log","high",`[${fx}] must_be.reachable eliminated remaining assets `,"Parser");this.game.debug("D1084",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.reachable`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(parsedNoun.matches.direction)msg+="{We} can't go "+parsedNoun.matches.direction;else if(parsedNoun.isPlural&&qualified_name)msg+=`{We} can't reach ${qualified_asset.definite_article} `+qualified_name;else msg+="{We} can't reach the "+parsedNoun.original_input;if(subject.isNested())msg+=` from {our} position ${subject.getPostureGerund()} ${subject.getNestPreposition()} `+subject.getNestAsset().articlename;else if("stand"!==subject.posture)msg=(msg+=" while "+subject.getPostureGerund())+(subject.isOnFloor()?" on the floor":"");msg=msg.trim();msg+=". ";this.game.print(msg,"");return false}}if(must_be.reachable_if_tangible){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectReachableIfTangible(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1186","log","high",`[${fx}] must_be.reachable_if_tangible eliminated remaining assets `,"Parser");this.game.debug("D1176",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.reachable`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't reach ${qualified_asset.definite_article} `+qualified_name;else msg+="{We} can't reach the "+parsedNoun.original_input;if(subject.isNested())msg+=` from your position ${subject.getPostureGerund()} ${subject.getNestPreposition()} `+subject.getNestAsset().articlename;msg=msg.trim();msg+=". ";this.game.print(msg,"");return false}}if(must_be.takeable){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectTakeable(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length&&"all"===parsedNoun.input){this.game.log("L1188","log","high",`[${fx}] must_be.takeable eliminated remaining assets `,"Parser");this.game.debug("D1085",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.takeable`);msg+="There's nothing takeable in reach. ";this.game.print(msg,"");return false}if(!parsedNoun.matches.qualified.length){this.game.debug("D1086",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.takeable`);var dasset=false;if(1<parsedNoun.input.split("&").length)dasset=true;else if(parsedNoun.isPlural||parsedNoun.isGroup)dasset=true;if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(dasset)msg+="{We} can't take them. ";else if(qualified_name)msg+=`{We} can't take ${qualified_asset.definite_article} ${qualified_name}. `;else msg+=`{We} can't take ${parsedNoun.original_input}. `;this.game.print(msg,"");return false}}if(must_be.player){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectPlayer(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1192","log","high",`[${fx}] must_be.player eliminated remaining assets `,"Parser");this.game.debug("D2109",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.player`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+="{We} can only do that to {ourself}. ";this.game.print(msg,"");return false}}if(must_be.not_player){var gerund,qualified_name,prettyverb,gerund=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotPlayer(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1194","log","high",`[${fx}] must_be.not_player eliminated remaining assets `,"Parser");this.game.debug("D2110",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_player`);if(gerund){let results=doVerbAction(prettyverb=this.game.getAsset(gerund),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(prettyverb)}msg+="{We} can't do that to {ourself}. ";this.game.print(msg,"");return false}}if(must_be.self){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectSelf(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1334","log","high",`[${fx}] must_be.self eliminated remaining assets `,"Parser");this.game.debug("D1184",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.self`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}if(qualified_name)msg+=`{We} can't ${parsedVerb} ${qualified_asset.definite_article} ${qualified_name}. `;else msg+="{We} can only do that to {ourself}. ";this.game.print(msg,"");return false}}if(must_be.not_self){let qualified_id,qualified_name,qualified_asset;qualified_id=getQualifiedId(parsedNoun);parsedNoun.matches.qualified=this.selectNotSelf(parsedNoun.matches.qualified);if(!parsedNoun.matches.qualified.length){this.game.log("L1396","log","high",`[${fx}] must_be.not_self eliminated remaining assets `,"Parser");this.game.debug("D1185",fx,` ${parsedVerb}.phrase${nounIndex}.noun.must_be.not_self`);if(qualified_id){let results=doVerbAction(qualified_asset=this.game.getAsset(qualified_id),verb);if(void 0!==results)return results;qualified_name=getQualifiedName(qualified_asset)}msg+="{We} can't do that to {ourself}. ";this.game.print(msg,"");return false}}if(1<parsedNoun.matches.qualified.length){var exactMatches=[],object;for(let i=0;i<parsedNoun.matches.qualified.length;i++){if((object=this.game.getAsset(parsedNoun.matches.qualified[i])).id===parsedNoun.serialized_input)exactMatches.push(object.id);else for(var s=0;s<object.synonyms.length;s++)if(object.synonyms[s]===parsedNoun.serialized_input)exactMatches.push(object.id)}if(0<exactMatches.length);}var ajsclass=A.propercase(parsedNoun.serialized_input.toLowerCase());if(1<parsedNoun.matches.qualified.length&&adventurejs[ajsclass]){var classMatches=[],object;for(let i=0;i<parsedNoun.matches.qualified.length;i++){if((object=this.game.getAsset(parsedNoun.matches.qualified[i]))instanceof adventurejs[ajsclass])classMatches.push(object.id)}if(0<classMatches.length)parsedNoun.matches.qualified=classMatches.splice(0)}parsedNoun.matches.qualifiedIndex=0;if(1===parsedNoun.matches.qualified.length){this.game.log("L1195","log","high",`[${fx}] found singular qualified `+parsedNoun.matches.qualified,"Parser");parsedNoun.qualified_object_id=parsedNoun.matches.qualified[0]}this.game.log("L1196","log","high",`[${fx}] qualifyParsedNoun() return: `+parsedNoun.matches.qualified,"Parser");return parsedNoun}})();(()=>{var p;adventurejs.Parser.prototype.qualifyParsedVerb=function Parser_qualifyParsedVerb(params){if(!params.parsed_verb_name)return false;this.game.log("L1252","log","high","[qualifyParsedVerb.js] qualifyParsedVerb() receive: "+params.parsed_verb_name,"Parser");var params=this.dictionary.verbs[params.parsed_verb_name];if(!params)return false;var input=this.game.getInput(),player=this.game.getPlayer(),input=input.getSubject(),player=input.id===player.id,room=this.game.getRoom(),nest_asset=input.getNestOrPlaceAsset(),nest_aspect=input.getNestOrPlaceAspect(),nest_prep=input.getNestOrPlacePreposition(),output_class="",player_cant=!input.can[params.name],nest_cant=!nest_aspect||!nest_aspect.nest||!nest_aspect.nest.can[params.name],player_cant_msg=` and ${input.id}.can.${params.name} is false`,nest_cant_msg=nest_aspect?` and ${nest_aspect.context_id}.aspects.${nest_aspect.preposition}.can.${params.name} is false`:"",msg="",qualifiers=params.subject_must_be;if(qualifiers.player)if(!player){this.game.debug("D1378","qualifyParsedVerb.js ",` ${params.name}.subject_must_be.player `);var player=this.game.dictionary.pronouns[this.game.getPlayer().pronouns]["our"];msg+=input.ignore_msg||`{We} ignores ${player} command. `;this.game.print(msg,"");return false}if(qualifiers.not_on_floor)if(input.isOnFloor()){this.game.debug("D1878","qualifyParsedVerb.js ",` ${params.name}.subject_must_be.not_on_floor `);msg+=`{We} can't do that from {our} position 
          ${input.getPostureGerund()} on the 
          ${input.isNested()?input.getNestAsset().name:"floor"}. `;this.game.print(msg,"");return false}if(qualifiers.not_constrained)if(input.is.constrained){this.game.debug("D1879","qualifyParsedVerb.js ",` ${params.name}.subject_must_be.not_constrained `);msg+=A.getSAF.call(this.game,input.constrained_msg)||"{We're} constrained. ";this.game.print(msg,"");return false}if(qualifiers.not_under);if(qualifiers.not_behind);if(qualifiers.not_nested_elsewhere);if(qualifiers["able_to_"+params.name])if(!input.can[params.name]||!nest_aspect.nest.can[params.name]){this.game.debug("D1410","qualifyParsedVerb.js ",` ${params.name}.subject_must_be.able_to_`+params.name+(player_cant?player_cant_msg:"")+(nest_cant?nest_cant_msg:""));msg+=`{We} can't ${params.name} `;if(nest_cant)msg+=`while {we're} ${nest_prep} ${nest_asset.articlename}. `;else msg+="right now. ";this.game.print(msg,"");return false}this.game.log("L1139","log","high","[qualifyParsedVerb.js] qualifyParsedVerb() return: "+params.name,"Parser");return params}})();(()=>{var p;adventurejs.Parser.prototype.sanitizeInput=function Parser_sanitizeInput(parsed_input,unparsed_input){this.game.log("L1560","log","high","[sanitizeInput.js] sanitizeInput() receive: "+parsed_input,"Parser");let quoted=false,cased_input="";for(let i=0;i<parsed_input.length;i++){var char=parsed_input[i];if('"'===char)quoted=!quoted;if(quoted)cased_input+=char;else cased_input+=char.toLowerCase()}if("."===(parsed_input=cased_input)[parsed_input.length-1])parsed_input=parsed_input.slice(0,-1);parsed_input=(parsed_input=(parsed_input=(parsed_input=parsed_input.replace(/\t/g," ")).trim()).replace(/\s+/g," ")).replace(/ and then /g," then ");var periodArray=this.splitByPeriods(parsed_input),thenArray=this.splitByThens(parsed_input),pushArray=[];if(1<periodArray.length)pushArray=periodArray;else if(1<thenArray.length)pushArray=thenArray;if(0===pushArray.length){if(this.game.dictionary.testVerbSynonyms(parsed_input,"again"))parsed_input=unparsed_input=this.game.parser.input_history[0].input}else if(0<pushArray.length){if(this.game.dictionary.testVerbSynonyms(pushArray[0],"again"))pushArray[0]=this.game.parser.input_history[0].input;for(var i=1;i<pushArray.length;i++)if(this.game.dictionary.testVerbSynonyms(pushArray[i],"again"))pushArray[i]=pushArray[i-1];parsed_input=unparsed_input=pushArray.shift();for(var i=0;i<pushArray.length;i++)this.input_queue.push({input:pushArray[i],printInput:true})}this.game.log("L1092","log","high","[sanitizeInput.js] sanitizeInput() return: "+parsed_input,"Parser");return[parsed_input,unparsed_input]}})();(()=>{var p;adventurejs.Parser.prototype.saveVerbPhrase=function Parser_saveVerbPhrase(){let this_turn=this.input_history[0],vphrase="",vpreps="";if(this_turn.verified_sentence.verb1)vphrase+=this_turn.verified_sentence.verb1.verb;for(let i=1;i<4;i++)if(this_turn.verified_sentence["phrase"+i]?.preposition){vphrase+=(vphrase?" ":"")+this_turn.verified_sentence["phrase"+i].preposition;vpreps+=(vpreps?" ":"")+this_turn.verified_sentence["phrase"+i].preposition}this_turn.verb_phrase_prepositions=vpreps;this.game.log("L1389","log","high","[saveVerbPhrase.js] saveVerbPhrase() "+(vphrase?"vphrase:"+vphrase:"")+(vpreps?", preposition:"+vpreps:""),"Parser");return true}})();(()=>{var p;adventurejs.Parser.prototype.selectAll=function Parser_selectAll(word){if("string"!=typeof word){this.game.log("L1143","error","critical",["[selectAll.js] selectAll() received non-string,",word],"Parser");return[]}this.game.log("L1145","log","high","[selectAll.js] selectAll() receive: "+word,"Parser");for(var room=this.game.getRoom(),roomObjects=this.game.getRoom().getListableContents(),playerObjects=this.game.getPlayer().getListableContents(),foundObjects=[],exactMatch=false,keys=Object.keys(this.game.world_lookup);0<keys.length;){if(word===keys[0])for(var i=0;i<this.game.world_lookup[keys[0]].IDs.length;i++){var objectID=this.game.world_lookup[keys[0]].IDs[i],object=this.game.getAsset(objectID);if(object instanceof adventurejs.Zone);else{if(object.is.global);if(object instanceof adventurejs.Exit&&object.is.global&&void 0!==room.exits[object.direction]);else{if(object instanceof adventurejs.Exit&&false===object.is.global&&object.getPlaceAssetId()!==room.id);if(objectID===this.game._player);var context=`parser.selectAll > found world_lookup[ ${keys[0]} ].IDs[${objectID}]`;if(!this.game.getInput().replacements[objectID])this.game.getInput().replacements[objectID]={source:keys[0],context:context};foundObjects.push(objectID)}}}keys.shift()}for(var i=0;i<foundObjects.length;i++)if((object=this.game.getAsset(foundObjects[i])).id===word&&object instanceof adventurejs.Substance){foundObjects=[word];break}this.game.log("L1276","log","high",`[selectAll.js] selectAll() return:
`+JSON.stringify(foundObjects),"Parser");return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectCarried=function Parser_selectCarried(list){if("object"!=typeof list){this.game.log("L1561","error","critical",["[selectCarried.js] selectCarried() received non-array,",list],"Parser");return[]}for(var foundObjects=[],i=0,object;i<list.length;i++){console.log("selectCarried list[i]",list[i]);if(this.game.getAsset(list[i]).isWithin(this.game.getPlayer()))foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectCharacter=function Parser_selectCharacter(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1562","error","critical",["[selectCharacter.js] selectCharacter() received non-array,",list],"Parser");return[]}this.game.log("L1149","log","high",`[selectCharacter.js] selectCharacter() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i])instanceof adventurejs.Character)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectDOV=function Parser_selectDOV(list,verb){if("object"!=typeof list){this.game.log("L1563","error","critical",["[selectDOV.js] selectDOV() received non-array,",list],"Parser");return[]}this.game.log("L1134","log","high",`[selectDOV.js] selectDOV() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){console.log("selectDOV list[i]",list[i]);if(this.game.getAsset(list[i]).isDOV(verb))foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectExtant=function Parser_selectExtant(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1258","error","critical",["[selectExtant.js] selectExtant() received non-array,",list],"Parser");return[]}this.game.log("L1189","log","high",`[selectExtant.js] selectExtant() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object,object;i<list.length;i++){if(!this.game.getAsset(list[i]).is.extant);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectGlobalSubstance=function Parser_selectGlobalSubstance(list){if("object"!=typeof list){this.game.log("L1564","error","critical",["[selectGlobalSubstance.js] selectGlobalSubstance() received non-array,",list],"Parser");return[]}this.game.log("L1138","log","high",`[selectGlobalSubstance.js] selectGlobalSubstance() receive:
`+list,"Parser");for(var foundObjects=[],i=0;i<list.length;i++){var object=list[i],asset_aspect_substance;if(1<object.split(":").length);else if((object=this.game.getAsset(list[i]))instanceof adventurejs.Substance)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectHeld=function Parser_selectHeld(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1236","error","critical",["[selectHeld.js] selectHeld() received non-array,",list],"Parser");return[]}this.game.log("L1167","log","high",`[selectHeld.js] selectHeld() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(subject.isConnectedToAsset("hold",object,"to_dov"))foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectInHands=function Parser_selectInHands(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1234","error","critical",["[selectInHands.js] selectInHands() received non-array",list],"Parser");return[]}this.game.log("L1161","log","high",`[selectInHands.js] selectInHands() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object instanceof adventurejs.Substance);else if(!object.getPlaceAsset);else{var parent=object.getPlaceAsset();if(!parent);else if(parent.id!==subject.id&&!subject.isConnectedToAsset("hold",object,"to_dov"));else if(parent.id===subject.id&&object.is.worn);else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectInHandsUnlessReservoir=function Parser_selectInHandsUnlessReservoir(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1241","error","critical",["[selectInHandsUnlessReservoir.js] selectInHandsUnlessReservoir() received non-array",list],"Parser");return[]}this.game.log("L1163","log","high",`[selectInHandsUnlessReservoir.js] selectInHandsUnlessReservoir() receive:
`+list,"Parser");for(var foundObjects=[],input,subject=this.game.getInput().getSubject(),i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object.$is("reservoir"))foundObjects.push(list[i]);else if(!object.getPlaceAsset);else{var parent=object.getPlaceAsset();if(!parent);else if(parent.id!==subject.id&&!subject.isConnectedToAsset("hold",object,"to_dov"));else if(parent.id===subject.id&&object.is.worn);else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectInInventory=function Parser_selectInInventory(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1275","error","critical",["[selectInInventory.js] selectInInventory() received non-array",list],"Parser");return[]}this.game.log("L1159","log","high",`[selectInInventory.js] selectInInventory() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object.areAnscestorsUnknown&&object.areAnscestorsUnknown());else if(!object.isWithin(subject)&&!subject.isConnectedToAsset("hold",object,"to_dov"));else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectInInventoryIfTakeable=function Parser_selectInInventoryIfTakeable(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1227","error","critical",["[selectInInventoryIfTakeable.js] selectInInventoryIfTakeable() received non-array",list],"Parser");return[]}this.game.log("L1157","log","high",`[selectInInventoryIfTakeable.js] selectInInventoryIfTakeable() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object.isDOV("take"))foundObjects.push(list[i]);else if(void 0!==object.areAnscestorsUnknown&&object.areAnscestorsUnknown());else if(!object.isWithin(subject)&&!subject.isConnectedToAsset("hold",object,"to_dov"));else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectIntangible=function Parser_selectIntangible(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1224","error","critical",["[selectIntangible.js] selectIntangible() received non-array",list],"Parser");return[]}this.game.log("L1126","log","high",`[selectIntangible.js] selectIntangible() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i])instanceof adventurejs.Intangible)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectIOV=function Parser_selectIOV(list,verb){if("object"!=typeof list){this.game.log("L1565","error","critical",["[selectIOV.js] selectIOV() received non-array",list],"Parser");return[]}this.game.log("L1136","log","high",`[selectIOV.js] selectIOV() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){console.log("selectIOV list[i]",list[i]);if(this.game.getAsset(list[i]).isIOV(verb))foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectKnown=function Parser_selectKnown(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1282","error","critical","[selectKnown.js] selectKnown() received non-array","Parser");return[]}this.game.log("L1112","log","high",`[selectKnown.js] selectKnown() receive:
`+list,"Parser");for(var foundObjects=[],character=this.game.getSubject(),i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if("string"==typeof list[i]){var sub=list[i].split(":"),known;if(3===sub.length){if(!this.game.getAsset(sub[0])?.aspects[sub[1]]?.vessel?.is.known)continue}}if(!character.knowsAbout(object));else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectMatter=function Parser_selectMatter(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1225","error","critical","[selectMatter.js] selectMatter() received non-array","Parser");return[]}this.game.log("L1130","log","high",`[selectMatter.js] selectMatter() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i])instanceof adventurejs.Matter)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotExit=function Parser_selectNotExit(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1263","error","critical",["[selectNotExit.js] selectNotExit() received non-array",list],"Parser");return[]}this.game.log("L1124","log","high",`[selectNotExit.js] selectNotExit() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(false==this.game.getAsset(list[i])instanceof adventurejs.Exit)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotGlobal=function Parser_selectNotGlobal(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1097","error","critical",["[selectNotGlobal.js] selectNotGlobal() received non-array"],"Parser");return[]}this.game.log("L1120","log","high",`[selectNotGlobal.js] selectNotGlobal() receive:
`+list,"Parser");for(var foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object.is.global||"global_floor"===object.id)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotInHands=function Parser_selectNotInHands(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1210","error","critical",["[selectNotInHands.js] selectNotInHands() received non-array",list],"Parser");return[]}this.game.log("L1165","log","high",`[selectNotInHands.js] selectNotInHands() receive:
`+list,"Parser");for(var foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object instanceof adventurejs.Substance)foundObjects.push(list[i]);else if(object instanceof adventurejs.Room)foundObjects.push(list[i]);else if(!object.getPlaceAsset);else{var parent=object.getPlaceAsset();if(!parent);else if(parent.id===this.game.world._player&&!object.is.worn);else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotInInventory=function Parser_selectNotInInventory(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1283","error","critical",["[selectNotInInventory.js] selectNotInInventory() received non-array",list],"Parser");return[]}this.game.log("L1169","log","high",`[selectNotInInventory.js] selectNotInInventory() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i]).isWithin(this.game.getPlayer()));else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotNestedInventoryIfAll=function Parser_selectNotNestedInventoryIfAll(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1242","error","critical",["[selectNotNestedInventoryIfAll.js] selectNotNestedInventoryIfAll() received non-array",list],"Parser");return[]}this.game.log("L1177","log","high",`[selectNotNestedInventoryIfAll.js] selectNotNestedInventoryIfAll() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object.getPlaceAsset);else{var parent=object.getPlaceAsset();if(!parent);else if(object.isWithin(subject)&&parent.id!==subject.id);else if(subject.isConnectedToAsset("hold",object,"to_dov"));else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotParent=function Parser_selectNotParent(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1281","error","critical",["[selectNotParent.js] selectNotParent() received non-array",list],"Parser");return[]}this.game.log("L1153","log","high",`[selectNotParent.js] selectNotParent() receive:
`+list,"Parser");for(var foundObjects=[],input=this.game.getInput(),player=this.game.getPlayer(),subject=input.getSubject(),room=this.game.getRoom(),i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(subject.isNested()&&object.id===subject.getNestId());else if(false===subject.isNested()&&object.id===room.id);else if(subject.isNested()&&object.id===room.id&&subject.getNestAsset()instanceof adventurejs.Floor);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotParentOrRoom=function Parser_selectNotParentOrRoom(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1281","error","critical",["[selectNotParentOrRoom.js] selectNotParentOrRoom() received non-array",list],"Parser");return[]}this.game.log("L1520","log","high",`[selectNotParentOrRoom.js] selectNotParentOrRoom() receive:
`+list,"Parser");for(var foundObjects=[],input=this.game.getInput(),player=this.game.getPlayer(),subject=input.getSubject(),room=this.game.getRoom(),nested=subject.isNested(),i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object.id===room.id);else if(nested&&object.id===subject.getNestId());else if(nested&&object.id===room.id&&subject.getNestAsset()instanceof adventurejs.Floor);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotPlayer=function Parser_selectNotPlayer(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1262","error","critical",["[selectNotPlayer.js] selectNotPlayer() received non-array",list],"Parser");return[]}this.game.log("L1193","log","high",`[selectNotPlayer.js] selectNotPlayer() receive:
`+list,"Parser");for(var input=this.game.getInput(),player=this.game.getPlayer(),subject=input.getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object);else if(object.id===player.id);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotScenery=function Parser_selectNotScenery(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1089","error","critical",["[selectNotScenery.js] selectNotScenery() received non-array",list],"Parser");return[]}this.game.log("L1122","log","high",`[selectNotScenery.js] selectNotScenery() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(false==this.game.getAsset(list[i])instanceof adventurejs.Scenery)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotSelf=function Parser_selectNotSelf(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1262","error","critical",["[selectNotSelf.js] selectNotSelf() received non-array",list],"Parser");return[]}this.game.log("L1335","log","high",`[selectNotSelf.js] selectNotSelf() receive:
`+list,"Parser");for(var input=this.game.getInput(),player=this.game.getPlayer(),subject=input.getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object);else if(object.id===subject.id);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotSubstance=function Parser_selectNotSubstance(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1197","error","critical",["[selectNotSubstance.js] selectNotSubstance() received non-array",list],"Parser");return[]}this.game.log("L1128","log","high",`[selectNotSubstance.js] selectNotSubstance() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(!(this.game.getAsset(list[i],{prefer_substance:true})instanceof adventurejs.Substance))foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotWorn=function Parser_selectNotWorn(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1264","error","critical",["[selectNotWorn.js] selectNotWorn() received non-array",list],"Parser");return[]}this.game.log("L1173","log","high",`[selectNotWorn.js] selectNotWorn() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i]).is.worn);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectNotWornIfAll=function Parser_selectNotWornIfAll(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1277","error","critical",["[selectNotWornIfAll.js] selectNotWornIfAll() received non-array",list],"Parser");return[]}this.game.log("L1175","log","high",`[selectNotWornIfAll.js] selectNotWornIfAll() receive:
`+list,"Parser");for(var foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object.getPlaceAsset);else{var parent=object.getPlaceAsset();if(!parent);else if(parent.id!==this.game.world._player);else if(parent.id===this.game.world._player&&object.is.worn);else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectParent=function Parser_selectParent(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1239","error","critical",["[selectParent.js] selectParent() received non-array",list],"Parser");return[]}this.game.log("L1151","log","high",`[selectParent.js] selectParent() receive:
`+list,"Parser");for(var foundObjects=[],input=this.game.getInput(),player=this.game.getPlayer(),subject=input.getSubject(),room=this.game.getRoom(),i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(subject.isNested()&&object.id===subject.getNestId())foundObjects.push(list[i]);else if(false===subject.isNested()&&object.id===room.id)foundObjects.push(list[i]);else if(subject.isNested()&&object.id===room.id&&subject.getNestAsset()instanceof adventurejs.Floor)foundObjects.push(room.id);if(0<foundObjects.length)break}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectParentOrRoom=function Parser_selectParentOrRoom(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1517","error","critical",["[selectParentOrRoom.js] selectParentOrRoom() received non-array",list],"Parser");return[]}this.game.log("L1518","log","high",`[selectParentOrRoom.js] selectParentOrRoom() receive:
`+list,"Parser");for(var foundObjects=[],input=this.game.getInput(),player=this.game.getPlayer(),subject=input.getSubject(),room=this.game.getRoom(),nested=subject.isNested(),i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object.id===room.id)foundObjects.push(list[i]);else if(nested&&object.id===subject.getNestId())foundObjects.push(list[i]);if(0<foundObjects.length)break}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectPlayer=function Parser_selectPlayer(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1235","error","critical",["[selectPlayer.js] selectPlayer() received non-array",list],"Parser");return[]}this.game.log("L1191","log","high",`[selectPlayer.js] selectPlayer() receive:
`+list,"Parser");for(var input=this.game.getInput(),player=this.game.getPlayer(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object);else if(!object.id===player.id);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectPresent=function Parser_selectPresent(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1240","error","critical",["[selectPresent.js] selectPresent() received non-array",list],"Parser");return[]}this.game.log("L1114","log","high",`[selectPresent.js] selectPresent() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),room=this.game.getRoom(),foundObjects=[],roomObjects=[],i=0;i<list.length;i++){var object,object=this.game.getAsset(list[i]);if(!object);else if(object.is.abstract)foundObjects.push(list[i]);else{if(object instanceof adventurejs.Substance){if(!roomObjects.length)roomObjects=[room.id].concat(room.getAllNestedContents());for(var j=0;j<roomObjects.length;j++){var roomObject=this.game.getAsset(roomObjects[j]);if(!subject.knowsAbout(roomObject));else{var preposition=roomObject.containsSubstance(object.id);if(preposition)if(!subject.knowsAbout(roomObject.id+`|${preposition}|vessel`));else foundObjects.push(roomObject.id+":"+preposition+":"+object.id)}}}if(object.is.global)if(object instanceof adventurejs.GlobalString||object instanceof adventurejs.GlobalNumber)foundObjects.push(list[i]);else{if(object instanceof adventurejs.Floor)if(this.game.getRoom().findNestedAssetsWithClass("Floor").length)continue;var scenery=room.area_scenery[object.id]||room.area_scenery[object.name];if(true===scenery?.enabled)foundObjects.push(list[i]);else if(false===scenery?.enabled);else if((scenery=this.game.world[room.zone]?.area_scenery[object.id]||this.game.world[room.zone]?.area_scenery[object.name]||void 0)?.enabled)foundObjects.push(list[i]);else if(false===scenery?.enabled)console.warn("selectPresent > false === room.zone.area_scenery[ object.id ].enabled");else if(object.enabled)foundObjects.push(list[i])}else if(object instanceof adventurejs.Exit&&object.is.global&&void 0!==room.exits[object.direction]);else if(object instanceof adventurejs.Exit&&object.is.global&&void 0===room.exits[object.direction])foundObjects.push(list[i]);else if(object instanceof adventurejs.Exit&&!object.is.global&&object.getPlaceAssetId()!==this.game.world._room);else if(object.id===this.game.world._room)foundObjects.push(list[i]);else if(object.isWithin&&object.isWithin(this.game.getRoom()))foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectPresentIfTangible=function Parser_selectPresentIfTangible(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1253","error","critical",["[selectPresentIfTangible.js] selectPresentIfTangible() received non-array",list],"Parser");return[]}this.game.log("L1116","log","high",`[selectPresentIfTangible.js] selectPresentIfTangible() receive:
`+list,"Parser");for(var room=this.game.getRoom(),foundObjects=[],roomObjects=[],i=0;i<list.length;i++){var object,object=this.game.getAsset(list[i]);if(object instanceof adventurejs.Substance)foundObjects.push(list[i]);else if(object.is.abstract)foundObjects.push(list[i]);else if(object.is.global)if(object instanceof adventurejs.GlobalString||object instanceof adventurejs.GlobalNumber)foundObjects.push(list[i]);else{if(object instanceof adventurejs.Floor)if(this.game.getRoom().findNestedAssetsWithClass("Floor").length)continue;var scenery=room.area_scenery[object.id]||room.area_scenery[object.name];if(true===scenery?.enabled)foundObjects.push(list[i]);else if(false===scenery?.enabled);else if((scenery=this.game.world[room.zone]?.area_scenery[object.id]||this.game.world[room.zone]?.area_scenery[object.name]||void 0)?.enabled)foundObjects.push(list[i]);else if(false===scenery?.enabled);else if(object.enabled)foundObjects.push(list[i])}else if(object instanceof adventurejs.Exit&&object.is.global&&void 0!==room.exits[object.direction]);else if(object instanceof adventurejs.Exit&&object.is.global&&void 0===room.exits[object.direction])foundObjects.push(list[i]);else if(object instanceof adventurejs.Exit&&!object.is.global&&object.getPlaceAssetId()!==this.game.world._room);else if(object.id===this.game.world._room)foundObjects.push(list[i]);else if(object.isWithin&&object.isWithin(this.game.getRoom()))foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectReachable=function Parser_selectReachable(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1096","error","critical",["[selectReachable.js] selectReachable() received non-array",list],"Parser");return[]}this.game.log("L1183","log","high",`[selectReachable.js] selectReachable() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),room=this.game.getRoom(),nest=subject.getNest(),nest_asset=subject.getNestAsset(),nest_ancestor=this.game.getAsset(subject.getNestAnscestorId()),foundObjects=[],roomObjects=[],containers=[],i=0;i<list.length;i++){var object_parent,object_ancestor,object_ancestor,object=this.game.getAsset(list[i]);if(!object);else if(object.is.abstract)foundObjects.push(list[i]);else if(object instanceof adventurejs.Substance){if(!roomObjects.length)roomObjects=[room.id].concat(room.getAllNestedContents());for(var j=0;j<roomObjects.length;j++){var roomObject=this.game.getAsset(roomObjects[j]);if(!subject.knowsAbout(roomObject));else{var preposition=roomObject.containsSubstance(object.id);if(preposition)if(!subject.knowsAbout(roomObject.id+`|${preposition}|vessel`));else containers.push(roomObject.id+":"+preposition+":"+object.id)}}if(containers.length)if((containers=this.selectReachable(containers)).length)foundObjects=foundObjects.concat(containers)}else{if(object.isConnectedToAsset("plug",object.getPlaceAsset(),"to_dov"))object=object.getPlaceAsset();object_parent=object.getPlaceAsset();object_ancestor=this.game.getAsset(object.getAncestorId());if(object.isWithin(subject))foundObjects.push(list[i]);else if(nest&&object.id===nest_asset.id)foundObjects.push(list[i]);else if(object.direction)foundObjects.push(list[i]);else if(nest&&"down"===object.direction||"up"===object.direction)foundObjects.push(list[i]);else if(nest&&object.id!==nest_asset.id&&object.id!==nest_ancestor.id&&object_parent.id!==nest_asset.id&&object_ancestor.id!==nest_ancestor.id&&!nest.canSubjectReachAssetFromNest(object)&&!nest.canSubjectReachAssetFromNest(object_ancestor));else if(!nest&&subject.isOnFloor()&&!(object instanceof adventurejs.Floor)&&object.getPlaceAssetId()!==subject.getPlaceAssetId());else{var object_parent=object.getYRange();if(subject.position.y<object_parent.min||subject.position.y>object_parent.max);else foundObjects.push(list[i])}}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectReachableIfTangible=function Parser_selectReachableIfTangible(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1259","error","critical",["[selectReachableIfTangible.js] selectReachableIfTangible() received non-array",list],"Parser");return[]}this.game.log("L1185","log","high",`[selectReachableIfTangible.js] selectReachableIfTangible() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),nest=subject.getNest(),nest_asset=subject.getNestAsset(),nest_ancestor=this.game.getAsset(subject.getNestAnscestorId()),foundObjects=[],i=0;i<list.length;i++){var object,object_parent,object_ancestor,object_ancestor,object=this.game.getAsset(list[i]);if(!object);else if(object instanceof adventurejs.Substance)foundObjects.push(list[i]);else if(object.is.abstract)foundObjects.push(list[i]);else{if(object.isConnectedToAsset("plug",object.getPlaceAsset(),"to_dov"))object=object.getPlaceAsset();object_parent=object.getPlaceAsset();object_ancestor=this.game.getAsset(object.getAncestorId());if(object.isWithin(subject))foundObjects.push(list[i]);else if(nest&&object.id===nest_asset.id)foundObjects.push(list[i]);else if(object.direction)foundObjects.push(list[i]);else if(nest&&"down"===object.direction||"up"===object.direction)foundObjects.push(list[i]);else if(nest&&object.id!==nest_asset.id&&object.id!==nest_ancestor.id&&object_parent.id!==nest_asset.id&&object_ancestor.id!==nest_ancestor.id&&!nest.canSubjectReachAssetFromNest(object)&&!nest.canSubjectReachAssetFromNest(object_ancestor));else if(!nest&&subject.isOnFloor()&&!(object instanceof adventurejs.Floor)&&object.getPlaceAssetId()!==subject.getPlaceAssetId());else{var object_parent=object.getYRange();if(subject.position.y<object_parent.min||subject.position.y>object_parent.max);else foundObjects.push(list[i])}}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectReservoir=function Parser_selectReservoir(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1229","error","critical",["[selectReservoir.js] selectReservoir() received non-array",list],"Parser");return[]}this.game.log("L1228","log","high",`[selectReservoir.js] selectReservoir() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i]).$is("reservoir"))foundObjects.push(list[i])}this.game.log("L1230","log","high","[selectReservoir.js] selectReservoir() return: "+String(foundObjects),"Parser");return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectReservoirIfSubstance=function Parser_selectReservoirIfSubstance(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1249","error","critical",["[selectReservoirIfSubstance.js] selectReservoirIfSubstance() received non-array",list],"Parser");return[]}this.game.log("L1248","log","high","[selectReservoirIfSubstance.js] selectReservoirIfSubstance() receive: "+list,"Parser");for(var foundObjects=[],i=0,split,object,object;i<list.length;i++){if(1===list[i].split(":").length)foundObjects.push(list[i]);else{if(this.game.getAsset(list[i]).$is("reservoir"))foundObjects.push(list[i])}}this.game.log("L1250","log","high","[selectReservoirIfSubstance.js] returns {String(foundObjects)}","Parser");return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectReservoirOrCarriedIfSubstance=function Parser_selectReservoirOrCarriedIfSubstance(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1232","warn","critical",["[selectReservoirOrCarriedIfSubstance.js] selectReservoirOrCarriedIfSubstance() received non-array",list],"Parser");return[]}this.game.log("L1231","log","high","[selectReservoirOrCarriedIfSubstance.js] selectReservoirOrCarriedIfSubstance() received "+list,"Parser");for(var foundObjects=[],i=0,split;i<list.length;i++){if(1===list[i].split(":").length)foundObjects.push(list[i]);else{var object,object=this.game.getAsset(list[i]);if(object.$is("reservoir")||object.isWithin(this.game.getPlayer()))foundObjects.push(list[i])}}this.game.log("L1233","log","high","[selectReservoirOrCarriedIfSubstance.js] returns "+String(foundObjects),"Parser");return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectSelf=function Parser_selectSelf(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1397","error","critical",["[selectSelf.js] selectSelf() received non-array",list],"Parser");return[]}this.game.log("L1333","log","high",`[selectSelf.js] selectSelf() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object);else if(!object.id===subject.id);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectSingular=function Parser_selectSingular(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1246","error","critical",["[selectSingular.js] selectSingular() received non-array",list],"Parser");return[]}this.game.log("L1155","log","high",`[selectSingular.js] selectSingular() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i]).is.collection);else foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectSubstance=function Parser_selectSubstance(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1254","error","critical",["[selectSubstance.js] selectSubstance() received non-array",list],"Parser");return[]}this.game.log("L1141","log","high",`[selectSubstance.js] selectSubstance() receive:
`+list,"Parser");for(var foundObjects=[],i=0,object;i<list.length;i++){if(this.game.getAsset(list[i],{prefer_substance:true})instanceof adventurejs.Substance)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectTakeable=function Parser_selectTakeable(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1255","error","critical",["[selectTakeable.js] selectTakeable() received non-array",list],"Parser");return[]}this.game.log("L1187","log","high",`[selectTakeable.js] selectTakeable() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]),parent;if(!object.isDOV("take")){if(object instanceof adventurejs.Room&&3===list[i].split(":").length)foundObjects.push(list[i])}else{if(object.isConnectedToAsset("plug",object.getPlaceAsset(),"to_dov"))object=object.getPlaceAsset();if(!object.getPlaceAsset);else{if(!object.getPlaceAsset());else if(object.areAnscestorsClosed&&object.areAnscestorsClosed()&&!object.isWithin(subject));else foundObjects.push(list[i])}}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectTangible=function Parser_selectTangible(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1251","error","critical",["[selectTangible.js] selectTangible() received non-array",list],"Parser");return[]}this.game.log("L1132","log","high",`[selectTangible.js] selectTangible() receive:
`+list,"Parser");for(var foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object instanceof adventurejs.Tangible||object instanceof adventurejs.Room||object instanceof adventurejs.Exit||object instanceof adventurejs.Scenery||object.is.global)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectTangibleOrSubstance=function Parser_selectTangibleOrSubstance(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1095","error","critical",["[selectTangibleOrSubstance.js] selectTangibleOrSubstance() received non-array",list],"Parser");return[]}for(var foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(object instanceof adventurejs.Tangible||object instanceof adventurejs.Substance||object instanceof adventurejs.Room||object instanceof adventurejs.Exit||object instanceof adventurejs.Scenery||object.is.global)foundObjects.push(list[i])}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectVisible=function Parser_selectVisible(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1090","error","critical",["[selectVisible.js] selectVisible() received non-array",list],"Parser");return[]}this.game.log("L1179","log","high",`[selectVisible.js] selectVisible() receive:
`+list,"Parser");for(var input,subject=this.game.getInput().getSubject(),room=this.game.getRoom(),foundObjects=[],roomObjects=[],containers=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object);else if(object.is.abstract)foundObjects.push(list[i]);else if(object.is.global)foundObjects.push(list[i]);else{if(object.isConnectedToAsset("plug",object.getPlaceAsset(),"to_dov"))object=object.getPlaceAsset();if(object instanceof adventurejs.Substance){if(!roomObjects.length)roomObjects=[room.id].concat(room.getAllNestedContents());for(var j=0;j<roomObjects.length;j++){var roomObject=this.game.getAsset(roomObjects[j]);if(!subject.knowsAbout(roomObject));else{var preposition=roomObject.containsSubstance(object.id);if(preposition)if(!subject.knowsAbout(roomObject.id+`|${preposition}|vessel`));else containers.push(roomObject.id+":"+preposition+":"+object.id)}}if(containers.length)if((containers=this.selectVisible(containers)).length)foundObjects=foundObjects.concat(containers)}else if(object.is.hidden);else if(!(object.hasClass("Substance")||object.getPlaceAsset()||object instanceof adventurejs.Room));else if(!object.isWithin(subject)&&object.areAnscestorsClosed&&object.areAnscestorsClosed());else if(object.areAnscestorsUnknown&&object.areAnscestorsUnknown());else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectVisibleIfTangible=function Parser_selectVisibleIfTangible(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1094","error","critical",["[selectVisibleIfTangible.js] selectVisibleIfTangible() received non-array",list],"Parser");return[]}this.game.log("L1181","log","high",`[selectVisibleIfTangible.js] selectVisibleIfTangible() receive:
`+list,"Parser");for(var input,character=this.game.getInput().getSubject(),room=this.game.getRoom(),foundObjects=[],roomObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object);else if(object instanceof adventurejs.Substance)foundObjects.push(list[i]);else if(object.is.abstract)foundObjects.push(list[i]);else if(object.is.global)foundObjects.push(list[i]);else{if(object.isConnectedToAsset("plug",object.getPlaceAsset(),"to_dov"))object=object.getPlaceAsset();if(object.is.hidden);else if(!(object.hasClass("Substance")||object.getPlaceAsset()||object instanceof adventurejs.Room));else if(object.areAnscestorsClosed&&object.areAnscestorsClosed()&&!object.isWithin(character));else if(object.areAnscestorsUnknown&&object.areAnscestorsUnknown());else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.selectWorn=function Parser_selectWorn(list){if("string"==typeof list)list=[list];if(!Array.isArray(list)){this.game.log("L1260","error","critical",["[selectWorn.js] selectWorn() received non-array",list],"Parser");return[]}this.game.log("L1171","log","high",`[selectWorn.js] selectWorn() receive:
`+list,"Parser");for(var foundObjects=[],i=0;i<list.length;i++){var object=this.game.getAsset(list[i]);if(!object.place);else{var parent=object.getParentAsset();if(!parent);else if(parent.id!==this.game.getPlayer().id);else if(!object.is.worn);else foundObjects.push(list[i])}}return foundObjects}})();(()=>{var p;adventurejs.Parser.prototype.splitByPeriods=function Parser_splitByPeriods(input){this.game.log("L1566","log","high","[splitByPeriods.js] splitByPeriods() receive: "+input,"Parser");for(var inputArray=input.split("."),i=inputArray.length-1;-1<i;i--){inputArray[i]=inputArray[i].trim();if(" "===inputArray[i]||""===inputArray[i])inputArray.splice(i,1)}inputArray.forEach(function(clause,index){var clause=this.splitByThens(clause);if(1<clause.length){var arrayFront=inputArray.slice(0,index),index=inputArray.slice(index+1,inputArray.length+1);inputArray=arrayFront.concat(clause.concat(index))}},this);this.game.log("L1567","log","high","[splitByPeriods.js] splitByPeriods() return: "+String(inputArray),"Parser");return inputArray}})();(()=>{var p;adventurejs.Parser.prototype.splitByThens=function Parser_splitByThens(input){this.game.log("L1568","log","high","[splitByThens.js] splitByThens() receive: "+input,"Parser");for(var split_input=input.split(" then "),i=0;i<split_input.length;i++){split_input[i]=split_input[i].trim();if(","===split_input[i].charAt(split_input[i].length-1))split_input[i]=split_input[i].slice(0,-1)}if(1<split_input.length&&1===split_input[0].split(" ").length){var input=this.parseVerb(split_input[0]);if(input){var dictionary_verb=this.game.getVerb(input);if(dictionary_verb&&!dictionary_verb.accepts_structures.verb){var dictionary_verb=this.parseVerb(split_input[1].split(" ")[0]),next_dictionary_verb;if(this.game.getVerb(dictionary_verb))split_input[0]=split_input[1].replace(dictionary_verb,input)}}}this.game.log("L1569","log","high","[splitByThens.js] splitByThens() return: "+String(split_input),"Parser");return split_input}})();(()=>{var p;adventurejs.Parser.prototype.stripArticles=function Parser_stripArticles(parsed_input){this.game.log("L1570","log","high","[stripArticles.js] stripArticles() receive: "+parsed_input,"Parser");parsed_input=(parsed_input=(parsed_input=(parsed_input=(parsed_input=(parsed_input=parsed_input.replace(/ the /g," ")).replace(/^the /g,"")).replace(/ a /g," ")).replace(/^a /g,"")).replace(/ an /g," ")).replace(/^an /g,"");this.game.log("L1237","log","high",`[stripArticles.js] stripArticles() return:
`+parsed_input,"Parser");return parsed_input}})();(()=>{var p;adventurejs.Parser.prototype.stripConjunctions=function Parser_stripConjunctions(input){this.game.log("L1571","log","high","[stripConjunctions.js] stripConjunctions() receive: "+input,"Parser");input=(input=(input=(input=(input=input.replace(/, and /g,"&")).replace(/ and /g,"&")).replace(/, /g,"&")).replace(/ but /g," -")).replace(/ except /g," -");this.game.log("L1513","log","high",`[stripConjunctions.js] stripConjunctions() return:
`+input,"Parser");return input}})();(()=>{var p;adventurejs.Parser.prototype.verifyAdverbs=function Parser_verifyAdverbs(){var this_turn=this.input_history[0],verb_name=(this.game.log("L1238","log","high","[verifyAdverbs.js] verifyAdverbs() "+this_turn.verified_sentence_structure,"Parser"),this_turn.getVerb(1)),verb=this.game.dictionary.verbs[verb_name],this_turn=this_turn.getAdverb(1);if(verb&&this_turn&&-1===verb.accepts_adverbs.indexOf(this_turn)&&-1===verb.accepts_adverbs.indexOf("*")){this.game.debug("D1592","verifySentenceStructure.js ",` ${verb_name} doesn't accept adverb > ${this_turn} `);var verb_name=`{We} {don't} know how to ${verb.name} ${this_turn}. `;this.game.print(verb_name);return false}return true}})();(()=>{var p;adventurejs.Parser.prototype.verifyCharacterCanDoVerb=function Parser_verifyCharacterCanDoVerb(optional_verb){var this_turn=this.input_history[0],character=(this.game.log("L1332","log","high","[verifyCharacterCanDoVerb.js] verifyCharacterCanDoVerb() "+this_turn.getSubject().id,"Parser"),this_turn.getSubject()),player=this.game.getPlayer(),optional_verb=optional_verb||this.game.parser.parseVerb(this_turn.input_verb),this_turn="";if(character.id===player.id||character.can[optional_verb])return true;this.game.debug("D1180","verifyCharacterCanDoVerb.js ",` ${character.id}.can.${optional_verb} is unset `);var player=this.game.dictionary.pronouns[this.game.getPlayer().pronouns]["our"];this_turn+=character.ignore_msg||`{We} ignores ${player} command. `;this.game.print(this_turn);return false}})();(()=>{var p;adventurejs.Parser.prototype.verifySentence=function Parser_verifySentence(){var this_turn=this.input_history[0],player=this.game.getPlayer(),count=(this.game.log("L1284","log","high","[verifySentence.js] verifySentence() "+this_turn.input,"Parser"),{noun:0,prep:0,verb:0,adverb:0,adjective:0,direction:0,exclusion:0,unknown:0,string:0,number:0,phrase:0}),firstverb;for(let position=0;position<this_turn.parsed_sentence.length;position++){var this_word=this_turn.parsed_sentence[position],last_word=this_turn.parsed_sentence[position-1],word_before_last=this_turn.parsed_sentence[position-2],next_word=this_turn.parsed_sentence[position+1];let msg="";if(0===position&&"noun"===this_word.type&&"verb"===next_word.type){var parsed_noun=this.parseNoun(this_word.word),asset;let char;var chars=[];let msg="",debug="";var replacement=this_turn.replacements[this_word.word];switch(parsed_noun.matches.qualified.length){case 0:break;case 1:if(!(asset=this.game.getAsset(parsed_noun.matches.qualified[0]))){msg+=`{We} {don't} need to use the word ${this_word.word}. `;debug="non-existent"}else if(!player.knowsAbout(asset)){msg+=`{We} {don't} know of any ${replacement?replacement.source:this_word.word}. `;debug="not known"}else if(!asset.is.present){msg=`{We} {don't} see ${asset.articlename} here. `;debug="not present"}else if(!asset.hasClass("Character")){msg+=asset.Articlename+" ignores {us}. ";debug="not character"}else char=asset;break;default:for(let i=0;i<parsed_noun.matches.qualified.length;i++){let asset=this.game.getAsset(parsed_noun.matches.qualified[i]);if(asset.hasClass("Character")&&asset.is.present)chars.push(asset)}switch(chars.length){case 0:break;case 1:char=chars[0];break;default:msg="{We'll} have to be more specific. ";debug="not unique";break}break}if(msg){this.game.debug("D1186","verifySentence.js ",` ${this_word.word} is `+debug);this.game.print(msg);return false}if(char){this_turn.input_verb=next_word.word;this_turn.setCharacter(char);this_turn.parsed_sentence.shift();position=-1;continue}}if("verb"===this_word.type){if(last_word&&"verb"===last_word.type&&"oops"!==last_word.word){this.game.debug("D1198","verifySentence.js "," input found two verbs in a row");msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg);return false}count.verb++;this_turn.verified_sentence_structure+="verb ";if(!this_turn.verified_sentence["verb"+count.verb])this_turn.verified_sentence["verb"+count.verb]={};this_turn.verified_sentence["verb"+count.verb].verb=this_word.word;this_turn.verified_sentence["verb"+count.verb].verb_properties=this_word.properties}else if("adverb"===this_word.type){if(last_word&&"adverb"===last_word.type){this.game.debug("D1650","verifySentence.js "," parser found two or more adverbs");msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg);return false}count.adverb++;if(0===count.verb)this_turn.verified_sentence.verb1={};this_turn.verified_sentence["verb"+(0===count.verb?1:count.verb)].adverb=this_word.word}else if("preposition"===this_word.type){if(last_word&&"preposition"===last_word.type){if(last_word.word===this_word.word){this.game.debug("D1320","verifySentence.js "," parser found two identical prepositions");msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg)}else{var last_word_is_direction=this.game.dictionary.getDirection(last_word.word),last_word_is_adverb;if(last_word_is_direction&&"verb"===word_before_last?.type&&"noun"===next_word?.type){var exit_from_last_word=this.game.getExitFromDirection(last_word.word),nouns_from_next_word=this.parseNoun(next_word.word);let match=false;for(let n=0;n<nouns_from_next_word.matches.qualified.length;n++){var exit_from_next_word=this.game.getAsset(nouns_from_next_word.matches.qualified[n]);console.warn({exit_from_last_word:exit_from_last_word,exit_from_next_word:exit_from_next_word});if(exit_from_next_word?.direction===exit_from_last_word?.direction)match=true}if(match){this_turn.verified_sentence["verb"+count.verb].adverb=last_word.word;this_turn.verified_sentence["phrase"+count.phrase].preposition=this_word.word;this_turn.verified_sentence["phrase"+count.phrase].preposition_properties=this_word.properties;continue}}if(last_word_is_direction&&"verb"===word_before_last?.type&&"noun"===next_word?.type){let nouns_from_next_word=this.parseNoun(next_word.word),found=false;for(let n=0;n<nouns_from_next_word.matches.qualified.length;n++){var asset_from_next_word=this.game.getAsset(nouns_from_next_word.matches.qualified[n]),aspect;if(asset_from_next_word?.$is("present")&&asset_from_next_word.hasAspectAt(this_word.word)){if(asset_from_next_word.getAspectAt(this_word.word).nest.can.enter)found=true}}if(found)continue}if(this.game.dictionary.getAdverb(last_word.word)&&"verb"===word_before_last?.type&&"noun"===next_word?.type){this_turn.verified_sentence["verb"+count.verb].adverb=last_word.word;this_turn.verified_sentence["phrase"+count.phrase].preposition=this_word.word;this_turn.verified_sentence["phrase"+count.phrase].preposition_properties=this_word.properties;continue}this.game.debug("D1030","verifySentence.js "," parser found two or more prepositions");msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg)}return false}count.prep++;count.phrase++;this_turn.verified_sentence_structure+="preposition ";this_turn.verified_sentence["phrase"+count.phrase]={preposition:this_word.word,preposition_properties:this_word.properties}}else if("noun"===this_word.type&&"itself"===this_word.word){if(!this_turn.verified_sentence["phrase"+count.phrase]?.noun){this.game.debug("D1862","verifySentence.js "," itself has no referent");msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg);return false}if(last_word&&"preposition"!==last_word.type)count.phrase++;this_turn.verified_sentence_structure+="noun ";this_turn.verified_sentence["phrase"+count.phrase].noun={noun:this_turn.verified_sentence["phrase"+(count.phrase-1)].noun,noun_properties:this_word.properties};if(this_turn.verified_sentence["phrase"+(count.phrase-1)].parsedNoun)this_turn.verified_sentence["phrase"+count.phrase].parsedNoun=(new adventurejs.ParsedNoun).set(this_turn.verified_sentence["phrase"+(count.phrase-1)].parsedNoun)}else if("noun"===this_word.type&&this_word.properties.relative_direction&&last_word&&"verb"===last_word.type&&next_word&&"noun"===next_word.type){this.game.debug(` | verifySentence.js | ${this_word.word} appears to be a spatial direction / preposition for `+next_word.word);count.phrase++;this_turn.verified_sentence["phrase"+count.phrase]={};this_turn.verified_sentence["phrase"+count.phrase].preposition=this_word.word}else{if("noun"===this_word.type&&this_word.adjective&&next_word&&"noun"===next_word.type){let found_asset_id,found_asset=this.game.getAsset(this_word.word+" "+next_word.word);if(found_asset)found_asset_id=found_asset.id;if(!found_asset){var last_word_is_direction=this.parseNoun(this_word.word+" "+next_word.word);found_asset_id=last_word_is_direction.matches.unambiguous;found_asset=this.game.getAsset(found_asset_id)}if(!found_asset_id){this.game.debug("D1219","verifySentence.js ",` ${this_word.word} appears to be an adjective for ${next_word.word} and no ${this_word.word} ${next_word.word} was found`);msg+=`{We} {don't} know of any ${this_word.word} ${next_word.word}. `;this.game.print(msg,this_turn.output_class);return false}this.game.debug("D1863","verifySentence.js ",` ${found_asset_id} was found to match ${this_word.word} + ${next_word.word} `);this_word.asset=found_asset;this_word.word=found_asset_id;position++}if("noun"===this_word.type){if(!last_word||"preposition"!==last_word.type){count.phrase++;this_turn.verified_sentence["phrase"+count.phrase]={}}this_turn.verified_sentence["phrase"+count.phrase].noun=this_word.word;this_turn.verified_sentence["phrase"+count.phrase].noun_properties=this_word.properties;if(this_word.exclusion)this_turn.verified_sentence["phrase"+count.phrase].exclusion=this_word.exclusion;this_turn.verified_sentence_structure+="noun ";count.noun++}else if("adjective"===this_word.type){if(next_word&&"noun"===next_word.type){this.game.debug("D1218","verifySentence.js ",` ${this_word.word} appears to be an adjective for ${next_word.word} and no ${this_word.word} ${next_word.word} was found`);msg+=`{We} {don't} know of any ${this_word.word} ${next_word.word}. `;this.game.print(msg,this_turn.output_class);return false}}else if("unknown"===this_word.type){this_turn.unknown_word=this_word.word;this.game.debug("D1200","verifySentence.js ",` ${this_word.word} is unknown`);if(0===position&&1<this_turn.parsed_sentence.length)msg+=this.game.settings.getUnknownVerbMessage(this_word.word);else if(this.game.dictionary.hasCommonWord(this_word.word))msg+=this.game.settings.getCommonWordMessage(this_word.word);else msg+=this.game.settings.getUnknownWordMessage(this_word.word);this.game.print(msg,this_turn.output_class);return false}}}this_turn.verified_sentence_structure=this_turn.verified_sentence_structure.trim();return true}})();(()=>{var p;adventurejs.Parser.prototype.verifySentenceStructure=function Parser_verifySentenceStructure(){var this_turn=this.input_history[0],verb_name=(this.game.log("L1243","log","high","[verifySentenceStructure.js] verifySentenceStructure() "+this_turn.verified_sentence_structure,"Parser"),this_turn.getVerb(1)),verb=this.game.dictionary.verbs[verb_name];if(verb&&verb.accepts_structures.length){for(var valid=verb.accepts_structures,structure=this_turn.verified_sentence_structure,found=false,j=0;j<valid.length;j++)if(valid[j]===structure){found=true;break}if(!found){let msg="";this.game.debug("D1199","verifySentenceStructure.js ",` ${verb_name} doesn't accept structure > ${this_turn.verified_sentence_structure} `);if("verb"===this_turn.verified_sentence_structure&&-1<verb.accepts_structures.indexOf("verb noun")){msg+=`What did {we} want to ${this_turn.input}? `;this_turn.setSoftPrompt({index:1,type:"noun",noun1:true,input_verb:this_turn.input_verb,verb_phrase:this_turn.verb_phrase,verb:this_turn.input_verb,structure:"verb noun"})}else if("verb"===this_turn.verified_sentence_structure&&-1<verb.accepts_structures.indexOf("verb preposition noun")){msg+=`What did {we} want to ${this_turn.input}? `;this_turn.setSoftPrompt({index:1,type:"noun",noun1:true,preposition1:true,input_verb:this_turn.input_verb,verb_phrase:this_turn.verb_phrase,verb:this_turn.input_verb,structure:"verb preposition noun"})}else if("verb noun"===this_turn.verified_sentence_structure&&-1<verb.accepts_structures.indexOf("verb noun noun")){msg+=`Where did {we} want to ${this_turn.input}? `;this_turn.setSoftPrompt({index:2,type:"noun",noun2:true,input_verb:this_turn.input_verb,verb_phrase:this_turn.verb_phrase,verb:this_turn.input_verb,structure:"verb noun noun"})}else if("verb noun"===this_turn.verified_sentence_structure&&-1<verb.accepts_structures.indexOf("verb noun preposition noun")){msg+=`Where did {we} want to ${this_turn.input}? `;this_turn.setSoftPrompt({index:2,type:"noun",noun2:true,preposition2:true,input_verb:this_turn.input_verb,verb_phrase:this_turn.verb_phrase,verb:this_turn.input_verb,structure:"verb noun preposition noun"})}else msg+=this.game.settings.getUnparsedMessage(this_turn.input);this.game.print(msg);return false}}return true}})();(()=>{class ParsedNoun{constructor(asset){if(!asset||!asset.id)asset=null;this.class="ParsedNoun";this.exclude=false;this.plural="";this.isPlural=false;this.isGroup=false;this.singular="";this.type="";this.input=null===asset?"":asset.name;this.serialized_input=null===asset?"":asset.id;this.original_input=null===asset?"":asset.name;this.qualified_object_id=null===asset?void 0:asset.id;this.matches={all:[],direction:false,substance:false,qualified:[],qualifiedIndex:0,unambiguous:""};if(null!==asset){this.matches.all=[asset.id];this.matches.qualified=[asset.id];this.matches.qualifiedIndex=0;this.matches.unambiguous=asset.id}this.preposition="";this.is_assumed=false;return this}get object_id(){if(void 0!==this.qualified_object_id)return this.qualified_object_id;else if(0<this.matches.qualified.length)return this.matches.qualified[this.matches.qualifiedIndex];else return null}set(props){return A.deepSet.call(this.game,props,this)}}adventurejs.ParsedNoun=ParsedNoun})();(()=>{class RestoreManager{constructor(game){this.game=game;this.restoreTabs=[];this.restorePanes=[];this.restoreButtons=[];this.restore_dialog=document.createElement("div");this.restore_dialog.classList.add("ajs-restore-dialog","ajs-dialog");this.restore_dialog.setAttribute("aria-hidden",true);this.restore_dialog.setAttribute("aria-modal",true);this.restore_dialog.role="dialog";this.restore_dialog.tabIndex="1";this.restore_dialog.style.display="none";this.restore_dialog.setAttribute("aria-labelledby",this.game.game_name+"-restore-dialog-title");this.game.display.dialogsEl.appendChild(this.restore_dialog);this.restore_dialog.innerHTML=`
<div class="ajs-restore-dialog-outer ajs-dialog-outer">
  <div class="ajs-restore-dialog-inner ajs-dialog-inner">

    <h2 id="${this.game.game_name}-restore-dialog-title" class="ajs-restore-dialog-title ajs-dialog-title">RESTORE GAME</h2>

    <div class="ajs-restore-dialog-content ajs-dialog-content">
      <div id="${this.game.game_name}-restore-dialog-radiogroup" role="radiogroup" aria-labelledby="${this.game.game_name}-restore-dialog-radiogroup-label">
        <p id="${this.game.game_name}-restore-dialog-radiogroup-label" class="ajs-hidden-label">Select an option:</p>
        <div class="ajs-dialog-radio-tab-container">
          <label class="ajs-dialog-radio-tab">
            <input
              type="radio"
              name="restoreoptions"
              value="restore_from_file"
              data-type="file"
              aria-describedby="${this.game.game_name}-restore-dialog-descriptions"
              checked
            />
            Restore from File
          </label>

          <label class="ajs-dialog-radio-tab">
            <input
              type="radio"
              name="restoreoptions"
              value="restore_from_browser"
              data-type="browser"
              aria-describedby="${this.game.game_name}-restore-dialog-descriptions"
            />
            Restore from Browser
          </label>

          <label class="ajs-dialog-radio-tab">
            <input
              type="radio"
              name="restoreoptions"
              value="restore_from_server"
              data-type="server"
              aria-describedby="${this.game.game_name}-restore-dialog-descriptions"
            />
            Restore from Server
          </label>
        </div>
        <!-- /ajs-dialog-radio-tab-container -->
      </div>
      <!-- /radiogroup -->

      <!-- CONTEXTUAL DESCRIPTIONS -->

      <div id="${this.game.game_name}-restore-dialog-descriptions" class="ajs-dialog-option-descriptions" aria-live="polite">
        <!-- Select an option to see more details. -->
      </div>

      <!-- SELECTION OPTIONS -->
      
      <div id="${this.game.game_name}-restore-dialog-selections" class="ajs-dialog-option-selections">

        <!-- CHOOSE FILE FROM DRIVE -->

        <div 
          id="${this.game.game_name}-restore-from-file-selection"
          class="ajs-dialog-option-selection ajs-restore-from-file-input-container "
          data-type="file"
        >
          <input 
            id="${this.game.game_name}-restore-from-file-input" 
            class="ajs-restore-from-file-input ajs-file-reader-required" 
            type="file" 
            accept=".json" 
            name="restore-file-input" 
          >
          <div class="ajs-file-reader-unsupported">
            :-(
          </div>
        </div>

        <!-- CHOOSE FROM BROWSER -->

        <div 
          id="${this.game.game_name}-restore-from-browser-selection"
          class="ajs-dialog-option-selection ajs-restore-from-browser-listbox-container"
          data-type="browser"
        >
          <p 
            id="${this.game.game_name}-restore-from-listbox-label"
            class="ajs-restore-from-browser-listbox-label ajs-listbox-label"
          >
            Select a saved game to restore:
          </p>
          <ul 
            class="ajs-restore-browser-listbox ajs-listbox listbox"
            id="${this.game.game_name}-restore-from-browser-listbox"
            aria-labelledby="${this.game.game_name}-restore-from-listbox-label"
            role="listbox"
            tabindex="0"
          >
          </ul>
        </div>

        <!-- CHOOSE FROM SERVER -->
      
        <div 
          id="${this.game.game_name}-restore-from-server-selection"
          class="ajs-dialog-option-selection ajs-restore-server-container"
          data-type="server"
        >
          <p class="ajs-restore-from-server-label">
            TBD
          </p>
        </div>

      </div>

      <!-- DIALOG BUTTONS -->

      <div class="ajs-restore-dialog-buttons ajs-dialog-button-container">

        <!-- CANCEL BUTTON -->

        <button
          id="${this.game.game_name}-restore-dialog-cancel-button"
          class="ajs-restore-dialog-cancel-button ajs-cancel-button ajs-dialog-button button-secondary"
          type="button"
          value="Cancel"
          name="restore_cancel"
        >
          Cancel
        </button>

        <!-- RESTORE BUTTON -->
        
        <button
          id="${this.game.game_name}-restore-dialog-submit-button"
          class="ajs-restore-dialog-submit-button ajs-restore-button ajs-dialog-button button-primary"
          type="button"
          value="submit"
          name="restore_submit"
        >
          Restore
        </button>
      </div>
      <!-- /ajs-restore-dialog-buttons -->
    </div>
    <!-- /ajs-restore-dialog-content -->

  </div> 
  <!-- /ajs-restore-dialog-inner -->
</div>
<!-- /ajs-restore-dialog-outer -->
      `;this.radiogroup=this.game.display.displayEl.querySelector(`#${this.game.game_name}-restore-dialog-radiogroup`);var game=this.game.display.displayEl.querySelectorAll('input[name="restoreoptions"]');let descriptions=this.game.display.displayEl.querySelector(`#${this.game.game_name}-restore-dialog-descriptions`),selections=this.game.display.displayEl.querySelectorAll(".ajs-dialog-option-selection"),optionDescriptions={restore_from_file:`
          <div class="ajs-dialog-option-description">
            <p class="">
              Use this option to restore a saved game file that you 
              downloaded using the 
              <span class="ajs-dialog-emphasis">Save to File</span> 
              option. If, when you saved, your browser didn't offer 
              you a file dialog to choose your download location, 
              then your save file was probably downloaded to 
              your computer's default Download folder. 
            </p>
            <div
              class="ajs-file-reader-unsupported"
            >
              <div class="alert alert-danger">
                <p class="">
                  Unfortunately, your web browser doesn't appear to support this
                  save/restore method. Please try one of the other methods, or try
                  playing with a different web browser.
                </p>
              </div>
            </div>
          </div>
        `,restore_from_browser:`
          <div class="ajs-dialog-option-description">
            <p class="">
              Use this option to restore a saved game you saved 
              to the browser using the 
              <span class="ajs-dialog-emphasis">Save to Browser</span> 
              option. It will only find save games you made while 
              playing the game
              on this browser on this computer at this web domain.
            </p>
          </div>
        `,restore_from_server:`
          <div class="ajs-dialog-option-description">
            <p class="">
              Use this option to restore a saved game you saved using the 
              <span class="ajs-dialog-emphasis">Save to Server</span> 
              option. You will need to log in to the adventurejs server 
              if you haven't already. 
            </p>
          </div>
        `};descriptions.innerHTML=optionDescriptions[Object.keys(optionDescriptions)[0]];game.forEach(radio=>{radio.selection=this.game.display.displayEl.querySelector(`[data-type="${radio.dataset.type}"].ajs-dialog-option-selection`);radio.addEventListener("change",event=>{var selectedOption=event.target.value;descriptions.innerHTML=optionDescriptions[selectedOption]||"Select an option to see more details.";selections.forEach(selection=>{selection.classList.remove("active")});event.target.selection.classList.add("active")})});setTimeout(()=>{var radioButtons,checkedRadio=Array.from(this.radiogroup.querySelectorAll('input[type="radio"]')).find(radio=>radio.checked);if(!checkedRadio&&0<this.radiogroup.length){this.radiogroup[0].checked=true;selections[0].classList.add("active");console.log("No radio button was selected. The first one is now checked.")}else if(checkedRadio)checkedRadio.selection.classList.add("active")},50);this.restore_cancel=this.game.display.displayEl.querySelector(`#${this.game.game_name}-restore-dialog-cancel-button`);(this.restore_cancel.manager=this).restore_cancel.addEventListener("click",function(){this.manager.clickClose()});this.restore_submit=this.game.display.displayEl.querySelector(`#${this.game.game_name}-restore-dialog-submit-button`);(this.restore_submit.manager=this).restore_submit.addEventListener("click",function(){this.manager.clickSubmit()});this.restore_file_input=this.game.display.displayEl.querySelector(`#${this.game.game_name}-restore-from-file-input`);(this.restore_file_input.manager=this).restore_file_input.addEventListener("change",function(e){console.log("restore_file_input.click");console.log("--",e.target.files[0]);console.log("--",e.target.value);if(".json"!==e.target.value.substring(e.target.value.length-5)){e.target.value="";alert("Selected file is not a JSON file.");return false}this.manager.restore_submit.classList.remove("inactive")},false);this.restore_from_browser_listbox=this.game.display.displayEl.querySelector(`#${this.game.game_name}-restore-from-browser-listbox`);this.restore_from_browser_observer=new MutationObserver(function(mutation){if("aria-activedescendant"!==mutation[0].attributeName);else{var mutation=mutation[0].target.getAttribute(mutation[0].attributeName);if(null!==document.getElementById(mutation).getAttribute("aria-selected"))this.manager.restore_submit.classList.remove("inactive")}});(this.restore_from_browser_observer.manager=this).restore_from_browser_observer.observe(this.restore_from_browser_listbox,{attributes:true});this.handleEscape=this.handleEscape.bind(this)}openDialog(){this.resetDialog();document.activeElement.blur();this.game.display.contentEl.blur();this.game.display.contentEl.setAttribute("aria-hidden",true);this.game.display.contentEl.setAttribute("inert","");this.restore_dialog.style.display="block";this.restore_dialog.classList.add("active");this.restore_dialog.setAttribute("aria-hidden",false);this.restore_dialog.focus();document.addEventListener("keyup",this.handleEscape)}resetDialog(){this.restore_file_input.value="";this.restore_submit.classList.add("inactive");this.getLocalStorageList()}closeDialog(){document.removeEventListener("keyup",this.handleEscape);document.activeElement.blur();this.restore_dialog.classList.remove("active");this.restore_dialog.setAttribute("aria-hidden",true);this.restoreButtons.forEach(function(button){button.classList.add("inactive")});setTimeout(()=>{this.restore_dialog.style.display="none";this.game.display.contentEl.setAttribute("aria-hidden",false);this.game.display.contentEl.removeAttribute("inert");this.game.display.inputEl.focus()},250)}handleEscape(event){var key;if(27===(event.which||event.keyCode)){event.stopPropagation();this.clickClose(this)}}clickClose(){console.log("clickClose");this.closeDialog();var msg;this.game.print("Restore cancelled.")}clickSubmit(){var selectedRadio=this.radiogroup.querySelector('input[name="restoreoptions"]:checked');if(selectedRadio){console.log("Selected value: "+selectedRadio.value);if("restore_from_file"===selectedRadio.value)this.restoreFromFile();if("restore_from_browser"===selectedRadio.value)this.restoreFromBrowser();if("restore_from_server"===selectedRadio.value)this.restoreFromServer()}else console.log("No radio button is selected.")}restoreFromFile(){console.log("restoreFromFile");var fileReader=new FileReader,manager;fileReader.onload=(manager=this,function(e){manager.fileReaderOnload(e)});fileReader.readAsText(this.restore_file_input.files[0],"UTF-8")}fileReaderOnload(e){console.log("fileReaderOnload");console.log(e);let text=e.target.result;this.closeDialog();if(A.isObfuscated(text))text=A.deobfuscate(text);var restored;if(false===A.restoreWorld.call(this.game,text)){var msg="Restore failed!";this.game.print(msg);return false}var msg="Game restored.";this.game.print(msg)}restoreFromBrowser(){console.log("restoreFromBrowser");var saveName=this.restore_from_browser_listbox.getAttribute("aria-activedescendant"),saveName=A.restoreWorld.call(this.game,window.localStorage[saveName]);this.closeDialog();if(!saveName){var msg="Restore failed!";this.game.print(msg);return false}var msg="Game restored.";this.game.print(msg)}getLocalStorageList(){this.resetLocalStorageListBox();var storage,key;for(key in window.localStorage)if(this.game.titleSerialized!==key.substring(0,this.game.titleSerialized.length));else{var li=document.createElement("li");li.id=key;li.innerHTML=key.substring(this.game.titleSerialized.length+1);li.setAttribute("role","option");this.restore_from_browser_listbox.appendChild(li)}if(0<this.restore_from_browser_listbox.childNodes.length)this.restore_from_browser_listbox.setAttribute("aria-activedescendant",this.restore_from_browser_listbox.childNodes[0].id);this.restoreListboxInstance_Browser=new aria.Listbox(this.restore_from_browser_listbox);this.restore_from_browser_listbox.focus()}resetLocalStorageListBox(){if(!this.restore_from_browser_listbox.innerHTML&&void 0===this.restoreListboxInstance_Browser);else{if(void 0!==this.restoreListboxInstance_Browser)delete this.restoreListboxInstance_Browser;for(var i=this.restore_from_browser_listbox.childNodes.length-1;-1<i;i--)this.restore_from_browser_listbox.removeChild(this.restore_from_browser_listbox.childNodes[i]);this.restore_from_browser_listbox.innerHTML=""}}restoreFromServer(){console.log("restoreFromServer")}selectTab(selectedTab){this.restoreTabs.forEach(function(tabButton){if(tabButton!==selectedTab){tabButton.classList.remove("active");tabButton.restorePane.classList.remove("active");tabButton.restorePaneQA.classList.remove("active")}else{tabButton.classList.add("active");tabButton.restorePane.classList.add("active")}},selectedTab)}set(props){return A.deepSet.call(this.game,props,this)}}adventurejs.RestoreManager=RestoreManager})();(()=>{class SaveManager{constructor(game){this.game=game;this.saveButtons=[];this.save_dialog=document.createElement("div");this.save_dialog.classList.add("ajs-save-dialog","ajs-dialog");this.save_dialog.setAttribute("aria-hidden",true);this.save_dialog.setAttribute("aria-modal",true);this.save_dialog.role="dialog";this.save_dialog.style.display="none";this.save_dialog.tabIndex="1";this.save_dialog.setAttribute("aria-labelledby",this.game.game_name+"-save-dialog-title");this.game.display.dialogsEl.appendChild(this.save_dialog);this.save_dialog.innerHTML=`
  <div class="ajs-save-dialog-outer ajs-dialog-outer">
    <div class="ajs-save-dialog-inner ajs-dialog-inner">

      <h2 id="${this.game.game_name}-save-dialog-title" class="ajs-save-dialog-title ajs-dialog-title">SAVE GAME</h2>

      <div class="ajs-save-dialog-content ajs-dialog-content">
        <div id="${this.game.game_name}-save-radiogroup" role="radiogroup" aria-labelledby="${this.game.game_name}-save-radiogroup-label">
          <p id="${this.game.game_name}-save-radiogroup-label" class="ajs-hidden-label">Select an option:</p>
          <div class="ajs-dialog-radio-tab-container">
            <label class="ajs-dialog-radio-tab">
              <input
                type="radio"
                name="saveoptions"
                value="save_to_file"
                aria-describedby="${this.game.game_name}-save-descriptions"
                checked
              />
              Save to File
            </label>

            <label class="ajs-dialog-radio-tab">
              <input
                type="radio"
                name="saveoptions"
                value="save_to_browser"
                aria-describedby="${this.game.game_name}-save-descriptions"
              />
              Save to Browser
            </label>

            <label class="ajs-dialog-radio-tab">
              <input
                type="radio"
                name="saveoptions"
                value="save_to_server"
                aria-describedby="${this.game.game_name}-save-descriptions"
              />
              Save to Server
            </label>
          </div>
          <!-- /ajs-dialog-radio-tab-container -->
        </div>
        <!-- /radiogroup -->

      <!-- CONTEXTUAL DESCRIPTIONS -->

      <div id="${this.game.game_name}-save-descriptions" class="ajs-dialog-option-descriptions" aria-live="polite">
          <!-- Select an option to see more details. -->
        </div>

        <div id="${this.game.game_name}-save-dialog-input-container" class="ajs-save-dialog-input-container">
          <label class="ajs-save-dialog-input-label"
            >Enter a name for your save file: <br /><input
              id="${this.game.game_name}-save-dialog-input"
              class="ajs-save-dialog-input"
              pattern="[_A-Za-z0-9-]{64}"
            />
          </label>
        </div>

        <div class="ajs-save-dialog-buttons ajs-dialog-button-container">
          <button
            id="${this.game.game_name}-save-dialog-cancel-button"
            class="ajs-save-dialog-cancel-button ajs-cancel-button ajs-dialog-button button-secondary"
            type="button"
            value="Cancel"
            name="saveCancel"
          >
            Cancel
          </button>
          <button
            id="${this.game.game_name}-save-dialog-submit-button"
            class="ajs-save-dialog-submit-button ajs-save-button ajs-dialog-button button-primary"
            type="button"
            value="submit"
            name="save_submit"
          >
            Save
          </button>
        </div>
        <!-- /ajs-save-dialog-buttons -->
      </div>
      <!-- /ajs-save-dialog-content -->

    </div> 
    <!-- /ajs-save-dialog-inner -->
  </div>
  <!-- /ajs-save-dialog-outer -->
      `;this.radiogroup=this.game.display.displayEl.querySelector(`#${this.game.game_name}-save-radiogroup`);var game=this.game.display.displayEl.querySelectorAll('input[name="saveoptions"]');let descriptions=this.game.display.displayEl.querySelector(`#${this.game.game_name}-save-descriptions`),optionDescriptions={save_to_file:`
          <div class="ajs-dialog-option-description">
            <p class="">
              The <span class="ajs-dialog-emphasis">Save to File</span>
              option will download a saved game file to your computer's hard
              drive.
            </p>
            <p class="">
              <strong>PRO:</strong> You can restore these save files in any browser
              that can run this game, and copy them to other computers.
            </p>
            <p class="">
              <strong>CON:</strong> For reasons of security, the browser won't open a
              file dialog to let you choose where to put it. It should go to your
              browser's default Download folder.
            </p>
            <div
              class="ajs-file-reader-unsupported"
            >
              <div class="alert alert-danger">
                <p class="">
                  Unfortunately, your web browser doesn't appear to support this
                  save/restore method. Please try one of the other methods, or try
                  playing with a different web browser.
                </p>
              </div>
            </div>
          </div>
        `,save_to_browser:`
          <div class="ajs-dialog-option-description">
            <p class="">
              The <span class="ajs-dialog-emphasis">Save to Browser</span>
              option will save your game to your web browser's
              <span class="ajs-dialog-emphasis">Local Storage</span>. It's like a
              cookie, but bigger. 
            </p>
            <p class="">
              <strong>PRO:</strong> Easy to manage saves if you
              only play the game in this browser on this computer. Best for short
              games that you're unlikely to replay. 
            </p>
            <p class="">
              <strong>CON:</strong> Storage is
              limited. You can only access these saves from this browser on this
              computer. If you clear your browser's cache, you may erase your
              saved games.
            </p>
          </div>
        `,save_to_server:`
          <div class="save_server_pane ajs-dialog-option-description active">
            <p class="">
              The <span class="ajs-dialog-emphasis">Save to Server</span>
              option will save your game to the adventurejs.com web
              server.
            </p>
            <p class="">
              <strong>PRO:</strong> It's easy to manage your saved games, and you can
              restore them to any browser on any computer that runs this game.
            </p>
            <p class="">
              <strong>CON:</strong> Saved games will be unavailable while you are
              offline.
            </p>
          </div>
        `};descriptions.innerHTML=optionDescriptions[Object.keys(optionDescriptions)[0]];game.forEach(radio=>{radio.addEventListener("change",event=>{var event=event.target.value;descriptions.innerHTML=optionDescriptions[event]||"Select an option to see more details."})});setTimeout(()=>{var radioGroup=this.game.display.displayEl.querySelectorAll(`#${this.game.game_name}-save-radiogroup input[name="saveoptions"]`),isChecked;if(!Array.from(radioGroup).some(radio=>radio.checked)&&0<radioGroup.length)radioGroup[0].checked=true},50);this.saveCancel=this.game.display.displayEl.querySelector(`#${this.game.game_name}-save-dialog-cancel-button`);(this.saveCancel.manager=this).saveCancel.addEventListener("click",function(){this.manager.clickClose()});this.save_submit=this.game.display.displayEl.querySelector(`#${this.game.game_name}-save-dialog-submit-button`);(this.save_submit.manager=this).save_submit.addEventListener("click",function(){this.manager.clickSubmit()});this.save_input=document.createElement("input");this.save_input=this.game.display.displayEl.querySelector(`#${this.game.game_name}-save-dialog-input`);this.save_input.pattern="[_A-Za-z0-9\\-]{64}";(this.save_input.manager=this).save_input.addEventListener("input",function(){this.manager.saveInputOninput(this)});this.save_input.addEventListener("onkeydown",function(){this.manager.saveInputOninput(this)});this.handleEscape=this.handleEscape.bind(this)}openDialog(){document.activeElement.blur();this.game.display.contentEl.blur();this.game.display.contentEl.setAttribute("aria-hidden",true);this.game.display.contentEl.setAttribute("inert","");this.save_dialog.style.display="block";this.save_dialog.classList.add("active");this.save_dialog.setAttribute("aria-hidden",false);this.save_dialog.focus();this.save_input.value=this.game.titleSerialized+"_"+(new Date).getTime().toString();document.addEventListener("keyup",this.handleEscape);setTimeout(function(saveManager){saveManager.save_input.select()},50,this)}closeDialog(){document.removeEventListener("keyup",this.handleEscape);document.activeElement.blur();this.save_dialog.classList.remove("active");this.save_dialog.setAttribute("aria-hidden",true);setTimeout(()=>{this.save_dialog.style.display="none";this.game.display.contentEl.setAttribute("aria-hidden",false);this.game.display.contentEl.removeAttribute("inert");this.game.display.inputEl.focus()},250)}handleEscape(event){var key;if(27===(event.which||event.keyCode)){event.stopPropagation();this.clickClose(this)}}clickClose(){this.closeDialog();var msg;this.game.print("Save cancelled.")}clickSubmit(){var selectedRadio=this.radiogroup.querySelector('input[name="saveoptions"]:checked');if(selectedRadio){console.log("Selected value: "+selectedRadio.value);if("save_to_file"===selectedRadio.value)this.saveToFile();if("save_to_browser"===selectedRadio.value)this.saveToBrowser();if("save_to_server"===selectedRadio.value)this.saveToServer()}else console.log("No radio button is selected.")}saveToFile(){var inputFileName=this.sanitizeInputFileName(),text=A.getBaselineDiff.call(this.game);if(this.game.settings.obfuscate_saves)text=A.obfuscate(text);var text=new Blob([text],{type:"application/json"}),anchor=document.createElement("a"),msg;anchor.download=inputFileName+".json";anchor.href=(window.webkitURL||window.URL).createObjectURL(text);anchor.dataset.downloadurl=["application/json",anchor.download,anchor.href].join(":");anchor.click();setTimeout(function(){URL.revokeObjectURL(anchor.href)},200);this.closeDialog();this.game.print("Game saved! <span class='text-success'>"+inputFileName+".json</span> has been saved to your Downloads folder.");return true}saveToBrowser(){var inputFileName=this.sanitizeInputFileName(),storage,msg;if(this.game.titleSerialized!==inputFileName.substring(0,this.game.titleSerialized.length))inputFileName=this.game.titleSerialized+"_"+inputFileName;window.localStorage.setItem(inputFileName,A.getBaselineDiff.call(this.game));this.closeDialog();this.game.print("Game saved to your browser's Local Storage!");return true}saveToServer(){var inputFileName=this.sanitizeInputFileName()}saveInputOninput(save_input){var activeState=""===save_input.value?"add":"remove";this.save_submit.classList[activeState]("inactive");this.save_submit.disabled=""===save_input.value?true:false}sanitizeInputFileName(){var inputFileName=this.save_input.value,inputFileName;if(!(inputFileName=(inputFileName=inputFileName.replace(/ /gim,"_")).replace(/[^a-zA-Z0-9áéíóúñü_-]/gim,"")))inputFileName=this.game.titleSerialized+"_"+(new Date).getTime().toString();return inputFileName}set(props){return A.deepSet.call(this.game,props,this)}}adventurejs.SaveManager=SaveManager})();(()=>{class UserManager{constructor(game){this.game=game}}adventurejs.UserManager=UserManager})();(()=>{class Scorecard{constructor(game){this.game=game;this.game.world._scorecard={initialize:{complete:true,points:0,recorded:true,message:"",bonus:false}};this.score=0;this.newscore=0;this.diff=0;this.score_message="";this.score_format={};this.summarize_updates=false;this.game.reactor.addEventListener("inputParseComplete",function(e){this.game.scorecard.updateScore()})}createEvent(){var event;return JSON.stringify({points:0,complete:false,bonus:false,recorded:false,message:""})}completeEvent(event){console.warn(`Scorecard.js > completeEvent(${event})`);if(this.game.world._scorecard[event])return this.game.world._scorecard[event].complete=true;else return false}updateScore(){let score=0,total=0;var msg="",prop;for(prop in this.game.world._scorecard){if(!this.game.world._scorecard[prop].bonus)total+=this.game.world._scorecard[prop].points;if(this.game.world._scorecard[prop].complete)score+=this.game.world._scorecard[prop].points}this.total=total;this.newscore=score;msg+=this.summarize_updates?this.aggregateUpdates():this.stackUpdates();this.score=score;this.game.display.setScore(this.formatScore(score,total));if(msg)this.game.print(msg);return true}aggregateUpdates(){let msg="";if(this.newscore!==this.score){var direction=this.newscore>this.score?"up":"down",diff=this.newscore-this.score,s=1<Math.abs(diff)?"s":"";this.diff=diff;msg=`<span class="ajs-score-msg ${direction}">${msg=this.score_message?A.getSAF.call(this.game,this.score_message,this):`[ ** {Our} score went ${direction} by ${diff} point${s} ** ]`}</span>`}return msg}stackUpdates(){let msg="";for(var prop in this.game.world._scorecard)if(this.game.world._scorecard[prop].complete&&!this.game.world._scorecard[prop].recorded){let eventmsg="";var diff=this.game.world._scorecard[prop].points,direction=0<diff?"up":"down",s=1<Math.abs(diff)?"s":"";this.diff=diff;this.game.world._scorecard[prop].recorded=true;if(this.game.world._scorecard[prop].message)eventmsg=A.getSAF.call(this.game,this.game.world._scorecard[prop].message,this);else eventmsg=this.score_message?A.getSAF.call(this.game,this.score_message,this):`[ ** {Our} score went ${direction} by ${diff} point${s} ** ]`;msg+=`<span class="ajs-score-msg ${direction}">${eventmsg}</span>`}return msg}formatScore(score,total){if(Object.keys(this.score_format).length){var results=A.getSAF.call(this.game,this.score_format,this);if(results)return results}return score+"/"+total}set(scorecard){if(scorecard.score_events)for(var event in scorecard.score_events){this.game.world._scorecard[event]=JSON.parse(this.createEvent());if("number"==typeof scorecard.score_events[event])this.game.world._scorecard[event].points=scorecard.score_events[event];else for(var prop in scorecard.score_events[event])this.game.world._scorecard[event][prop]=JSON.parse(JSON.stringify(scorecard.score_events[event][prop]))}if(void 0!==scorecard.summarize_updates)this.summarize_updates=scorecard.summarize_updates;if(scorecard.score_message)this.score_message=scorecard.score_message;if(scorecard.score_format)this.score_format=scorecard.score_format;return this}}adventurejs.Scorecard=Scorecard})();(()=>{class Settings{constructor(game){this.game=game;this.max_undos=10;this.log_level=1;this.log_trace_level=0;this.include_filename_in_log=false;this.log={all:false,character:false,copyoperations:false,debug:false,dictionary:false,display:false,exit:false,game:false,parser:false,print:false,room:false,substanceemitter:false,substancemixer:false,tangible:false,travel:false,utility:false,verb:false,verbaction:false,verbreaction:false,verbphase:false,vessel:false};this.debug={all:false,verbaction:false,verbreaction:false,verbphase:false,general:false};this.use_nested_verb_phase_hooks=false;this.when_travel_fails_list_exits=true;this.show_room_names_in_exit_descriptions=true;this.show_room_names_in_exit_descriptions_only_when_room_is_known=false;this.show_room_names_in_exit_descriptions_only_after_exit_has_been_used=true;this.show_disambiguation_as_ordered_list=false;this.show_disambiguation_as_numbered_paragraph=true;this.if_input_is_empty_print_room_description=false;this.if_input_is_empty_print_this="I didn't see any input. ";this.if_parser_has_no_response_print_this="I don't understand what you mean by <em class='ajs-unparsed'>{input}</em>. ";this.asset_list_format="{Preposition} {name} {we} see {list}. ";this.if_word_is_common_print_this=`{We} {don't} know of any <span class="ajs-common ajs-word">{word}</span>. `;this.if_word_is_unknown_print_this=`{We} {don't} know the word <span class="ajs-unknown ajs-word">{word}</span>. `;this.if_verb_is_unknown_print_this=`{We} {don't} know how to <span class="ajs-unknown ajs-word ajs-verb">{word}</span> anything. `;this.if_room_is_dark_print_this="It is pitch black. {We} are likely to be eaten by a grue. ";this.name_for_dark_rooms="In the dark";this.if_input_is_an_asset_name_examine_it=true;this.randomize_arrays_in_getStringArrayFunction=false;this.reset_arrays_in_getStringOrArrayOrFunction=true;this.auto_take_assets=true;this.auto_take_assets_after_first_use=true;this.auto_open_containers=true;this.auto_open_containers_after_first_use=true;this.mouthful=100;this.handful=100;this.ambient_temperature=20;this.states={SOLID:"SOLID",LIQUID:"LIQUID",GAS:"GAS"};this.pronouns={FIRST:"first",PLURAL:"plural",SECOND:"second",MALE:"male",FEMALE:"female",NONBINARY:"non-binary",NONHUMAN:"non-human"};this.genders={MALE:"male",FEMALE:"female",NONBINARY:"non-binary",TRANSGENDER:"transgender",NONHUMAN:"non-human"};this.person=this.pronouns.SECOND;this.ambient_gravity=1;this.ambient_light=1;this.light_sources_are_cumulative=false;this.ambient_sound=0;this.things_float_on_water=true;this.things_sink_in_water=true;this.things_disappear_in_water=true;this.things_rise_in_low_gravity=true;this.things_fall_in_high_gravity=true;this.things_disappear_in_space=true;this.print_room_exits=true;this.print_room_contents=true;this.verbosity=0;this.min_verbosity=-2;this.max_verbosity=1;this.print_verbose_room_descriptions_on_first_visit=true;this.enable_events=true;this.infer_containers=true;this.infer_containers_prefers_reservoir=true;this.auto_pick_inferred_container=true;this.infer_objects=true;this.objects_must_be_used_before_inferring=false;this.auto_pick_inferred_objects=true;this.auto_unnest_on_travel=false;this.auto_stand_on_travel=false;this.on_floor_blocks_travel=false;this.auto_mount_vehicles=false;this._show_compass_rose_in_status=true;this.xz_determines_reachability=true;this.y_determines_reachability=true;this.concatenate_descriptions=true;this.disambiguation_considers_last_turn=true;this.print_inferred=true;this.known_by_all_players=true;this.seen_by_all_players=true;this.quiet=false;this.respect_quiet=true;this.obfuscate_saves=false;this.goto_excludes_locked_doors=false;this.goto_excludes_unvisited_locations=true;this.goto_prints_room_descriptions=true;this.max_level_of_modified_descriptions_to_stack=1;this.apply_color_classes_to_written_strings=true;this.apply_color_classes_to_drawn_things=true;this.include_exits_in_roomdocks=true;this.include_contents_in_roomdocks=true}set(props){return A.deepSet.call(this.game,props,this)}getUnparsedMessage(input){this.game.debug("D1158","Settings.js "," input couldn't be parsed, print settings.if_parser_has_no_response_print_this");var msg,regex;return A.getSAF.call(this.game,this.game.settings.if_parser_has_no_response_print_this).replace(/\{(input)\}/g,""+input)}getUnknownVerbMessage(word){var msg,regex;return A.getSAF.call(this.game,this.game.settings.if_verb_is_unknown_print_this).replace(/\{(word)\}/g,""+word)}getUnknownWordMessage(word){var msg,regex;return A.getSAF.call(this.game,this.game.settings.if_word_is_unknown_print_this).replace(/\{(word)\}/g,""+word)}getCommonWordMessage(word){var msg,regex;return A.getSAF.call(this.game,this.game.settings.if_word_is_common_print_this).replace(/\{(word)\}/g,""+word)}get show_compass_rose_in_status(){return this._show_compass_rose_in_status}set show_compass_rose_in_status(value){this._show_compass_rose_in_status=value;if(this.game.display)this.game.display.exitsContainerEl.classList[value?"remove":"add"]("hidden")}}adventurejs.Settings=Settings})();(()=>{class Reactor extends EventTarget{constructor(game){super();this.game=game}emit(type,detail={}){this.game.log("L1514","log","high",`Reactor.emit(${type})`,"Game");var type=new CustomEvent(type,{bubbles:false,cancelable:true,detail:{...detail,game:this.game}});this.dispatchEvent(type)}}adventurejs.Reactor=Reactor})();(()=>{class Game{constructor(game_name="MyGame",displayElId="MyGameDisplay"){this.class="Game";this.game_states={STATIC:-1,CONSTRUCTION:0,VALIDATE_ASSETS:1,CREATE_DEFERRED_ASSETS:2,INITIALIZE_ASSETS:3,SORT_LOOKUP_VALUES:4,SET_DEFAULT_ASSETS:5,INIT_PLAYER:6,SAVE_BASELINE:7,PLAYING:8};this.game_state=this.game_states.CONSTRUCTION;this.knows_about={};this.has_seen={};(this.game=window[game_name]=this).game_name=game_name;this.reactor=new adventurejs.Reactor(this);this.reactor.addEventListener("inputParseComplete",e=>{var game;e.detail.game.log("L1002","log","high","Event > inputParseComplete","events")});this.settings=new adventurejs.Settings(this);this.log("L1004","log",1,"[Game.js] Constructing "+this.game_name);this.world={};this.world._vars={};this.world._game_name=this.game_name;this.world._room="";this.world._player="";this.world._version="";this.world._title="";this.world._author="";this.world._score="";this.world._ifid="";this.world._timestamp=(new Date).getTime().toString();this.world._intervals={};this.NPCs={};this.pre_scripts={};this.post_scripts={};this.UIDs={};this.vessels={};this.baseline={world:{}};this.world_lookup={};this.longest_lookup=0;this.class_lookup={};this.room_lookup=[];this.image_lookup={};this.dictionary=new adventurejs.Dictionary(this);this.dictionary.initStandardVerbs();this.display=new adventurejs.Display(displayElId,this);this.parser=new adventurejs.Parser(this).set({display:this.display});this.fileReaderUnsupported=void 0===window.File||void 0===window.FileReader||void 0===window.FileList||void 0===window.Blob;var game_name=document.createElement("a");this.downloadUnsupported=void 0===game_name.download;if(this.fileReaderUnsupported||this.downloadUnsupported)this.display.displayEl.classList.add("ajs-file-reader-unsupported");this.saveManager=new adventurejs.SaveManager(this);this.restoreManager=new adventurejs.RestoreManager(this);this.userManager=new adventurejs.UserManager(this);this.createAsset({class:"All",name:"all"});this.createAsset({class:"Void",name:"void"});this.createAsset({class:"Null",name:"null"});this.createGlobalConcepts();this.createGlobalExits();this.createGlobalWalls();this.createGlobalFloors();this.createGlobalCeilings();this.createGlobalScenery();this.scorecard=new adventurejs.Scorecard(this);this.deferredObjects=[];this.description="";this.world_history=[];return this}initialize(params){return this}sendToParser(value){this.reactor.emit("inputEnter");this.parser.input_string=value;this.parser.parseInput(value);this.display.clearInput()}sendToInput(value){this.display.sendToInput(value)}clearInput(value){this.display.clearInput()}get title(){return this._title}set title(title){this.display.set({title:this._title=title});this.titleSerialized=A.serialize(title);this.world._title=title}get author(){return this._author}set author(author){this.display.set({author:this._author=author});this.world._author=author}updateDisplayRoom(){var player=this.getPlayer(),situation="",nest_asset=player.getNestAsset(),room=this.game.getAsset(this.world._room);if(nest_asset)situation=` (${player.getPostureGerund()} 
        ${player.getNestPreposition()} 
        ${nest_asset.articlename})`;else if(player.isOnFloor())situation=` (${player.getPostureGerund()} on the floor)`;var situation=situation?`<span class='situation'>${situation}</span>`:"",nest_asset=(room.is.dark&&this.game.settings.name_for_dark_rooms?this.game.settings.name_for_dark_rooms:room.name)+(situation&&situation);this.display.setRoomName(nest_asset).setRoomImage(room.image)}updateDisplayCompasses(){let exitnames="";var exits=this.getRoom().exits,exitlist={},id;for(id in exits){var exit=this.getAsset(exits[id]);if(exit.destination){exitnames+=" "+exit.direction;exitlist[exit.direction]=exit}}this.display.updateCompasses(exitlist)}updateDisplayVerbs(){this.display.updateVerbDocks()}updateDisplayInventory(){this.display.updateInventoryDocks(this.game.getPlayer().getAllNestedContents())}get score(){return this._score}set score(score){this.display.set({score:this._score=score});this.world._score=score}get version(){return this._version}set version(version){this.display.set({version:this._version=version});this.world._version=version}get player(){return this.getAsset(this.world._player)}get room(){return this.world[this.world._room]}get input(){return this.parser.input_history[0]}get last_turn(){return this.parser.input_history[1]}createParser(parser){return this.parser.createParser(parser)}enableParser(parser){return this.parser.enableParser(parser)}disableParser(parser){return this.parser.disableParser(parser)}appendOutput(msg){return this.getInput().appendOutput(msg)}overrideOutput(msg){return this.getInput().overrideOutput(msg)}prependOutput(msg){return this.getInput().prependOutput(msg)}getStringLookup(type,value){return this.dictionary.getStringLookup(type,value)}hasCommonWord(word){return this.dictionary.hasCommonWord(word)}getVerb(verb){return this.dictionary.getVerb(verb)}disableVerbs(verbs){return this.dictionary.disableVerbs(verbs)}disableAllVerbsBut(verbs){return this.dictionary.disableAllVerbsBut(verbs)}enableVerbs(verbs){return this.dictionary.enableVerbs(verbs)}createVerb(verb){return this.dictionary.createVerb(verb)}replaceVerb(oldVerb,newVerb){return newVerb=this.dictionary.replaceVerb(oldVerb,newVerb)}combineVerbs(verbs,intoVerb){return intoVerb=this.dictionary.combineVerbs(verbs,intoVerb)}patchVerb(patch_verb){return patch_verb=this.dictionary.patchVerb(patch_verb)}startInterval({id,callback,times=null,frequency=1}={}){if(!id||!callback)return null;id=A.serialize(id);if(void 0===this.world._intervals[id])this.world._intervals[id]={};if(void 0!==this.world._intervals[id][callback])return null;this.world._intervals[id][callback]={frequency:frequency,times:times,count:0,last:0}}stopInterval({id,callback}){if(void 0===id||void 0===this.world._intervals[id]||void 0===this.world._intervals[id][callback]);else{delete this.world._intervals[id][callback];if(0===Object.keys(this.world._intervals[id]).length)delete this.world._intervals[id]}}callIntervals(){var game=this;Object.keys(this.world._intervals).forEach(function(id){Object.keys(game.world._intervals[id]).forEach(function(callback){var interval=game.world._intervals[id][callback],asset,asset,asset=game.getAsset(id),rand;if(!asset||void 0===asset[callback]);else if(1<interval.frequency&&interval.last<interval.frequency)interval.last=interval.last+1;else{if(interval.frequency<1){if(Math.random(1)>interval.frequency)return}if("string"==typeof(asset=A.getSAF.call(game,asset[callback],asset)))game.print(asset);interval.last=0;if("number"==typeof interval.times){interval.times=interval.times-1;if(interval.times<=0)game.stopInterval({id:id,callback:callback})}}})})}idleNPCs(){var game=this;let input=game.getInput();Object.keys(this.NPCs).forEach(function(id){var id=game.getAsset(id);if(!id.is.present);else if(id.id===game.getInput().getSubject().id);else if(input.isObject(id.id));else if("function"==typeof id.doIdle)return id.doIdle();else if(id["do_idle"])if(!game.settings.quiet&&game.settings.respect_quiet);else{var id=A.getSAF.call(game,id["do_idle"],id);if("string"==typeof id)game.print(id)}})}callPreScripts(input){var game=this;Object.keys(this.pre_scripts).forEach(function(id){game.pre_scripts[id](input)})}callPostScripts(){var game=this;Object.keys(this.post_scripts).forEach(function(id){game.post_scripts[id]()})}endTurn(){this.updateDisplayVerbs();this.updateDisplayInventory();this.printAreaEvents();this.callIntervals();this.idleNPCs();this.callPostScripts();this.reactor.emit("inputParseComplete")}get vars(){return this.world._vars}getVar(key){if(void 0===this.world._vars[key])return null;else return this.world._vars[key]}setVar(key,value){if("object"==typeof value){var msg;this.game.log("L1578","warn",0,"Game.setVar() received a value that is not a primitive. ","Game");return false}this.world._vars[key]=value}hasVar(key){return void 0!==this.world._vars[key]}setPlayer(new_player,room=null){if("string"==typeof new_player)new_player=this.getAsset(new_player);if(!new_player.id||!new_player.hasClass("Player"))return null;this.getPlayer().is.active=false;new_player.is.active=true;this.world._player=new_player.id;this.world_lookup.me.IDs[0]=new_player.id;this.world_lookup.myself.IDs[0]=new_player.id;if(!room)room=new_player.getRoomAsset();if(!room)room=this.getRoom();this.world._room=room.id;this.getInput().setCharacter(new_player);this.setRoom(room);return new_player}}var p=Game.prototype;p.$setVar=p.setVar;p.$getVar=p.getVar;p.$hasVar=p.hasVar;adventurejs.Game=Game})();(()=>{var p;adventurejs.Game.prototype.$=function Game_$(identifier,params){let asset=this.getAsset(identifier,params);if(!asset){this.game.log("L1576","warn","high",`Game_$ received invalid identifier: ${identifier}, returning Null `,"Game");asset=this.world["null"]}return asset}})();(()=>{var p;adventurejs.Game.prototype.addAsset=function Game_addAsset(asset){var asset=this.createAsset(asset);if(!asset)return false;if(!asset.validate())return false;if(!asset.initialize())return false;this.game.getLongestLookup();return asset}})();(()=>{var p;adventurejs.Game.prototype.constructAsset=function Game_constructAsset(source){var id,dest;if(source.id)id=A.serialize(source.id);else if("Exit"===source.class)id=A.serialize(source.place[Object.keys(source.place)[0]]+" "+source.direction);else if(source.name)id=A.serialize(source.name);if(!this.class_lookup[source.class])this.class_lookup[source.class]=[];this.class_lookup[source.class].push(id);if("object"==typeof source.place&&0<Object.keys(source.place).length)source.place[Object.keys(source.place)[0]]=A.serialize(source.place[Object.keys(source.place)[0]]);(dest=new adventurejs[source.class](id,this.game_name)).game_name=this.game_name;if(void 0===source.singlePluralPairs)source.singlePluralPairs=[];if("string"==typeof source.noun)source.noun=source.noun.trim();if("string"==typeof source.plural)source.plural=source.plural.trim();if(source.aspects&&dest.aspects)if(Array.isArray(source.aspects)){for(var i=0;i<source.aspects.length;i++){var aspect=source.aspects[i];if(dest.aspects[aspect])dest.aspects[aspect].enabled=true;else dest.aspects[aspect]=new adventurejs.Aspect(aspect,this.game_name,id).set({enabled:true})}delete source.aspects}else for(var aspect in source.aspects){if(!dest.aspects[aspect]?.class)dest.aspects[aspect]=new adventurejs.Aspect(aspect,this.game_name,id).set({enabled:true});if(source.aspects[aspect].vessel)if("boolean"==typeof source.aspects[aspect].vessel){if(dest.aspects[aspect].vessel?.class)dest.aspects[aspect].enabled=source.aspects[aspect].vessel;else if(source.aspects[aspect].vessel)dest.aspects[aspect].vessel=new adventurejs.Vessel(aspect,this.game_name,dest.id).set({enabled:true});delete source.aspects[aspect].vessel}else if(!dest.aspects[aspect].vessel?.class)dest.aspects[aspect].vessel=new adventurejs.Vessel(aspect,this.game_name,dest.id).set({enabled:true});if(source.aspects[aspect].nest)if("boolean"==typeof source.aspects[aspect].nest){if(dest.aspects[aspect].nest?.class)dest.aspects[aspect].enabled=source.aspects[aspect].nest;else if(source.aspects[aspect].nest)dest.aspects[aspect].nest=new adventurejs.Nest(aspect,this.game_name,dest.id).set({enabled:true});delete source.aspects[aspect].nest}else if(!dest.aspects[aspect].nest?.class)dest.aspects[aspect].nest=new adventurejs.Nest(aspect,this.game_name,dest.id).set({enabled:true});if(-1===this.game.dictionary.prepositions.indexOf(aspect))this.game.dictionary.prepositions.push(aspect);if(true===source.aspects[aspect]||false===source.aspects[aspect]){dest.aspects[aspect].enabled=source.aspects[aspect];delete source.aspects[aspect]}}for(var object=["dov","iov"],of=0;of<object.length;of++)if(source&&source[object[of]]){if(Array.isArray(source[object[of]]))dest.setObjectOfVerbs(object[of],source[object[of]]);else for(var verb in source[object[of]])dest.setVerbSubscription(object[of],{[verb]:source[object[of]][verb]});delete source[object[of]]}if(source["descriptions"]){dest["descriptions"]=A.clone.call(this.game,source["descriptions"]);delete source["descriptions"]}for(var keys=Object.keys(source),i=0;i<keys.length;i++){var prop=keys[i];if(!Object.prototype.hasOwnProperty.call(source,prop));else{if("string"==typeof source[prop]&&Array.isArray(dest[prop]))source[prop]=source[prop].toLowerCase().split(",");if(Array.isArray(source[prop])){for(var p=0;p<source[prop].length;p++)if("string"==typeof source[prop][p])source[prop][p]=source[prop][p].trim();source[prop]=source[prop].concat(dest[prop])}}}dest.set(source);return dest}})();(()=>{var p;adventurejs.Game.prototype.createAsset=function Game_createAsset(asset){if("Object"===asset.constructor.name)if(asset=this.validateAssetPrecursor(asset))asset=this.constructAsset(asset);else return false;if(this.world[asset.id]){var msg=`Warning: createAsset id ${asset.id} is used more than once. `;if("Exit"===asset.class)msg+="This could happen if you define an exit in a room's exits property and also as a separate exit asset. ";this.game.log("L1073","error",0,msg,"Game");return false}return this.world[asset.id]=asset}})();(()=>{var p;adventurejs.Game.prototype.createClass=function Game_createCustomClass(data={}){let{parent,class:CustomClass,...props}=data;var data=adventurejs[parent];if(!data);var data=class CustomClass extends data{constructor(...args){super(...args);A.deepSet.call(this.game,props,this)}};Object.defineProperty(data,"name",{value:CustomClass});return A[CustomClass]=data}})();(()=>{var p;adventurejs.Game.prototype.createCompass=function Game_createCompass(properties){return this.display.createCompass(properties)}})();(()=>{var p;adventurejs.Game.prototype.createDeferredAssets=function Game_createDeferredAssets(){for(var i=0;i<this.deferredObjects.length;i++){var newObject=this.game.createAsset(this.deferredObjects[i]);if(false===newObject)return false;if(false===newObject.validate(this))return false;newObject.is.validated=true}return true}})();(()=>{var p;adventurejs.Game.prototype.createGlobalCeilings=function Game_createGlobalCeilings(){for(var i=0;i<A.GlobalAssets.Ceilings.length;i++){var precursor=A.GlobalAssets.Ceilings[i];precursor.id="global_ceiling";precursor.class="Ceiling";var asset=this.game.createAsset(precursor).set({is:{global:true,known:true,seen:true,placeholder:true},descriptions:{look:precursor.description},exclude_from_disambiguation:true})}}})();(()=>{var p;adventurejs.Game.prototype.createGlobalConcepts=function Game_createGlobalConcepts(){this.createAsset({class:"GlobalString",id:"global_string",nameless:true});this.createAsset({class:"GlobalNumber",id:"global_number",nameless:true});this.createAsset({class:"GlobalDrawing",id:"global_drawing",nameless:true});this.createAsset({class:"GlobalTurn",id:"global_turn",nameless:true});this.createAsset({class:"GlobalMinute",id:"global_minute",nameless:true})}})();(()=>{var p;adventurejs.Game.prototype.createGlobalExits=function Game_createGlobalExits(){for(var i=0;i<A.GlobalAssets.Exits.length;i++){var precursor=A.GlobalAssets.Exits[i];precursor.class="Exit";precursor.id="global_"+precursor.direction;precursor.name=`non-existent ${precursor.direction} exit`;var description=precursor.descriptions?.look||precursor.description||"",asset=this.game.createAsset(precursor).set({is:{global:true,known:true,seen:true,placeholder:true},descriptions:{look:description},exclude_from_disambiguation:true})}}})();(()=>{var p;adventurejs.Game.prototype.createGlobalFloors=function Game_createGlobalFloors(){for(var i=0;i<A.GlobalAssets.Floors.length;i++){var precursor=A.GlobalAssets.Floors[i];precursor.id="global_floor";precursor.class="Floor";var asset=this.game.createAsset(precursor).set({is:{global:true,known:true,seen:true,placeholder:true},descriptions:{look:precursor.description},exclude_from_disambiguation:true})}}})();(()=>{var p;adventurejs.Game.prototype.createGlobalScenery=function Game_createGlobalScenery(){for(var i=0;i<A.GlobalAssets.Scenery.length;i++){var precursor=A.GlobalAssets.Scenery[i];precursor.class="Scenery";precursor.id="global_"+A.serialize(precursor.name);var description=precursor.descriptions?.look||precursor.description||"",asset=this.game.createAsset(precursor).set({is:{global:true,known:true,seen:true},descriptions:{look:description},exclude_from_disambiguation:true})}}})();(()=>{var p;adventurejs.Game.prototype.createGlobalWalls=function Game_createGlobalWalls(){for(var i=0;i<A.GlobalAssets.Walls.length;i++){var precursor=A.GlobalAssets.Walls[i];precursor.class="Wall";precursor.id=`global_${precursor.direction}_wall`;precursor.name=precursor.direction+" wall";var description=precursor.descriptions?.look||precursor.description||"",asset=this.game.createAsset(precursor).set({class:"Wall",descriptions:{look:description},enabled:precursor.enabled,is:{global:true,known:true,seen:true,placeholder:true},exclude_from_disambiguation:true})}}})();(()=>{var p;adventurejs.Game.prototype.createImageDock=function Game_createImageDock(properties){return this.display.createImageDock(properties)}})();(()=>{var p;adventurejs.Game.prototype.createImageLookup=function Game_createImageLookup(properties){if(properties.images)for(var item in properties.images)this.image_lookup[properties.images[item].id]=properties.images[item].image;return this.image_lookup}})();(()=>{var p;adventurejs.Game.prototype.createInventoryDock=function Game_createInventoryDock(properties){return this.display.createInventoryDock(properties)}})();(()=>{var p;adventurejs.Game.prototype.createPostScript=function Game_createPostScript(object){var game=this;Object.entries(object).forEach(([id,value])=>{game.post_scripts[id]=value});return object}})();(()=>{var p;adventurejs.Game.prototype.createPreScript=function Game_createPreScript(object){var game=this;Object.entries(object).forEach(([id,value])=>{game.pre_scripts[id]=value});return object}})();(()=>{var p;adventurejs.Game.prototype.createRoomDock=function Game_createRoomDock(properties){return this.display.createRoomDock(properties)}})();(()=>{var p;adventurejs.Game.prototype.createVerbDock=function Game_createVerbDock(properties){return this.display.createVerbDock(properties)}})();(()=>{var p;adventurejs.Game.prototype.debug=function Game_print(code,fx_or_type,content){code=code.trim();fx_or_type=fx_or_type.trim();content=content.trim();fx_or_type=fx_or_type.replace(".js","");let msg="";var hook=["verbaction","verbreaction","verbphase"].includes(fx_or_type.toLowerCase()),keyword=hook?fx_or_type.toLowerCase():"general",type=hook?"hook":"debug";if(!this.game.settings.debug[keyword]&&!this.game.settings.debug.all);else{msg=`<span class="ajs-${type} ajs-${fx_or_type.toLowerCase()}">`;msg+=`<span class="_0">${hook?fx_or_type:code}</span> `;if(void 0!==this.game.dictionary.verbs[fx_or_type])msg+=`<span class="_1">[${fx_or_type}]</span> `;msg=msg+`<span class="_2">${content}</span> `+"</span>";this.display.print(msg,"ajs-debug")}}})();(()=>{var p;adventurejs.Game.prototype.findSubstanceBodyOrHeld=function Game_findSubstanceBodyOrHeld(substance_id){this.game.log("L1085","log","low","game.findSubstanceBodyOrHeld > receive: "+substance_id,"Game");if("string"!=typeof substance_id)return[];var substance_id=this.game.findSubstanceContainers(substance_id,this.game.getRoom(),["Present","Known","Visible","Reservoir"]).concat(this.game.findSubstanceContainers(substance_id,this.game.getPlayer(),["Present","Known","Visible","InHands"]));this.game.log("L1086","log","high",`[findSubstanceBodyOrHeld.js] return:
" + `+JSON.stringify(substance_id),"Game");return substance_id}})();(()=>{var p;adventurejs.Game.prototype.findSubstanceContainers=function Game_getSubstanceContainers(substance_id,parent,selects=[]){this.game.log("L1076","log","high","game.findSubstanceContainers > receive: "+substance_id,"Game");if("string"!=typeof substance_id){console.warn("findSubstanceContainers received non-string",substance_id);return[]}var containers=[],contents=parent.getAllNestedContents(),i;for(i in contents){var asset=this.game.getAsset(contents[i]);if(!asset);else if(asset.containsSubstance(substance_id))containers.push(asset)}if("string"==typeof selects)selects=selects.split(" ");for(let i in selects)containers=this.parser["select"+selects[i]](containers);this.game.log("L1077","log","high",`[findSubstanceContainers.js] return:
`+containers.map(container=>container.id).join(", "),"Game");return containers}})();(()=>{var p;adventurejs.Game.prototype.findViewModifiers=function Game_findViewModifiers(){this.game.log("L1061","log","low","findViewModifiers.js","Game");var input=this.game.getInput(),adverb=input.getAdverb(),wornoptics,lightemitters,player=this.game.getPlayer(),room=this.game.getRoom();if(adverb)input.pushViewModifier(adverb,null,"input");wornoptics=player.getWornOptics();for(let i=0;i<wornoptics.length;i++)input.pushViewModifier("through",wornoptics[i],"auto");lightemitters=room.findNestedAssetsWithProperty("is.emitting_light");for(let i=0;i<lightemitters.length;i++){var light=lightemitters[i];if(light.must.hold_to_see_with&&!this.game.parser.selectInHands(light.id).length);else if(light.must.wear_to_see_with&&!this.game.parser.selectInHands(light.id).length);else input.pushViewModifier("with",lightemitters[i],"auto")}if(player.isNested())input.pushViewModifier("from",player.getNestAsset(),"auto");input.pushViewModifier("in",this.game.getRoom(),"auto");return input.view_modifiers}})();(()=>{var p;adventurejs.Game.prototype.getAreaScenery=function Game_getGlobalScenery(asset,identifier="look"){if("string"==typeof asset)asset=this.game.getAsset(asset);if(!(asset instanceof adventurejs.Asset))return"";var room=this.game.getRoom(),defined_in_room,enabled_in_room,described_in_room,defined_in_zone,enabled_in_zone,described_in_zone,defined_in_game,defined_in_room,room,defined_in_room=room.area_scenery[asset.name],described;if(void 0!==defined_in_room){enabled_in_room=defined_in_room.enabled;if(defined_in_room)described_in_room=this.game.getModifiedDescription({asset:defined_in_room,identifier:identifier,find_modifiers:true,fallback_base:false})||this.game.getDescription({asset:defined_in_room,identifier:identifier})}if(void 0!==this.game.world[room.zone])defined_in_zone=this.game.world[room.zone].area_scenery[asset.name];if(defined_in_zone){enabled_in_zone=defined_in_zone.enabled;if(defined_in_zone)described_in_zone=this.game.getModifiedDescription({asset:defined_in_zone,identifier:identifier,find_modifiers:true,fallback_base:false})||this.game.getDescription({asset:defined_in_zone,identifier:identifier})}defined_in_room=asset.enabled;room=this.game.getModifiedDescription({asset:asset,identifier:identifier,find_modifiers:true,fallback_base:false})||this.game.getDescription({asset:asset,identifier:identifier});if(false===enabled_in_room)return"";else if(true===enabled_in_room){return A.getSAF.call(this.game,described_in_room||described_in_zone||room)}else if(false===enabled_in_zone)return"";else if(true===enabled_in_zone){let described=described_in_zone||room;return A.getSAF.call(this.game,described)}else if(false===defined_in_room)return"";else if(true===defined_in_room)return A.getSAF.call(this.game,room);if(void 0===enabled_in_room&&void 0===enabled_in_zone&&void 0===defined_in_room&&(described_in_room||described_in_zone||room)){let described=described_in_room||described_in_zone||room;return A.getSAF.call(this.game,described)}return asset.Articlename_is+" indescribable. "}})();(()=>{var p;adventurejs.Game.prototype.getAsset=function Game_getAsset(identifier,params){if(identifier&&"object"==typeof identifier&&identifier.id)return identifier;if("string"!=typeof identifier){this.game.log("L1051","warn","low","Game_getAsset received invalid identifier. ","Game");return null}if(void 0===params)params={};var object,asset_aspect_substance=identifier.split(":");switch(asset_aspect_substance.length){case 3:if(void 0!==params.prefer_substance&&true===params.prefer_substance)identifier=asset_aspect_substance[2];else identifier=asset_aspect_substance[0];break;case 2:this.game.log("L1052","warn","high","Game_getAsset received invalid identifier: "+identifier,"Game");return null;default:break}if("player"===identifier)object=this.getPlayer();else if("room"===identifier)object=this.getRoom();else object=this.world[A.serialize(identifier)];if(void 0!==object)return object;else return null}})();(()=>{var p;adventurejs.Game.prototype.getDescription=function Game_getDescription({asset,identifier="look"}){let description;if("at"===identifier)identifier="look";if(asset.proxy){var proxy,proxy_description=this.game.getAsset(asset.proxy).getDescription(identifier);if(proxy_description)return proxy_description}if(!asset.descriptions)return asset.description||"";if(asset.descriptions[identifier])description=asset.descriptions[identifier];else if(asset.descriptions["look"]&&asset.descriptions["look"][identifier])description=asset.descriptions["look"][identifier];else if(asset.descriptions["look"])description=asset.descriptions["look"];else if(!asset.descriptions)description=asset.description;if(description){if(Array.isArray(description)||"object"==typeof description&&description.array||"string"==typeof description||"function"==typeof description)return A.getSAF.call(this.game,description,asset);if("object"==typeof description&&description.default)return A.getSAF.call(this.game,description.default,asset)}return""}})();(()=>{var p;adventurejs.Game.prototype.getDirections=function Game_getDirections(){return this.getAsset(this.world._room).getDirections()}})();(()=>{var p;adventurejs.Game.prototype.getExitFromDirection=function Game_getExitFromDirection(direction){var exit=false;if(void 0!==this.game.world[this.game.world._room+"_"+direction])exit=this.game.world[this.game.world._room+"_"+direction];else if(void 0!==this.game.world["global_"+direction])exit=this.game.world["global_"+direction];return exit}})();(()=>{var p;adventurejs.Game.prototype.getExits=function Game_getExits(){return this.getAsset(this.world._room).getExits()}})();(()=>{var p;adventurejs.Game.prototype.getExtendedExitName=function Game_getExtendedExitName(exit,destination){var output=`<span class="ajs-exit-direction">${exit.direction}</span>`,player=this.game.getPlayer(),preposition=" to ",definite_article=destination.definite_article,destName=destination.name,addDest=true,room=this.game.getRoom(),settings=this.settings;if(false===settings.show_room_names_in_exit_descriptions||false===room.show_room_names_in_exit_descriptions)addDest=false;if(!player.knowsAbout(destination)&&(settings.show_room_names_in_exit_descriptions_only_when_room_is_known||room.show_room_names_in_exit_descriptions_only_when_room_is_known))addDest=false;if(!exit.is.used&&(settings.show_room_names_in_exit_descriptions_only_after_exit_has_been_used||room.show_room_names_in_exit_descriptions_only_after_exit_has_been_used))addDest=false;if(addDest)output+=` to  ${definite_article?definite_article+" ":""} 
        <span class="ajs-exit-destination">${destName}</span>`;return output}})();(()=>{var p;adventurejs.Game.prototype.getInput=function Game_getInput(){return this.parser.input_history[0]}})();(()=>{var p;adventurejs.Game.prototype.getLastTurn=function Game_getLastTurn(){return this.parser.input_history[1]}})();(()=>{var p;adventurejs.Game.prototype.getLongestLookup=function Game_getLongestLookup(){for(var lookupKeys=Object.keys(this.game.world_lookup),maxwords=0,l=0;l<lookupKeys.length;l++){var length=lookupKeys[l].split(" ").length;if(maxwords<length)maxwords=length}this.game.longest_lookup=maxwords}})();(()=>{var p;adventurejs.Game.prototype.getModifiedDescription=function Game_getModifiedDescription({asset,identifier="look",find_modifiers,fallback_base,append_base,prepend_base}){let msg="";if("at"===identifier)identifier="look";if(asset.proxy){var proxy=this.game.getAsset(asset.proxy);if(proxy){var proxy=this.game.getModifiedDescription({asset:proxy,identifier:identifier,find_modifiers:find_modifiers,fallback_base:fallback_base});if(proxy)return proxy}}var input=this.game.getInput();if(!asset.descriptions)return asset.description?asset.description:"";if(void 0===asset.descriptions[identifier]){if("look"===identifier||!asset.descriptions.look)return"";if(void 0===asset.descriptions.look[identifier])return"";input.pushViewModifier(identifier,null,"input");identifier="look"}if(find_modifiers)this.game.findViewModifiers();if(0===input.view_modifiers.length);else{for(let index=0;index<input.view_modifiers.length;index++){var indirect_identifier=input.view_modifiers[index].identifier,indirect_asset=input.view_modifiers[index].asset,indirect_aspects;if(!indirect_identifier||!indirect_asset);else{indirect_aspects=[indirect_identifier];if("with"===indirect_identifier&&indirect_asset.hasQuirk("look_with_means_look_through"))if(!indirect_aspects.includes("through"))indirect_aspects.push("through");if("through"===indirect_identifier&&indirect_asset.hasQuirk("look_with_means_look_through"))if(!indirect_aspects.includes("with"))indirect_aspects.push("with");if("in"===indirect_identifier&&indirect_asset.hasQuirk("in_means_on"))if(!indirect_aspects.includes("on"))indirect_aspects.push("on");for(let i=0;i<indirect_aspects.length;i++){let indirect_identifier=indirect_aspects[i];var target=indirect_identifier+" "+indirect_asset.name;if(!input.view_modifiers[index].equivalencies)input.view_modifiers[index].equivalencies=[];if(!input.view_modifiers[index].equivalencies.includes(target))input.view_modifiers[index].equivalencies.push(target)}}}var provided_modifier_targets=[];for(let index=0;index<input.view_modifiers.length;index++)provided_modifier_targets.push(input.view_modifiers[index].equivalencies);var expanded_modifier_targets=A.generateCombinations(provided_modifier_targets);if("string"==typeof asset.descriptions[identifier])return asset.descriptions[identifier];var comparisons=[],description_keys=Object.keys(asset.descriptions[identifier]);for(let i=0;i<expanded_modifier_targets.length;i++)for(let j=0;j<description_keys.length;j++)if(description_keys[j].split(",").length>expanded_modifier_targets[i].split(",").length);else{var count=A.countCommonElements(expanded_modifier_targets[i],description_keys[j]);comparisons.push({view_modifiers:expanded_modifier_targets[i],description:description_keys[j],count:count})}var maxstack=this.game.settings.max_level_of_modified_descriptions_to_stack,stacked_descriptions=[];let highestcount=-1;var highestindex=-1,description_length;for(let i=0;i<comparisons.length;i++){let count=comparisons[i].count;if(count===comparisons[i].description.split(",").length&&count>highestcount){highestcount=comparisons[i].count;highestindex=i}}for(let i=0;i<comparisons.length;i++){let count=comparisons[i].count,description_length=comparisons[i].description.split(",").length;if(count<=maxstack&&count===description_length&&count===highestcount)stacked_descriptions.push(comparisons[i]);if(count>maxstack&&0===stacked_descriptions.length)stacked_descriptions.push(comparisons[i])}if(-1<highestcount){let modifiers_sets="";var best_descriptions=[];for(let i=0;i<stacked_descriptions.length;i++){best_descriptions.push(asset.descriptions[identifier][stacked_descriptions[i].description]);if(modifiers_sets.length)modifiers_sets+=",";modifiers_sets+=stacked_descriptions[i].description}var modifiers=modifiers_sets.split(",").map(item=>item.trim()),user_modified=false;for(let i=0;i<modifiers.length;i++){var modifier=modifiers[i];if(!modifier.length);else for(let j=0;j<input.view_modifiers.length;j++)if(input.view_modifiers[j].string===modifier){input.view_modifiers[j].used=true;if("input"===input.view_modifiers[j].type);}}for(let i=0;i<best_descriptions.length;i++)msg+=A.getSAF.call(this.game,best_descriptions[i],asset);if(prepend_base||this.game.settings.concatenate_descriptions)msg=this.getDescription({asset:asset,identifier:identifier})+msg;if(append_base)msg=this.getDescription({asset:asset,identifier:identifier})+msg;return msg}}return""}})();(()=>{var p;adventurejs.Game.prototype.getPlayer=function Game_getPlayer(){return this.getAsset(this.world._player)}})();(()=>{var p;adventurejs.Game.prototype.getPrintableObjectList=function Game_getPrintableObjectList({article,objects,exclusions}){this.game.log("L1074","log","high",`[getPrintableObjectList.js] getPrintableObjectList() receive:
`+objects.map(a=>a.id).join(", "),"Game");var list="",definite=false;if("definite"===article)definite=true;if(void 0!==exclusions){if("string"==typeof exclusions)exclusions=[exclusions];objects=objects.filter(function(objects){return exclusions.indexOf(objects)<0})}for(var i=0;i<objects.length;i++){var object=this.getAsset(objects[i]);if(0<i&&i<objects.length-1)list+=", ";if(1<objects.length&&i===objects.length-1)list+=" and ";list+=definite?object.definite_name:object.indefinite_name}return list}})();(()=>{var p;adventurejs.Game.prototype.getRoom=function Game_getRoom(){return this.getAsset(this.world._room)}})();(()=>{var p;adventurejs.Game.prototype.getRoomExits=function Game_getRoomExits(room=this.world[this.world._room]){var exits=Object.keys(room.exits),exitID,exit,destinationID,destination,closed=[],output="";if(room.hasDescription("exits"))return`<span class="ajs-room-exits">${A.getSAF.call(this.game,room.descriptions.exits)}</span>`;for(var i=exits.length-1;-1<i;i--){var exitID=room.exits[exits[i]],exit=this.world[exitID],destinationID;if(void 0===this.world[exit.destinationID])exits.splice(i,1);if(exit.is.closed){closed.push(exit);exits.splice(i,1)}}if(!exits.length&&!closed.length)return false;if(exits.length)output+="{We} can go ";for(var i=0;i<exits.length;i++){exitID=room.exits[exits[i]];exit=this.world[exitID];destination=this.world[exit.destinationID];if(1<exits.length&&i===exits.length-1)output+="or ";var for_exits_list=A.getSAF.call(this.game,exit.descriptions.for_exits_list);if(for_exits_list)output+=`<span class="ajs-custom-exit-name">${for_exits_list}</span>`;else output+=`<span class="ajs-extended-exit-name">${this.getExtendedExitName(exit,destination)}</span>`;if(i===exits.length-1)output+=". ";else output+=", "}if(closed.length){output+=`${1<closed.length?"Ways ":"A way "} `;for(var i=0;i<closed.length;i++){var lookup=this.game.dictionary.direction_lookup[closed[i].direction];if(0<i&&i<closed.length-1)output+=", ";if(1<closed.length&&i===closed.length-1)output+=" and ";if(0===i&&lookup.article)output+=`to ${lookup.article} `;output+=closed[i].direction}output+=`${1<closed.length?" are":" is"} blocked. `}return`<span class="ajs-room-exits">${output}</span>`}})();(()=>{var p;adventurejs.Game.prototype.getRoomFloor=function Game_getCurrentRoomFloor(room=this.world[this.world._room]){var floor,room=room.findNestedAssetsWithClass("Floor");if(room.length)floor=room[0];else floor=this.game.getAsset("global_floor");return floor||null}})();(()=>{var p=adventurejs.Game.prototype;p.getSubject=p.$subject=function Game_getSubject(){return this.getInput().getSubject()}})();(()=>{var p=adventurejs.Game.prototype;p.getVerifiedSentence=p.$verified=function Game_getVerifiedSentence(){return this.parser.input_history[0].verified_sentence}})();(()=>{var p;adventurejs.Game.prototype.getWordCount=function Game_getWordCount(){let unique_words=[],keys=Object.keys(this.world_lookup);for(var index in keys){var key,words=keys[index].split(" "),ind;for(ind in words){var word=words[ind];if(-1===word.indexOf("_")&&-1===unique_words.indexOf(word))unique_words.push(word)}}for(let index in keys=Object.keys(this.dictionary.verb_lookup)){let word=keys[index];if(-1===unique_words.indexOf(word))unique_words.push(word);var sins=this.dictionary.verb_lookup[word].synonyms,s;for(s in sins){var sin=sins[s];if(-1===unique_words.indexOf(sin))unique_words.push(sin)}}return unique_words=(unique_words=(unique_words=unique_words.concat(this.dictionary.adjectives)).concat(this.dictionary.adverbs)).concat(this.dictionary.prepositions)}})();(()=>{var p;adventurejs.Game.prototype.hasVerb=function Game_hasVerb(verb){return this.game.dictionary.verbs[verb]?true:false}})();(()=>{var p;adventurejs.Game.prototype.initializeAssets=function Game_initializeAssets(){for(var prop in this.world)if("_"===prop.charAt(0));else{if(void 0===this.world[prop].initialize){console.warn("initialize() not found on "+this.world[prop].constructor.name+" "+this.world[prop].name);return false}var initializedProp;if(!this.world[prop].initialize(this)){console.warn("Failed to initialize "+this.world[prop].constructor.name+" "+this.world[prop].name);return false}this.world[prop].set({is:{initialized:true}})}return true}})();(()=>{var p;adventurejs.Game.prototype.log=function Game_log(code,method,level,msg,keyword){if("string"!=typeof keyword)keyword="";var hook=["verbaction","verbreaction","verbphase"].includes(keyword.toLowerCase()),levels,methods;if(this.game.settings.log_level<0);else if("log"===method&&!this.game.settings.log[keyword.toLowerCase()]&&!this.game.settings.log.all);else{if("string"==typeof level)level=["critical","high","medium","low"].indexOf(level);if(level>this.game.settings.log_level);else{if(null==method)method="log";if("number"==typeof method)method=["log","warn","error"][method];if(Array.isArray(msg))msg=msg.join(" ");let src="";var level=msg.match(/^\[[^\]]+\]\s*/);if(level)src=level[0];if(src)msg=msg.replace(/^\[[^\]]+\]\s*/,"");msg=msg.replace("⤷","");if(!this.game.settings.include_filename_in_log)src="";var level="#36e400",yellow,red,orange="#ff9700",hookcolors={verbphase:"#31f0bf",verbaction:"#4fcbff",verbreaction:"#83a9fb"};let codecolor=level;if("warn"===method)codecolor="#e5d254";else if("error"===method)codecolor="#ef866d";else if("debug"===keyword.toLowerCase())codecolor=orange;else if(hook)codecolor=hookcolors[keyword.toLowerCase()];var orange=[level].includes(codecolor)?"#FFF":codecolor,hook=codecolor,line="",hookcolors=" color: #4a3532; font-weight: bold; padding: 3px 5px; ",level=`background: ${codecolor}; ${hookcolors} margin: 0 -2px 4px 0;`,tagstyle,srcstyle,msgstyle;if("error"!==method)method="log";if(void 0!==console[method])console[method](`%c${code}%c %c${keyword}%c %c${src}%c%c${msg}%c`,level,"",`background: ${hook}; ${hookcolors} margin: 0 0 0px 0; `,"","color: #bbb;","",`color: ${orange}; ${""} margin-bottom: 0px; `,"")}}}})();(()=>{var p;adventurejs.Game.prototype.play=function Game_play(){var fx="play.js",startPlayTime=(new Date).getTime();this.game.log("L1054","log",1,`[${fx}] Validating objects.`,"Game");this.game_state=this.game_states.VALIDATE_ASSETS;this.game.log("L1468","log","high",`[${fx}] game_state = VALIDATE_ASSETS`,"Game");if(!this.validateAssets())return false;this.game.log("L1055","log",1,`[${fx}] Creating deferred objects.`,"Game");this.game_state=this.game_states.CREATE_DEFERRED_ASSETS;this.game.log("L1469","log","high",`[${fx}] game_state = CREATE_DEFERRED_ASSETS`,"Game");if(!this.createDeferredAssets())return false;this.game.log("L1056","log",1,`[${fx}] Initializing objects.`,"Game");this.game_state=this.game_states.INITIALIZE_ASSETS;this.game.log("L1470","log","high",`[${fx}] game_state = INITIALIZE_ASSETS`,"Game");if(!this.initializeAssets())return false;this.game.log("L1057","log",1,`[${fx}] Sorting lookup values.`,"Game");this.game_state=this.game_states.SORT_LOOKUP_VALUES;this.game.log("L1471","log","high",`[${fx}] game_state = SORT_LOOKUP_VALUES`,"Game");this.sortLookupValues();this.getLongestLookup();this.game_state=this.game_states.SET_DEFAULT_ASSETS;this.game.log("L1472","log","high",`[${fx}] game_state = SET_DEFAULT_ASSETS`,"Game");if(0===this.room_lookup.length){this.createAsset({class:"Room",name:"Empty Room",descriptions:{look:"The emptiest room {we've} ever seen.",brief:"The emptiest room ever.",verbose:"This is, by far, the emptiest room {we've} ever seen."}});this.game.world.empty_room.validate();this.game.world.empty_room.initialize()}if(!this.world._player){this.createAsset({class:"Player",name:"Unnamed Hero",is:{active:true},place:{in:this.room_lookup[0]}});this.game.world.unnamed_hero.validate();this.game.world.unnamed_hero.initialize()}this.game_state=this.game_states.INIT_PLAYER;this.game.log("L1473","log","high",`[${fx}] game_state = INIT_PLAYER`,"Game");var player=this.getPlayer(),startRoom=(this.getInput().setCharacter(player),player.getPlaceAsset()),params={};player.is.active=true;if(player.isNested()){var nestprep=player.getNestPreposition(),nestobject=player.getNestAsset();params.nestobject=nestobject;params.nestprep=nestprep}if(!startRoom)startRoom=this.getAsset(this.room_lookup[0]);this.setRoom(startRoom,params);this.updateDisplayInventory();player.knows_about=Object.assign(player.knows_about,this.game.knows_about);player.has_seen=Object.assign(player.has_seen,this.game.has_seen);this.scorecard.updateScore();this.game_state=this.game_states.SAVE_BASELINE;this.game.log("L1474","log","high",`[${fx}] game_state = SAVE_BASELINE`,"Game");this.baseline.world=A.clone.call(this,this.world);this.game.log("L1058","log","high",`[${fx}] READY! Startup took ${((new Date).getTime()-startPlayTime)/1e3} seconds.`,"Game");this.game_state=this.game_states.PLAYING;this.game.log("L1475","log","high",`[${fx}] game_state = PLAYING`,"Game");this.game.knows_about=null;this.game.has_seen=null;return this}})();(()=>{var p;adventurejs.Game.prototype.print=function Game_print(msg="",classes=""){if(this.input?.printer?.override.length){msg=this.input.printer.override.join(" ");this.input.printer.overrode=this.input.printer.overrode.concat(this.input.printer.override);this.input.printer.override=[]}if(this.input?.printer?.prepend.length){msg=this.input.printer.prepend.join(" ")+" "+msg;this.input.printer.prepended=this.input.printer.prepended.concat(this.input.printer.prepend);this.input.printer.prepend=[]}if(this.input?.printer?.append.length){msg+=" "+this.input.printer.append.join(" ");this.input.printer.appended=this.input.printer.appended.concat(this.input.printer.appended);this.input.printer.append=[]}if(!msg);else{msg=(msg=(msg=(msg=(msg=(msg=(msg=(msg=msg.replace(/  +/g," ")).replace(/ outfrombehind /g," out from behind ")).replace(/ outfromunder /g," out from under ")).replace(/ infront /g," in front ")).replace(/ frombehind /g," from behind ")).replace(/ fromin /g," from in ")).replace(/ fromon /g," from on ")).replace(/ fromunder /g," from under ");this.game.log("L1088","log","high",msg,"Print");if(msg=A.handlePlaceholders.call(this,msg))return this.display.print(msg,classes)}}})();(()=>{var p;adventurejs.Game.prototype.printAreaEvents=function Game_printRoomZoneEvents(e){this.game.log("L1071","log","low","printAreaEvents","Game");if(this.game.getInput().soft_prompt.enabled);else if(this.game.getInput().disambiguate.enabled);else if(!this.game.settings.quiet&&this.game.settings.respect_quiet);else{var room=this.game.getRoom(),area_events,msg="",source,rand;if(false===this.game.settings.enable_events);else{if(void 0!==room.area_events){source=room.id+".area_events";area_events=room.area_events}else if(void 0!==room.zone&&void 0!==this.game.world[room.zone]&&void 0!==this.game.world[room.zone].area_events){source=room.id+".zone.area_events";area_events=this.game.world[room.zone].area_events}if(area_events&&area_events.array){if(void 0===area_events.use_saf)area_events.use_saf=true;if(void 0===area_events.randomize)area_events.randomize=this.game.settings.randomize_arrays_in_getStringArrayFunction;if(void 0===area_events.index)area_events.index=0;if(void 0===area_events.frequency)area_events.frequency=0;if(area_events.frequency<1){if(Math.random(1)>area_events.frequency)return}source=(source=(source+=", randomize "+area_events.randomize)+(", index "+area_events.index))+(", frequency "+area_events.frequency);this.game.log("L1072","log","high","[printAreaEvents.js] found zone events in "+source,"Game");if(msg+=A.getSAF.call(this.game,area_events))this.game.print(msg)}}}}})();(()=>{var p;adventurejs.Game.prototype.printInferred=function Game_printInferred(msg="",classes=""){var input=this.game.getInput();if(!this.game.settings.print_inferred);else if("all"===input.getNoun(1));else if("all"===input.parsed_input);else if(input.parsed_input.includes(","));else if(input.verified_sentence.phrase1?.parsedNoun?.isPlural);else if(0<this.game.parser.input_queue.length);else{if(!classes.includes("ajs-inferred"))classes+=" ajs-inferred";if(msg)msg=`(${msg})`;if(msg)this.game.print(msg,classes)}}})();(()=>{var p;adventurejs.Game.prototype.printInput=function Game_printInput(input){this.display.printInput(input)}})();(()=>{var p;adventurejs.Game.prototype.printPlayerInventory=function Game_printPlayerInventory(){var player=this.game.getPlayer(),nest_preposition=player.getNestPreposition(),nest_parent_id=player.getNestId(),nest_parent_object=player.getNestAsset(),output="",carried=[],openCarried=[],worn=[],riding=[],holding=[],carriedtied=[],holdingtied=[],handsempty=true,contents=player.aspects.in.contents,holding=player.getVerbConnections("hold","to_dov");if(0===contents.length)output+="{We're} not carrying anything. ";for(var i=0;i<contents.length;i++)if(this.game.getAsset(contents[i]).is.worn)worn.push(contents[i]);else if(this.game.getAsset(contents[i]).isDOV("ride")&&contents[i]===nest_parent_id)riding.push(contents[i]);else carried.push(contents[i]);if(0<riding.length)for(var i=0;i<riding.length;i++){var object=this.game.getAsset(riding[i]);output+="{We're} "+player.getPostureGerund()+" "+nest_preposition+" "+object.articlename+". "}if(0<carried.length){handsempty=false;output+="{We're} carrying ";for(var i=0,object;i<carried.length;i++){if((object=this.game.getAsset(carried[i])).hasAspectAt("in")&&0<object.aspects.in.contents.length&&false===object.is.closed)openCarried.push(object.id);if(object.getVerbConnectionCount("tie","to_iov"))carriedtied.push(object.id)}output=output+this.game.getPrintableObjectList({objects:carried})+". "}if(0<carriedtied.length)for(var i=0;i<carriedtied.length;i++)var object,output=(output+=(object=this.game.getAsset(carriedtied[i])).Articlename+" {we're} carrying is tied to ")+this.game.getPrintableObjectList({objects:object.is.connected_by.tie.to_dov,article:"definite"})+". ";if(0<holding.length){for(var i=0,object;i<holding.length;i++){if(0<(object=this.game.getAsset(holding[i])).getVerbConnectionCount("tie","to_iov"))holdingtied.push(object.id)}handsempty=false;output=(output+="{We're} holding ")+this.game.getPrintableObjectList({objects:holding})+". "}if(0<holdingtied.length)for(var i=0,object;i<holdingtied.length;i++){output=(output+=(object=this.game.getAsset(holdingtied[i])).Articlename+" {we're} holding is tied to ")+this.game.getPrintableObjectList({objects:object.is.connected_by.tie.to_iov,article:"definite"})+". "}if(handsempty)output+="{Our} hands are empty. ";if(0<openCarried.length)for(var i=0,object;i<openCarried.length;i++){output=(output+=(object=this.game.getAsset(openCarried[i])).Articlename+" {we're} carrying contains ")+this.game.getPrintableObjectList({objects:object.aspects.in.contents})+". "}if(0<worn.length){output+="{We're} wearing ";for(var i=0;i<worn.length;i++){var object=this.game.getAsset(worn[i]);if(1<worn.length&&i===worn.length-1)output+=" and ";output=(output+=object.indefinite_article)+" "+object.name;if(object.is.closed)output+=", which is closed";if(object.isDOV("close")&&object.hasAspectAt("in")&&0<object.aspects.in.contents.length)output=(output+=", which contains ")+this.game.getPrintableObjectList({objects:object.aspects.in.contents});if(i===worn.length-1)output+=". ";if(i!==worn.length-1&&2<worn.length)output+=", "}}this.print(output)}})();(()=>{var p;adventurejs.Game.prototype.printRoom=function Game_printRoom(params={}){this.game.log("L1083","log",1,`[printRoom.js] print ${this.world._room} description`,"Game");var{verbose=false,room=this.world[this.world._room]}=params,player=this.game.getPlayer(),desc="description",v=this.settings.verbosity,msg="";if(room.is.dark&&this.game.settings.name_for_dark_rooms)this.print(this.game.settings.name_for_dark_rooms,"ajs-dark-room ajs-room-name");else this.print(room.name,"ajs-room-name");if(params.verbose||!player.hasSeen(room)&&this.settings.print_verbose_room_descriptions_on_first_visit)v=1;if(1===v&&!room.descriptions.verbose)v=0;if(-2===v&&!room.descriptions.briefer)v=-1;if(-1===v&&!room.descriptions.brief)v=0;switch(v){case-2:desc="briefer";break;case-1:desc="brief";break;case 1:desc="verbose";break;default:desc="look";break}if(room.is.dark)desc="dark";if(void 0===room.descriptions[desc])desc="look";msg+=this.game.getModifiedDescription({asset:room,identifier:desc,find_modifiers:true,fallback_base:false})||this.game.getDescription({asset:room,identifier:desc});var params="",params=this.print(msg,`${room.is.dark?"ajs-dark-room":""} ajs-room-description`),item;console.warn({description:params});let dockmsg=`<div class="ajs-room-description-container">${params}</div>`,exits="";if(this.game.settings.print_room_exits&&!room.is.dark)exits=this.printRoomExits();if(exits)dockmsg+=`<div class="ajs-exits-container">${exits}</div>`;let contents="";if(this.game.settings.print_room_contents&&!room.is.dark)contents=this.printRoomContents();if(contents)dockmsg+=`<div class="ajs-contents-container">${contents}</div>`;dockmsg=`<div class="ajs-roomdock-output ajs-output">${dockmsg}</div>`;for(item in this.display.roomdocks){var dock=this.display.roomdocks[item];console.warn({dock:dock});dock.innerHTML=dockmsg}return this}})();(()=>{var p;adventurejs.Game.prototype.printRoomContents=function Game_printRoomContents(room=this.world[this.world._room]){this.game.log("L1050","log",1,`[printRoomContents.js] print ${this.world._room} contents`,"Game");var roomContentsByID=A.clone.call(this.game,room.getAllContents()),listableObjects=[],objectsWithListableContents=[],objectsTiedToOtherThings=[],output="",player=this.game.getPlayer();roomContentsByID.splice(roomContentsByID.indexOf(this.world._player),1);for(let i=roomContentsByID.length-1;-1<i;i--){let object=this.game.getAsset(roomContentsByID[i]);if(!object)this.game.log("L1053","warn","critical","[printRoomContents.js] found an undefined object in room "+room.name,"Game");else if(object.is.hidden);else{if(object.is.listed)listableObjects.push(object);if(object.hasListableContents())objectsWithListableContents.push(object)}}if(!listableObjects.length&&!objectsWithListableContents.length)return false;if(0<listableObjects.length)output+="{We} can see ";for(var i=0;i<listableObjects.length;i++){var object=listableObjects[i];if(1<listableObjects.length&&i===listableObjects.length-1)output+=" and ";output+=object.indefinite_article+" ";let name=A.getSAF.call(this,object.name);if(object.print_bold)name=`<strong>${name}</strong>`;if(object.print_italic)name=`<em>${name}</em>`;if(object.print_style)name=`<span class="${object.print_style}">${name}</span>`;output+=name;if(object.getVerbConnectionCount("tie","to_iov")){objectsTiedToOtherThings.push(object);output+=" (tied to "+this.game.getPrintableObjectList({objects:object.is.connected_by.tie.to_iov})+")"}if(i===listableObjects.length-1)output+=" here. ";else output+=", "}if(0<objectsWithListableContents.length)for(var i=0;i<objectsWithListableContents.length;i++)output+=objectsWithListableContents[i].getPrintableListOfContents({caller:"room"});if(output)output=this.print(output);return output}})();(()=>{var p=adventurejs.Game.prototype;p.printRoomExits=p.printExits=function Game_printRoomExits(room=this.world[this.world._room]){var exits="",exits=this.getRoomExits();return exits=this.print(exits)}})();(()=>{var p;adventurejs.Game.prototype.printWithInput=function Game_printWithInput(msg,classes){this.display.printWithInput(msg,classes)}})();(()=>{var p;adventurejs.Game.prototype.removePostScript=function Game_removePostScript(key){if(this.post_scripts[key])delete this.post_scripts[key]}})();(()=>{var p;adventurejs.Game.prototype.removePreScript=function Game_removePreScript(key){if(this.pre_scripts[key])delete this.pre_scripts[key]}})();(()=>{var p;adventurejs.Game.prototype.set=function Game_set(props){if(null!=props)for(var n in props)this[n]=props[n];return this}})();(()=>{var p;adventurejs.Game.prototype.setAreaScenery=function Game_setAreaScenery(globals){for(var globalsKeys=Object.keys(globals),i=0;i<globalsKeys.length;i++){var id=globalsKeys[i],global_id=id.startsWith("global_")?id:"global_"+id,id=globals[id],global_id=this.game.world[global_id],see,msg,description;if(void 0===global_id){this.game.log("L1084","warn","critical","setAreaScenery received an id for which there is no global object. "+"See adventurejs.Game#setAreaScenery for info about setting area scenery. ","Game")}else{if(id.descriptions&&id.descriptions.look)description=id.descriptions.look;else if(id.description)description=id.description;else description="";var id=id.enabled;if(void 0!==global_id){global_id.descriptions.look=description;global_id.enabled=id}}}return this}})();(()=>{var p;adventurejs.Game.prototype.setRoom=function Game_setRoom(newRoom,params={}){if("string"==typeof newRoom)newRoom=this.game.getAsset(newRoom);if(!newRoom){this.game.log("L1522","warn","high","[setRoom.js] received invalid room "+newRoom,"Game");return false}this.game.log("L1059","log","high","[setRoom.js] "+newRoom.name,"Game");var output_class="";if(params.output_class)output_class=params.output_class;var currentRoomID=this.world._room,currentRoomObj=this.world[currentRoomID],input=this.getInput(),player=this.getPlayer(),subject=input.getSubject()||this.getPlayer(),input=subject.id===player.id,player=subject.getNestAsset(),results,msg;if(subject.has_tied_things_that_drag_on_travel)var dragged_things=subject.getTiedThingsThatDragOnTravel();if(""!==currentRoomID&&void 0!==currentRoomObj&&void 0!==Object.keys(currentRoomObj)&&0<Object.keys(currentRoomObj).length){if(void 0!==(results=currentRoomObj.onRemoveThatFromThis(subject)))return results;if(subject.isNested()&&player.isDOV("ride"));if(void 0!==dragged_things)for(var i=0,dragged_thing,results;i<dragged_things.length;i++){if(void 0!==(results=(dragged_thing=this.game.getAsset(dragged_things[i])).getPlaceAsset().onRemoveThatFromThis(dragged_thing)))return results}}if(void 0!==(results=newRoom.onMoveThatToThis(subject,"in")))return results;subject.knowAsset(newRoom,true);subject.seeAsset(newRoom,true);subject.position=Object.assign(subject.position,newRoom.aspects.in.nest.initial_position);if(subject.isNested()&&player.isDOV("ride"));if(void 0!==dragged_things)for(var i=0;i<dragged_things.length;i++){var dragged_thing=this.game.getAsset(dragged_things[i]);if(void 0!==(results=newRoom.onMoveThatToThis(dragged_thing,"in")))return results}if(input)this.world._room=newRoom.id;if(params.nestobject&&params.nestprep){results=subject.onNestThisToThat(params.nestobject,params.nestprep);if(A.isFalseOrNull(results))this.game.log("L1060","error","high",`[setRoom.js] onNestThisToThat failed to nest ${subject.id} in params.nestobject.id. `,"Game")}if(!input){if(msg)this.game.print(msg,output_class)}else{this.updateDisplayRoom();this.updateDisplayCompasses();for(var directions=Object.keys(newRoom.exits),i=0;i<directions.length;i++){var exit=this.getAsset(newRoom.id+"_"+directions[i]);subject.knowAsset(exit);subject.seeAsset(exit)}if(void 0!==this.parser.input_queue[0]&&void 0!==this.parser.input_queue[0].excludeRoomDescriptions&&this.parser.input_queue[0].excludeRoomDescriptions);else{if(void 0!==dragged_things)for(var i=0;i<dragged_things.length;i++){var dragged_thing,rope_asset=(dragged_thing=this.game.getAsset(dragged_things[i])).getThingThisIsTiedToPlayerBy(),msg="{We} drag "+dragged_thing.articlename+" along";if(void 0!==rope_asset)msg+=" at the end of "+rope_asset.articlename;msg+=". "}if(msg)this.game.print(msg,output_class);this.printRoom()}}}})();(()=>{var p;adventurejs.Game.prototype.setStyle=function Game_setRoom(style={}){let sheet=document.styleSheets[0];if(!sheet){var styleEl=document.createElement("style");document.head.appendChild(styleEl);sheet=styleEl.sheet}this.game.log("L1572","log","high","[setStyle.js] setStyle()","Game");for(var selector in style){var declarations=style[selector],declarations=Object.entries(declarations).map(([prop,value])=>prop+`: ${value};`).join(" ");try{sheet.insertRule(selector+` { ${declarations} }`,sheet.cssRules.length)}catch(err){this.game.log("L1573","error","high",`[setStyle.js] setStyle() insertRule failed
${selector}: { ${declarations} }`,"Verbs");console.error("insertRule failed",selector,declarations,err)}}}})();(()=>{var p;adventurejs.Game.prototype.sortLookupValues=function Game_sortLookupValues(){for(var prop in this.game.world_lookup){var lookupValue=this.game.world_lookup[prop].IDs;if(1<lookupValue.length){for(var sortedLookupValues=[],wordCount=0,i=0,length;i<lookupValue.length;i++){if(wordCount<(length=lookupValue[i].split("_").length))wordCount=length}for(var w=wordCount;0<w;w--)for(var i=0,length;i<lookupValue.length;i++){if((length=lookupValue[i].split("_").length)===w)sortedLookupValues.push(lookupValue[i])}this.game.world_lookup[prop].IDs=sortedLookupValues}}}})();(()=>{var p;adventurejs.Game.prototype.tryTravel=function Game_tryTravel(direction,params={}){var fx="qualifyParsedNoun.js";this.game.log("L1078","log","high",`[${fx}] `+(direction.direction||direction),"Travel");if(direction.direction)direction=direction.direction;var input=this.game.getInput(),subject=input.getSubject(),room=this.getRoom(),nest_asset=subject.getNestAsset(),nest_preposition=subject.getNestPreposition(),nest_aspect=subject.getNestAspect(),exit_id=room.exits[direction],currentZone,global_object,msg="",results,exits,exits;input.did.tryTravel=true;if(!exit_id){this.game.debug("D1115",fx,"exit_id is undefined");var global_object=this.game.world["global_"+direction],global_description,currentZone=this.game.world[room.zone],exits;if(room.area_scenery[global_object.name]?.enabled&&room.area_scenery[global_object.name]?.description){this.game.log("L1491","log","high",`[${fx}] use ${room.id}.area_scenery.${global_object.name} for description`,"Travel");global_description=room.area_scenery[global_object.name].description}else if(currentZone?.area_scenery[global_object.name]?.enabled&&currentZone?.area_scenery[global_object.name]?.description){this.game.log("L1491","log","high",`[${fx}] use ${currentZone.id}.area_scenery.${global_object.name} for description`,"Travel");global_description=currentZone.area_scenery[global_object.name].description}else if(room.area_scenery[global_object.name]?.enabled&&global_object.description){this.game.log("L1493","log","high",`[${fx}] use ${global_object.name}.description for description`,"Travel");global_description=global_object.description}if(global_description)msg+=A.getSAF.call(this.game,global_description);if(this.settings.when_travel_fails_list_exits||this.world[this.world._room].when_travel_fails_list_exits){this.game.debug("D1120",fx,` 
          `+(this.world[this.world._room].when_travel_fails_list_exits?this.world._room+".when_travel_fails_list_exits":this.game_name+".settings.when_travel_fails_list_exits"));if(exits=this.getRoomExits())msg+=" "+exits}this.print(msg,input.output_class);return null}currentZone=this.game.getAsset(exit_id);global_object=this.game.getAsset(currentZone.aperture);this.game.log("L1079","log","high",`[${fx}] found exit: ${currentZone.id} `+(global_object?"with aperture: "+global_object.id:""),"Travel");if(!currentZone){this.game.debug("D1104",fx," no exit found matching "+exit_id);this.print(msg+="That doesn't appear to be an exit. ",input.output_class)}else{if(subject.is.constrained){this.game.debug("D1103",fx,"subject.is.constrained");msg+=A.getSAF.call(this.game,subject.constrained_msg)||"{We} can't go anywhere. ";this.game.print(msg,input.output_class);return null}if(0<subject.getVerbConnectionCount("hold","to_dov")){this.game.debug("D1133",fx,` ${subject.id}.is.connected_by.hold.to_dov contains `+subject.is.connected_by.hold.to_dov);msg+=`{We'll} have to let go of ${this.game.getPrintableObjectList({objects:subject.getVerbConnections("hold","to_dov")})}. `;this.game.print(msg,input.output_class);return null}if(subject.isOnFloor()&&this.game.settings.on_floor_blocks_travel){this.game.debug("D1215",fx,` ${subject.id}.isOnFloor and game.settings.on_floor_blocks_travel is true `);msg+=`{We} c