/* global adventurejs A */
var MyGame = new adventurejs.Game("MyGame", "MyGameDisplay").set({
  title: "Dungeon Drifter",
  author: "Dungeon Master Dan",
  description: "Welcome to the dungeon, baby!",
  version: "0.0.1",
});

MyGame.settings.set({
  debug: {
    verbphase: true,
  },
});

MyGame.createAsset({
  class: "Player",
  name: "Mighty Hero",
  is: { active: true },
  doMoveThisToThat: {
    "Central Chamber": function () {
      MyGame.scorecard.completeEvent("enter central chamber");
    },
  },
});

// dungeon antechamber
MyGame.createAsset({
  class: "Room",
  name: "Dungeon Antechamber",
  description:
    "You're in a dingy dungeon antechamber. The air here is dank and oppressive, leavened only by a slight draft of fresh air at your back. A dark path descending to the north is bound by a massive wood planked door. Every surface of the dungeon seems to be made of pitted cobblestones. The cobblestones around the door frame appear to be particularly irregular. ",
  exits: {
    // north: "Central Chamber",
    south:
      "You feel the lure of the tiny patch of sky that's still visible through the entrance... but you don't want to leave without the treasure! ",
  },
});
MyGame.createAsset({
  class: "Exit",
  direction: "north",
  place: { in: "Dungeon Antechamber" },
  destination: "Central Chamber",
  // description: "You see a wall of cobbled stone inset with a heavy door. ",
  aperture: "wood planked door",
});
MyGame.createAsset({
  class: "Door",
  name: "wood planked door",
  adjectives: ["massive"],
  place: { in: "Dungeon Antechamber" },
  is: {
    closed: true,
    locked: true,
  },
  linked_asset: "iron bound door",
  direction: "north",
  description:
    "The imposing door is made of thick wooden planks, bound solidly together with corroded, but still quite strong, iron straps. ",
});

// central chamber
MyGame.createAsset({
  class: "Room",
  name: "Central Chamber",
  description:
    "You're in the central chamber of the dungeon, a round room with a high stone ceiling. Paths in several directions are blocked by fallen stones. The path to the south is a touch brighter and emits a hint of sweeter air. ",
  exits: {
    // south: "Dungeon Antechamber",
  },
});
MyGame.createAsset({
  class: "Exit",
  direction: "south",
  place: { in: "Central Chamber" },
  destination: "Dungeon Antechamber",
  // description: "A glimmer of daylight reaches you from the long antechamber corridor. ",
  aperture: "iron bound door",
});
MyGame.createAsset({
  class: "Door",
  name: "iron bound door",
  adjectives: ["massive"],
  direction: "south",
  linked_asset: "wood planked door",
  place: { in: "Central Chamber" },
  is: {
    closed: true,
    locked: true,
  },
  description:
    "The face of the door on this side is more iron than wood. You never would have been able to break it down. ",
});

MyGame.createAsset({
  class: "Key",
  name: "beaten iron key",
  dov: {
    take: {
      on_first_success: function () {
        MyGame.scorecard.completeEvent("take iron key");
      },
    },
  },
  iov: {
    unlock: {
      with_assets: ["wood planked door"],
      on_first_success: function () {
        MyGame.scorecard.completeEvent("unlock door");
      },
    },
  },
  description: "It's a thick, heavy key made of beaten iron. ",
  article: "a",
  adjectives: ["thick", "heavy"],
  place: { in: "pitted cobblestone" },
});

MyGame.createAsset({
  class: "Thing",
  name: "pitted cobblestone",
  aspects: { in: { with_assets: ["pitted iron key"] } },
  dov: {
    open: {
      with_nothing: true,
      on_first_success: function () {
        MyGame.scorecard.completeEvent("open pitted cobblestone");
      },
    },
    close: { with_nothing: true },
    examine: {
      on_first_success: function () {
        MyGame.scorecard.completeEvent("examine pitted cobblestone");
      },
    },
    look: {
      on_first_success: function () {
        return this.dov.examine.on_first_success();
      },
    },
  },
  is: { closed: true, known: true, listed: false },
  description:
    "The surface of this cobblestone seems especially pitted. The stone appears to be seamed, suggesting that it must be hinged. Currently it is { pitted cobblestone [is] open [or] closed }. ",
  article: "a",
  adjectives: [],
  place: { in: "Dungeon Antechamber" },
});

MyGame.createAsset({
  class: "Thing",
  name: "weathered cobblestone",
  is: { listed: false, known: true },
  description:
    "This cobblestone looks particularly weathered. Which is odd, given that it's underground where there's no weather to speak of. ",
  article: "a",
  adjectives: [],
  place: { in: "Dungeon Antechamber" },
});

MyGame.createAsset({
  class: "Thing",
  name: "cracked cobblestone",
  is: { listed: false, known: true },
  description:
    "This cobblestone is splintered with a spider's web of fine cracks. ",
  article: "a",
  adjectives: [],
  place: { in: "Dungeon Antechamber" },
});

MyGame.createAsset({
  class: "Collection",
  name: "cobblestones",
  place: { in: "Dungeon Antechamber" },
  collection: "pitted cobblestone, weathered cobblestone, cracked cobblestone",
  synonyms: [],
  is: { listed: false, known: true },
  description:
    "The entire room seems to be laid in cobblestones. Not just the floor, but also the walls and ceiling. The stones around the frame of the wood planked door draw your eye. Three in particular stand out: a cracked cobblestone, a weathered cobblestone, and a pitted cobblestone. ",
  dov: {
    examine: {
      on_first_success: function () {
        MyGame.scorecard.completeEvent("examine cobblestones");
      },
    },
    look: {
      on_first_success: function () {
        return this.dov.examine.on_first_success();
      },
    },
  },
});

MyGame.createAsset({
  class: "Chest",
  name: "brass chest",
  place: { in: "Central Chamber" },
  description: `It's a small but sturdy looking chest bound in brass{ brass chest [is] open [then] and lined with yolk colored satin }. `,
  adjectives: ["treasure", "holy"],
  is: {
    closed: true,
    locked: false,
  },
  dov: {
    open: {
      with_nothing: true,
      // on_first_success: `The chest's interior is lined with a rich golden yolk colored satin that fairly glows in the dim dungeon. Nestled comfortably inside the yolky satin bed is a small jade statuette. ` },
      on_first_success: function () {
        MyGame.overrideOutput(
          `The chest's interior is lined with a rich golden yolk colored satin that fairly glows in the dim dungeon. Nestled comfortably inside the yolky satin bed is a small jade statuette. `
        );
        MyGame.scorecard.completeEvent("open chest");
      },
    },
    close: { with_nothing: true },
  },
});

MyGame.createAsset({
  class: "Thing",
  name: "jade statuette",
  synonyms: ["statue", "dragon"],
  adjectives: ["green"],
  dov: {
    drop: true,
    take: {
      on_first_success: function () {
        MyGame.scorecard.completeEvent("take statuette");
      },
    },
  },
  description: `It's a breathtakingly detailed statuette of a dragon in miniature. The polished jade has a translucent effect that fairly glows, drawing your gaze into its depths. It takes effort to drag your eyes away from it. `,
  place: { in: "brass chest" },
});

MyGame.scorecard.set({
  score_events: {
    "examine cobblestones": 1,
    "examine pitted cobblestone": 1,
    "open pitted cobblestone": 5,
    "take iron key": 1,
    "unlock door": 5,
    "enter central chamber": 1,
    "open chest": 1,
    "take statuette": 10,
  },
});
